/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.messageDetail.service;

import com.coraltele.db.billing.main.repository.MessageDetailRepository;
import com.coraltele.db.billing.main.repository.NotificationRepository;
import com.coraltele.db.billing.main.specification.MessageDetailSpecification;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.billing.main.uc_notification.service.UcNotificationService;
import com.coraltele.service.uc.service.UCService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class MessageDetailService {
    private static final Logger logger = LogManager.getLogger(MessageDetailService.class);
    @Autowired
    private MessageDetailRepository repository;
    @Autowired
    NotificationRepository notificationRepository;
    @Autowired
    UCService ucService;
    @Autowired
    UcNotificationService ucNotificationService;

    public RequestResponse getList(SearchRequest searchRequestData, Authentication authentication) {
        this.ucNotificationService.updateNotificationForMessages(authentication);
        RequestResponse returnValue = new RequestResponse();
        Specification filters = MessageDetailSpecification.generateFilters((SearchRequest)searchRequestData, (String)authentication.getName());
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "recordDate" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "recordDate" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.repository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.repository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessageDetail("filtered list");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }
}

