/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.archiving.billingCdrHistorical.service;

import com.coraltele.helper.Constants;
import com.coraltele.service.archiving.billingCdrHistorical.model.RestoreResult;
import com.coraltele.service.archiving.billingCdrHistorical.service.TableRestoreService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.stereotype.Service;

@Service
public class TableRestoreService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableRestoreService.class);
    @Value(value="${spring.datasource.username:postgres}")
    private String dbUsername;
    @Value(value="${spring.datasource.password:postgres}")
    private String dbPassword;
    private final ObjectMapper objectMapper = new ObjectMapper();

    private DataSource createRemoteDataSource(String ipAddress, String database, int port) {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName("org.postgresql.Driver");
        dataSource.setUrl(String.format("jdbc:postgresql://%s:%d/%s", ipAddress, port, database));
        dataSource.setUsername(this.dbUsername);
        dataSource.setPassword(this.dbPassword);
        return dataSource;
    }

    public RestoreResult restoreAllTables(String ipAddress, String inputPath) {
        return this.restoreAllTables(ipAddress, inputPath, 5432);
    }

    public RestoreResult restoreAllTables(String ipAddress, String inputPath, int port) {
        String[] servicesToRestart;
        log.info("Starting table restore to remote database at {}:{}", (Object)ipAddress, (Object)port);
        RestoreResult result = new RestoreResult(ipAddress, port);
        try {
            List tableConfigs = this.readTableConfiguration();
            result.setTotalTables(tableConfigs.size());
            log.info("Found {} tables to restore", (Object)tableConfigs.size());
            String fileName = Constants.CONFIG_ARCHIVE_PATH + "/" + inputPath + ".json";
            File jsonFile = new File(fileName);
            if (!jsonFile.exists()) {
                log.error("JSON file not found: {}", (Object)jsonFile.getAbsolutePath());
                result.setConnectionSuccess(false);
                result.setConnectionError("JSON file not found: " + jsonFile.getAbsolutePath());
                result.addError("JSON file not found: " + jsonFile.getAbsolutePath());
                result.markComplete();
                return result;
            }
            Map dumpData = (Map)this.objectMapper.readValue(jsonFile, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            boolean connectionTested = false;
            for (Map config : tableConfigs) {
                String database = (String)config.get("database");
                String schema = (String)config.get("schema");
                String table = (String)config.get("table");
                String businessKey = (String)config.get("businessKey");
                List keyFields = (List)config.get("keyFields");
                Boolean isAutoGenerated = (Boolean)config.get("isAutoGenerated");
                Boolean isImportReady = (Boolean)config.get("isImportReady");
                List foreignKeyMappings = (List)config.get("foreignKeyMappings");
                if (isImportReady == null || !isImportReady.booleanValue()) {
                    log.info("Skipping non-import-ready table {}.{}.{}", new Object[]{database, schema, table});
                    result.setSkippedCount(result.getSkippedCount() + 1);
                    continue;
                }
                if (!connectionTested) {
                    try {
                        DataSource testDs = this.createRemoteDataSource(ipAddress, database, port);
                        try (Connection conn = testDs.getConnection();){
                            result.setConnectionSuccess(true);
                            log.info("Successfully connected to database at {}:{}/{}", new Object[]{ipAddress, port, database});
                        }
                        connectionTested = true;
                    }
                    catch (SQLException e) {
                        log.error("Failed to connect to database at {}:{}: {}", new Object[]{ipAddress, port, e.getMessage()});
                        result.setConnectionSuccess(false);
                        result.setConnectionError("Connection failed: " + e.getMessage());
                        result.addError("Database connection failed: " + e.getMessage());
                        result.markComplete();
                        return result;
                    }
                }
                RestoreResult.TableRestoreResult tableResult = new RestoreResult.TableRestoreResult(database, schema, table);
                try {
                    this.restoreTableWithResult(ipAddress, port, database, schema, table, businessKey, jsonFile, keyFields, isAutoGenerated != null && isAutoGenerated != false, foreignKeyMappings, dumpData, tableResult);
                    log.info("Successfully restored {}.{}.{} - Inserts: {}, Updates: {}, Deletes: {}, Skipped: {}", new Object[]{database, schema, table, tableResult.getInsertCount(), tableResult.getUpdateCount(), tableResult.getDeleteCount(), tableResult.getSkipCount()});
                }
                catch (Exception e) {
                    tableResult.setSuccess(false);
                    tableResult.setErrorMessage(e.getMessage());
                    log.error("Failed to restore {}.{}.{}: {}", new Object[]{database, schema, table, e.getMessage(), e});
                }
                result.addTableResult(tableResult);
            }
            log.info("Table restore completed. Success: {}, Failures: {}, Skipped: {}", new Object[]{result.getSuccessCount(), result.getFailureCount(), result.getSkippedCount()});
        }
        catch (Exception e) {
            log.error("Error during table restore: {}", (Object)e.getMessage(), (Object)e);
            result.setConnectionSuccess(false);
            result.setConnectionError(e.getMessage());
            result.addError("General error: " + e.getMessage());
        }
        for (String serviceName : servicesToRestart = new String[]{"coral-ldap.service", "sipserver.service", "featuregateway.service", "trunkgateway.service", "coral-ims-v2.service", "coral-websocketservice.service"}) {
            new Thread(() -> {
                try {
                    Process checkEnabledProcess = Runtime.getRuntime().exec(new String[]{"systemctl", "is-enabled", serviceName});
                    checkEnabledProcess.waitFor();
                    if (checkEnabledProcess.exitValue() == 0) {
                        log.info("{} is enabled, restarting service...", (Object)serviceName);
                        Process restartProcess = Runtime.getRuntime().exec(new String[]{"systemctl", "restart", serviceName});
                        restartProcess.waitFor();
                        if (restartProcess.exitValue() == 0) {
                            log.info("Successfully restarted {}", (Object)serviceName);
                        } else {
                            log.warn("Failed to restart {}, exit code: {}", (Object)serviceName, (Object)restartProcess.exitValue());
                        }
                    } else {
                        log.info("{} is not enabled, skipping restart", (Object)serviceName);
                    }
                }
                catch (Exception e) {
                    log.warn("Error checking/restarting {}: {}", (Object)serviceName, (Object)e.getMessage());
                }
            }, "ServiceRestart-" + serviceName).start();
        }
        result.markComplete();
        return result;
    }

    public RestoreResult restoreAllTablesFromData(Map<String, Object> dumpData) {
        return this.restoreAllTablesFromData(dumpData, "127.0.0.1", 5432);
    }

    public RestoreResult restoreAllTablesFromData(Map<String, Object> dumpData, String ipAddress, int port) {
        log.info("Starting table restore from JSON data to database at {}:{}", (Object)ipAddress, (Object)port);
        RestoreResult result = new RestoreResult(ipAddress, port);
        try {
            List tableConfigs = this.readTableConfiguration();
            result.setTotalTables(tableConfigs.size());
            log.info("Found {} tables to restore", (Object)tableConfigs.size());
            if (dumpData == null || dumpData.isEmpty()) {
                log.error("Dump data is null or empty");
                result.setConnectionSuccess(false);
                result.setConnectionError("Dump data is null or empty");
                result.addError("Dump data is null or empty");
                result.markComplete();
                return result;
            }
            boolean connectionTested = false;
            for (Map config : tableConfigs) {
                String database = (String)config.get("database");
                String schema = (String)config.get("schema");
                String table = (String)config.get("table");
                String businessKey = (String)config.get("businessKey");
                List keyFields = (List)config.get("keyFields");
                Boolean isAutoGenerated = (Boolean)config.get("isAutoGenerated");
                Boolean isImportReady = (Boolean)config.get("isImportReady");
                List foreignKeyMappings = (List)config.get("foreignKeyMappings");
                if (isImportReady == null || !isImportReady.booleanValue()) {
                    log.info("Skipping non-import-ready table {}.{}.{}", new Object[]{database, schema, table});
                    result.setSkippedCount(result.getSkippedCount() + 1);
                    continue;
                }
                if (!connectionTested) {
                    try {
                        DataSource testDs = this.createRemoteDataSource(ipAddress, database, port);
                        try (Connection conn = testDs.getConnection();){
                            result.setConnectionSuccess(true);
                            log.info("Successfully connected to local database at {}:{}/{}", new Object[]{ipAddress, port, database});
                        }
                        connectionTested = true;
                    }
                    catch (SQLException e) {
                        log.error("Failed to connect to local database at {}:{}: {}", new Object[]{ipAddress, port, e.getMessage()});
                        result.setConnectionSuccess(false);
                        result.setConnectionError("Connection failed: " + e.getMessage());
                        result.addError("Database connection failed: " + e.getMessage());
                        result.markComplete();
                        return result;
                    }
                }
                RestoreResult.TableRestoreResult tableResult = new RestoreResult.TableRestoreResult(database, schema, table);
                try {
                    this.restoreTableFromDataWithResult(ipAddress, port, database, schema, table, businessKey, keyFields, isAutoGenerated != null && isAutoGenerated != false, foreignKeyMappings, dumpData, tableResult);
                    log.info("Successfully restored {}.{}.{} - Inserts: {}, Updates: {}, Deletes: {}, Skipped: {}", new Object[]{database, schema, table, tableResult.getInsertCount(), tableResult.getUpdateCount(), tableResult.getDeleteCount(), tableResult.getSkipCount()});
                }
                catch (Exception e) {
                    tableResult.setSuccess(false);
                    tableResult.setErrorMessage(e.getMessage());
                    log.error("Failed to restore {}.{}.{}: {}", new Object[]{database, schema, table, e.getMessage(), e});
                }
                result.addTableResult(tableResult);
            }
            log.info("Table restore from data completed. Success: {}, Failures: {}, Skipped: {}", new Object[]{result.getSuccessCount(), result.getFailureCount(), result.getSkippedCount()});
        }
        catch (Exception e) {
            log.error("Error during table restore from data: {}", (Object)e.getMessage(), (Object)e);
            result.setConnectionSuccess(false);
            result.setConnectionError(e.getMessage());
            result.addError("General error: " + e.getMessage());
        }
        result.markComplete();
        return result;
    }

    private void restoreTableFromDataWithResult(String ipAddress, int port, String database, String schema, String table, String businessKey, List<String> keyFields, boolean isAutoGenerated, List<Map<String, String>> foreignKeyMappings, Map<String, Object> dumpData, RestoreResult.TableRestoreResult tableResult) {
        log.info("Restoring table {}.{}.{} from data with comprehensive sync", new Object[]{database, schema, table});
        try {
            String compositeKey;
            List tables = (List)dumpData.get("tables");
            if (tables == null) {
                log.warn("No 'tables' array found in dump data");
                tableResult.setSuccess(false);
                tableResult.setErrorMessage("No 'tables' array found in dump data");
                return;
            }
            Map tableData = null;
            for (Map tbl : tables) {
                if (!database.equals(tbl.get("database")) || !schema.equals(tbl.get("schema")) || !table.equals(tbl.get("table"))) continue;
                tableData = tbl;
                break;
            }
            if (tableData == null) {
                log.warn("Table {}.{}.{} not found in dump data", new Object[]{database, schema, table});
                tableResult.setSuccess(false);
                tableResult.setErrorMessage("Table not found in dump data");
                return;
            }
            List sourceRecords = (ArrayList)tableData.get("data");
            if (sourceRecords == null) {
                sourceRecords = new ArrayList();
            }
            DataSource remoteDataSource = this.createRemoteDataSource(ipAddress, database, port);
            JdbcTemplate jdbcTemplate = new JdbcTemplate(remoteDataSource);
            String fullTableName = schema + "." + table;
            if (foreignKeyMappings != null && !foreignKeyMappings.isEmpty()) {
                log.info("Resolving foreign key references for {} mappings in {}", (Object)foreignKeyMappings.size(), (Object)fullTableName);
                sourceRecords = this.resolveForeignKeyReferences(sourceRecords, foreignKeyMappings, dumpData, ipAddress, port);
            }
            if (businessKey == null || businessKey.trim().isEmpty()) {
                this.truncateAndInsertAllWithResult(jdbcTemplate, schema, table, sourceRecords, keyFields, isAutoGenerated, tableResult);
                return;
            }
            List targetRecords = this.readAllRecords(jdbcTemplate, fullTableName);
            log.info("Source records: {}, Target records: {}", (Object)sourceRecords.size(), (Object)targetRecords.size());
            Map columnTypes = this.getColumnTypes(jdbcTemplate, schema, table);
            log.debug("Fetched {} column types for {}", (Object)columnTypes.size(), (Object)fullTableName);
            List matchKeyFields = this.parseBusinessKey(businessKey);
            log.debug("Using composite business key fields: {}", (Object)matchKeyFields);
            Map sourceMap = this.buildRecordMap(sourceRecords, matchKeyFields);
            Map targetMap = this.buildRecordMap(targetRecords, matchKeyFields);
            for (Map.Entry entry : sourceMap.entrySet()) {
                compositeKey = (String)entry.getKey();
                Map sourceRecord = (Map)entry.getValue();
                try {
                    if (targetMap.containsKey(compositeKey)) {
                        Map targetRecord = (Map)targetMap.get(compositeKey);
                        if (this.hasChanges(sourceRecord, targetRecord, keyFields)) {
                            OperationResultWithError opResult = this.updateRecordWithResult(jdbcTemplate, fullTableName, sourceRecord, matchKeyFields, keyFields, isAutoGenerated, columnTypes);
                            if (opResult.operationType == OperationType.UPDATE) {
                                tableResult.setUpdateCount(tableResult.getUpdateCount() + 1);
                                continue;
                            }
                            tableResult.setSkipCount(tableResult.getSkipCount() + 1);
                            if (opResult.errorMessage == null) continue;
                            tableResult.addOperationError(new RestoreResult.OperationError(RestoreResult.OperationType.UPDATE, compositeKey, opResult.errorMessage, opResult.sqlState));
                            continue;
                        }
                        log.debug("No changes for composite key {} in {}", (Object)compositeKey, (Object)fullTableName);
                        tableResult.setSkipCount(tableResult.getSkipCount() + 1);
                        continue;
                    }
                    OperationResultWithError opResult = this.insertRecordWithResult(jdbcTemplate, fullTableName, sourceRecord, keyFields, isAutoGenerated, columnTypes);
                    if (opResult.operationType == OperationType.INSERT) {
                        tableResult.setInsertCount(tableResult.getInsertCount() + 1);
                        continue;
                    }
                    tableResult.setSkipCount(tableResult.getSkipCount() + 1);
                    if (opResult.errorMessage == null) continue;
                    tableResult.addOperationError(new RestoreResult.OperationError(RestoreResult.OperationType.INSERT, compositeKey, opResult.errorMessage, opResult.sqlState));
                }
                catch (Exception e) {
                    log.error("Failed to process record with composite key {} in {}: {}", new Object[]{compositeKey, fullTableName, e.getMessage()});
                    tableResult.setSkipCount(tableResult.getSkipCount() + 1);
                    tableResult.addOperationError(new RestoreResult.OperationError(RestoreResult.OperationType.INSERT, compositeKey, e.getMessage()));
                }
            }
            for (Map.Entry entry : targetMap.entrySet()) {
                compositeKey = (String)entry.getKey();
                Map targetRecord = (Map)entry.getValue();
                if (sourceMap.containsKey(compositeKey)) continue;
                try {
                    StringBuilder whereClause = new StringBuilder();
                    ArrayList whereValues = new ArrayList();
                    for (int i = 0; i < matchKeyFields.size(); ++i) {
                        if (i > 0) {
                            whereClause.append(" AND ");
                        }
                        String field = (String)matchKeyFields.get(i);
                        whereClause.append(this.quoteIdentifier(field)).append(" = ?");
                        whereValues.add(targetRecord.get(field));
                    }
                    String deleteSql = String.format("DELETE FROM %s WHERE %s", fullTableName, whereClause);
                    jdbcTemplate.update(deleteSql, whereValues.toArray());
                    tableResult.setDeleteCount(tableResult.getDeleteCount() + 1);
                    log.debug("Deleted record with composite key {} from {}", (Object)compositeKey, (Object)fullTableName);
                }
                catch (Exception e) {
                    log.error("Failed to delete record with composite key {} from {}: {}", new Object[]{compositeKey, fullTableName, e.getMessage()});
                    tableResult.addOperationError(new RestoreResult.OperationError(RestoreResult.OperationType.DELETE, compositeKey, e.getMessage()));
                }
            }
            log.info("Comprehensive sync completed for {}. Inserted: {}, Updated: {}, Deleted: {}, Skipped: {}, Errors: {}", new Object[]{fullTableName, tableResult.getInsertCount(), tableResult.getUpdateCount(), tableResult.getDeleteCount(), tableResult.getSkipCount(), tableResult.getOperationErrors().size()});
            tableResult.setSuccess(!tableResult.hasOperationErrors() || tableResult.getInsertCount() + tableResult.getUpdateCount() + tableResult.getDeleteCount() > 0);
        }
        catch (Exception e) {
            log.error("Unexpected error restoring table {}.{}.{}: {}", new Object[]{database, schema, table, e.getMessage(), e});
            tableResult.setSuccess(false);
            tableResult.setErrorMessage("Unexpected error: " + e.getMessage());
        }
    }

    public void restoreTable(String ipAddress, int port, String database, String schema, String table, String businessKey, File jsonFile) {
        this.restoreTable(ipAddress, port, database, schema, table, businessKey, jsonFile, null, false, null, null);
    }

    public void restoreTable(String ipAddress, int port, String database, String schema, String table, String businessKey, File jsonFile, List<String> keyFields, boolean isAutoGenerated) {
        this.restoreTable(ipAddress, port, database, schema, table, businessKey, jsonFile, keyFields, isAutoGenerated, null, null);
    }

    public void restoreTable(String ipAddress, int port, String database, String schema, String table, String businessKey, File jsonFile, List<String> keyFields, boolean isAutoGenerated, List<Map<String, String>> foreignKeyMappings, Map<String, Object> preloadedDumpData) {
        log.info("Restoring table {}.{}.{} from {} with comprehensive sync", new Object[]{database, schema, table, jsonFile.getName()});
        try {
            String compositeKey;
            Map dumpData = preloadedDumpData != null ? preloadedDumpData : (Map)this.objectMapper.readValue(jsonFile, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            List tables = (List)dumpData.get("tables");
            if (tables == null) {
                log.warn("No 'tables' array found in JSON file: {}", (Object)jsonFile.getName());
                return;
            }
            Map tableData = null;
            for (Map tbl : tables) {
                if (!database.equals(tbl.get("database")) || !schema.equals(tbl.get("schema")) || !table.equals(tbl.get("table"))) continue;
                tableData = tbl;
                break;
            }
            if (tableData == null) {
                log.warn("Table {}.{}.{} not found in JSON file: {}", new Object[]{database, schema, table, jsonFile.getName()});
                return;
            }
            List sourceRecords = (ArrayList)tableData.get("data");
            if (sourceRecords == null) {
                sourceRecords = new ArrayList();
            }
            DataSource remoteDataSource = this.createRemoteDataSource(ipAddress, database, port);
            JdbcTemplate jdbcTemplate = new JdbcTemplate(remoteDataSource);
            String fullTableName = schema + "." + table;
            if (foreignKeyMappings != null && !foreignKeyMappings.isEmpty()) {
                log.info("Resolving foreign key references for {} mappings in {}", (Object)foreignKeyMappings.size(), (Object)fullTableName);
                sourceRecords = this.resolveForeignKeyReferences(sourceRecords, foreignKeyMappings, dumpData, ipAddress, port);
            }
            if (businessKey == null || businessKey.trim().isEmpty()) {
                this.truncateAndInsertAll(jdbcTemplate, schema, table, sourceRecords, keyFields, isAutoGenerated);
                return;
            }
            List targetRecords = this.readAllRecords(jdbcTemplate, fullTableName);
            log.info("Source records: {}, Target records: {}", (Object)sourceRecords.size(), (Object)targetRecords.size());
            Map columnTypes = this.getColumnTypes(jdbcTemplate, schema, table);
            log.debug("Fetched {} column types for {}", (Object)columnTypes.size(), (Object)fullTableName);
            List matchKeyFields = this.parseBusinessKey(businessKey);
            log.debug("Using composite business key fields: {}", (Object)matchKeyFields);
            Map sourceMap = this.buildRecordMap(sourceRecords, matchKeyFields);
            Map targetMap = this.buildRecordMap(targetRecords, matchKeyFields);
            int insertCount = 0;
            int updateCount = 0;
            int deleteCount = 0;
            int skipCount = 0;
            if (table.equals("m_userrole")) {
                log.debug("Source Map Keys for m_userrole: {}", sourceMap.keySet());
                log.debug("Target Map Keys for m_userrole: {}", targetMap.keySet());
            }
            for (Map.Entry entry : sourceMap.entrySet()) {
                compositeKey = (String)entry.getKey();
                Map sourceRecord = (Map)entry.getValue();
                try {
                    if (targetMap.containsKey(compositeKey)) {
                        Map targetRecord = (Map)targetMap.get(compositeKey);
                        if (this.hasChanges(sourceRecord, targetRecord, keyFields)) {
                            OperationType result = this.updateRecord(jdbcTemplate, fullTableName, sourceRecord, matchKeyFields, keyFields, isAutoGenerated, columnTypes);
                            if (result == OperationType.UPDATE) {
                                ++updateCount;
                                continue;
                            }
                            ++skipCount;
                            continue;
                        }
                        log.debug("No changes for composite key {} in {}", (Object)compositeKey, (Object)fullTableName);
                        ++skipCount;
                        continue;
                    }
                    OperationType result = this.insertRecord(jdbcTemplate, fullTableName, sourceRecord, keyFields, isAutoGenerated, columnTypes);
                    if (result == OperationType.INSERT) {
                        ++insertCount;
                        continue;
                    }
                    ++skipCount;
                }
                catch (Exception e) {
                    log.error("Failed to process record with composite key {} in {}: {}", new Object[]{compositeKey, fullTableName, e.getMessage()});
                    ++skipCount;
                }
            }
            for (Map.Entry entry : targetMap.entrySet()) {
                compositeKey = (String)entry.getKey();
                Map targetRecord = (Map)entry.getValue();
                if (sourceMap.containsKey(compositeKey)) continue;
                try {
                    StringBuilder whereClause = new StringBuilder();
                    ArrayList whereValues = new ArrayList();
                    for (int i = 0; i < matchKeyFields.size(); ++i) {
                        if (i > 0) {
                            whereClause.append(" AND ");
                        }
                        String field = (String)matchKeyFields.get(i);
                        whereClause.append(this.quoteIdentifier(field)).append(" = ?");
                        whereValues.add(targetRecord.get(field));
                    }
                    String deleteSql = String.format("DELETE FROM %s WHERE %s", fullTableName, whereClause);
                    jdbcTemplate.update(deleteSql, whereValues.toArray());
                    ++deleteCount;
                    log.debug("Deleted record with composite key {} from {}", (Object)compositeKey, (Object)fullTableName);
                }
                catch (Exception e) {
                    log.error("Failed to delete record with composite key {} from {}: {}", new Object[]{compositeKey, fullTableName, e.getMessage()});
                }
            }
            log.info("Comprehensive sync completed for {}. Inserted: {}, Updated: {}, Deleted: {}, Skipped: {}", new Object[]{fullTableName, insertCount, updateCount, deleteCount, skipCount});
        }
        catch (IOException e) {
            log.error("Failed to read JSON file {}: {}", (Object)jsonFile.getName(), (Object)e.getMessage());
        }
    }

    private void restoreTableWithResult(String ipAddress, int port, String database, String schema, String table, String businessKey, File jsonFile, List<String> keyFields, boolean isAutoGenerated, List<Map<String, String>> foreignKeyMappings, Map<String, Object> preloadedDumpData, RestoreResult.TableRestoreResult tableResult) {
        log.info("Restoring table {}.{}.{} from {} with comprehensive sync", new Object[]{database, schema, table, jsonFile.getName()});
        try {
            String compositeKey;
            Map dumpData = preloadedDumpData != null ? preloadedDumpData : (Map)this.objectMapper.readValue(jsonFile, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            List tables = (List)dumpData.get("tables");
            if (tables == null) {
                log.warn("No 'tables' array found in JSON file: {}", (Object)jsonFile.getName());
                tableResult.setSuccess(false);
                tableResult.setErrorMessage("No 'tables' array found in JSON file");
                return;
            }
            Map tableData = null;
            for (Map tbl : tables) {
                if (!database.equals(tbl.get("database")) || !schema.equals(tbl.get("schema")) || !table.equals(tbl.get("table"))) continue;
                tableData = tbl;
                break;
            }
            if (tableData == null) {
                log.warn("Table {}.{}.{} not found in JSON file: {}", new Object[]{database, schema, table, jsonFile.getName()});
                tableResult.setSuccess(false);
                tableResult.setErrorMessage("Table not found in JSON file");
                return;
            }
            List sourceRecords = (ArrayList)tableData.get("data");
            if (sourceRecords == null) {
                sourceRecords = new ArrayList();
            }
            DataSource remoteDataSource = this.createRemoteDataSource(ipAddress, database, port);
            JdbcTemplate jdbcTemplate = new JdbcTemplate(remoteDataSource);
            String fullTableName = schema + "." + table;
            if (foreignKeyMappings != null && !foreignKeyMappings.isEmpty()) {
                log.info("Resolving foreign key references for {} mappings in {}", (Object)foreignKeyMappings.size(), (Object)fullTableName);
                sourceRecords = this.resolveForeignKeyReferences(sourceRecords, foreignKeyMappings, dumpData, ipAddress, port);
            }
            if (businessKey == null || businessKey.trim().isEmpty()) {
                this.truncateAndInsertAllWithResult(jdbcTemplate, schema, table, sourceRecords, keyFields, isAutoGenerated, tableResult);
                return;
            }
            List targetRecords = this.readAllRecords(jdbcTemplate, fullTableName);
            log.info("Source records: {}, Target records: {}", (Object)sourceRecords.size(), (Object)targetRecords.size());
            Map columnTypes = this.getColumnTypes(jdbcTemplate, schema, table);
            log.debug("Fetched {} column types for {}", (Object)columnTypes.size(), (Object)fullTableName);
            List matchKeyFields = this.parseBusinessKey(businessKey);
            log.debug("Using composite business key fields: {}", (Object)matchKeyFields);
            Map sourceMap = this.buildRecordMap(sourceRecords, matchKeyFields);
            Map targetMap = this.buildRecordMap(targetRecords, matchKeyFields);
            for (Map.Entry entry : sourceMap.entrySet()) {
                compositeKey = (String)entry.getKey();
                Map sourceRecord = (Map)entry.getValue();
                try {
                    if (targetMap.containsKey(compositeKey)) {
                        Map targetRecord = (Map)targetMap.get(compositeKey);
                        if (this.hasChanges(sourceRecord, targetRecord, keyFields)) {
                            OperationResultWithError opResult = this.updateRecordWithResult(jdbcTemplate, fullTableName, sourceRecord, matchKeyFields, keyFields, isAutoGenerated, columnTypes);
                            if (opResult.operationType == OperationType.UPDATE) {
                                tableResult.setUpdateCount(tableResult.getUpdateCount() + 1);
                                continue;
                            }
                            tableResult.setSkipCount(tableResult.getSkipCount() + 1);
                            if (opResult.errorMessage == null) continue;
                            tableResult.addOperationError(new RestoreResult.OperationError(RestoreResult.OperationType.UPDATE, compositeKey, opResult.errorMessage, opResult.sqlState));
                            continue;
                        }
                        log.debug("No changes for composite key {} in {}", (Object)compositeKey, (Object)fullTableName);
                        tableResult.setSkipCount(tableResult.getSkipCount() + 1);
                        continue;
                    }
                    OperationResultWithError opResult = this.insertRecordWithResult(jdbcTemplate, fullTableName, sourceRecord, keyFields, isAutoGenerated, columnTypes);
                    if (opResult.operationType == OperationType.INSERT) {
                        tableResult.setInsertCount(tableResult.getInsertCount() + 1);
                        continue;
                    }
                    tableResult.setSkipCount(tableResult.getSkipCount() + 1);
                    if (opResult.errorMessage == null) continue;
                    tableResult.addOperationError(new RestoreResult.OperationError(RestoreResult.OperationType.INSERT, compositeKey, opResult.errorMessage, opResult.sqlState));
                }
                catch (Exception e) {
                    log.error("Failed to process record with composite key {} in {}: {}", new Object[]{compositeKey, fullTableName, e.getMessage()});
                    tableResult.setSkipCount(tableResult.getSkipCount() + 1);
                    tableResult.addOperationError(new RestoreResult.OperationError(RestoreResult.OperationType.INSERT, compositeKey, e.getMessage()));
                }
            }
            for (Map.Entry entry : targetMap.entrySet()) {
                compositeKey = (String)entry.getKey();
                Map targetRecord = (Map)entry.getValue();
                if (sourceMap.containsKey(compositeKey)) continue;
                try {
                    StringBuilder whereClause = new StringBuilder();
                    ArrayList whereValues = new ArrayList();
                    for (int i = 0; i < matchKeyFields.size(); ++i) {
                        if (i > 0) {
                            whereClause.append(" AND ");
                        }
                        String field = (String)matchKeyFields.get(i);
                        whereClause.append(this.quoteIdentifier(field)).append(" = ?");
                        whereValues.add(targetRecord.get(field));
                    }
                    String deleteSql = String.format("DELETE FROM %s WHERE %s", fullTableName, whereClause);
                    jdbcTemplate.update(deleteSql, whereValues.toArray());
                    tableResult.setDeleteCount(tableResult.getDeleteCount() + 1);
                    log.debug("Deleted record with composite key {} from {}", (Object)compositeKey, (Object)fullTableName);
                }
                catch (Exception e) {
                    log.error("Failed to delete record with composite key {} from {}: {}", new Object[]{compositeKey, fullTableName, e.getMessage()});
                    tableResult.addOperationError(new RestoreResult.OperationError(RestoreResult.OperationType.DELETE, compositeKey, e.getMessage()));
                }
            }
            log.info("Comprehensive sync completed for {}. Inserted: {}, Updated: {}, Deleted: {}, Skipped: {}, Errors: {}", new Object[]{fullTableName, tableResult.getInsertCount(), tableResult.getUpdateCount(), tableResult.getDeleteCount(), tableResult.getSkipCount(), tableResult.getOperationErrors().size()});
            tableResult.setSuccess(!tableResult.hasOperationErrors() || tableResult.getInsertCount() + tableResult.getUpdateCount() + tableResult.getDeleteCount() > 0);
        }
        catch (IOException e) {
            log.error("Failed to read JSON file {}: {}", (Object)jsonFile.getName(), (Object)e.getMessage());
            tableResult.setSuccess(false);
            tableResult.setErrorMessage("Failed to read JSON file: " + e.getMessage());
        }
        catch (Exception e) {
            log.error("Unexpected error restoring table {}.{}.{}: {}", new Object[]{database, schema, table, e.getMessage(), e});
            tableResult.setSuccess(false);
            tableResult.setErrorMessage("Unexpected error: " + e.getMessage());
        }
    }

    private void truncateAndInsertAllWithResult(JdbcTemplate jdbcTemplate, String schema, String table, List<Map<String, Object>> sourceRecords, List<String> keyFields, boolean isAutoGenerated, RestoreResult.TableRestoreResult tableResult) {
        String tableName = schema + "." + table;
        log.info("No business key defined for {}. Using TRUNCATE + INSERT approach.", (Object)tableName);
        try {
            Map columnTypes = this.getColumnTypes(jdbcTemplate, schema, table);
            String truncateSql = String.format("TRUNCATE TABLE %s CASCADE", tableName);
            jdbcTemplate.execute(truncateSql);
            log.info("Truncated table {}", (Object)tableName);
            for (Map<String, Object> record : sourceRecords) {
                OperationResultWithError opResult = this.insertRecordWithResult(jdbcTemplate, tableName, record, keyFields, isAutoGenerated, columnTypes);
                if (opResult.operationType == OperationType.INSERT) {
                    tableResult.setInsertCount(tableResult.getInsertCount() + 1);
                    continue;
                }
                tableResult.setSkipCount(tableResult.getSkipCount() + 1);
                if (opResult.errorMessage == null) continue;
                tableResult.addOperationError(new RestoreResult.OperationError(RestoreResult.OperationType.INSERT, "unknown", opResult.errorMessage, opResult.sqlState));
            }
            log.info("TRUNCATE + INSERT completed for {}. Inserted: {}, Failed: {}", new Object[]{tableName, tableResult.getInsertCount(), tableResult.getSkipCount()});
            tableResult.setSuccess(tableResult.getInsertCount() > 0 || sourceRecords.isEmpty());
        }
        catch (Exception e) {
            log.error("Failed to truncate and insert records into {}: {}", new Object[]{tableName, e.getMessage(), e});
            tableResult.setSuccess(false);
            tableResult.setErrorMessage("Failed to truncate and insert: " + e.getMessage());
            tableResult.addOperationError(new RestoreResult.OperationError(RestoreResult.OperationType.TRUNCATE, tableName, e.getMessage()));
        }
    }

    private OperationResultWithError updateRecordWithResult(JdbcTemplate jdbcTemplate, String tableName, Map<String, Object> record, List<String> matchKeyFields, List<String> keyFields, boolean isAutoGenerated, Map<String, String> columnTypes) {
        try {
            StringBuilder sql = new StringBuilder("UPDATE ").append(tableName).append(" SET ");
            ArrayList<Object> values = new ArrayList<Object>();
            int columnCount = 0;
            for (Map.Entry<String, Object> entry : record.entrySet()) {
                String column = entry.getKey();
                if (isAutoGenerated && keyFields != null && keyFields.contains(column) || column.equals("createdon") || column.equals("createdby")) continue;
                if (columnCount > 0) {
                    sql.append(", ");
                }
                sql.append(this.quoteIdentifier(column)).append(" = ?");
                values.add(this.convertValue(entry.getValue(), columnTypes.get(column)));
                ++columnCount;
            }
            if (columnCount == 0) {
                log.debug("No columns to update for record in {}", (Object)tableName);
                return new OperationResultWithError(OperationType.SKIP);
            }
            sql.append(" WHERE ");
            for (int i = 0; i < matchKeyFields.size(); ++i) {
                if (i > 0) {
                    sql.append(" AND ");
                }
                String field = matchKeyFields.get(i);
                sql.append(this.quoteIdentifier(field)).append(" = ?");
                values.add(record.get(field));
            }
            jdbcTemplate.update(sql.toString(), values.toArray());
            log.debug("Updated record in {} with composite key", (Object)tableName);
            return new OperationResultWithError(OperationType.UPDATE);
        }
        catch (Exception e) {
            log.error("Failed to update record in {}: {}", (Object)tableName, (Object)e.getMessage());
            String sqlState = null;
            if (e.getCause() instanceof SQLException) {
                sqlState = ((SQLException)e.getCause()).getSQLState();
            }
            return new OperationResultWithError(OperationType.SKIP, e.getMessage(), sqlState);
        }
    }

    private OperationResultWithError insertRecordWithResult(JdbcTemplate jdbcTemplate, String tableName, Map<String, Object> record, List<String> keyFields, boolean isAutoGenerated, Map<String, String> columnTypes) {
        try {
            StringBuilder columns = new StringBuilder();
            StringBuilder placeholders = new StringBuilder();
            ArrayList<Object> values = new ArrayList<Object>();
            int columnCount = 0;
            for (Map.Entry<String, Object> entry : record.entrySet()) {
                String column = entry.getKey();
                if (isAutoGenerated && keyFields != null && keyFields.contains(column)) continue;
                if (columnCount > 0) {
                    columns.append(", ");
                    placeholders.append(", ");
                }
                columns.append(this.quoteIdentifier(column));
                placeholders.append("?");
                values.add(this.convertValue(entry.getValue(), columnTypes.get(column)));
                ++columnCount;
            }
            String sql = String.format("INSERT INTO %s (%s) VALUES (%s)", tableName, columns, placeholders);
            jdbcTemplate.update(sql, values.toArray());
            log.debug("Inserted new record into {}", (Object)tableName);
            return new OperationResultWithError(OperationType.INSERT);
        }
        catch (Exception e) {
            log.error("Failed to insert record into {}: {}", (Object)tableName, (Object)e.getMessage());
            String sqlState = null;
            if (e.getCause() instanceof SQLException) {
                sqlState = ((SQLException)e.getCause()).getSQLState();
            }
            return new OperationResultWithError(OperationType.SKIP, e.getMessage(), sqlState);
        }
    }

    private List<Map<String, Object>> readAllRecords(JdbcTemplate jdbcTemplate, String tableName) {
        try {
            String sql = String.format("SELECT * FROM %s", tableName);
            return jdbcTemplate.queryForList(sql);
        }
        catch (Exception e) {
            log.warn("Failed to read records from {}: {}. Assuming empty table.", (Object)tableName, (Object)e.getMessage());
            return new ArrayList<Map<String, Object>>();
        }
    }

    private void truncateAndInsertAll(JdbcTemplate jdbcTemplate, String schema, String table, List<Map<String, Object>> sourceRecords, List<String> keyFields, boolean isAutoGenerated) {
        String tableName = schema + "." + table;
        log.info("No business key defined for {}. Using TRUNCATE + INSERT approach.", (Object)tableName);
        try {
            Map columnTypes = this.getColumnTypes(jdbcTemplate, schema, table);
            String truncateSql = String.format("TRUNCATE TABLE %s CASCADE", tableName);
            jdbcTemplate.execute(truncateSql);
            log.info("Truncated table {}", (Object)tableName);
            int insertCount = 0;
            int failCount = 0;
            for (Map<String, Object> record : sourceRecords) {
                OperationType result = this.insertRecord(jdbcTemplate, tableName, record, keyFields, isAutoGenerated, columnTypes);
                if (result == OperationType.INSERT) {
                    ++insertCount;
                    continue;
                }
                ++failCount;
            }
            log.info("TRUNCATE + INSERT completed for {}. Inserted: {}, Failed: {}", new Object[]{tableName, insertCount, failCount});
        }
        catch (Exception e) {
            log.error("Failed to truncate and insert records into {}: {}", new Object[]{tableName, e.getMessage(), e});
        }
    }

    private List<String> parseBusinessKey(String businessKey) {
        if (businessKey == null || businessKey.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(businessKey.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private String createCompositeKey(Map<String, Object> record, List<String> keyFields) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < keyFields.size(); ++i) {
            Object value;
            if (i > 0) {
                key.append("|");
            }
            key.append((value = record.get(keyFields.get(i))) != null ? value.toString() : "null");
        }
        return key.toString();
    }

    private Map<String, Map<String, Object>> buildRecordMap(List<Map<String, Object>> records, List<String> keyFields) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        for (Map<String, Object> record : records) {
            String compositeKey = this.createCompositeKey(record, keyFields);
            if (compositeKey.contains("null")) continue;
            map.put(compositeKey, record);
        }
        return map;
    }

    private boolean hasChanges(Map<String, Object> sourceRecord, Map<String, Object> targetRecord, List<String> keyFields) {
        for (Map.Entry<String, Object> entry : sourceRecord.entrySet()) {
            Object targetValue;
            Object sourceValue;
            String column = entry.getKey();
            if (keyFields != null && keyFields.contains(column) || column.equals("createdon") || column.equals("createdby") || Objects.equals(sourceValue = entry.getValue(), targetValue = targetRecord.get(column))) continue;
            return true;
        }
        return false;
    }

    private String quoteIdentifier(String identifier) {
        return "\"" + identifier + "\"";
    }

    private Map<String, String> getColumnTypes(JdbcTemplate jdbcTemplate, String schema, String table) {
        HashMap<String, String> columnTypes = new HashMap<String, String>();
        try {
            String sql = "SELECT column_name, data_type FROM information_schema.columns WHERE table_schema = ? AND table_name = ?";
            List rows = jdbcTemplate.queryForList(sql, new Object[]{schema, table});
            for (Map row : rows) {
                String columnName = (String)row.get("column_name");
                String dataType = (String)row.get("data_type");
                columnTypes.put(columnName, dataType);
            }
        }
        catch (Exception e) {
            log.warn("Could not fetch column types for {}.{}: {}", new Object[]{schema, table, e.getMessage()});
        }
        return columnTypes;
    }

    private Object convertValue(Object value, String dataType) {
        if (value == null || dataType == null) {
            return value;
        }
        if ((dataType.contains("timestamp") || dataType.equals("date") || dataType.contains("time")) && value instanceof String) {
            String strValue = (String)value;
            if (strValue.trim().isEmpty()) {
                return null;
            }
            return this.parseTimestamp(strValue);
        }
        if ((dataType.equals("integer") || dataType.equals("bigint") || dataType.equals("smallint")) && value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        if (dataType.equals("boolean") && value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        if ((dataType.equals("numeric") || dataType.contains("decimal") || dataType.equals("double precision") || dataType.equals("real")) && value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        return value;
    }

    private Timestamp parseTimestamp(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        try {
            OffsetDateTime odt = OffsetDateTime.parse(value, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            return Timestamp.from(odt.toInstant());
        }
        catch (DateTimeParseException odt) {
            String[] patterns;
            for (String pattern : patterns = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss.SSSSSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd"}) {
                try {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
                    LocalDateTime ldt = pattern.contains("HH") ? LocalDateTime.parse(value, formatter) : LocalDate.parse(value, formatter).atStartOfDay();
                    return Timestamp.valueOf(ldt);
                }
                catch (DateTimeParseException dateTimeParseException) {
                }
            }
            log.warn("Could not parse timestamp value: {}", (Object)value);
            return null;
        }
    }

    private OperationType updateRecord(JdbcTemplate jdbcTemplate, String tableName, Map<String, Object> record, List<String> matchKeyFields, List<String> keyFields, boolean isAutoGenerated, Map<String, String> columnTypes) {
        try {
            StringBuilder sql = new StringBuilder("UPDATE ").append(tableName).append(" SET ");
            ArrayList<Object> values = new ArrayList<Object>();
            int columnCount = 0;
            for (Map.Entry<String, Object> entry : record.entrySet()) {
                String column = entry.getKey();
                if (isAutoGenerated && keyFields != null && keyFields.contains(column) || column.equals("createdon") || column.equals("createdby")) continue;
                if (columnCount > 0) {
                    sql.append(", ");
                }
                sql.append(this.quoteIdentifier(column)).append(" = ?");
                values.add(this.convertValue(entry.getValue(), columnTypes.get(column)));
                ++columnCount;
            }
            if (columnCount == 0) {
                log.debug("No columns to update for record in {}", (Object)tableName);
                return OperationType.SKIP;
            }
            sql.append(" WHERE ");
            for (int i = 0; i < matchKeyFields.size(); ++i) {
                if (i > 0) {
                    sql.append(" AND ");
                }
                String field = matchKeyFields.get(i);
                sql.append(this.quoteIdentifier(field)).append(" = ?");
                values.add(record.get(field));
            }
            jdbcTemplate.update(sql.toString(), values.toArray());
            log.debug("Updated record in {} with composite key", (Object)tableName);
            return OperationType.UPDATE;
        }
        catch (Exception e) {
            log.error("Failed to update record in {}: {}", (Object)tableName, (Object)e.getMessage());
            return OperationType.SKIP;
        }
    }

    private OperationType insertRecord(JdbcTemplate jdbcTemplate, String tableName, Map<String, Object> record, List<String> keyFields, boolean isAutoGenerated, Map<String, String> columnTypes) {
        try {
            StringBuilder columns = new StringBuilder();
            StringBuilder placeholders = new StringBuilder();
            ArrayList<Object> values = new ArrayList<Object>();
            int columnCount = 0;
            for (Map.Entry<String, Object> entry : record.entrySet()) {
                String column = entry.getKey();
                if (isAutoGenerated && keyFields != null && keyFields.contains(column)) continue;
                if (columnCount > 0) {
                    columns.append(", ");
                    placeholders.append(", ");
                }
                columns.append(this.quoteIdentifier(column));
                placeholders.append("?");
                values.add(this.convertValue(entry.getValue(), columnTypes.get(column)));
                ++columnCount;
            }
            String sql = String.format("INSERT INTO %s (%s) VALUES (%s)", tableName, columns, placeholders);
            jdbcTemplate.update(sql, values.toArray());
            log.debug("Inserted new record into {}", (Object)tableName);
            return OperationType.INSERT;
        }
        catch (Exception e) {
            log.error("Failed to insert record into {}: {}", (Object)tableName, (Object)e.getMessage());
            return OperationType.SKIP;
        }
    }

    public void deleteRecord(String ipAddress, int port, String database, String schema, String table, String businessKey, Object keyValue) {
        log.info("Deleting record from {}.{}.{} where {}={}", new Object[]{database, schema, table, businessKey, keyValue});
        try {
            DataSource remoteDataSource = this.createRemoteDataSource(ipAddress, database, port);
            JdbcTemplate jdbcTemplate = new JdbcTemplate(remoteDataSource);
            String fullTableName = schema + "." + table;
            String deleteKey = businessKey != null ? businessKey : "id";
            String sql = String.format("DELETE FROM %s WHERE %s = ?", fullTableName, deleteKey);
            int rowsDeleted = jdbcTemplate.update(sql, new Object[]{keyValue});
            log.info("Deleted {} record(s) from {}", (Object)rowsDeleted, (Object)fullTableName);
        }
        catch (Exception e) {
            log.error("Failed to delete record: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private List<Map<String, Object>> resolveForeignKeyReferences(List<Map<String, Object>> sourceRecords, List<Map<String, String>> foreignKeyMappings, Map<String, Object> dumpData, String ipAddress, int port) {
        if (sourceRecords.isEmpty()) {
            return sourceRecords;
        }
        HashMap<String, Map> sourceLookupMaps = new HashMap<String, Map>();
        HashMap<String, Map> targetLookupMaps = new HashMap<String, Map>();
        List allTables = (List)dumpData.get("tables");
        for (Map<String, String> mapping : foreignKeyMappings) {
            String fkColumn = mapping.get("column");
            String refDatabase = mapping.get("refDatabase");
            String refSchema = mapping.get("refSchema");
            String refTable = mapping.get("refTable");
            String refKeyField = mapping.get("refKeyField");
            String refBusinessKey = mapping.get("refBusinessKey");
            log.debug("Building lookup for FK column '{}' -> {}.{}.{} via {}", new Object[]{fkColumn, refDatabase, refSchema, refTable, refBusinessKey});
            Map sourceIdToBusinessKey = this.buildSourceLookupMap(allTables, refDatabase, refSchema, refTable, refKeyField, refBusinessKey);
            sourceLookupMaps.put(fkColumn, sourceIdToBusinessKey);
            log.debug("Source lookup map for '{}' has {} entries", (Object)fkColumn, (Object)sourceIdToBusinessKey.size());
            Map businessKeyToTargetId = this.buildTargetLookupMap(ipAddress, port, refDatabase, refSchema, refTable, refKeyField, refBusinessKey);
            targetLookupMaps.put(fkColumn, businessKeyToTargetId);
            log.debug("Target lookup map for '{}' has {} entries", (Object)fkColumn, (Object)businessKeyToTargetId.size());
        }
        ArrayList<Map<String, Object>> resolvedRecords = new ArrayList<Map<String, Object>>();
        int resolvedCount = 0;
        int skippedCount = 0;
        for (Map<String, Object> sourceRecord : sourceRecords) {
            HashMap<String, Object> resolvedRecord = new HashMap<String, Object>(sourceRecord);
            boolean allResolved = true;
            for (Map<String, String> mapping : foreignKeyMappings) {
                String fkColumn = mapping.get("column");
                Object sourceIdValue = sourceRecord.get(fkColumn);
                if (sourceIdValue == null) continue;
                Map sourceMap = (Map)sourceLookupMaps.get(fkColumn);
                Object businessKeyValue = sourceMap.get(sourceIdValue);
                if (businessKeyValue == null) {
                    log.warn("Could not find business key for {} = {} in source data", (Object)fkColumn, sourceIdValue);
                    allResolved = false;
                    continue;
                }
                Map targetMap = (Map)targetLookupMaps.get(fkColumn);
                Object targetIdValue = targetMap.get(businessKeyValue);
                if (targetIdValue == null) {
                    log.warn("Could not resolve target ID for {} business key '{}' - record will be skipped", (Object)fkColumn, businessKeyValue);
                    allResolved = false;
                    continue;
                }
                resolvedRecord.put(fkColumn, targetIdValue);
                log.debug("Resolved {} : {} \u2192 '{}' \u2192 {}", new Object[]{fkColumn, sourceIdValue, businessKeyValue, targetIdValue});
            }
            if (allResolved) {
                resolvedRecords.add(resolvedRecord);
                ++resolvedCount;
                continue;
            }
            ++skippedCount;
        }
        log.info("FK resolution complete. Resolved: {}, Skipped: {}", (Object)resolvedCount, (Object)skippedCount);
        return resolvedRecords;
    }

    private Map<Object, Object> buildSourceLookupMap(List<Map<String, Object>> allTables, String database, String schema, String table, String keyField, String businessKey) {
        HashMap<Object, Object> lookupMap = new HashMap<Object, Object>();
        for (Map<String, Object> tbl : allTables) {
            if (!database.equals(tbl.get("database")) || !schema.equals(tbl.get("schema")) || !table.equals(tbl.get("table"))) continue;
            List records = (List)tbl.get("data");
            if (records == null) break;
            for (Map rec : records) {
                Object keyValue = rec.get(keyField);
                Object businessValue = rec.get(businessKey);
                if (keyValue == null || businessValue == null) continue;
                lookupMap.put(keyValue, businessValue);
            }
        }
        return lookupMap;
    }

    private Map<Object, Object> buildTargetLookupMap(String ipAddress, int port, String database, String schema, String table, String keyField, String businessKey) {
        HashMap<Object, Object> lookupMap = new HashMap<Object, Object>();
        try {
            DataSource targetDataSource = this.createRemoteDataSource(ipAddress, database, port);
            JdbcTemplate jdbcTemplate = new JdbcTemplate(targetDataSource);
            String fullTableName = schema + "." + table;
            String sql = String.format("SELECT %s, %s FROM %s", this.quoteIdentifier(keyField), this.quoteIdentifier(businessKey), fullTableName);
            List rows = jdbcTemplate.queryForList(sql);
            for (Map row : rows) {
                Object keyValue = row.get(keyField);
                Object businessValue = row.get(businessKey);
                if (keyValue == null || businessValue == null) continue;
                lookupMap.put(businessValue, keyValue);
            }
        }
        catch (Exception e) {
            log.error("Failed to build target lookup map for {}.{}: {}", new Object[]{schema, table, e.getMessage()});
        }
        return lookupMap;
    }

    private List<Map<String, Object>> readTableConfiguration() {
        ClassPathResource resource = new ClassPathResource("default-data/database-schema-tables.json");
        try {
            return (List)this.objectMapper.readValue(resource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            log.error("Failed to read table configuration", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

