/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.telemetry.main.repository;

import com.coraltele.db.telemetry.main.entity.BillingCDR;
import com.coraltele.service.telemetry.main.billingCDR.model.BillingCDRGatewayModel;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface BillingCDRRepository
extends JpaRepository<BillingCDR, Long>,
JpaSpecificationExecutor<BillingCDR> {
    public Page<BillingCDR> findAll(Specification<BillingCDR> var1, Pageable var2);

    public List<BillingCDR> findAll(Specification<BillingCDR> var1, Sort var2);

    public List<BillingCDR> findAll(Specification<BillingCDR> var1);

    @Query(value="SELECT DISTINCT new com.coraltele.service.telemetry.main.billingCDR.model.BillingCDRGatewayModel(b.coralGateway) FROM BillingCDR b WHERE b.coralGateway IS NOT NULL AND TRIM(b.coralGateway) <> ''")
    public List<BillingCDRGatewayModel> findDistinctGateways();

    @Query(value="SELECT DISTINCT new com.coraltele.service.telemetry.main.billingCDR.model.BillingCDRGatewayModel(b.coralInBoundGateway) FROM BillingCDR b WHERE b.coralInBoundGateway IS NOT NULL AND TRIM(b.coralInBoundGateway) <> ''")
    public List<BillingCDRGatewayModel> findDistinctInBoundGateways();

    @Query(value="SELECT * FROM (    SELECT coral_gateway,        SUM(intercom_call) AS intercom_call,        SUM(intercom_cost) AS intercom_cost,        SUM(local_call) AS local_call,        SUM(local_cost) AS local_cost,        SUM(std_call) AS std_call,        SUM(std_cost) AS std_cost,        SUM(isd_call) AS isd_call,        SUM(isd_cost) AS isd_cost,        COUNT(total_call) AS total_call,        SUM(total_cost) AS total_cost    FROM (        SELECT coral_gateway,            CAST(                to_timestamp(start_epoch) AS DATE            ) AS call_date,            CASE WHEN call_type = 'INTERCOM' THEN 1 ELSE 0 END AS intercom_call,            CASE WHEN call_type = 'INTERCOM' THEN cost ELSE 0 END AS intercom_cost,            CASE WHEN call_type = 'LOCAL' THEN 1 ELSE 0 END AS local_call,            CASE WHEN call_type = 'LOCAL' THEN cost ELSE 0 END AS local_cost,            CASE WHEN call_type = 'STD' THEN 1 ELSE 0 END AS std_call,            CASE WHEN call_type = 'STD' THEN cost ELSE 0 END AS std_cost,            CASE WHEN call_type = 'ISD' THEN 1 ELSE 0 END AS isd_call,            CASE WHEN call_type = 'ISD' THEN cost ELSE 0 END AS isd_cost,            call_type AS total_call,            cost AS total_cost        FROM billing_cdr WHERE COALESCE(coral_gateway , '') <> ''    ) a    WHERE a.call_date >= COALESCE(:fromDate, a.call_date)      AND a.call_date <= COALESCE(:toDate, a.call_date)      AND a.coral_gateway = COALESCE(:gateway, a.coral_gateway)    GROUP BY a.coral_gateway ) x ORDER BY coral_gateway ASC LIMIT :limit OFFSET :offset", nativeQuery=true)
    public List<Object[]> fetchAsc(@Param(value="fromDate") LocalDate var1, @Param(value="toDate") LocalDate var2, @Param(value="gateway") String var3, @Param(value="limit") int var4, @Param(value="offset") int var5);

    @Query(value="SELECT * FROM (    SELECT        coral_gateway,        SUM(intercom_call) AS intercom_call,        SUM(intercom_cost) AS intercom_cost,        SUM(local_call) AS local_call,        SUM(local_cost) AS local_cost,        SUM(std_call) AS std_call,        SUM(std_cost) AS std_cost,        SUM(isd_call) AS isd_call,        SUM(isd_cost) AS isd_cost,        COUNT(total_call) AS total_call,        SUM(total_cost) AS total_cost    FROM (        SELECT            coral_gateway,            CAST(                to_timestamp(start_epoch) AS DATE            ) AS call_date,            CASE WHEN call_type = 'INTERCOM' THEN 1 ELSE 0 END AS intercom_call,            CASE WHEN call_type = 'INTERCOM' THEN cost ELSE 0 END AS intercom_cost,            CASE WHEN call_type = 'LOCAL' THEN 1 ELSE 0 END AS local_call,            CASE WHEN call_type = 'LOCAL' THEN cost ELSE 0 END AS local_cost,            CASE WHEN call_type = 'STD' THEN 1 ELSE 0 END AS std_call,            CASE WHEN call_type = 'STD' THEN cost ELSE 0 END AS std_cost,            CASE WHEN call_type = 'ISD' THEN 1 ELSE 0 END AS isd_call,            CASE WHEN call_type = 'ISD' THEN cost ELSE 0 END AS isd_cost,            call_type AS total_call,            cost AS total_cost        FROM billing_cdr WHERE COALESCE(coral_gateway , '') <> ''    ) a    WHERE (:fromDate IS NULL OR a.call_date >= :fromDate)      AND (:toDate IS NULL OR a.call_date <= :toDate)      AND (:gateway IS NULL OR a.coral_gateway = :gateway)    GROUP BY a.coral_gateway ) x ORDER BY coral_gateway DESC LIMIT :limit OFFSET :offset", nativeQuery=true)
    public List<Object[]> fetchDesc(@Param(value="fromDate") LocalDate var1, @Param(value="toDate") LocalDate var2, @Param(value="gateway") String var3, @Param(value="limit") int var4, @Param(value="offset") int var5);

    @Query(value="SELECT     coral_inboundgateway,     SUM(TotalCall) AS TotalCall,     SUM(Answered) AS Answered,     SUM(UnAnswered) AS UnAnswered,     SUM(RingDuration) AS RingDuration,     SUM(AvgRingDuration) AS AvgRingDuration,     SUM(TalkDuration) AS TalkDuration,     SUM(AvgCallDuration) AS AvgCallDuration FROM (     SELECT         coral_inboundgateway,         CAST(             to_timestamp(start_epoch) AS DATE         ) AS call_date,         COUNT(*) AS TotalCall,         COUNT(CASE WHEN call_connected = 'true' THEN 1 END) AS Answered,         COUNT(CASE WHEN call_connected = 'false' THEN 1 END) AS UnAnswered,         SUM(ring_duration) AS RingDuration,         ROUND(             CAST(SUM(ring_duration) AS numeric) / NULLIF(COUNT(*), 0),             2         ) AS AvgRingDuration,         SUM(talk_duration) AS TalkDuration,         ROUND(             CAST(SUM(talk_duration) AS numeric) /             NULLIF(COUNT(CASE WHEN call_connected = 'true' THEN 1 END), 0),             2         ) AS AvgCallDuration     FROM billing_cdr  WHERE COALESCE(coral_inboundgateway , '') <> ''     GROUP BY coral_inboundgateway, call_date ) a WHERE a.call_date >= COALESCE(:fromDate, a.call_date)   AND a.call_date <= COALESCE(:toDate, a.call_date)   AND a.coral_inboundgateway = COALESCE(:inBoundGateway, a.coral_inboundgateway) GROUP BY a.coral_inboundgateway ORDER BY a.coral_inboundgateway", nativeQuery=true)
    public List<Object[]> getInboundSummary(@Param(value="fromDate") LocalDate var1, @Param(value="toDate") LocalDate var2, @Param(value="inBoundGateway") String var3);

    @Query(value="SELECT     a.Extension_No,     SUM(a.TotalCall) AS TotalCall,     SUM(a.Answered) AS Answered,     SUM(a.UnAnswered) AS UnAnswered,     SUM(a.RingDuration) AS RingDuration,     SUM(a.AvgRingDuration) AS AvgRingDuration,     SUM(a.CallDuration) AS CallDuration,     SUM(a.AvgCallDuration) AS AvgCallDuration FROM (     SELECT         destination_number AS Extension_No,         COUNT(*) AS TotalCall,         COUNT(CASE WHEN call_connected = 'true' THEN 1 END) AS Answered,         COUNT(CASE WHEN call_connected = 'false' THEN 1 END) AS UnAnswered,         SUM(ring_duration) AS RingDuration,         ROUND(CAST(SUM(ring_duration) AS numeric) / NULLIF(COUNT(*), 0), 2) AS AvgRingDuration,         SUM(talk_duration) AS CallDuration,         ROUND(             CAST(SUM(talk_duration) AS numeric) /             NULLIF(COUNT(CASE WHEN call_connected = 'true' THEN 1 END), 0),             2         ) AS AvgCallDuration,         CAST(             to_timestamp(start_epoch)AS DATE         ) AS call_date     FROM billing_cdr     WHERE coral_call_direction IN ('IN','INT')       AND (coral_featurecode IS NULL OR coral_featurecode = '')       AND destination_extension_type = 'phone'       AND (:search IS NULL OR destination_number ILIKE CONCAT('%', :search, '%'))     GROUP BY destination_number, call_date ) a WHERE (CAST(:fromDate AS DATE) IS NULL OR a.call_date >= CAST(:fromDate AS DATE))   AND (CAST(:toDate AS DATE) IS NULL OR a.call_date <= CAST(:toDate AS DATE))   AND (:extension IS NULL OR a.Extension_No = :extension) GROUP BY a.Extension_No ORDER BY     CASE WHEN :sortBy = 'extension' AND :sortDir = 'asc' THEN a.Extension_No END ASC,     CASE WHEN :sortBy = 'extension' AND :sortDir = 'desc' THEN a.Extension_No END DESC,     CASE WHEN :sortBy = 'totalCall' AND :sortDir = 'asc' THEN SUM(a.TotalCall) END ASC,     CASE WHEN :sortBy = 'totalCall' AND :sortDir = 'desc' THEN SUM(a.TotalCall) END DESC ", nativeQuery=true)
    public List<Object[]> getExtensionSummary(@Param(value="fromDate") LocalDate var1, @Param(value="toDate") LocalDate var2, @Param(value="extension") String var3, @Param(value="search") String var4, @Param(value="sortBy") String var5, @Param(value="sortDir") String var6);

    @Query(value="SELECT   caller_id_number,   SUM(IntercomCall) AS IntercomCall,   SUM(IntercomCost) AS IntercomCost,   SUM(LocalCall) AS LocalCall,   SUM(LocalCost) AS LocalCost,   SUM(STDCall) AS STDCall,   SUM(STDCost) AS STDCost,   SUM(ISDCall) AS ISDCall,   SUM(ISDCost) AS ISDCost,   SUM(TotalCall) AS TotalCall,   SUM(TotalCost) AS TotalCost FROM (    SELECT      caller_id_number,      CAST(          to_timestamp(start_epoch) AS DATE      ) AS call_date,      COUNT(CASE WHEN call_type = 'INTERCOM' THEN 1 END) AS IntercomCall,      SUM(CASE WHEN call_type = 'INTERCOM' THEN cost ELSE 0 END) AS IntercomCost,      COUNT(CASE WHEN call_type = 'LOCAL' THEN 1 END) AS LocalCall,      SUM(CASE WHEN call_type = 'LOCAL' THEN cost ELSE 0 END) AS LocalCost,      COUNT(CASE WHEN call_type = 'STD' THEN 1 END) AS STDCall,      SUM(CASE WHEN call_type = 'STD' THEN cost ELSE 0 END) AS STDCost,      COUNT(CASE WHEN call_type = 'ISD' THEN 1 END) AS ISDCall,      SUM(CASE WHEN call_type = 'ISD' THEN cost ELSE 0 END) AS ISDCost,      COUNT(CASE WHEN call_type IS NOT NULL THEN 1 END) AS TotalCall,      SUM(CASE WHEN call_type IS NOT NULL THEN cost ELSE 0 END) AS TotalCost    FROM billing_cdr    WHERE coral_call_direction IN ('OUT','INT')   AND  caller_extension_type = 'phone'  AND (:search IS NULL OR caller_id_number ILIKE CONCAT('%', :search, '%'))      AND (coral_featurecode IS NULL OR coral_featurecode = '')    GROUP BY caller_id_number, call_date ) a WHERE (CAST(:fromDate AS DATE) IS NULL OR a.call_date >= CAST(:fromDate AS DATE))   AND (CAST(:toDate AS DATE) IS NULL OR a.call_date <= CAST(:toDate AS DATE))   AND (:callerId IS NULL OR a.caller_id_number = :callerId) GROUP BY caller_id_number ORDER BY caller_id_number", nativeQuery=true)
    public List<Object[]> getCallerSummary(@Param(value="fromDate") LocalDate var1, @Param(value="toDate") LocalDate var2, @Param(value="callerId") String var3, @Param(value="search") String var4);

    @Query(value="SELECT   destination_number AS extension_no,   to_char(to_timestamp(start_epoch), 'YYYY-MM-DD HH24:MI:SS') AS call_date,   caller_id_number AS called_no,   call_type,   talk_duration,   ring_duration,   coral_call_direction,   coral_featurecode,   CASE WHEN call_connected = 'true' THEN 'YES' ELSE 'NO' END AS connected,   transfer_agent,   CASE WHEN transfer_agent IS NULL OR transfer_agent = '' THEN 'NO' ELSE 'YES' END AS transfer FROM billing_cdr WHERE coral_call_direction IN ('IN','INT')   AND destination_extension_type = 'phone'   AND (coral_featurecode IS NULL OR coral_featurecode = '')   AND ( :callerId IS NULL         OR caller_id_number ILIKE CONCAT('%', :callerId, '%'))   AND ( :extension IS NULL         OR destination_number ILIKE CONCAT('%', :extension, '%') )   AND ( :callType IS NULL         OR call_type ILIKE CONCAT('%', :callType, '%') )  AND ( COALESCE(:extension, '') = '' OR destination_number = :extension )   AND ( CAST(:fromDate AS DATE) IS NULL         OR CAST(to_timestamp(start_epoch) AS DATE) >= CAST(:fromDate AS DATE) )   AND ( CAST(:toDate AS DATE) IS NULL         OR CAST(to_timestamp(start_epoch) AS DATE) <= CAST(:toDate AS DATE) ) ORDER BY destination_number, call_date DESC", nativeQuery=true)
    public List<Object[]> extensionDetailsIn(@Param(value="fromDate") LocalDate var1, @Param(value="toDate") LocalDate var2, @Param(value="extension") String var3, @Param(value="callerId") String var4, @Param(value="callType") String var5);

    @Query(value="select department_code, department_name, caller_id_number,        sum(IntercomCall) as IntercomCall,        sum(IntercomCost) as IntercomCost,        sum(LocalCall) as LocalCall,        sum(LocalCost) as LocalCost,        sum(STDCall) as STDCall,        sum(STDCost) as STDCost,        sum(ISDCall) as ISDCall,        sum(ISDCost) as ISDCost,        sum(TotalCall) as TotalCall,        sum(TotalCost) as TotalCost from (      SELECT department_code, department_name, caller_id_number,             CAST(to_timestamp(start_epoch) AS date) AS call_date,             COUNT(CASE WHEN call_type = 'INTERCOM' THEN 1 END) AS IntercomCall,             SUM(CASE WHEN call_type = 'INTERCOM' THEN cost ELSE 0 END) AS IntercomCost,             COUNT(CASE WHEN call_type = 'LOCAL' THEN 1 END) AS LocalCall,             SUM(CASE WHEN call_type = 'LOCAL' THEN cost ELSE 0 END) AS LocalCost,             COUNT(CASE WHEN call_type = 'STD' THEN 1 END) AS STDCall,             SUM(CASE WHEN call_type = 'STD' THEN cost ELSE 0 END) AS STDCost,             COUNT(CASE WHEN call_type = 'ISD' THEN 1 END) AS ISDCall,             SUM(CASE WHEN call_type = 'ISD' THEN cost ELSE 0 END) AS ISDCost,             COUNT(CASE WHEN call_type IS NOT NULL THEN 1 END) AS TotalCall,             SUM(CASE WHEN call_type IS NOT NULL THEN cost ELSE 0 END) AS TotalCost      FROM billing_cdr      WHERE coral_call_direction in ('OUT','INT')        AND caller_extension_type = 'phone'        AND (coral_featurecode is null or coral_featurecode='')     AND (:deptCode IS NULL OR LOWER(department_code) LIKE LOWER(CONCAT('%', :deptCode, '%')))      AND (:deptName IS NULL OR LOWER(department_name) LIKE LOWER(CONCAT('%', :deptName, '%')))      AND (:callerIdNumber IS NULL OR caller_id_number LIKE CONCAT('%', :callerIdNumber, '%'))        AND (CAST(:fromDate AS date) IS NULL OR CAST(to_timestamp(start_epoch) AS date) >= CAST(:fromDate AS date))        AND (CAST(:toDate AS date) IS NULL OR CAST(to_timestamp(start_epoch) AS date) <= CAST(:toDate AS date))      GROUP BY department_code, department_name, caller_id_number, call_date ) a group by department_code, department_name, caller_id_number", nativeQuery=true)
    public List<Object[]> getDepartmentSummaryReport(@Param(value="deptCode") String var1, @Param(value="deptName") String var2, @Param(value="callerIdNumber") String var3, @Param(value="fromDate") LocalDate var4, @Param(value="toDate") LocalDate var5);

    @Query(value="SELECT  id, department_code AS departmentCode, department_name AS departmentName, caller_id_number AS callerIdNumber,  to_char(to_timestamp(start_epoch), 'DDMMYY HH24MISS') AS datetimeIst,  destination_number AS destinationNumber,  call_type AS callType, coral_call_direction AS coralCallDirection,  talk_duration AS talkDuration, pulse, cost FROM billing_cdr WHERE coral_call_direction IN ('OUT','INT') AND caller_extension_type = 'phone' AND (coral_featurecode IS NULL OR coral_featurecode = '') AND call_type IS NOT NULL AND (:departmentCode IS NULL OR LOWER(department_code) LIKE LOWER(CONCAT('%', :departmentCode, '%'))) AND (:departmentName IS NULL OR LOWER(department_name) LIKE LOWER(CONCAT('%', :departmentName, '%'))) AND (:callerId IS NULL OR caller_id_number LIKE CONCAT('%', :callerId, '%')) AND (:callType IS NULL OR call_type = :callType) AND (:destinationNumber IS NULL OR destination_number LIKE CONCAT('%', :destinationNumber, '%')) AND (CAST(:fromDate AS date) IS NULL OR CAST(to_timestamp(start_epoch) AS date) >= CAST(:fromDate AS date)) AND (CAST(:toDate AS date) IS NULL OR CAST(to_timestamp(start_epoch) AS date) <= CAST(:toDate AS date)) ORDER BY department_code, department_name, caller_id_number, start_epoch desc", nativeQuery=true)
    public List<Object[]> getDepartmentDetailsReport(@Param(value="departmentCode") String var1, @Param(value="departmentName") String var2, @Param(value="callerId") String var3, @Param(value="callType") String var4, @Param(value="destinationNumber") String var5, @Param(value="fromDate") LocalDate var6, @Param(value="toDate") LocalDate var7);
}

