/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.service;

import com.coraltele.db.users.main.entity.ExternalApplication;
import com.coraltele.db.users.main.entity.Role;
import com.coraltele.db.users.main.repository.ExternalApplicationRepository;
import com.coraltele.db.users.main.repository.RoleRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.service.user.model.ExternalApplicationModel;
import com.coraltele.service.user.model.ProvisioningApplicationModel;
import com.coraltele.service.user.service.UserRoleMenuService;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalApplicationService {
    private static final Logger logger = LogManager.getLogger(ExternalApplicationService.class);
    @Autowired
    ExternalApplicationRepository extApplicationRepository;
    @Autowired
    UserRoleMenuService userRoleMenuService;
    @Autowired
    RoleRepository roleRepository;

    public RequestResponse createNewApplication(ExternalApplicationModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            ExternalApplication externalApplication = new ExternalApplication();
            externalApplication.setApplicationName(data.getApplicationName());
            externalApplication.setCookieName(data.getCookieName());
            externalApplication.setCreatedBy(principal.getName());
            externalApplication.setCreatedOn(LocalDateTime.now());
            externalApplication.setUrl(data.getUrl());
            externalApplication.setUuid(UUID.randomUUID().toString());
            externalApplication.setRole(data.getRole());
            this.extApplicationRepository.save((Object)externalApplication);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage(" Registered new data");
            returnValue.setMessageDetail("Application registered successfully ");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to create new data");
            returnValue.setMessageDetail("Contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse deleteData(InputIdModel id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            for (Integer ids : id.getIntId()) {
                Optional extApplication = this.extApplicationRepository.findById((Object)ids);
                if (extApplication.isPresent()) {
                    this.extApplicationRepository.deleteById((Object)ids);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("deleted");
                    returnValue.setMessageDetail("Record deleted successfully");
                    logger.info(returnValue.getMessage());
                    continue;
                }
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to delete data");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.extApplicationRepository.findAll();
        ArrayList<ExternalApplicationModel> addValue = new ArrayList<ExternalApplicationModel>();
        RequestResponse returnValue = new RequestResponse();
        for (ExternalApplication record : list) {
            ExternalApplicationModel data = new ExternalApplicationModel();
            data.setId(record.getId());
            data.setApplicationName(record.getApplicationName());
            data.setCookieName(record.getCookieName());
            data.setCreatedBy(record.getCreatedBy());
            data.setCreatedOn(record.getCreatedOn());
            data.setRole(record.getRole());
            data.setUpdatedBy(record.getUpdatedBy());
            data.setUpdatedOn(record.getUpdatedOn());
            data.setUrl(record.getUrl());
            data.setUuid(record.getUuid());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateData(ExternalApplicationModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional extApplication = this.extApplicationRepository.findById((Object)data.getId());
            if (extApplication.isPresent()) {
                if (data.getApplicationName() != null) {
                    ((ExternalApplication)extApplication.get()).setApplicationName(data.getApplicationName());
                }
                if (data.getCookieName() != null) {
                    ((ExternalApplication)extApplication.get()).setCookieName(data.getCookieName());
                }
                if (data.getUrl() != null) {
                    ((ExternalApplication)extApplication.get()).setUrl(data.getUrl());
                }
                if (data.getRole() != null) {
                    ((ExternalApplication)extApplication.get()).setRole(data.getRole());
                }
                ((ExternalApplication)extApplication.get()).setUpdatedBy(principal.getName());
                ((ExternalApplication)extApplication.get()).setUpdatedOn(LocalDateTime.now());
                this.extApplicationRepository.save(extApplication.get());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated");
                returnValue.setMessageDetail("application data Updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("application data not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update application data");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.error(returnValue.getMessage(), (Object)e.getMessage());
        }
        return returnValue;
    }

    public List<ProvisioningApplicationModel> applicationListByRole(String userName) {
        ArrayList<ProvisioningApplicationModel> addValue = new ArrayList<ProvisioningApplicationModel>();
        List roles = this.userRoleMenuService.rolesOfParticularUser(userName);
        if (!roles.isEmpty()) {
            for (String role : roles) {
                List applicationList;
                Optional mainRoleData = this.roleRepository.findByShortCode(role);
                if (!mainRoleData.isPresent() || (applicationList = this.extApplicationRepository.findByRole(Long.valueOf(((Role)mainRoleData.get()).getId().intValue()))).isEmpty()) continue;
                for (ExternalApplication record : applicationList) {
                    ProvisioningApplicationModel data = new ProvisioningApplicationModel();
                    data.setApplicationName(record.getApplicationName());
                    data.setCookieName(record.getCookieName());
                    data.setId(record.getId());
                    data.setUrl(record.getUrl());
                    addValue.add(data);
                }
            }
        }
        return addValue;
    }
}

