/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.service;

import com.coraltele.db.billing.main.entity.SendFaxProgress;
import com.coraltele.db.billing.main.repository.SendFaxProgressRepository;
import com.coraltele.db.billing.main.specification.SendFaxProgressSpecification;
import com.coraltele.db.telephony.uc.repository.SendFaxDetailsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.billing.main.fax.model.FaxSearchAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class SendFaxDetailsService {
    private static final Logger logger = LogManager.getLogger(SendFaxDetailsService.class);
    @Autowired
    SendFaxDetailsRepository sendFaxDetailsRepository;
    @Autowired
    SendFaxProgressRepository sendFaxProgressRepository;

    public RequestResponse getListFromSendFaxProgress(SearchRequest searchRequestData, Authentication authentication) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = SendFaxProgressSpecification.generateFilters((SearchRequest)searchRequestData, (String)authentication.getName());
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.sendFaxProgressRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.sendFaxProgressRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModel(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessageDetail("filtered list");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public List<FaxSearchAttribute> entityToModel(List<SendFaxProgress> sendFaxProgresses) {
        ArrayList<FaxSearchAttribute> addValue = new ArrayList<FaxSearchAttribute>();
        for (SendFaxProgress data : sendFaxProgresses) {
            FaxSearchAttribute modelData = new FaxSearchAttribute();
            modelData.setCreatedBy(data.getCreatedBy());
            modelData.setCreatedOn(data.getCreatedOn());
            modelData.setFromUser(data.getSourceUser());
            modelData.setToUser(data.getDestinationUser());
            modelData.setFileName(data.getVariableFaxFilename());
            modelData.setFileLocation(data.getVariableCurrentApplicationData());
            modelData.setFullFilePath(data.getVariableCurrentApplication());
            modelData.setFileId(data.getFileId());
            modelData.setFileType("image/tiff");
            modelData.setFaxSuccess(data.getFaxSuccess().toString());
            modelData.setFaxResultCode(data.getFaxResultCode().toString());
            modelData.setFaxProgress(data.getFaxResultText());
            modelData.setId(data.getId());
            addValue.add(modelData);
        }
        return addValue;
    }

    public RequestResponse deleteSendFaxDetailsById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional sendFaxDetails = this.sendFaxDetailsRepository.findById(Integer.valueOf(ids));
            if (sendFaxDetails.isPresent()) {
                addValue.add(sendFaxDetails.get());
                this.sendFaxDetailsRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

