/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.taskDetails.service;

import com.coraltele.db.telemetry.main.entity.TaskDetails;
import com.coraltele.db.telemetry.main.repository.TaskDetailsRepository;
import com.coraltele.db.telemetry.main.specification.TaskDetailsSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.taskDetails.model.TaskDetailsCreateModel;
import com.coraltele.service.telemetry.main.taskDetails.model.TaskDetailsModel;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class TaskDetailsService {
    private static final Logger logger = LogManager.getLogger(TaskDetailsService.class);
    @Autowired
    private TaskDetailsRepository taskDetailsRepository;
    @Autowired
    UserService userService;

    public RequestResponse createTaskDetail(TaskDetailsCreateModel data, Principal principal) {
        logger.debug("Creating new task details: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            TaskDetails taskDetails = new TaskDetails();
            taskDetails.setTaskStats(data.getTaskStats());
            taskDetails.setIsDelay(data.getIsDelay());
            taskDetails.setChangedCompletionOn(Long.valueOf(DateFormatUtility.convertLocalDateTimeToEpochLong((LocalDateTime)data.getChangedCompletionOn())));
            taskDetails.setRemarks(data.getRemarks());
            taskDetails.setTaskId(data.getTaskId());
            taskDetails.setTaskStats(data.getTaskStats());
            this.taskDetailsRepository.save((Object)taskDetails);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Task details registered successfully");
            logger.info("Task details saved: {}", (Object)returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to create task details");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllTaskDetails() {
        List list = (List)this.taskDetailsRepository.findAll();
        ArrayList<TaskDetailsModel> taskDetailsModels = new ArrayList<TaskDetailsModel>();
        RequestResponse returnValue = new RequestResponse();
        try {
            for (TaskDetails taskDetails : list) {
                TaskDetailsModel model = new TaskDetailsModel();
                model.setId(taskDetails.getId());
                model.setTaskId(taskDetails.getTaskId());
                model.setTaskStats(taskDetails.getTaskStats());
                model.setStatusUpdatedBy(taskDetails.getStatusUpdatedBy());
                model.setStatusUpdatedOn(DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)taskDetails.getStatusUpdatedOn()));
                model.setIsDelay(taskDetails.getIsDelay());
                model.setChangedCompletionOn(DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)taskDetails.getChangedCompletionOn()));
                taskDetailsModels.add(model);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setData(taskDetailsModels);
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to get task details");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getByTaskId(Integer id) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<TaskDetailsModel> taskDetailsModels = new ArrayList<TaskDetailsModel>();
        List list = this.taskDetailsRepository.findByTaskId(id);
        try {
            for (TaskDetails row : list) {
                TaskDetailsModel data = new TaskDetailsModel();
                data.setChangedCompletionOn(DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)row.getChangedCompletionOn()));
                data.setId(row.getId());
                data.setIsDelay(row.getIsDelay());
                data.setStatusUpdatedBy(row.getStatusUpdatedBy());
                data.setStatusUpdatedByDesignation(this.userService.getDesignationByUsername(row.getStatusUpdatedBy()));
                data.setStatusUpdatedOn(DateFormatUtility.epochToLocalDateTimeAsStringToHandleNull((Long)row.getStatusUpdatedOn()));
                data.setTaskId(row.getTaskId());
                data.setTaskStats(row.getTaskStats());
                data.setRemarks(row.getRemarks());
                taskDetailsModels.add(data);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setData(taskDetailsModels);
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to get task details");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteTaskDetails(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional task = this.taskDetailsRepository.findById((Object)ids);
            if (task.isPresent()) {
                addValue.add(task.get());
                this.taskDetailsRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessage("Record Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateTaskDetails(TaskDetailsModel data, Principal principal) {
        logger.debug("Updating TaskDetails: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional taskDetailsOptional = this.taskDetailsRepository.findById((Object)data.getId());
            if (taskDetailsOptional.isPresent()) {
                TaskDetails taskDetails = (TaskDetails)taskDetailsOptional.get();
                if (data.getTaskStats() != null) {
                    taskDetails.setTaskStats(data.getTaskStats());
                }
                if (data.getStatusUpdatedBy() != null) {
                    taskDetails.setStatusUpdatedBy(principal.getName());
                }
                if (data.getStatusUpdatedOn() != null) {
                    taskDetails.setStatusUpdatedOn(DateFormatUtility.toEpochSeconds((String)data.getStatusUpdatedOn()));
                }
                if (data.getIsDelay() != null) {
                    taskDetails.setIsDelay(data.getIsDelay());
                }
                if (data.getChangedCompletionOn() != null) {
                    taskDetails.setChangedCompletionOn(DateFormatUtility.toEpochSeconds((String)data.getChangedCompletionOn()));
                }
                this.taskDetailsRepository.save((Object)taskDetails);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated successfully");
                returnValue.setMessageDetail("Task Details updated successfully");
                logger.info("Task updated successfully: {}", (Object)data.getId());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Task details not found");
                returnValue.setMessageDetail("No task details found with the given ID");
                logger.info("No task details found with ID: {}", (Object)data.getId());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update task details");
            returnValue.setMessageDetail("Please contact the administrator");
            logger.error("Error while updating task details.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getFilterTaskDetails(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = TaskDetailsSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.taskDetailsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.taskDetailsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

