/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.discoveryIp.service;

import com.coraltele.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.db.telemetry.main.entity.DiscoveredIP;
import com.coraltele.db.telemetry.main.repository.DiscoveredIPRepository;
import com.coraltele.db.telemetry.main.specification.DiscoveryIpSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.discoveryIp.model.DiscoveredIpListModel;
import com.coraltele.service.telemetry.main.discoveryIp.model.DiscoveryIpModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DiscoveryIpService {
    public static final Logger logger = LogManager.getLogger(DiscoveryIpService.class);
    @Autowired
    private DiscoveredIPRepository discoveryRepository;
    @Autowired
    private SCADAAssetRepository scadAssetRepository;

    public RequestResponse getDiscoveryIpByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DiscoveryIpSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = Sort.unsorted();
        String sortBy = searchRequestData.getSortBy();
        String sortDirection = searchRequestData.getSortDirection();
        sort = sort.and(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"inUse")}));
        if (sortBy != null && !sortBy.isEmpty() && sortDirection != null && !sortDirection.isEmpty()) {
            String[] sortFields = sortBy.split(",");
            String[] sortDirections = sortDirection.split(",");
            for (int i = 0; i < sortFields.length; ++i) {
                String field = sortFields[i].trim();
                if ("inUse".equalsIgnoreCase(field)) continue;
                String direction = i < sortDirections.length ? sortDirections[i].trim().toLowerCase() : "asc";
                Sort.Order order = direction.equals("desc") ? Sort.Order.desc((String)field) : Sort.Order.asc((String)field);
                sort = sort.and(Sort.by((Sort.Order[])new Sort.Order[]{order}));
            }
        }
        Page page = null;
        page = sort == null ? this.discoveryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.discoveryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    private List<DiscoveredIpListModel> entityToModelConversion(List<DiscoveredIP> filtered) {
        ArrayList<DiscoveredIpListModel> resultList = new ArrayList<DiscoveredIpListModel>();
        for (DiscoveredIP row : filtered) {
            DiscoveredIpListModel data = new DiscoveredIpListModel();
            data.setIpAddress(row.getIpAddress());
            data.setLocation(row.getLocation());
            data.setIsAlive(row.getIsAlive());
            if (row.getLastSeen() != null) {
                data.setLastSeen(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getDiscoveryTime()).toString());
            } else {
                data.setDiscoveryTime("");
            }
            if (row.getDiscoveryTime() != null) {
                data.setDiscoveryTime(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)row.getDiscoveryTime()).toString());
            } else {
                data.setDiscoveryTime("");
            }
            data.setSuccessCount(row.getSuccessCount());
            data.setFailCount(row.getFailCount());
            data.setInUse(row.getInUse());
            resultList.add(data);
        }
        return resultList;
    }

    public RequestResponse updateIsFalse(List<String> ipList) {
        RequestResponse returnValue = new RequestResponse();
        List discoveredIPs = this.discoveryRepository.findAllByIpAddressIn(ipList);
        for (DiscoveredIP ip : discoveredIPs) {
            ip.setInUse(Boolean.valueOf(false));
        }
        this.discoveryRepository.saveAll((Iterable)discoveredIPs);
        returnValue.setData((Object)discoveredIPs);
        returnValue.setMessage("Updated entries where isFalse set to true");
        returnValue.setMessageDetail("successfully updated");
        return returnValue;
    }

    public RequestResponse createData(DiscoveryIpModel data) {
        RequestResponse returnValue = new RequestResponse();
        List ipAddresses = data.getIpAddress();
        List locations = data.getLocation();
        String category = data.getCategory();
        if (ipAddresses.size() != locations.size()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Mismatch in number of IP addresses and locations.");
            returnValue.setData(Collections.emptyList());
            return returnValue;
        }
        List existingIps = this.scadAssetRepository.findByIpAddressIn(ipAddresses).stream().map(SCADAAsset::getIpAddress).collect(Collectors.toList());
        ArrayList<SCADAAsset> scadaAssets = new ArrayList<SCADAAsset>();
        for (int i = 0; i < ipAddresses.size(); ++i) {
            String ip = (String)ipAddresses.get(i);
            if (existingIps.contains(ip)) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("SCADA assets Ip is Duplicate");
                returnValue.setMessageDetail("SCADA assets  Ip is Duplicate");
                returnValue.setData(Collections.emptyList());
                return returnValue;
            }
            SCADAAsset asset = new SCADAAsset();
            asset.setIpAddress(ip);
            asset.setNodeName(ip);
            asset.setLocation((String)locations.get(i));
            asset.setCategory(category);
            asset.setUuid(UUID.randomUUID());
            asset.setStatus(false);
            scadaAssets.add(asset);
        }
        if (!scadaAssets.isEmpty()) {
            this.scadAssetRepository.saveAll(scadaAssets);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("SCADA assets created successfully.");
        returnValue.setMessageDetail("All IPs saved successfully.");
        return returnValue;
    }
}

