/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.operator.service;

import com.coraltele.db.coralapps.callcenter.entity.OperatorMaster;
import com.coraltele.db.coralapps.callcenter.repository.OperatorMasterRepository;
import com.coraltele.db.coralapps.callcenter.specification.OperatorMasterSpecification;
import com.coraltele.db.coralapps.main.entity.Agent;
import com.coraltele.db.coralapps.main.entity.OperatorTiers;
import com.coraltele.db.coralapps.main.entity.Tiers;
import com.coraltele.db.coralapps.main.repository.AgentRepository;
import com.coraltele.db.coralapps.main.repository.OperatorTiersRepository;
import com.coraltele.db.coralapps.main.repository.TiersRepository;
import com.coraltele.db.telephony.pbx.entity.ControlRluServer;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ControlRluServerRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.users.main.entity.Role;
import com.coraltele.db.users.main.entity.UserRole;
import com.coraltele.db.users.main.repository.RoleRepository;
import com.coraltele.db.users.main.repository.UserRoleRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.main.service.AgentService;
import com.coraltele.service.pbx.fileConfiguration.defaultConfiguration.service.DefaultConfigurationService;
import com.coraltele.service.pbx.operator.model.ExtensionResponseModel;
import com.coraltele.service.pbx.operator.model.OperatorModel;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class OperatorService {
    private static final Logger logger = LogManager.getLogger(OperatorService.class);
    @Autowired
    private OperatorMasterRepository operatorMasterRepository;
    @Autowired
    private ExtensionsRepository extensionsRepository;
    @Autowired
    private UserRoleRepository userRoleRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private TiersRepository tiersRepository;
    @Autowired
    private OperatorTiersRepository operatorTiersRepository;
    @Autowired
    private AgentRepository agentRepository;
    @Autowired
    DefaultConfigurationService extensionFileConfigurationService;
    @Autowired
    private ControlRluServerRepository controlRluServerRepository;

    public RequestResponse createOperator(OperatorModel operatorModel) {
        List operatorTiersListToDelete;
        RequestResponse response = new RequestResponse();
        Optional existingOperator = this.operatorMasterRepository.findByOperatorcode(operatorModel.getOperatorcode());
        if (existingOperator.isPresent()) {
            response.setMessage("Operator already exists");
            response.setStatus(Constants.Error.ERROR);
            return response;
        }
        Optional operatorMasterOptional = this.operatorMasterRepository.findByExtension(operatorModel.getExtension());
        if (operatorMasterOptional.isPresent()) {
            response.setMessage(operatorModel.getExtension() + " has already assigned to Operator " + ((OperatorMaster)operatorMasterOptional.get()).getOperatorcode());
            response.setStatus(Constants.Error.ERROR);
            return response;
        }
        String landingExtension = operatorModel.getLandingextension();
        String extension = operatorModel.getExtension();
        List tiersListToDelete = this.tiersRepository.findByAgent(extension);
        if (tiersListToDelete.size() > 0) {
            this.tiersRepository.deleteAll((Iterable)tiersListToDelete);
        }
        if ((operatorTiersListToDelete = this.operatorTiersRepository.findByAgent(extension)).size() > 0) {
            this.operatorTiersRepository.deleteAll((Iterable)operatorTiersListToDelete);
        }
        List<String> systemNames = Arrays.asList("ACD_" + landingExtension + "_AS", "ACD_" + landingExtension + "_AV", "ACD_" + landingExtension + "_AT", "ACD_" + landingExtension + "_AR_" + extension, "ACD_" + landingExtension + "_AB_" + extension);
        List<String> systemNames1 = Arrays.asList("ACD_" + landingExtension + "_AS", "ACD_" + landingExtension + "_AV", "ACD_" + landingExtension + "_AT", "ACD_" + landingExtension + "_AR_" + extension, "ACD_" + landingExtension + "_AB_" + extension);
        for (String systemName : systemNames) {
            Tiers tier = new Tiers();
            tier.setQueue(systemName);
            tier.setAgent(extension);
            tier.setState("Ready");
            tier.setLevel(Integer.valueOf(1));
            tier.setPosition(Integer.valueOf(1));
            this.tiersRepository.save((Object)tier);
        }
        for (String systemName : systemNames1) {
            OperatorTiers operatorTier = new OperatorTiers();
            operatorTier.setQueue(systemName);
            operatorTier.setAgent(extension);
            operatorTier.setState("Ready");
            operatorTier.setLevel(Integer.valueOf(1));
            operatorTier.setPosition(Integer.valueOf(1));
            this.operatorTiersRepository.save((Object)operatorTier);
        }
        Optional optionalAgent = this.agentRepository.findByName(operatorModel.getExtension());
        if (!optionalAgent.isPresent()) {
            this.createAgentForOperator(extension);
        }
        OperatorMaster operator = new OperatorMaster();
        operator.setOperatorcode(operatorModel.getOperatorcode());
        operator.setLandingextension(operatorModel.getLandingextension());
        operator.setCreatedby(this.getLoggedInUsername());
        operator.setCreatedon(LocalDateTime.now());
        operator.setExtension(operatorModel.getExtension());
        if (operatorModel.getAs() != null) {
            operator.setAs(operatorModel.getAs());
        } else {
            operator.setAs(null);
        }
        if (operatorModel.getAv() != null) {
            operator.setAv(operatorModel.getAv());
        } else {
            operator.setAv(null);
        }
        if (operatorModel.getAb() != null) {
            operator.setAb(operatorModel.getAb());
        } else {
            operator.setAb(null);
        }
        if (operatorModel.getSc() != null) {
            operator.setSerialcall(operatorModel.getSc());
        } else {
            operator.setSerialcall(null);
        }
        if (operatorModel.getAt() != null) {
            operator.setAt(operatorModel.getAt());
        } else {
            operator.setAt(null);
        }
        operator.setOperatorstatus(operatorModel.getOperatorstatus());
        operator.setOperatorstatusupdatedon(operatorModel.getOperatorstatusupdatedon());
        if ("With Headphone".equals(operatorModel.getOperatormode())) {
            operator.setOperatormode(Integer.valueOf(1));
        } else {
            operator.setOperatormode(Integer.valueOf(0));
        }
        this.operatorMasterRepository.save((Object)operator);
        response.setMessage("Operator created successfully");
        response.setStatus(Constants.Error.OK);
        response.setData((Object)operator);
        return response;
    }

    public RequestResponse updateOperator(OperatorModel operatorModel) {
        RequestResponse response = new RequestResponse();
        try {
            Optional optionalAgent;
            Optional extensionCheck;
            Optional operatorMasterOptional = this.operatorMasterRepository.findByOperatorcode(operatorModel.getOperatorcode());
            if (!operatorMasterOptional.isPresent()) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessageDetail("Operator not found");
                return response;
            }
            OperatorMaster operatorMaster = (OperatorMaster)operatorMasterOptional.get();
            if (operatorModel.getExtension() != null && (extensionCheck = this.operatorMasterRepository.findByExtension(operatorModel.getExtension())).isPresent() && !((OperatorMaster)extensionCheck.get()).getId().equals(operatorMaster.getId())) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessageDetail("Extension " + operatorModel.getExtension() + " is already assigned to another operator");
                return response;
            }
            String operatorOldExtension = ((OperatorMaster)operatorMasterOptional.get()).getExtension();
            String landingExtension = operatorModel.getLandingextension();
            String extension = operatorModel.getExtension();
            if (!operatorModel.getExtension().equals(operatorOldExtension)) {
                Optional agentToDelete;
                List operatorTiersListToDelete1;
                List operatorTiersListToDelete;
                List tiersListToDelete1;
                List tiersListToDelete = this.tiersRepository.findByAgent(extension);
                if (tiersListToDelete.size() > 0) {
                    this.tiersRepository.deleteAll((Iterable)tiersListToDelete);
                }
                if ((tiersListToDelete1 = this.tiersRepository.findByAgent(operatorOldExtension)).size() > 0) {
                    this.tiersRepository.deleteAll((Iterable)tiersListToDelete1);
                }
                if ((operatorTiersListToDelete = this.operatorTiersRepository.findByAgent(extension)).size() > 0) {
                    this.operatorTiersRepository.deleteAll((Iterable)operatorTiersListToDelete);
                }
                if ((operatorTiersListToDelete1 = this.operatorTiersRepository.findByAgent(operatorOldExtension)).size() > 0) {
                    this.operatorTiersRepository.deleteAll((Iterable)operatorTiersListToDelete1);
                }
                if ((agentToDelete = this.agentRepository.findByName(operatorOldExtension)).isPresent()) {
                    this.agentRepository.deleteAgentByName(operatorOldExtension);
                }
                List<String> systemNames = Arrays.asList("ACD_" + landingExtension + "_AS", "ACD_" + landingExtension + "_AV", "ACD_" + landingExtension + "_AT", "ACD_" + landingExtension + "_AR_" + extension, "ACD_" + landingExtension + "_AB_" + extension);
                List<String> systemNames1 = Arrays.asList("ACD_" + landingExtension + "_AS", "ACD_" + landingExtension + "_AV", "ACD_" + landingExtension + "_AT", "ACD_" + landingExtension + "_AR_" + extension, "ACD_" + landingExtension + "_AB_" + extension);
                for (String systemName : systemNames) {
                    Tiers tier = new Tiers();
                    tier.setQueue(systemName);
                    tier.setAgent(extension);
                    tier.setState("Ready");
                    tier.setLevel(Integer.valueOf(1));
                    tier.setPosition(Integer.valueOf(1));
                    this.tiersRepository.save((Object)tier);
                }
                for (String systemName : systemNames1) {
                    OperatorTiers operatorTier = new OperatorTiers();
                    operatorTier.setQueue(systemName);
                    operatorTier.setAgent(extension);
                    operatorTier.setState("Ready");
                    operatorTier.setLevel(Integer.valueOf(1));
                    operatorTier.setPosition(Integer.valueOf(1));
                    this.operatorTiersRepository.save((Object)operatorTier);
                }
            }
            if (!(optionalAgent = this.agentRepository.findByName(operatorModel.getExtension())).isPresent()) {
                this.createAgentForOperator(extension);
            }
            operatorMaster.setLandingextension(operatorModel.getLandingextension());
            operatorMaster.setExtension(operatorModel.getExtension());
            operatorMaster.setOperatorstatus(operatorModel.getOperatorstatus());
            operatorMaster.setOperatorstatusupdatedon(LocalDateTime.now());
            if ("With Headphone".equals(operatorModel.getOperatormode())) {
                operatorMaster.setOperatormode(Integer.valueOf(1));
            } else {
                operatorMaster.setOperatormode(Integer.valueOf(0));
            }
            if (operatorModel.getAs() != null) {
                operatorMaster.setAs(operatorModel.getAs());
            } else {
                operatorMaster.setAs(null);
            }
            if (operatorModel.getAv() != null) {
                operatorMaster.setAv(operatorModel.getAv());
            } else {
                operatorMaster.setAv(null);
            }
            if (operatorModel.getAb() != null) {
                operatorMaster.setAb(operatorModel.getAb());
            } else {
                operatorMaster.setAb(null);
            }
            if (operatorModel.getSc() != null) {
                operatorMaster.setSerialcall(operatorModel.getSc());
            } else {
                operatorMaster.setSerialcall(null);
            }
            if (operatorModel.getAt() != null) {
                operatorMaster.setAt(operatorModel.getAt());
            } else {
                operatorMaster.setAt(null);
            }
            this.operatorMasterRepository.save((Object)operatorMaster);
            response.setMessageDetail("Operator master saved successfully");
            response.setStatus(Constants.Error.OK);
        }
        catch (Exception ex) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessageDetail("An unexpected error occurred while updating the operator");
            ex.printStackTrace();
        }
        return response;
    }

    public RequestResponse deleteOperator(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        List tiersAddValue = new ArrayList();
        List operatorsAddValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional operatorMasterOptional = this.operatorMasterRepository.findById((Object)ids);
            if (operatorMasterOptional.isPresent()) {
                Optional agentToDelete;
                List operatorTiersToDelete;
                List tiersToDelete = this.tiersRepository.findByAgent(((OperatorMaster)operatorMasterOptional.get()).getExtension());
                if (tiersToDelete.size() > 0) {
                    tiersAddValue = tiersToDelete;
                }
                if ((operatorTiersToDelete = this.operatorTiersRepository.findByAgent(((OperatorMaster)operatorMasterOptional.get()).getExtension())).size() > 0) {
                    operatorsAddValue = operatorTiersToDelete;
                }
                if ((agentToDelete = this.agentRepository.findByName(((OperatorMaster)operatorMasterOptional.get()).getExtension())).isPresent()) {
                    this.agentRepository.delete(agentToDelete.get());
                }
                addValue.add(operatorMasterOptional.get());
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.operatorMasterRepository.deleteAll(addValue);
        this.tiersRepository.deleteAll(tiersAddValue);
        this.operatorTiersRepository.deleteAll(operatorsAddValue);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllOperators() {
        RequestResponse response = new RequestResponse();
        List operators = (List)this.operatorMasterRepository.findAll();
        if (operators.isEmpty()) {
            response.setMessage("No data found");
            response.setStatus(Constants.Error.ERROR);
            response.setData(new ArrayList());
            return response;
        }
        List operatorModels = operators.stream().map(operator -> {
            OperatorModel model = new OperatorModel();
            model.setOperatorcode(operator.getOperatorcode());
            model.setLandingextension(operator.getLandingextension());
            model.setCreatedby(operator.getCreatedby());
            model.setExtension(operator.getExtension());
            model.setAs(operator.getAs());
            model.setAv(operator.getAv());
            model.setAb(operator.getAb());
            model.setSc(operator.getSerialcall());
            model.setAt(operator.getAt());
            model.setOperatorstatus(operator.getOperatorstatus());
            model.setOperatorstatusupdatedon(operator.getOperatorstatusupdatedon());
            if (operator.getOperatormode() != null) {
                if (operator.getOperatormode() == 1) {
                    model.setOperatormode("With Headphone");
                } else if (operator.getOperatormode() == 0) {
                    model.setOperatormode("Without Headphone");
                } else {
                    model.setOperatormode("unknown");
                }
            } else {
                model.setOperatormode(null);
            }
            return model;
        }).collect(Collectors.toList());
        response.setMessage("Operators fetched successfully");
        response.setStatus(Constants.Error.OK);
        response.setData(operatorModels);
        return response;
    }

    public RequestResponse getAllExtension() {
        RequestResponse response = new RequestResponse();
        List listExtension = this.extensionsRepository.findByExtensionType("ocgroup");
        if (listExtension.isEmpty()) {
            response.setMessage("Extension is empty");
            return response;
        }
        ArrayList<ExtensionResponseModel> listOfModelExtension = new ArrayList<ExtensionResponseModel>();
        for (Extension extension : listExtension) {
            ExtensionResponseModel responseModel = new ExtensionResponseModel();
            responseModel.setExtensionNo(extension.getExtension());
            listOfModelExtension.add(responseModel);
        }
        response.setMessageDetail("List of extension having extensiontype ocgroup");
        response.setStatus(Constants.Error.OK);
        response.setData(listOfModelExtension);
        return response;
    }

    public RequestResponse getUserRoleWithOcAdmin() {
        RequestResponse response = new RequestResponse();
        Optional roleOptional = this.roleRepository.findByShortCode("ROLE_OCADMIN");
        if (!roleOptional.isPresent()) {
            response.setMessage("User with role ROLE_OCADMIN does not exist");
            response.setStatus(Constants.Error.ERROR);
            response.setData(Collections.emptyList());
            return response;
        }
        List userRoleList = this.userRoleRepository.findByRole((Role)roleOptional.get());
        if (userRoleList == null || userRoleList.isEmpty()) {
            response.setMessage("No users found with role ROLE_OCADMIN");
            response.setStatus(Constants.Error.ERROR);
            response.setData(Collections.emptyList());
            return response;
        }
        ArrayList userList = new ArrayList();
        for (UserRole userRole : userRoleList) {
            if (userRole.getUser() == null) continue;
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("username", userRole.getUser().getUsername());
            userMap.put("userId", String.valueOf(userRole.getUser().getId()));
            userList.add(userMap);
        }
        response.setMessage("Users with role ROLE_OCADMIN fetched successfully");
        response.setStatus(Constants.Error.OK);
        response.setData(userList);
        return response;
    }

    public RequestResponse getExtensionWithPhoneExtension() {
        RequestResponse response = new RequestResponse();
        List extensions = this.extensionsRepository.findByExtensionType("phone");
        if (extensions == null || extensions.isEmpty()) {
            response.setMessage("No extensions found with type 'phone'");
            response.setStatus(Constants.Error.ERROR);
            response.setData(null);
            return response;
        }
        ArrayList extensionList = new ArrayList();
        for (Extension extension : extensions) {
            HashMap<String, String> extMap = new HashMap<String, String>();
            extMap.put("extensionId", String.valueOf(extension.getId()));
            extMap.put("extensionNumber", extension.getExtension());
            extensionList.add(extMap);
        }
        response.setMessage("Phone extensions fetched successfully");
        response.setStatus(Constants.Error.OK);
        response.setData(extensionList);
        return response;
    }

    private String getLoggedInUsername() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof UserDetails) {
            return ((UserDetails)principal).getUsername();
        }
        return principal.toString();
    }

    public RequestResponse getFilteredOperatorMaster(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = OperatorMasterSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.operatorMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.operatorMasterRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<OperatorModel> entityToModelConversion(List<OperatorMaster> model) {
        ArrayList<OperatorModel> addValue = new ArrayList<OperatorModel>();
        for (OperatorMaster row : model) {
            OperatorModel data = new OperatorModel();
            data.setId(row.getId());
            data.setOperatorcode(this.safeValue(row.getOperatorcode()));
            data.setLandingextension(this.safeValue(row.getLandingextension()));
            data.setCreatedby(this.safeValue(row.getCreatedby()));
            data.setCreatedon(row.getCreatedon() != null ? row.getCreatedon() : LocalDateTime.now());
            data.setExtension(this.safeValue(row.getExtension()));
            data.setAs(this.safeValue(row.getAs()));
            data.setAv(this.safeValue(row.getAv()));
            data.setAb(this.safeValue(row.getAb()));
            data.setSc(this.safeValue(row.getSerialcall()));
            data.setAt(this.safeValue(row.getAt()));
            data.setOperatorstatus(this.safeValue(row.getOperatorstatus()));
            data.setOperatorstatusupdatedon(row.getOperatorstatusupdatedon() != null ? row.getOperatorstatusupdatedon() : LocalDateTime.now());
            Integer operatorMode = row.getOperatormode();
            if (operatorMode != null) {
                if (operatorMode == 1) {
                    data.setOperatormode("With Headphone");
                } else if (operatorMode == 0) {
                    data.setOperatormode("Without Headphone");
                }
            } else {
                data.setOperatormode(null);
            }
            addValue.add(data);
        }
        return addValue;
    }

    private String safeValue(String value) {
        return value != null ? value : "";
    }

    public void createAgentForOperator(String extension) {
        String string5 = "";
        String sBcPortUser = "";
        try {
            sBcPortUser = this.extensionFileConfigurationService.getSBCUserPort();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        if (sBcPortUser.equals("null") || sBcPortUser == null || sBcPortUser.equals("")) {
            sBcPortUser = "5060";
        }
        Agent agent = new Agent();
        agent.setName(extension);
        agent.setSystem("single_box");
        agent.setType("callback");
        agent.setStatus("Logged Out");
        agent.setState("Waiting");
        agent.setAgentFullName(extension);
        agent.setInstanceId("single_box");
        String portNumber = "";
        String rluCode = "";
        List list = this.controlRluServerRepository.findAllByOrderByIdAsc();
        if (list.size() >= 1) {
            rluCode = ((ControlRluServer)list.get(0)).getRluCode();
            string5 = ((ControlRluServer)list.get(0)).getVirtualIp();
            portNumber = ((ControlRluServer)list.get(0)).getMsfIpPort().toString();
        } else {
            rluCode = "";
            string5 = "";
            portNumber = "";
        }
        if (AgentService.getExtensionCreationAndDeletionTag()) {
            agent.setContact("[call_timeout=30,sip_h_X-CC_CALL=true,sip_h_CC_Q=${cc_queue}]sofia/internal/" + extension + "@" + string5 + ":" + portNumber);
            logger.info("[call_timeout=30,sip_h_X-CC_CALL=true,sip_h_CC_Q=${cc_queue}]sofia/internal/{}@{}:{}", (Object)extension, (Object)string5, (Object)portNumber);
        } else {
            agent.setContact("[call_timeout=30,sip_h_X-CC_CALL=true,sip_h_CC_Q=${cc_queue}]user/" + extension);
            logger.info("[call_timeout=30,sip_h_X-CC_CALL=true,sip_h_CC_Q=${cc_queue}]user/{}", (Object)extension);
        }
        this.agentRepository.save((Object)agent);
    }
}

