/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.m_modeldetail.service;

import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.ModelDetail;
import com.coraltele.db.telephony.pbx.repository.ModelDetailRepository;
import com.coraltele.db.telephony.pbx.specification.ModelDetailSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.ReturnField;
import com.coraltele.model.CliCommandData;
import com.coraltele.model.InputAction;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.cLIServerCommandLog.service.CLIServerCommandLogService;
import com.coraltele.service.pbx.m_modeldetail.model.ModelDetailModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class ModelDetailService {
    private static final Logger logger = LogManager.getLogger(ModelDetail.class);
    @Autowired
    private ModelDetailRepository modelDetailRepository;
    @Autowired
    private CLIServerCommandLogService cLIServerCommandLogService;

    public RequestResponse createModelDetail(ModelDetailModel data) {
        logger.debug("create new data for modelDetail : {} ==> {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            ModelDetail modelDetail = new ModelDetail();
            modelDetail.setCreatedOn(LocalDateTime.now());
            modelDetail.setManufacturerId(data.getManufacturerId());
            modelDetail.setModelCode(data.getModelCode());
            modelDetail.setModelDescription(data.getModelDescription());
            modelDetail.setFirmwareXml(data.getFirmwareXml());
            modelDetail.setMacSip(data.getMacSip());
            modelDetail.setMacReg(data.getMacReg());
            modelDetail.setFileExtension(data.getFileExtension());
            modelDetail.setFilePrefix(data.getFilePrefix());
            modelDetail.setFilenameUppercase(data.getFilenameUppercase());
            modelDetail.setUpgrade(data.getUpgrade());
            modelDetail.setSingleSignOn(data.getSingleSignOn());
            this.modelDetailRepository.save((Object)modelDetail);
            ReturnField field = new ReturnField();
            field.setId(modelDetail.getId().intValue());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("modelDetail Registered");
            returnValue.setData((Object)field);
            logger.info(" modelDetail saved : {}", (Object)returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("unable to create modelDetail");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getById(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional modelDetail = this.modelDetailRepository.findById(Integer.valueOf(id));
            if (modelDetail.isPresent()) {
                ModelDetailModel data = new ModelDetailModel();
                data.setId(((ModelDetail)modelDetail.get()).getId().intValue());
                data.setCreatedOn(((ModelDetail)modelDetail.get()).getCreatedOn());
                data.setManufacturerId(((ModelDetail)modelDetail.get()).getManufacturerId());
                data.setModelCode(((ModelDetail)modelDetail.get()).getModelCode());
                data.setModelDescription(((ModelDetail)modelDetail.get()).getModelDescription());
                data.setFirmwareXml(((ModelDetail)modelDetail.get()).getFirmwareXml());
                data.setMacSip(((ModelDetail)modelDetail.get()).getMacSip());
                data.setMacReg(((ModelDetail)modelDetail.get()).getMacReg());
                data.setFileExtension(((ModelDetail)modelDetail.get()).getFileExtension());
                data.setFilePrefix(((ModelDetail)modelDetail.get()).getFilePrefix());
                data.setFilenameUppercase(((ModelDetail)modelDetail.get()).getFilenameUppercase());
                data.setUpgrade(((ModelDetail)modelDetail.get()).getUpgrade());
                data.setSingleSignOn(((ModelDetail)modelDetail.get()).getSingleSignOn());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("ModelDetail Found");
                returnValue.setData((Object)data);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.modelDetailRepository.findAll();
        ArrayList<ModelDetailModel> addValue = new ArrayList<ModelDetailModel>();
        RequestResponse returnValue = new RequestResponse();
        for (ModelDetail modelDetail : list) {
            ModelDetailModel data = new ModelDetailModel();
            data.setId(modelDetail.getId().intValue());
            data.setCreatedOn(modelDetail.getCreatedOn());
            data.setManufacturerId(modelDetail.getManufacturerId());
            data.setModelCode(modelDetail.getModelCode());
            data.setModelDescription(modelDetail.getModelDescription());
            data.setFirmwareXml(modelDetail.getFirmwareXml());
            data.setMacSip(modelDetail.getMacSip());
            data.setMacReg(modelDetail.getMacReg());
            data.setFileExtension(modelDetail.getFileExtension());
            data.setFilePrefix(modelDetail.getFilePrefix());
            data.setFilenameUppercase(modelDetail.getFilenameUppercase());
            data.setUpgrade(modelDetail.getUpgrade());
            data.setSingleSignOn(modelDetail.getSingleSignOn());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateModelDetail(HttpServletRequest request, ModelDetailModel data, Authentication authentication) {
        logger.debug("Update modelDetail {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional modelDetail = this.modelDetailRepository.findById(Integer.valueOf(data.getId()));
            if (modelDetail.isPresent()) {
                ((ModelDetail)modelDetail.get()).setId(Integer.valueOf(data.getId()));
                ((ModelDetail)modelDetail.get()).setCreatedOn(data.getCreatedOn());
                ((ModelDetail)modelDetail.get()).setManufacturerId(data.getManufacturerId());
                ((ModelDetail)modelDetail.get()).setModelCode(data.getModelCode());
                ((ModelDetail)modelDetail.get()).setModelDescription(data.getModelDescription());
                ((ModelDetail)modelDetail.get()).setFirmwareXml(data.getFirmwareXml());
                ((ModelDetail)modelDetail.get()).setMacSip(data.getMacSip());
                ((ModelDetail)modelDetail.get()).setMacReg(data.getMacReg());
                ((ModelDetail)modelDetail.get()).setFileExtension(data.getFileExtension());
                ((ModelDetail)modelDetail.get()).setFilePrefix(data.getFilePrefix());
                ((ModelDetail)modelDetail.get()).setFilenameUppercase(data.getFilenameUppercase());
                ((ModelDetail)modelDetail.get()).setUpgrade(data.getUpgrade());
                ((ModelDetail)modelDetail.get()).setSingleSignOn(data.getSingleSignOn());
                this.modelDetailRepository.save(modelDetail.get());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated");
                returnValue.setMessageDetail("modelDetail Updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("modelDetail not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update modelDetail");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.error("error while fetching the data.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteModelDetail(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        for (Integer ids : data.getIntId()) {
            Optional modelDetail = this.modelDetailRepository.findById(ids);
            if (!modelDetail.isPresent()) continue;
            this.modelDetailRepository.deleteById((Object)ids);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ModelDetailSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.modelDetailRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.modelDetailRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteModelDetail(int id) {
        RequestResponse returnValue = new RequestResponse();
        Optional data = this.modelDetailRepository.findById(Integer.valueOf(id));
        if (!data.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("Records not found");
            logger.info(returnValue.getMessage());
        } else {
            this.modelDetailRepository.deleteById((Object)id);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("deleted");
            returnValue.setMessageDetail("Record deleted successfully");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public void saveData(HttpServletRequest request, ModelDetail data, Authentication authentication) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules();
        Map newMap = (Map)new ObjectMapper().readValue((InputStream)request.getInputStream(), Map.class);
        Set entrySet = newMap.entrySet();
        Iterator iterator = entrySet.iterator();
        ArrayList<InputAction> addValue = new ArrayList<InputAction>();
        CliCommandData cliCommandData = new CliCommandData();
        try {
            if (data.getId() != null && this.modelDetailRepository.findById(data.getId()).isPresent()) {
                Optional oldData = this.modelDetailRepository.findById(data.getId());
                Map oldMap = (Map)objectMapper.convertValue(oldData.get(), Map.class);
                while (iterator.hasNext()) {
                    Map.Entry mapEntry = iterator.next();
                    InputAction inputValue = new InputAction();
                    inputValue.setFieldName(mapEntry.getKey());
                    inputValue.setNewValue(mapEntry.getValue());
                    for (Map.Entry compare : oldMap.entrySet()) {
                        if (!mapEntry.getKey().equals(compare.getKey())) continue;
                        inputValue.setOldValue(compare.getValue());
                    }
                    addValue.add(inputValue);
                }
                cliCommandData.setData(addValue);
                cliCommandData.setEntity("m_modeldetail");
                String dataReceived = objectMapper.writeValueAsString(addValue);
                CLIServerCommandLog dataLogs = new CLIServerCommandLog();
                dataLogs.setCLICommand(dataReceived);
                dataLogs.setRecordSource("dl");
                dataLogs.setServerCode("");
                dataLogs.setRecordCreatedBy(authentication.getName());
                dataLogs.setRecordCreatedOn(LocalDateTime.now());
                dataLogs.setOutputFileName("Name");
                dataLogs.setOutputFilePath("");
                this.cLIServerCommandLogService.save(dataLogs);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }
}

