/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.conferenceMeeting.conferenceParticipant.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.conferenceMeeting.conferenceParticipant.model.ConferenceModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceParticipant.model.ConferenceParticipantModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceParticipant.model.ParticipantEmailModel;
import com.coraltele.service.pbx.conferenceMeeting.conferenceParticipant.service.ConferenceParticipantService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/conferenceParticipant"})
@RestController
public class ConferenceParticipantController {
    @Autowired
    ConferenceParticipantService conferenceParticipantService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody ParticipantEmailModel data, Authentication authentication) {
        RequestResponse returnValue = this.conferenceParticipantService.createData(data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody ConferenceParticipantModel data, Authentication authentication) {
        RequestResponse returnValue = this.conferenceParticipantService.updateById(data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.conferenceParticipantService.deleteConferenceParticipantById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllConferenceParticipantByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.conferenceParticipantService.getAllConferenceParticipantByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list1"})
    public ResponseEntity<RequestResponse> getAllConferenceParticipantByFilter1(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.conferenceParticipantService.getAllConferenceParticipantByFilter1(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/extension"})
    public ResponseEntity<RequestResponse> listNodes() {
        RequestResponse returnValue = this.conferenceParticipantService.getExtensionList();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/{id}"})
    public ResponseEntity<RequestResponse> getAllConferenceParticipantByConferenceId(@PathVariable(value="id") Integer id) {
        RequestResponse returnValue = this.conferenceParticipantService.getParticipantList(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/conferenceCall/{confId}"})
    public ResponseEntity<RequestResponse> makeConferenceCall(@PathVariable(value="confId") Integer conferenceId, Principal principal) {
        RequestResponse returnValue = this.conferenceParticipantService.makeConferenceMeetingCall(conferenceId, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/stop/{confId}"})
    public ResponseEntity<RequestResponse> stopConference(@PathVariable(value="confId") Integer conferenceId) {
        RequestResponse returnValue = this.conferenceParticipantService.stopCall(conferenceId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/dialConference"})
    public ResponseEntity<RequestResponse> makeConferenceCall(Principal principal, @RequestBody ConferenceModel data) {
        RequestResponse returnValue = this.conferenceParticipantService.callToParticipant(principal, data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/dial/{participantNumber}/{confId}/{conferenceNumber}/{isModerator}"})
    public ResponseEntity<RequestResponse> makeConferenceCall(Principal principal, @PathVariable(value="participantNumber") String participantNumber, @PathVariable(value="confId") String conferenceId, @PathVariable(value="conferenceNumber") String conferenceNumber, @PathVariable(value="isModerator") Boolean isModerator) {
        RequestResponse returnValue = this.conferenceParticipantService.callToParticipant1(principal, participantNumber, conferenceId, conferenceNumber, isModerator);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/confCallDetail/{confId}"})
    public ResponseEntity<RequestResponse> getListOfActiveCall(@PathVariable(value="confId") String conferenceId) {
        RequestResponse returnValue = this.conferenceParticipantService.getActiveCallDetails(conferenceId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{action}/{memberId}/{conferenceId}"})
    public ResponseEntity<RequestResponse> muteOrUnMuteMember(@PathVariable(value="action") String action, @PathVariable(value="memberId") String memberId, @PathVariable(value="conferenceId") String conferenceId) {
        RequestResponse returnValue = this.conferenceParticipantService.muteMember(action, memberId, conferenceId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{action}/all/{confId}"})
    public ResponseEntity<RequestResponse> muteOrUnMuteAll(@PathVariable(value="action") String action, @PathVariable(value="confId") String conferenceId) {
        RequestResponse returnValue = this.conferenceParticipantService.muteAll(action, conferenceId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateHandRaise/{uuid}"})
    public ResponseEntity<RequestResponse> handRaiseUpdate(@PathVariable(value="uuid") String uuid) {
        RequestResponse returnValue = this.conferenceParticipantService.handRaiseUpdate(uuid);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/unMuteRaisedUser/{confNumber}/{accessCode}/{memberId}/{moderatorMemberId}"})
    public ResponseEntity<RequestResponse> permitHandRaisedUser(@PathVariable(value="confNumber") String confNumber, @PathVariable(value="accessCode") String accessCode, @PathVariable(value="memberId") String memberId, @PathVariable(value="moderatorMemberId") String moderatorMemberId) {
        RequestResponse returnValue = this.conferenceParticipantService.allowUserToSpeak(confNumber, accessCode, memberId, moderatorMemberId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{accessCode}/kick/{memberId}/{extension}"})
    public ResponseEntity<RequestResponse> removeMember(@PathVariable(value="accessCode") String accessCode, @PathVariable(value="memberId") String memberId, @PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.conferenceParticipantService.removeMember(accessCode, memberId, extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/unblock/{accessCode}/{extension}"})
    public ResponseEntity<RequestResponse> unblock(@PathVariable(value="accessCode") String accessCode, @PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.conferenceParticipantService.unblockMember(accessCode, extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/activeJsonList/{confId}"})
    public ResponseEntity<RequestResponse> getListOfActiveCallByJson(@PathVariable(value="confId") String conferenceId) {
        RequestResponse returnValue = this.conferenceParticipantService.getActiveCallsByJson(conferenceId);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

