/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.chatMessage.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.chatMessage.model.SendMessageModel;
import com.coraltele.service.pbx.chatMessage.model.SendSingleMessageModel;
import com.coraltele.service.pbx.chatMessage.service.ChatMessageService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/chatMessage"})
@RestController
public class ChatMessageController {
    @Autowired
    ChatMessageService chatMessageService;

    @PostMapping(value={"/send/zone"})
    public ResponseEntity<RequestResponse> sendZone(@RequestBody SendMessageModel data, Principal principal) {
        RequestResponse returnValue = this.chatMessageService.sendMessageByZone(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/send/department"})
    public ResponseEntity<RequestResponse> sendDepartment(@RequestBody SendMessageModel data, Principal principal) {
        RequestResponse returnValue = this.chatMessageService.sendMessageByDepartment(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAll(Principal principal) {
        RequestResponse returnValue = this.chatMessageService.getAllData(principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/sendSocket/zone"})
    public ResponseEntity<RequestResponse> sendSocketZone(@RequestBody SendMessageModel data) {
        RequestResponse returnValue = this.chatMessageService.sendSocketMessageByZone(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/sendSocket/department"})
    public ResponseEntity<RequestResponse> sendSocketDepartment(@RequestBody SendMessageModel data) {
        RequestResponse returnValue = this.chatMessageService.sendSocketMessageByDepartment(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/sendMessageByExtension"})
    public ResponseEntity<RequestResponse> sendSingleMessage(@RequestBody SendSingleMessageModel data) {
        RequestResponse returnValue = this.chatMessageService.sendMessageToExtension(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

