/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.hotel.service;

import com.coraltele.db.telephony.pbx.entity.AlarmDetail;
import com.coraltele.db.telephony.pbx.entity.AlarmType;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.AlarmDetailRepository;
import com.coraltele.db.telephony.pbx.repository.AlarmTypeRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateConverter;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.hotel.model.AlarmDetailModel;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlarmDetailService {
    private static final Logger logger = LogManager.getLogger(AlarmDetailService.class);
    @Autowired
    AlarmDetailRepository alarmDetailRepository;
    @Autowired
    private ExtensionsRepository extensionsRepository;
    @Autowired
    AlarmTypeRepository alarmTypeRepository;
    @Autowired
    DateConverter dateConverter;

    public RequestResponse alarmProvision(AlarmDetailModel data) {
        LocalDate date = this.dateConverter.convertToLocalDate(data.getScheduledTime());
        RequestResponse returnValue = new RequestResponse();
        if (data.getExtension() == null || data.getActivate() == null) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("parameter is required.");
            returnValue.setMessageDetail("Please provide a valid parameter of extension and activate status.");
            logger.info(returnValue.getMessageDetail());
            return returnValue;
        }
        Optional extensions = this.extensionsRepository.findByExtensionAndExtensionTypeAndExtensionSubtype(data.getExtension(), "phone", "room");
        Optional alarmType = this.alarmTypeRepository.findByAlarmCode(data.getAlarmTypeCode());
        List alarm = this.alarmDetailRepository.findAllByPhoneNumber(data.getExtension());
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Extension not registered with type phone and subType room");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)extensions.get()).getCheckIn() != 1) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("room not checkIn to set alarm!");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (!alarmType.isPresent() || ((AlarmType)alarmType.get()).getAlarmCode() == null || ((AlarmType)alarmType.get()).getAlarmCode().isEmpty()) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("alarm code not exist!");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getActivate().equals(false)) {
            if (alarm.isEmpty()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("alarm not set of this extension for deactivate");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            for (AlarmDetail id : alarm) {
                this.alarmDetailRepository.deleteById((Object)id.getId());
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("alarm successfully deactivated ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getActivate().equals(true)) {
            Integer epoch = this.dateConverter.concatenateAndConvertToEpoch(data.getScheduledTime(), date);
            AlarmDetail alarmDetail = new AlarmDetail();
            alarmDetail.setCreatedOn(LocalDateTime.now());
            alarmDetail.setAlarmSource(((AlarmType)alarmType.get()).getCreatedBy());
            alarmDetail.setAlarmTypeId(Long.valueOf(((AlarmType)alarmType.get()).getId().intValue()));
            alarmDetail.setAlarmTypeCode(((AlarmType)alarmType.get()).getAlarmCode());
            alarmDetail.setPhoneNumber(data.getExtension());
            alarmDetail.setScheduledDate(date);
            alarmDetail.setScheduledTime(data.getScheduledTime());
            alarmDetail.setLanguageCode(((AlarmType)alarmType.get()).getDefaultLanguage());
            alarmDetail.setIsActive(((AlarmType)alarmType.get()).getActive());
            alarmDetail.setIsProcessed(Integer.valueOf(1));
            alarmDetail.setScheduledDateTimeEpoch(Integer.valueOf(epoch));
            alarmDetail.setNoOfTry(Integer.valueOf(1));
            alarmDetail.setFilePath(((AlarmType)alarmType.get()).getDefaultFile());
            alarmDetail.setRetryCount(((AlarmType)alarmType.get()).getRetryCount());
            alarmDetail.setRetryDelay(((AlarmType)alarmType.get()).getRetryDelay());
            this.alarmDetailRepository.save((Object)alarmDetail);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("alarm configure successfully");
        returnValue.setData((Object)data);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public void removeAlarm(String extension) {
        List list = this.alarmDetailRepository.findAllByPhoneNumber(extension);
        if (!list.isEmpty()) {
            for (AlarmDetail id : list) {
                this.alarmDetailRepository.deleteById((Object)id.getId());
            }
        }
    }
}

