/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.data;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.billing.log.service.ViewChannelService;
import com.coraltele.service.billing.main.voiceLogger.service.VoiceLoggerService;
import com.coraltele.service.pbx.extension.model.ExtensionNameUpdateModel;
import com.coraltele.service.pbx.extension.service.AuthExtensionService;
import com.coraltele.service.telemetry.main.alertHistory.service.AlertHistoryViewService;
import com.coraltele.service.telemetry.main.customerCDR.service.CustomerCDRSecondaryService;
import com.coraltele.service.telemetry.main.lastTenCalls.service.MissedCallService;
import com.coraltele.service.telemetry.main.queuePerformance.service.QueuePerformanceSummaryService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/app/v2/data"})
@RestController
public class SystemApiController {
    @Autowired
    CustomerCDRSecondaryService customerCDRSecondaryService;
    @Autowired
    QueuePerformanceSummaryService queuePerformanceSummaryService;
    @Autowired
    MissedCallService missedCallService;
    @Autowired
    private ViewChannelService channelService;
    @Autowired
    AlertHistoryViewService alertHistoryViewService;
    @Autowired
    VoiceLoggerService voiceLoggerService;
    @Autowired
    private AuthExtensionService authExtensionService;

    @PostMapping(value={"/answeredList"})
    public ResponseEntity<RequestResponse> getListOfAnswered(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.customerCDRSecondaryService.getListOfAnswered(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/queuePerformanceSummary"})
    public ResponseEntity<RequestResponse> getAllByFilterForSummation(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.queuePerformanceSummaryService.getAllByFilterForSummation(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/missedCallList"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.missedCallService.getAllByFilter(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/billingCDR"})
    public ResponseEntity<RequestResponse> getAllBilling(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.channelService.getBillingRecords(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/alertHistory"})
    public ResponseEntity<RequestResponse> getAllAlertHistory(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.alertHistoryViewService.getAllAlertHistory(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/voiceLoggerList"})
    public ResponseEntity<RequestResponse> getAllBilling(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.voiceLoggerService.getVoiceLogger(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateExtension"})
    public ResponseEntity<RequestResponse> updateExtensionName(@RequestBody ExtensionNameUpdateModel model) {
        RequestResponse returnValue = this.authExtensionService.updateExtensionName(model);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

