/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.agentStatus.controller;

import com.coraltele.db.billing.main.entity.view.UserStatusView;
import com.coraltele.db.billing.main.repository.AgentStatusRepository;
import com.coraltele.db.billing.main.repository.UserStatusViewRepository;
import com.coraltele.db.billing.main.specification.AgentStatusSpecification;
import com.coraltele.db.billing.main.specification.AgentStatusSpecificationNew;
import com.coraltele.db.billing.main.specification.UserStatusViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResultModel;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.billing.main.agentStatus.model.AgentStatusModel;
import com.coraltele.service.billing.main.agentStatus.service.AgentStatusService;
import com.coraltele.service.billing.main.agentStatus.service.UserStatusViewService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/agentStatus"})
@RestController
public class AgentStatusController {
    private static final Logger logger = LogManager.getLogger(AgentStatusController.class);
    @Autowired
    UserStatusViewRepository userStatusViewRepository;
    @Autowired
    AgentStatusService agentStatusService;
    @Autowired
    UserStatusViewService userStatusViewService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadServiceTest;
    @Autowired
    AgentStatusRepository agentStatusRepository;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody AgentStatusModel data, Principal principal, HttpServletRequest request) {
        RequestResponse returnValue = this.agentStatusService.createData(data, principal, request);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create/{agent}"})
    public ResponseEntity<RequestResponse> createStatus(@PathVariable String agent, @RequestBody AgentStatusModel data) {
        RequestResponse returnValue = this.agentStatusService.createStatusData(agent, data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadServiceTest.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for login-logout user status--");
            List agentList = this.userService.getAgentList();
            boolean adminUser = false;
            boolean teamLeaderUser = false;
            boolean agentUser = false;
            boolean managerUser = false;
            if (this.userService.checkAdminUser(principal.getName())) {
                adminUser = true;
            } else if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            } else if (this.userService.checkManagerUser(principal.getName())) {
                managerUser = true;
            } else {
                agentUser = true;
            }
            Specification filters = AgentStatusSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (List)agentList, (boolean)adminUser, (boolean)teamLeaderUser, (boolean)agentUser, (boolean)managerUser, (List)this.queueTLService.getAgentListByTL(principal.getName()));
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "extensionNo" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "extensionNo" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.userStatusViewRepository.findAll(filters, sort) : this.userStatusViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (UserStatusView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for login-logout user status", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading login-logout user status CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(UserStatusView item, String columnName) {
        switch (columnName) {
            case "id": {
                return this.checkNull((Object)item.getId());
            }
            case "username": {
                return this.checkNull((Object)item.getUsername());
            }
            case "status": {
                return this.checkNull((Object)item.getStatus());
            }
            case "date": {
                return this.checkNull((Object)item.getDate());
            }
            case "time": {
                return this.checkNull((Object)item.getTime().toString());
            }
            case "extensionNo": {
                return this.checkNull((Object)item.getExtensionNo());
            }
            case "userFullname": {
                return this.checkNull((Object)item.getUserFullname());
            }
            case "currentTime": {
                return this.checkNull((Object)item.getCurrentTime());
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllAgentStatus(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.userStatusViewService.getAllAgentStatus(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list/userStatus"})
    public ResponseEntity<RequestResponse> getAllUserStatus(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.userStatusViewService.getAllUserStatus(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV/userStatus"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForUserStatus(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for login-logout user status--");
            Specification filters = UserStatusViewSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "extensionNo" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "extensionNo" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.userStatusViewRepository.findAll(filters, sort) : this.userStatusViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (UserStatusView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for login-logout user status", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading login-logout user status CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping(value={"/downloadCSV1"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV1(@RequestBody SearchResultModel searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for login-logout user status--");
            List agentList = this.userService.getAgentList();
            Specification filters = AgentStatusSpecificationNew.buildSpecification((SearchResultModel)searchRequestData, (List)agentList);
            List filteredData = this.userStatusViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getSelectedColumns());
                List displayNames = searchRequestData.getSelectedColumns().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (UserStatusView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getSelectedColumns()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for login-logout user status", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading login-logout user status CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping(value={"/agentList"})
    public ResponseEntity<RequestResponse> getAllAgents() {
        RequestResponse returnValue = this.agentStatusService.getAgentList();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    static {
        columnMappings.put("id", "Id");
        columnMappings.put("username", "User Id");
        columnMappings.put("status", "Status");
        columnMappings.put("date", "Log Date");
        columnMappings.put("time", "Log Time");
        columnMappings.put("currentTime", "Current Date Time");
        columnMappings.put("extensionNo", "Extension No");
        columnMappings.put("userFullname", "User Name");
    }
}

