/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.messaging;

import com.coraltele.helper.Constants;
import com.coraltele.messaging.SubscribedMessage;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.stereotype.Service;

@Service
public class RedisMessageSubscriber
implements MessageListener {
    private static final Logger logger = LogManager.getLogger(RedisMessageSubscriber.class);

    public void onMessage(Message message, byte[] pattern) {
        String messageBody = message.toString();
        logger.info("Message received : {}", (Object)messageBody);
        ObjectMapper data = new ObjectMapper();
        try {
            SubscribedMessage subscribedMessage = (SubscribedMessage)data.readValue(messageBody, SubscribedMessage.class);
            Integer event = subscribedMessage.getEvent();
            if (event.equals(Constants.Message.UE_ATTACH) || event.equals(Constants.Message.UE_ATTACH_5G)) {
                logger.info("UE Connected");
                Constants.messagingService.imsiConnected(subscribedMessage);
            } else if (event.equals(Constants.Message.UE_DETACH) || event.equals(Constants.Message.UE_DETACH_5G)) {
                logger.info("UE disconnected");
                Constants.messagingService.imsiDisconnected(subscribedMessage);
            } else {
                logger.info("Messaging un-processed  event");
            }
            logger.info("Message Processed : {} {}", (Object)subscribedMessage.getEvent(), subscribedMessage.getData());
        }
        catch (JsonProcessingException e) {
            logger.info("Error while processing message : {} {}", (Object)messageBody, (Object)e);
            e.printStackTrace();
        }
    }
}

