/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import com.coraltele.service.archiving.billingCdrHistorical.service.TableDumpService;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class TableDumpCommandLineRunner
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(TableDumpCommandLineRunner.class);
    @Autowired
    private TableDumpService tableDumpService;

    private Properties loadGitProperties() {
        Properties properties = new Properties();
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream("git.properties");){
            if (input != null) {
                properties.load(input);
            } else {
                logger.warn("git.properties not found");
            }
        }
        catch (IOException e) {
            logger.error("Error loading git.properties: {}", (Object)e.getMessage());
        }
        return properties;
    }

    public void run(String ... args) throws Exception {
        boolean shouldDump = false;
        String outputPath = null;
        for (String arg : args) {
            if (arg.startsWith("--dump-tables=")) {
                shouldDump = Boolean.parseBoolean(arg.substring("--dump-tables=".length()));
                continue;
            }
            if (!arg.startsWith("--output-path=")) continue;
            outputPath = arg.substring("--output-path=".length());
        }
        if (shouldDump) {
            logger.info("Table dump requested via command line");
            if (outputPath == null || outputPath.isEmpty()) {
                outputPath = System.getProperty("user.home") + "/table-dump-" + System.currentTimeMillis() + ".json";
            }
            try {
                Properties gitProps = this.loadGitProperties();
                String gitBuildId = gitProps.getProperty("git.commit.id.abbrev", "");
                String gitBuildTime = gitProps.getProperty("git.build.time", "");
                String gitBuildVersion = gitProps.getProperty("git.build.version", "");
                String gitBranch = gitProps.getProperty("git.branch", "");
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("configId", UUID.randomUUID().toString());
                metadata.put("buildId", gitBuildId);
                metadata.put("buildTime", gitBuildTime);
                metadata.put("buildVersion", gitBuildVersion);
                metadata.put("gitBranch", gitBranch);
                metadata.put("configName", "");
                Map result = this.tableDumpService.dumpAllTables(outputPath, metadata);
                logger.info("Table dump completed successfully!");
                logger.info("Total tables processed: {}", result.get("totalTables"));
                logger.info("Output file: {}", (Object)outputPath);
                System.exit(0);
            }
            catch (Exception e) {
                logger.error("Table dump failed: {}", (Object)e.getMessage(), (Object)e);
                System.exit(1);
            }
        }
    }
}

