/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userGroupMaster.service;

import com.coraltele.db.telemetry.main.entity.Area;
import com.coraltele.db.telemetry.main.repository.AreaRepository;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.entity.UserGroup;
import com.coraltele.db.users.main.entity.UserGroupMaster;
import com.coraltele.db.users.main.repository.UserGroupMasterRepository;
import com.coraltele.db.users.main.repository.UserGroupRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.db.users.main.specification.UserGroupMasterSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.user.service.UserService;
import com.coraltele.service.user.userGroupMaster.model.AreaModel;
import com.coraltele.service.user.userGroupMaster.model.CoordinateModel;
import com.coraltele.service.user.userGroupMaster.model.UserAreaModel;
import com.coraltele.service.user.userGroupMaster.model.UserGroupMasterDropdownModel;
import com.coraltele.service.user.userGroupMaster.model.UserGroupMasterModel;
import com.coraltele.service.user.userGroupMaster.model.UserGroupMasterMultipleUpdateModel;
import com.coraltele.service.user.userGroupMaster.model.XmPPGroupModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UserGroupMasterService {
    private static final Logger logger = LogManager.getLogger(UserGroupMasterService.class);
    private static final String XmPP_FILE_PATH = "/etc/prosody/sharedgroups.txt";
    @Autowired
    UserGroupMasterRepository userGroupRepository;
    @Autowired
    UserGroupRepository userGroupLinkRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    AreaRepository areaRepository;
    @Autowired
    UserService userService;

    public RequestResponse createData(UserGroupMasterModel data, Principal principal) {
        logger.debug("Create New UserGroupMaster : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        if (this.checkDuplicateCode(data.getCode())) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Same Group already exist");
            returnValue.setMessageDetail("Choose different groupCode");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        if (this.checkDuplicateDescription(data.getDescription())) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Same Group Description already exist");
            returnValue.setMessageDetail("Choose different groupDescription");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        if (!StringUtils.hasLength((String)data.getCode()) || !StringUtils.hasLength((String)data.getDescription())) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Group Name or Description not be blank");
            returnValue.setMessageDetail("Invalid groupCode or description");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        try {
            UserGroupMaster userGroup = new UserGroupMaster();
            userGroup.setActive(data.getActive());
            userGroup.setCode(data.getCode());
            userGroup.setCreatedBy(principal.getName());
            userGroup.setCreatedOn(LocalDateTime.now());
            userGroup.setDescription(data.getDescription());
            userGroup.setAreaId(data.getAreaId());
            userGroup.setDepartmentCode(data.getDepartmentCode());
            userGroup.setGroupOwner(data.getGroupOwner());
            this.userGroupRepository.save((Object)userGroup);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("UserGroup Created Successfully");
            logger.info(returnValue.getMessage());
            try {
                if (StringUtils.hasLength((String)this.userService.getXmPPServer())) {
                    this.createGroup(data.getCode());
                }
                logger.info("xmPP group created successfully");
            }
            catch (Exception e) {
                logger.error("Unable to create XmPP group:{}", (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create UserGroup");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(UserGroupMasterMultipleUpdateModel data, Principal principal) {
        logger.debug("Update UserGroupMaster {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        if (this.duplicateCodeOnUpdate(data)) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Select different groupCode");
            returnValue.setMessageDetail("GroupCode Already Exist");
            logger.error(returnValue.getMessage());
            return returnValue;
        }
        for (Integer id : data.getId()) {
            Optional userGroup = this.userGroupRepository.findById((Object)id);
            Optional user = this.userRepository.findByUsername(principal.getName());
            if (!userGroup.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Not Found");
                returnValue.setMessageDetail("UserGroup Not Found");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            if (data.getActive() != null) {
                ((UserGroupMaster)userGroup.get()).setActive(data.getActive());
            }
            if (data.getCode() != null) {
                ((UserGroupMaster)userGroup.get()).setCode(data.getCode());
            }
            if (data.getDescription() != null) {
                ((UserGroupMaster)userGroup.get()).setDescription(data.getDescription());
            }
            if (data.getDepartmentCode() != null) {
                ((UserGroupMaster)userGroup.get()).setDepartmentCode(data.getDepartmentCode());
            }
            if (data.getAreaId() != null) {
                ((UserGroupMaster)userGroup.get()).setAreaId(data.getAreaId());
            }
            if (data.getGroupOwner() != null) {
                ((UserGroupMaster)userGroup.get()).setGroupOwner(data.getGroupOwner());
            }
            ((UserGroupMaster)userGroup.get()).setUpdatedBy(Long.valueOf(((User)user.get()).getId().intValue()));
            ((UserGroupMaster)userGroup.get()).setUpdatedOn(LocalDateTime.now());
            this.userGroupRepository.save(userGroup.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("UserGroup Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional userGroup = this.userGroupRepository.findById((Object)ids);
            if (userGroup.isPresent()) {
                addValue.add(userGroup.get());
                this.userGroupRepository.deleteAll(addValue);
                try {
                    if (!StringUtils.hasText((String)this.userService.getXmPPServer())) continue;
                    Map groups = this.readFile();
                    this.deleteGroup(groups, ((UserGroupMaster)userGroup.get()).getCode());
                }
                catch (Exception exception) {}
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllUserGroupByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = UserGroupMasterSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.userGroupRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.userGroupRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = this.userGroupRepository.findAll();
        ArrayList<UserGroupMasterDropdownModel> addValue = new ArrayList<UserGroupMasterDropdownModel>();
        RequestResponse returnValue = new RequestResponse();
        for (UserGroupMaster userGroup : list) {
            UserGroupMasterDropdownModel data = new UserGroupMasterDropdownModel();
            data.setId(userGroup.getId());
            data.setCode(userGroup.getCode());
            data.setDescription(userGroup.getDescription());
            data.setAreaId(userGroup.getAreaId());
            data.setDepartmentCode(userGroup.getDepartmentCode());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    private boolean checkDuplicateCode(String groupCode) {
        List groupList = this.userGroupRepository.findByCode(groupCode);
        return !groupList.isEmpty();
    }

    private boolean checkDuplicateDescription(String groupDescription) {
        List groupList = this.userGroupRepository.findByDescription(groupDescription);
        return !groupList.isEmpty();
    }

    private boolean duplicateCodeOnUpdate(UserGroupMasterMultipleUpdateModel data) {
        Optional groupList = this.userGroupRepository.findById(data.getId().get(0));
        if (groupList.isPresent()) {
            String groupCode = ((UserGroupMaster)groupList.get()).getCode();
            if (data.getCode() != null && data.getCode().equals(groupCode)) {
                return false;
            }
            List list1 = this.userGroupRepository.findByIdNot(((UserGroupMaster)groupList.get()).getId());
            if (data.getCode() != null) {
                UserGroupMaster row;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext() && !(row = (UserGroupMaster)iterator.next()).getCode().equals(data.getCode())) {
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private List<String> getGroupOfUser(Integer groupId) {
        List userGroupList = this.userGroupLinkRepository.findByGroup(Long.valueOf(groupId.longValue()));
        if (userGroupList.isEmpty()) {
            return Collections.emptyList();
        }
        List userIds = userGroupList.stream().map(UserGroup::getUsers).map(Long::intValue).collect(Collectors.toList());
        List users = this.userRepository.findByIdIn(userIds);
        return users.stream().map(User::getUsername).collect(Collectors.toList());
    }

    public RequestResponse getAreaLoggedUser(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional loggedUser = this.userRepository.findByUsername(principal.getName());
            if (loggedUser.isPresent()) {
                List userGroup = this.userGroupLinkRepository.findByUsers(Long.valueOf(((User)loggedUser.get()).getId().intValue()));
                if (!userGroup.isEmpty()) {
                    UserGroup userGroupData = (UserGroup)userGroup.get(0);
                    UserAreaModel data = new UserAreaModel();
                    data.setUsername(principal.getName());
                    Optional groupMasterData = this.userGroupRepository.findById((Object)userGroupData.getGroup().intValue());
                    if (groupMasterData.isPresent()) {
                        Optional area;
                        UserGroupMasterDropdownModel groupData = new UserGroupMasterDropdownModel();
                        groupData.setCode(((UserGroupMaster)groupMasterData.get()).getCode());
                        groupData.setDepartmentCode(((UserGroupMaster)groupMasterData.get()).getDepartmentCode());
                        groupData.setAreaId(((UserGroupMaster)groupMasterData.get()).getAreaId());
                        groupData.setDescription(((UserGroupMaster)groupMasterData.get()).getDescription());
                        groupData.setId(((UserGroupMaster)groupMasterData.get()).getId());
                        data.setGroup(groupData);
                        if (((UserGroupMaster)groupMasterData.get()).getAreaId() != null && (area = this.areaRepository.findById((Object)((UserGroupMaster)groupMasterData.get()).getAreaId())).isPresent()) {
                            AreaModel model = new AreaModel();
                            model.setId(((Area)area.get()).getId());
                            model.setName(((Area)area.get()).getName());
                            model.setShapeId(((Area)area.get()).getType());
                            if (((Area)area.get()).getCoordinate() != null) {
                                ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
                                for (Coordinate coordinate : ((Area)area.get()).getCoordinate().getCoordinates()) {
                                    CoordinateModel coordModel = new CoordinateModel();
                                    coordModel.setLng(String.valueOf(coordinate.x));
                                    coordModel.setLat(String.valueOf(coordinate.y));
                                    coordinateModels.add(coordModel);
                                }
                                model.setCoordinates(coordinateModels);
                            }
                            data.setAreaCoordinate(model);
                        }
                        returnValue.setStatus(Constants.Error.OK);
                        returnValue.setMessage("Area Details of User");
                        returnValue.setMessageDetail("Data fetched Successfully");
                        returnValue.setData((Object)data);
                    } else {
                        returnValue.setStatus(Constants.Error.ERROR);
                        returnValue.setMessage("Invalid group of user");
                        returnValue.setMessageDetail("Contact With Administrator");
                        logger.error(returnValue.getMessage());
                    }
                } else {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("User not associated with group");
                    returnValue.setMessageDetail("Contact With Administrator");
                    logger.error(returnValue.getMessage());
                }
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("user not exist");
                returnValue.setMessageDetail("Contact With Administrator");
                logger.error("user not exist:{}", (Object)principal.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("User not associated with group");
            returnValue.setMessageDetail("Contact With Administrator");
        }
        return returnValue;
    }

    public void createOrUpdateGroup(Map<String, XmPPGroupModel> groups, String groupName, List<String> users) {
        groups.putIfAbsent(groupName, new XmPPGroupModel(groupName));
        groups.get(groupName).setUsers(users);
    }

    public void deleteGroup(Map<String, XmPPGroupModel> groups, String groupName) {
        groups.remove(groupName);
    }

    public Map<String, XmPPGroupModel> readFile() throws IOException {
        LinkedHashMap<String, XmPPGroupModel> groups = new LinkedHashMap<String, XmPPGroupModel>();
        try (BufferedReader reader = new BufferedReader(new FileReader(XmPP_FILE_PATH));){
            String line;
            XmPPGroupModel currentGroup = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("[") && line.endsWith("]")) {
                    String groupName = line.substring(1, line.length() - 1);
                    currentGroup = new XmPPGroupModel(groupName);
                    groups.put(groupName, currentGroup);
                    continue;
                }
                if (currentGroup == null || line.isEmpty()) continue;
                currentGroup.getUsers().add(line);
            }
        }
        return groups;
    }

    public void writeFile(Map<String, XmPPGroupModel> groups) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(XmPP_FILE_PATH));){
            for (XmPPGroupModel group : groups.values()) {
                writer.write("[" + group.getGroupName() + "]");
                writer.newLine();
                for (String user : group.getUsers()) {
                    writer.write(user);
                    writer.newLine();
                }
                writer.newLine();
            }
        }
    }

    public void associateUsersWithGroup(Map<String, XmPPGroupModel> groups, String selectedGroup, List<String> users) {
        groups.putIfAbsent(selectedGroup, new XmPPGroupModel(selectedGroup));
        XmPPGroupModel targetGroup = groups.get(selectedGroup);
        HashSet<String> userSet = new HashSet<String>(targetGroup.getUsers());
        userSet.addAll(users);
        targetGroup.setUsers(new ArrayList(userSet));
        for (Map.Entry<String, XmPPGroupModel> entry : groups.entrySet()) {
            if (entry.getKey().equals(selectedGroup)) continue;
            XmPPGroupModel group = entry.getValue();
            group.getUsers().removeAll(users);
        }
    }

    public void updateUserWithGroup(String groupName, List<String> userList) {
        try {
            Map groups = this.readFile();
            this.associateUsersWithGroup(groups, groupName, userList);
            this.writeFile(groups);
            logger.info("User associated with XmPP group successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Unable to create XmPP userGroup:{}", (Object)e.getMessage());
        }
    }

    public void createGroup(String groupName) throws IOException {
        Map groups = this.readFile();
        if (groups.containsKey(groupName)) {
            logger.error("Group '" + groupName + "' already exists.");
            return;
        }
        groups.put(groupName, new XmPPGroupModel(groupName));
        this.writeFile(groups);
        logger.info("Group '" + groupName + "' created successfully.");
    }
}

