/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.uc.service;

import com.coraltele.db.telephony.uc.entity.view.PhoneBook;
import com.coraltele.db.telephony.uc.repository.PhoneBookRepository;
import com.coraltele.db.telephony.uc.specification.PhoneBookSpecification;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.blfExtension.BLFExtService;
import com.coraltele.service.pbx.extension.service.AuthExtensionService;
import com.coraltele.service.uc.model.PhoneBookModel;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class PhoneBookService {
    private static final Logger logger = LogManager.getLogger(PhoneBookService.class);
    @Autowired
    PhoneBookRepository phoneBookRepository;
    @Autowired
    BLFExtService blfExtService;
    @Autowired
    AuthExtensionService authExtensionService;

    public RequestResponse getAll(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = PhoneBookSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.phoneBookRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.phoneBookRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessageDetail("filtered list");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse getAllData(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        String loggedUserExtension = this.authExtensionService.getExtensionOfUser(principal.getName());
        ArrayList<PhoneBookModel> addValue = new ArrayList<PhoneBookModel>();
        List contactList = this.phoneBookRepository.findAll();
        if (!contactList.isEmpty()) {
            for (PhoneBook row : contactList) {
                PhoneBookModel data = new PhoneBookModel();
                data.setId(row.getId());
                data.setName(row.getName());
                data.setType(row.getType());
                data.setDesignation(row.getDesignation());
                data.setOffEXtn(row.getOffEXtn());
                data.setPhoneOffice(row.getPhoneOffice());
                data.setPhoneHome(row.getPhoneHome());
                data.setMobileNumber(row.getMobileNumber());
                if (this.blfExtService.checkExtension(loggedUserExtension, row.getOffEXtn())) {
                    data.setBlf(true);
                } else {
                    data.setBlf(false);
                }
                addValue.add(data);
            }
            returnValue.setData(addValue);
            returnValue.setMessage("contact list");
            returnValue.setMessageDetail("list of records");
        } else {
            returnValue.setData(Collections.emptyList());
            returnValue.setMessage("Data is empty");
            returnValue.setMessageDetail("No data present");
            logger.error(returnValue.getMessageDetail());
        }
        return returnValue;
    }
}

