/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.queuePerformance.controller;

import com.coraltele.db.telemetry.main.entity.AgentCDR;
import com.coraltele.db.telemetry.main.entity.QueuePerformance;
import com.coraltele.db.telemetry.main.repository.AgentCDRRepository;
import com.coraltele.db.telemetry.main.repository.QueuePerformanceRepository;
import com.coraltele.db.telemetry.main.specification.QueuePerformanceSpecification;
import com.coraltele.db.telemetry.main.specification.QueuePerformanceSpecificationNew;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResultModel;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.queuePerformance.service.QueuePerformanceService;
import com.coraltele.service.telemetry.main.queuePerformance.service.QueuePerformanceSummaryService;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/queuePerformance"})
@RestController
public class QueuePerformanceController {
    private static final Logger logger = LogManager.getLogger(QueuePerformanceController.class);
    @Autowired
    QueuePerformanceService queuePerformanceService;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    QueuePerformanceRepository queuePerformanceRepository;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadServiceTest;
    @Autowired
    QueuePerformanceSummaryService queuePerformanceSummaryService;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    @Autowired
    AgentCDRRepository agentCDRRepository;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.queuePerformanceService.getAllByFilter(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            Object key;
            logger.info("CSV file download started for queue performance--");
            List queueId = null;
            if (this.userService.checkRoleTL(principal.getName())) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            Specification filters = QueuePerformanceSpecification.generateFilters((SearchRequest)searchRequestData, queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "queue" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.queuePerformanceRepository.findAll(filters, sort) : this.queuePerformanceRepository.findAll(filters);
            List agentCdrList = (List)this.agentCDRRepository.findAll();
            HashMap<String, Set> agentMap = new HashMap<String, Set>();
            for (AgentCDR cdr : agentCdrList) {
                if (cdr.getStartTime() == null || cdr.getQueue() == null || cdr.getCallDirection() == null || cdr.getAgentName() == null) continue;
                LocalDate date = Instant.ofEpochSecond(cdr.getStartTime()).atZone(ZoneId.systemDefault()).toLocalDate();
                key = date + "|" + cdr.getQueue() + "|" + cdr.getCallDirection();
                agentMap.computeIfAbsent((String)key, k -> new HashSet()).add(cdr.getAgentName());
            }
            Map<String, Integer> agentCountMap = agentMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Set)e.getValue()).size()));
            StringWriter stringWriter = new StringWriter();
            try {
                CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);
                key = null;
                try {
                    logger.info("Original column names: " + searchRequestData.getColumnNames());
                    List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                    logger.info("Display names: " + displayNames);
                    csvPrinter.printRecord(displayNames);
                    for (QueuePerformance item : filteredData) {
                        ArrayList<Object> values = new ArrayList<Object>();
                        for (String columnName2 : searchRequestData.getColumnNames()) {
                            values.add(this.getColumnValue(item, columnName2, agentCountMap));
                        }
                        csvPrinter.printRecord(values);
                    }
                }
                catch (Throwable displayNames) {
                    key = displayNames;
                    throw displayNames;
                }
                finally {
                    if (csvPrinter != null) {
                        if (key != null) {
                            try {
                                csvPrinter.close();
                            }
                            catch (Throwable displayNames) {
                                ((Throwable)key).addSuppressed(displayNames);
                            }
                        } else {
                            csvPrinter.close();
                        }
                    }
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
                logger.error("Error while traversing data for queue performance", (Object)e2.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e3) {
            e3.printStackTrace();
            logger.error("Error while downloading queue performance CSV file!", (Object)e3.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(QueuePerformance item, String columnName, Map<String, Integer> agentCountMap) {
        Duration totalCustomerAgentTalkTime = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getTotalCustomerAgentTalkTime())));
        Duration totalCustomerTime = Duration.ofSeconds(this.getDurationOrZero(Long.valueOf(item.getTotalCustomerTime())));
        switch (columnName) {
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "queueName": {
                return this.checkNull((Object)item.getQueueName());
            }
            case "callDirection": {
                return this.checkNull((Object)item.getCallDirection());
            }
            case "recordEpoch": {
                return this.checkNull((Object)this.dateFormatUtility.epochToLocalDateForLocalTimeZone(item.getRecordEpoch()));
            }
            case "totalJoined": {
                return this.checkNull((Object)item.getTotalJoined());
            }
            case "totalConnectedWithAgent": {
                return this.checkNull((Object)item.getTotalConnectedWithAgent());
            }
            case "totalAbandonedAtQueue": {
                return this.checkNull((Object)item.getTotalAbandonedAtQueue());
            }
            case "totalCustomerAgentTalkTime": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalCustomerAgentTalkTime.getSeconds()));
            }
            case "totalCustomerTime": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)totalCustomerTime.getSeconds()));
            }
            case "totalNoContact": {
                return this.checkNull((Object)item.getTotalNoContact());
            }
            case "totalWaitTime": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTotalWaitTime()));
            }
            case "totalAbandonedAtAgent": {
                if (item.getTotalAbandonedAtAgent() != null) {
                    return this.checkNull((Object)item.getTotalAbandonedAtAgent());
                }
                return this.checkNull((Object)"");
            }
            case "answerWaitSecond10": {
                return this.checkNull(item.getAnswerWaitSecond10() != null ? item.getAnswerWaitSecond10() : "");
            }
            case "answerWaitSecond20": {
                return this.checkNull(item.getAnswerWaitSecond20() != null ? item.getAnswerWaitSecond20() : "");
            }
            case "answerWaitSecond30": {
                return this.checkNull(item.getAnswerWaitSecond30() != null ? item.getAnswerWaitSecond30() : "");
            }
            case "answerWaitSecond40": {
                return this.checkNull(item.getAnswerWaitSecond40() != null ? item.getAnswerWaitSecond40() : "");
            }
            case "answerWaitSecond50": {
                return this.checkNull(item.getAnswerWaitSecond50() != null ? item.getAnswerWaitSecond50() : "");
            }
            case "answerWaitSecond60": {
                return this.checkNull(item.getAnswerWaitSecond60() != null ? item.getAnswerWaitSecond60() : "");
            }
            case "greaterAnswerWaitSecond60": {
                return this.checkNull(item.getGreaterAnswerWaitSecond60() != null ? item.getGreaterAnswerWaitSecond60() : "");
            }
            case "abandonedWaitSecond10": {
                return this.checkNull(item.getAbandonedWaitSecond10() != null ? item.getAbandonedWaitSecond10() : "");
            }
            case "abandonedWaitSecond20": {
                return this.checkNull(item.getAbandonedWaitSecond20() != null ? item.getAbandonedWaitSecond20() : "");
            }
            case "abandonedWaitSecond30": {
                return this.checkNull(item.getAbandonedWaitSecond30() != null ? item.getAbandonedWaitSecond30() : "");
            }
            case "abandonedWaitSecond40": {
                return this.checkNull(item.getAbandonedWaitSecond40() != null ? item.getAbandonedWaitSecond40() : "");
            }
            case "abandonedWaitSecond50": {
                return this.checkNull(item.getAbandonedWaitSecond50() != null ? item.getAbandonedWaitSecond50() : "");
            }
            case "abandonedWaitSecond60": {
                return this.checkNull(item.getAbandonedWaitSecond60() != null ? item.getAbandonedWaitSecond60() : "");
            }
            case "greaterAbandonedWaitSecond60": {
                return this.checkNull(item.getGreaterAbandonedWaitSecond60() != null ? item.getGreaterAbandonedWaitSecond60() : "");
            }
            case "averageNumberAgent": {
                LocalDate recordDate = Instant.ofEpochSecond(item.getRecordEpoch()).atZone(ZoneId.systemDefault()).toLocalDate();
                String key = recordDate + "|" + item.getQueue() + "|" + item.getCallDirection();
                return this.checkNull((Object)agentCountMap.getOrDefault(key, 0));
            }
            case "averageAnswerWaitTime": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getAverageAnswerWaitTime()));
            }
            case "totalAbandonedWaitTime": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTotalAbandonedWaitTime()));
            }
            case "totalAnswerWaitTime": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTotalAnswerWaitTime()));
            }
            case "averageAbandonedWaitTime": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getAverageAbandonedWaitTime()));
            }
            case "averageTalkTime": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getAverageTalkTime()));
            }
            case "servicePercentage": {
                return this.checkNull(item.getServicePercentage() != null ? item.getServicePercentage() : "");
            }
            case "abandonedPercentage": {
                return this.checkNull(item.getAbandonedPercentage() != null ? item.getAbandonedPercentage() : "");
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadServiceTest.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    private long getDurationOrZero(Long duration) {
        return duration != null ? duration : 0L;
    }

    @PostMapping(value={"/downloadCSV1"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV1(@RequestBody SearchResultModel searchRequestData, Principal principal) {
        try {
            Object key;
            logger.info("CSV file download started for queue performance--");
            Specification filters = QueuePerformanceSpecificationNew.buildSpecification((SearchResultModel)searchRequestData);
            List filteredData = this.queuePerformanceRepository.findAll(filters);
            List agentCdrList = (List)this.agentCDRRepository.findAll();
            HashMap<String, Set> agentMap = new HashMap<String, Set>();
            for (AgentCDR cdr : agentCdrList) {
                if (cdr.getStartTime() == null || cdr.getQueue() == null || cdr.getCallDirection() == null || cdr.getAgentName() == null) continue;
                LocalDate date = Instant.ofEpochSecond(cdr.getStartTime()).atZone(ZoneId.systemDefault()).toLocalDate();
                key = date + "|" + cdr.getQueue() + "|" + cdr.getCallDirection();
                agentMap.computeIfAbsent((String)key, k -> new HashSet()).add(cdr.getAgentName());
            }
            Map<String, Integer> agentCountMap = agentMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Set)e.getValue()).size()));
            StringWriter stringWriter = new StringWriter();
            try {
                CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);
                key = null;
                try {
                    logger.info("Original column names: " + searchRequestData.getSelectedColumns());
                    List displayNames = searchRequestData.getSelectedColumns().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                    logger.info("Display names: " + displayNames);
                    csvPrinter.printRecord(displayNames);
                    for (QueuePerformance item : filteredData) {
                        ArrayList<Object> values = new ArrayList<Object>();
                        for (String columnName2 : searchRequestData.getSelectedColumns()) {
                            values.add(this.getColumnValue(item, columnName2, agentCountMap));
                        }
                        csvPrinter.printRecord(values);
                    }
                }
                catch (Throwable displayNames) {
                    key = displayNames;
                    throw displayNames;
                }
                finally {
                    if (csvPrinter != null) {
                        if (key != null) {
                            try {
                                csvPrinter.close();
                            }
                            catch (Throwable displayNames) {
                                ((Throwable)key).addSuppressed(displayNames);
                            }
                        } else {
                            csvPrinter.close();
                        }
                    }
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
                logger.error("Error while traversing data for queue performance", (Object)e2.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e3) {
            e3.printStackTrace();
            logger.error("Error while downloading queue performance CSV file!", (Object)e3.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping(value={"/queue"})
    public ResponseEntity<RequestResponse> getAllByFilter() {
        RequestResponse returnValue = this.queuePerformanceService.getDistinctNonNullQueues();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    static {
        columnMappings.put("queue", "Queue ID");
        columnMappings.put("queueName", "Queue Name");
        columnMappings.put("callDirection", "Call Direction");
        columnMappings.put("recordEpoch", "Record DateTime");
        columnMappings.put("totalJoined", "Total Call Offered");
        columnMappings.put("totalConnectedWithAgent", "Total Call Answered");
        columnMappings.put("totalAbandonedAtQueue", "ABD At ACD");
        columnMappings.put("totalCustomerAgentTalkTime", "Total Talk Time");
        columnMappings.put("totalCustomerTime", "Total Customer Time");
        columnMappings.put("totalNoContact", "Total No Answered");
        columnMappings.put("totalWaitTime", "Total Wait Time");
        columnMappings.put("totalAbandonedAtAgent", "ABD At Agent");
        columnMappings.put("answerWaitSecond10", "Ans Wait 10 Second");
        columnMappings.put("answerWaitSecond20", "Ans Wait 20 Second");
        columnMappings.put("answerWaitSecond30", "Ans Wait 30 Second");
        columnMappings.put("answerWaitSecond40", "Ans Wait 40 Second");
        columnMappings.put("answerWaitSecond50", "Ans Wait 50 Second");
        columnMappings.put("answerWaitSecond60", "Ans Wait 60 Second");
        columnMappings.put("greaterAnswerWaitSecond60", "Ans Wait >60 Second");
        columnMappings.put("abandonedWaitSecond10", "ABD Wait 10 Second");
        columnMappings.put("abandonedWaitSecond20", "ABD Wait 20 Second");
        columnMappings.put("abandonedWaitSecond30", "ABD Wait 30 Second");
        columnMappings.put("abandonedWaitSecond40", "ABD Wait 40 Second");
        columnMappings.put("abandonedWaitSecond50", "ABD Wait 50 Second");
        columnMappings.put("abandonedWaitSecond60", "ABD Wait 60 Second");
        columnMappings.put("greaterAbandonedWaitSecond60", "ABD Wait >60 Second");
        columnMappings.put("averageNumberAgent", "Avg No of Agent");
        columnMappings.put("averageAnswerWaitTime", "Avg Ans Wait Time");
        columnMappings.put("totalAbandonedWaitTime", "Total ABD Wait Time");
        columnMappings.put("totalAnswerWaitTime", "Total Ans Wait Time");
        columnMappings.put("averageAbandonedWaitTime", "Avg ABD Wait Time");
        columnMappings.put("averageTalkTime", "Avg Talk Time");
        columnMappings.put("servicePercentage", "Service %");
        columnMappings.put("abandonedPercentage", "Abandoned %");
    }
}

