/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.inOutgatewaySummary.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.inOutgatewaySummary.model.GatewayInBoundModel;
import com.coraltele.service.telemetry.main.inOutgatewaySummary.model.GatewayOutBoundModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class GatewaySummaryService {
    private static final Logger logger = LogManager.getLogger(GatewaySummaryService.class);
    @Autowired
    private BillingCDRRepository billingCdrRepository;
    @Autowired
    private DateFormatUtility dateFormatUtility;
    @Autowired
    private PdfReportRepository pdfReportRepository;
    private static final NumberFormat INR_FORMAT = NumberFormat.getCurrencyInstance(new Locale("en", "IN"));

    private LocalDate parseDate(String date) {
        return date == null || date.trim().isEmpty() ? null : LocalDate.parse(date);
    }

    private Long toLong(Object val) {
        return val == null ? 0L : ((Number)val).longValue();
    }

    private Double toDouble(Object val) {
        return val == null ? 0.0 : ((Number)val).doubleValue();
    }

    private String formatINR(Double amount) {
        if (amount == null) {
            return "\u20b90.00";
        }
        amount = amount / 100.0;
        return INR_FORMAT.format(amount);
    }

    private String formatDuration(Long sec) {
        return DateFormatUtility.findLocalTime((Long)sec);
    }

    public RequestResponse getListOutBound(SearchRequest request) {
        List<Object[]> rows;
        boolean hasSearch;
        String from = null;
        String to = null;
        String gateway = null;
        if (request.getAdvancedFilters() != null) {
            for (AdvanceFilter f : request.getAdvancedFilters()) {
                if ("callDate".equalsIgnoreCase(f.getFieldName())) {
                    if ("from".equalsIgnoreCase(f.getDirection())) {
                        from = f.getValue();
                    }
                    if ("to".equalsIgnoreCase(f.getDirection())) {
                        to = f.getValue();
                    }
                }
                if (!"coralGateway".equalsIgnoreCase(f.getFieldName())) continue;
                gateway = f.getValue();
            }
        }
        LocalDate fromDate = this.parseDate(from);
        LocalDate toDate = this.parseDate(to);
        int pageSize = request.getPageSize();
        int page = request.getCurrentPage();
        int offset = page * pageSize;
        String search = request.getSearch();
        boolean bl = hasSearch = search != null && !search.trim().isEmpty();
        if (hasSearch) {
            search = search.trim();
        }
        if (!hasSearch) {
            rows = "desc".equalsIgnoreCase(request.getSortDirection()) ? this.billingCdrRepository.fetchDesc(fromDate, toDate, gateway, pageSize, offset) : this.billingCdrRepository.fetchAsc(fromDate, toDate, gateway, pageSize, offset);
        } else {
            List allRows = this.billingCdrRepository.fetchAsc(fromDate, toDate, gateway, Integer.MAX_VALUE, 0);
            rows = new ArrayList();
            for (Object[] r : allRows) {
                String gw = this.safe(r[0]);
                if (gw == null || !gw.toLowerCase().contains(search)) continue;
                rows.add(r);
            }
            int start = Math.min(offset, rows.size());
            int end = Math.min(offset + pageSize, rows.size());
            rows = rows.subList(start, end);
        }
        ArrayList<GatewayOutBoundModel> result = new ArrayList<GatewayOutBoundModel>();
        for (Object[] r : rows) {
            GatewayOutBoundModel m = new GatewayOutBoundModel();
            m.setCoralGateway((String)r[0]);
            m.setIntercomCall(this.toLong(r[1]));
            m.setIntercomCost(this.formatINR(this.toDouble(r[2])));
            m.setLocalCall(this.toLong(r[3]));
            m.setLocalCost(this.formatINR(this.toDouble(r[4])));
            m.setStdCall(this.toLong(r[5]));
            m.setStdCost(this.formatINR(this.toDouble(r[6])));
            m.setIsdCall(this.toLong(r[7]));
            m.setIsdCost(this.formatINR(this.toDouble(r[8])));
            m.setTotalCall(this.toLong(r[9]));
            m.setTotalCost(this.formatINR(this.toDouble(r[10])));
            result.add(m);
        }
        SearchResponse sr = new SearchResponse();
        sr.setCurrentPage((long)page);
        sr.setPageSize((long)pageSize);
        sr.setCurrentPageData(result);
        sr.setTotalRecords((long)result.size());
        RequestResponse rr = new RequestResponse();
        rr.setStatus(Constants.Error.OK);
        rr.setMessage("Outbound Summary fetched successfully");
        rr.setData((Object)sr);
        return rr;
    }

    public RequestResponse getListInBound(SearchRequest request) {
        boolean hasSearch;
        String from = null;
        String to = null;
        String gateway = null;
        if (request.getAdvancedFilters() != null) {
            for (AdvanceFilter f : request.getAdvancedFilters()) {
                if ("callDate".equalsIgnoreCase(f.getFieldName())) {
                    if ("from".equalsIgnoreCase(f.getDirection())) {
                        from = f.getValue();
                    }
                    if ("to".equalsIgnoreCase(f.getDirection())) {
                        to = f.getValue();
                    }
                }
                if (!"coralInboundGateway".equalsIgnoreCase(f.getFieldName())) continue;
                gateway = this.emptyToNull(f.getValue());
            }
        }
        LocalDate fromDate = this.parseDateSafe(from);
        LocalDate toDate = this.parseDateSafe(to);
        String search = request.getSearch();
        boolean bl = hasSearch = search != null && !search.trim().isEmpty();
        if (hasSearch) {
            search = search.trim().toLowerCase();
        }
        List rows = this.billingCdrRepository.getInboundSummary(fromDate, toDate, gateway);
        List<Object> all = new ArrayList();
        for (Object r : rows) {
            String gw = this.safe(r[0]);
            GatewayInBoundModel m2 = new GatewayInBoundModel();
            m2.setCoralInboundGateway(gw);
            m2.setTotalCall(this.toLong(r[1]));
            m2.setAnswered(this.toLong(r[2]));
            m2.setUnAnswered(this.toLong(r[3]));
            m2.setRingDuration(this.formatDuration(this.toLong(r[4])));
            m2.setAvgRingDuration(this.formatDuration(this.toLong(r[5])));
            m2.setTalkDuration(this.formatDuration(this.toLong(r[6])));
            m2.setAvgCallDuration(this.formatDuration(this.toLong(r[7])));
            all.add(m2);
        }
        if (hasSearch) {
            String searchTerm = search;
            all = all.stream().filter(m -> m.getCoralInboundGateway() != null && m.getCoralInboundGateway().toLowerCase().contains(searchTerm)).collect(Collectors.toList());
        }
        if (request.getSortBy() != null && !"none".equalsIgnoreCase(request.getSortDirection())) {
            Comparator<GatewayInBoundModel> cmp = null;
            switch (request.getSortBy()) {
                case "coralInboundGateway": {
                    cmp = Comparator.comparing(m -> m.getCoralInboundGateway() == null ? "" : m.getCoralInboundGateway(), String.CASE_INSENSITIVE_ORDER);
                    break;
                }
                case "totalCall": {
                    cmp = Comparator.comparing(GatewayInBoundModel::getTotalCall);
                    break;
                }
                case "answered": {
                    cmp = Comparator.comparing(GatewayInBoundModel::getAnswered);
                    break;
                }
                case "unAnswered": {
                    cmp = Comparator.comparing(GatewayInBoundModel::getUnAnswered);
                    break;
                }
                default: {
                    cmp = null;
                }
            }
            if (cmp != null && "desc".equalsIgnoreCase(request.getSortDirection())) {
                cmp = cmp.reversed();
            }
            if (cmp != null) {
                all.sort(cmp);
            }
        }
        int page = request.getCurrentPage();
        int size = request.getPageSize();
        int offset = page * size;
        int start = Math.min(offset, all.size());
        int end = Math.min(offset + size, all.size());
        List<Object> pageData = all.subList(start, end);
        SearchResponse sr = new SearchResponse();
        sr.setCurrentPage((long)page);
        sr.setPageSize((long)size);
        sr.setCurrentPageData(pageData);
        sr.setTotalRecords((long)all.size());
        RequestResponse rr = new RequestResponse();
        rr.setStatus(Constants.Error.OK);
        rr.setMessage("Inbound Summary fetched successfully");
        rr.setData((Object)sr);
        return rr;
    }

    private String emptyToNull(String v) {
        return v == null || v.trim().isEmpty() ? null : v.trim();
    }

    private LocalDate parseDateSafe(String v) {
        try {
            return v == null || v.trim().isEmpty() ? null : LocalDate.parse(v);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String safe(Object val) {
        return val == null ? null : val.toString();
    }

    public ResponseEntity<byte[]> getPdfFile(String path) {
        try {
            Optional entry = this.pdfReportRepository.findByPdfLocation(path);
            if (!entry.isPresent() || !"success".equalsIgnoreCase(((PdfReportFilters)entry.get()).getStatus())) {
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
            }
            byte[] data = Files.readAllBytes(new File(path).toPath());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_PDF);
            headers.setContentDispositionFormData("attachment", "GatewaySummary.pdf");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)data);
        }
        catch (IOException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }
}

