/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.extensionDetailIn.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.db.telemetry.main.repository.BillingCdrIncomingSummaryViewRepository;
import com.coraltele.db.telemetry.main.specification.BillingCdrIncomingSummarySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.background.PdfGeneratorService;
import com.coraltele.service.telemetry.main.extensionDetailIn.model.ExtensionSummaryModel;
import com.coraltele.service.telemetry.main.extensionDetailIn.service.ExtensionDetailInService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ExtensionDetailsSummaryInPdf")
public class ExtensionDetailSummaryInPdf
implements PdfGeneratorService {
    private static final Logger logger = LogManager.getLogger(ExtensionDetailSummaryInPdf.class);
    @Autowired
    BillingCdrIncomingSummarySpecification billingCdrIncomingSummarySpecification;
    @Autowired
    BillingCdrIncomingSummaryViewRepository billingCdrIncomingSummaryViewRepository;
    @Autowired
    PdfPageNumberEvent pageNumberEvent;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    DynamicPdfThreadService generatingReports;
    @Autowired
    private PdfReportRepository pdfReportRepository;
    @Autowired
    BillingCDRRepository billingCdrRepository;
    @Autowired
    ExtensionDetailInService extensionCDRService;
    LocalDateTime now;
    private static String reportFileName = "Inbound Extension summary";
    private static final String DATE_FORMAT = "dd-MM-yyyy hh:mm:ss a";
    private static final String LOGO = "/var/www/html/apple-icon.png";
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    public RequestResponse generatePdfReport(SearchRequest req, String path, Principal p) {
        RequestResponse res = new RequestResponse();
        try {
            List<Object> list;
            this.now = LocalDateTime.now();
            this.pageNumberEvent.initialize(LOGO, reportFileName, DATE_FORMAT, this.now);
            try {
                SearchResponse sr;
                RequestResponse rr = this.extensionCDRService.getExtensionSummary(req);
                list = rr != null && rr.getData() instanceof SearchResponse ? ((sr = (SearchResponse)rr.getData()).getCurrentPageData() != null ? (List<Object>)sr.getCurrentPageData() : Collections.emptyList()) : Collections.emptyList();
            }
            catch (Exception ex) {
                logger.error("Failed to fetch extension summary", (Throwable)ex);
                list = Collections.emptyList();
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Document doc = req.getColumnNames().size() > 6 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4.rotate());
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)out);
            writer.setPageEvent((PdfPageEvent)this.pageNumberEvent);
            doc.open();
            this.addFrontPage(doc);
            doc.newPage();
            this.addTable(doc, (List)list, req.getColumnNames());
            doc.close();
            this.save(out.toByteArray(), path);
            res.setStatus(Constants.Error.OK);
            res.setMessage("PDF Generated");
            res.setData((Object)path);
        }
        catch (Exception e) {
            e.printStackTrace();
            res.setStatus(Constants.Error.ERROR);
            res.setMessage("FAILED");
        }
        return res;
    }

    private void addFrontPage(Document doc) throws Exception {
        PdfPTable t = new PdfPTable(1);
        t.setWidthPercentage(100.0f);
        Image img = Image.getInstance((String)LOGO);
        img.scaleAbsolute(360.0f, 340.0f);
        PdfPCell logo = new PdfPCell(img);
        logo.setHorizontalAlignment(1);
        logo.setBorder(0);
        logo.setPaddingTop(40.0f);
        t.addCell(logo);
        PdfPCell title = new PdfPCell(new Phrase(reportFileName, COURIER));
        title.setHorizontalAlignment(1);
        title.setBorder(0);
        title.setPaddingTop(20.0f);
        t.addCell(title);
        PdfPCell dt = new PdfPCell(new Phrase("Report generated on  " + this.now.format(DateTimeFormatter.ofPattern(DATE_FORMAT)), COURIER_SMALL));
        dt.setHorizontalAlignment(1);
        dt.setBorder(0);
        dt.setPaddingTop(10.0f);
        t.addCell(dt);
        doc.add((Element)t);
        doc.add((Element)Chunk.NEWLINE);
        doc.add((Element)Chunk.NEWLINE);
    }

    private void addTable(Document doc, List<ExtensionSummaryModel> list, List<String> cols) throws Exception {
        PdfPTable t = new PdfPTable(cols.size());
        t.setWidthPercentage(100.0f);
        BaseColor blue = new BaseColor(2, 111, 194);
        BaseColor alt = new BaseColor(235, 235, 235);
        Font headerFont = new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE);
        for (String c : cols) {
            PdfPCell x = new PdfPCell(new Phrase(columnMappings.getOrDefault(c, c), headerFont));
            x.setBackgroundColor(blue);
            x.setHorizontalAlignment(1);
            x.setBorder(0);
            t.addCell(x);
        }
        t.setHeaderRows(1);
        for (int i = 0; i < list.size(); ++i) {
            ExtensionSummaryModel d = list.get(i);
            t.getDefaultCell().setBackgroundColor(i % 2 == 0 ? BaseColor.WHITE : alt);
            t.getDefaultCell().setHorizontalAlignment(1);
            t.getDefaultCell().setVerticalAlignment(5);
            t.getDefaultCell().setBorder(0);
            for (String c : cols) {
                t.addCell(String.valueOf(this.getVal(d, c)));
            }
        }
        doc.add((Element)t);
    }

    private Object getVal(ExtensionSummaryModel d, String c) {
        if (d == null) {
            return "";
        }
        switch (c) {
            case "extension": {
                return d.getExtension();
            }
            case "totalCall": {
                return d.getTotalCall();
            }
            case "answered": {
                return d.getAnswered();
            }
            case "unanswered": {
                return d.getUnanswered();
            }
            case "ringDuration": {
                return d.getRingDuration();
            }
            case "avgRingDuration": {
                return d.getAvgRingDuration();
            }
            case "callDuration": {
                return d.getCallDuration();
            }
            case "avgCallDuration": {
                return d.getAvgCallDuration();
            }
        }
        return "";
    }

    private void save(byte[] b, String p) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(p);){
            fos.write(b);
        }
    }

    public void createPdfReportRecord(String id, SearchRequest data, String path) {
        try {
            PdfReportFilters rec = new PdfReportFilters();
            rec.setId(id);
            rec.setReportName(reportFileName);
            rec.setPdfLocation(path);
            rec.setCreatedOnDate(this.now);
            rec.setStatus("InProgress");
            rec.setFilterParameters(new ObjectMapper().writeValueAsString((Object)data));
            this.pdfReportRepository.save((Object)rec);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        columnMappings.put("extension", "Extension No");
        columnMappings.put("totalCall", "Total Call");
        columnMappings.put("answered", "Answered");
        columnMappings.put("unanswered", "Unanswered");
        columnMappings.put("ringDuration", "Ring Time(HH:MM:SS)");
        columnMappings.put("avgRingDuration", "Avg Ring Time(HH:MM:SS)");
        columnMappings.put("callDuration", "Talk Time(HH:MM:SS)");
        columnMappings.put("avgCallDuration", "Avg Talk Time (HH:MM:SS)");
    }
}

