/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.agentCDR.controller;

import com.coraltele.db.telemetry.main.entity.AgentCDR;
import com.coraltele.db.telemetry.main.repository.AgentCDRRepository;
import com.coraltele.db.telemetry.main.specification.AgentCDRSpecification;
import com.coraltele.db.telemetry.main.specification.AgentCdrSpecificationNew;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResultModel;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.agentCDR.service.AgentCDRService;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/agentCDR"})
@RestController
public class AgentCDRController {
    private static final Logger logger = LogManager.getLogger(AgentCDRController.class);
    @Autowired
    AgentCDRRepository agentCDRRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    AgentCDRService agentCDRService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> columnMappingsAgentCdr;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.agentCDRService.getAllByFilter(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    private String formatNullableDate(Long epochMillis) {
        return epochMillis != null ? DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)epochMillis)) : "";
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForCallerCall(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for Agent-Call-Data-");
            boolean adminUser = false;
            boolean teamLeaderUser = false;
            boolean agentUser = false;
            boolean managerUser = false;
            if (this.userService.checkAdminUser(principal.getName())) {
                adminUser = true;
            } else if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            } else if (this.userService.checkManagerUser(principal.getName())) {
                managerUser = true;
            } else {
                agentUser = true;
            }
            List queueId = null;
            if (teamLeaderUser) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            Specification filters = AgentCDRSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)teamLeaderUser, (boolean)agentUser, (boolean)managerUser, (List)queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.agentCDRRepository.findAll(filters, sort) : this.agentCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (AgentCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValueForCallerCall(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Agent-Call-Data", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Agent-Call-Data CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValueForCallerCall(AgentCDR item, String columnName) {
        switch (columnName) {
            case "agentTalkedTo": {
                return this.checkNull((Object)item.getAgentTalkedTo());
            }
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "startTime": {
                return this.formatNullableDate(item.getStartTime());
            }
            case "endTime": {
                return this.formatNullableDate(item.getEndTime());
            }
            case "answerTime": {
                return DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getAnswerTime());
            }
            case "talkDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTalkDuration()));
            }
            case "recordingFile": {
                return this.checkNull((Object)item.getRecordingFile());
            }
            case "queueName": {
                return this.checkNull((Object)item.getQueueName());
            }
            case "agentName": {
                return this.checkNull((Object)item.getAgentName());
            }
            case "callDirection": {
                return this.checkNull((Object)item.getCallDirection());
            }
            case "duration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTimeForInteger((Integer)item.getDuration()));
            }
            case "fullName": {
                return this.checkNull((Object)item.getFullName());
            }
            case "campaignName": {
                return this.checkNull((Object)item.getCampaignName());
            }
            case "hangupCause": {
                return this.checkNull((Object)item.getHangupCause());
            }
            case "isMissed": {
                if (item.getIsMissed() != null && !item.getIsMissed().booleanValue()) {
                    return "Answered";
                }
                return "Not Answered";
            }
            case "mos": {
                if (item.getMos() != null) {
                    if (item.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                        return BigDecimal.valueOf(4.3);
                    }
                    return item.getMos();
                }
                return BigDecimal.valueOf(4.3);
            }
        }
        return null;
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/agentCdr/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for agent cdr--");
            boolean adminUser = false;
            boolean teamLeaderUser = false;
            boolean agentUser = false;
            boolean managerUser = false;
            if (this.userService.checkAdminUser(principal.getName())) {
                adminUser = true;
            } else if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            } else if (this.userService.checkManagerUser(principal.getName())) {
                managerUser = true;
            } else {
                agentUser = true;
            }
            List queueId = null;
            if (teamLeaderUser) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            Specification filters = AgentCDRSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)teamLeaderUser, (boolean)agentUser, (boolean)managerUser, (List)queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "extensionNo" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "extensionNo" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.agentCDRRepository.findAll(filters, sort) : this.agentCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappingsAgentCdr.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (AgentCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for agent cdr", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading agent cdr CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(AgentCDR item, String columnName) {
        switch (columnName) {
            case "queueName": {
                return this.checkNull((Object)item.getQueueName());
            }
            case "campaignName": {
                return this.checkNull((Object)item.getCampaignName());
            }
            case "agentTalkedTo": {
                return this.checkNull((Object)item.getAgentTalkedTo());
            }
            case "startTime": {
                return this.checkNull(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getStartTime()));
            }
            case "talkDuration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getTalkDuration()));
            }
            case "agentName": {
                return this.checkNull((Object)item.getAgentName());
            }
            case "fullName": {
                return this.checkNull((Object)item.getFullName());
            }
            case "leadName": {
                return this.checkNull((Object)item.getLeadName());
            }
            case "answerTime": {
                return this.checkNull(DateFormatUtility.epochToLocalDateTimeAsStringForSecondToHandleZero((Long)item.getAnswerTime()));
            }
            case "second10": {
                return this.checkNull((Object)item.getSecond10());
            }
            case "second20": {
                return this.checkNull((Object)item.getSecond20());
            }
            case "second30": {
                return this.checkNull((Object)item.getSecond30());
            }
            case "second40": {
                return this.checkNull((Object)item.getSecond40());
            }
            case "second50": {
                return this.checkNull((Object)item.getSecond50());
            }
            case "second60": {
                return this.checkNull((Object)item.getSecond60());
            }
            case "recordingFile": {
                return this.checkNull((Object)item.getRecordingFile());
            }
            case "callDirection": {
                return this.checkNull((Object)item.getCallDirection());
            }
            case "isMissed": {
                return this.checkNull((Object)item.getIsMissed());
            }
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "recordType": {
                return this.checkNull((Object)item.getRecordType());
            }
            case "mos": {
                if (item.getMos().compareTo(BigDecimal.valueOf(0.0)) == 0) {
                    return 4.3;
                }
                return item.getMos();
            }
        }
        return null;
    }

    @PostMapping(value={"/downloadCSV1"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForCallerCall1(@RequestBody SearchResultModel searchRequestData) {
        try {
            logger.info("CSV file download started for Agent-Call-Data-");
            Specification filters = AgentCdrSpecificationNew.buildSpecification((SearchResultModel)searchRequestData);
            List filteredData = this.agentCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getSelectedColumns());
                List displayNames = searchRequestData.getSelectedColumns().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (AgentCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getSelectedColumns()) {
                        values.add(this.getColumnValueForCallerCall(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Agent-Call-Data", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Agent-Call-Data CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping(value={"/queues"})
    public ResponseEntity<RequestResponse> getQueues() {
        RequestResponse returnValue = this.agentCDRService.getQueueOfAgentCdr();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/agents"})
    public ResponseEntity<RequestResponse> getAgents() {
        RequestResponse returnValue = this.agentCDRService.getAgentOfAgentCdr();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listFilter"})
    public ResponseEntity<RequestResponse> getAllByFilterWithToken(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.agentCDRService.getAllByFilterWithToken(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    static {
        columnMappings.put("agentTalkedTo", "Caller ID");
        columnMappings.put("startTime", "Start Stamp");
        columnMappings.put("answerTime", "Answer Stamp");
        columnMappings.put("endTime", "End Stamp");
        columnMappings.put("recordingFile", "Recording File");
        columnMappings.put("queueName", "Queue Name");
        columnMappings.put("agentName", "Agent ID");
        columnMappings.put("callDirection", "Direction");
        columnMappings.put("duration", "Duration");
        columnMappings.put("fullName", "Agent Name");
        columnMappings.put("talkDuration", "Talk Time");
        columnMappings.put("campaignName", "Campaign Name");
        columnMappings.put("hangupCause", "Hangup Cause");
        columnMappings.put("isMissed", "Call Status");
        columnMappings.put("queue", "Queue");
        columnMappings.put("mos", "MOS");
        columnMappingsAgentCdr = new ConcurrentHashMap();
        columnMappingsAgentCdr.put("queueName", "Queue Name");
        columnMappingsAgentCdr.put("campaignName", "Campaign Name");
        columnMappingsAgentCdr.put("agentTalkedTo", "Customer Number");
        columnMappingsAgentCdr.put("startTime", "Start Time");
        columnMappingsAgentCdr.put("talkDuration", "Talk Time");
        columnMappingsAgentCdr.put("agentName", "Agent id");
        columnMappingsAgentCdr.put("fullName", "Agent Name");
        columnMappingsAgentCdr.put("answerTime", "Answer Time");
        columnMappingsAgentCdr.put("leadName", "Lead Name");
        columnMappingsAgentCdr.put("second10", "Second 10");
        columnMappingsAgentCdr.put("second20", "Second 20");
        columnMappingsAgentCdr.put("second30", "Second 30");
        columnMappingsAgentCdr.put("second40", "Second 40");
        columnMappingsAgentCdr.put("second50", "Second 50");
        columnMappingsAgentCdr.put("second60", "Second 60");
        columnMappingsAgentCdr.put("recordingFile", "Recording File");
        columnMappingsAgentCdr.put("callDirection", "call Direction");
        columnMappingsAgentCdr.put("isMissed", "Missed Call");
        columnMappingsAgentCdr.put("queue", "Queue Id");
        columnMappingsAgentCdr.put("recordType", "Record Type");
        columnMappingsAgentCdr.put("mos", "MOS");
    }
}

