/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.videoRecording.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.videoRecording.model.MultipleVideoRecordings;
import com.coraltele.service.pbx.videoRecording.model.VideoRecordingMultipleUpdates;
import com.coraltele.service.pbx.videoRecording.service.VideoRecordingService;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/videoRecordings"})
@RestController
public class VideoRecordingController {
    @Autowired
    private VideoRecordingService videoRecordingsService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> addVideoRecordings(@RequestBody MultipleVideoRecordings multipleVideoRecordings) {
        RequestResponse returnValue = this.videoRecordingsService.createVideoRecordings(multipleVideoRecordings);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllVideoRecordings(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.videoRecordingsService.getFilterVideoData(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiDelete"})
    public ResponseEntity<RequestResponse> deleteAll(@RequestBody List<Integer> ids) {
        RequestResponse returnValue = this.videoRecordingsService.deleteMultipleRecords(ids);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/multiUpdate"})
    public ResponseEntity<RequestResponse> partialUpdateOutboundCos(HttpServletRequest request, @RequestBody VideoRecordingMultipleUpdates data, Authentication authentication) throws IOException {
        RequestResponse returnValue = this.videoRecordingsService.updateAll(request, data, authentication);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

