/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.codeBlueReport.controller;

import com.coraltele.db.telephony.pbx.entity.view.CodeBlueReportView;
import com.coraltele.db.telephony.pbx.repository.CodeBlueReportViewRepository;
import com.coraltele.db.telephony.pbx.specification.CodeBlueReportViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.pbx.codeBlueReport.service.CodeBlueReportViewService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/codeBlueReport"})
public class CodeBlueReportViewController {
    private static final Logger logger = LogManager.getLogger(CodeBlueReportViewController.class);
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    CodeBlueReportViewService codeBlueReportViewService;
    @Autowired
    CodeBlueReportViewRepository codeBlueReportViewRepository;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.codeBlueReportViewService.getAll(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for code blue--");
            Specification filters = CodeBlueReportViewSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.codeBlueReportViewRepository.findAll(filters, sort) : this.codeBlueReportViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (CodeBlueReportView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Code Blue Report", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Code Blue Report CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(CodeBlueReportView item, String columnName) {
        switch (columnName) {
            case "callerIdNumber": {
                return this.checkNull((Object)item.getCallerIdNumber());
            }
            case "codeBlueType": {
                return this.checkNull((Object)item.getCodeBlueType());
            }
            case "accessCode": {
                return this.checkNull((Object)item.getAccessCode());
            }
            case "dialNumber": {
                return this.checkNull((Object)item.getDialNumber());
            }
            case "startTime": {
                return this.checkNull((Object)item.getStartTime());
            }
            case "answerTime": {
                return this.checkNull((Object)item.getAnswerTime());
            }
            case "endtime": {
                return this.checkNull((Object)item.getEndtime());
            }
            case "duration": {
                return this.checkNull((Object)item.getDuration());
            }
            case "hangupCause": {
                return this.checkNull((Object)item.getHangupCause());
            }
            case "ivrStarttime": {
                return this.checkNull((Object)item.getIvrStarttime());
            }
            case "ivrEndtime": {
                return this.checkNull((Object)item.getIvrEndtime());
            }
            case "ivrDuration": {
                return this.checkNull((Object)item.getIvrDuration());
            }
            case "coralDialId": {
                return this.checkNull((Object)item.getCoralDialId());
            }
            case "smsText": {
                return this.checkNull((Object)item.getSmsText());
            }
            case "status": {
                return this.checkNull((Object)item.getStatus());
            }
            case "executionTime": {
                return this.checkNull((Object)item.getExecutionTime());
            }
        }
        return "";
    }

    private String formatNullableDate(Long epochMillis) {
        return epochMillis != null ? DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)epochMillis)) : "";
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    static {
        columnMappings.put("callerIdNumber", "Caller Id Number");
        columnMappings.put("codeBlueType", "Code Blue Type");
        columnMappings.put("accessCode", "Access Code");
        columnMappings.put("dialNumber", "Dial Number");
        columnMappings.put("startTime", "Start Time");
        columnMappings.put("answerTime", "Answer Time");
        columnMappings.put("endtime", "End Time");
        columnMappings.put("duration", "Duration");
        columnMappings.put("hangupCause", "Hang Up Cause");
        columnMappings.put("ivrStarttime", "IVR Start Time");
        columnMappings.put("ivrEndtime", "IVR End Time");
        columnMappings.put("ivrDuration", "IVR Duration");
        columnMappings.put("coralDialId", "Coral DialId");
        columnMappings.put("smsText", "SMS Text");
        columnMappings.put("status", "Status");
        columnMappings.put("executionTime", "Execution Time");
    }
}

