/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.leadSummaryInternalView.controller;

import com.coraltele.db.coralapps.callcenter.entity.view.LeadDialingSummaryView;
import com.coraltele.db.coralapps.callcenter.entity.view.LeadSummaryView;
import com.coraltele.db.coralapps.callcenter.repository.LeadDialingSummaryViewRepository;
import com.coraltele.db.coralapps.callcenter.repository.LeadSummaryViewRepository;
import com.coraltele.db.coralapps.callcenter.specification.LeadDialingSummaryViewSpecification;
import com.coraltele.db.coralapps.callcenter.specification.LeadSummaryViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.coralApps.callcenter.leadSummaryInternalView.model.LeadSummaryViewModel;
import com.coraltele.service.coralApps.callcenter.leadSummaryInternalView.service.LeadDialingSummaryViewService;
import com.coraltele.service.coralApps.callcenter.leadSummaryInternalView.service.LeadSummaryViewService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/leadSummaryView"})
@RestController
public class LeadSummaryViewController {
    private static final Logger logger = LogManager.getLogger(LeadSummaryViewController.class);
    @Autowired
    LeadSummaryViewService leadSummaryViewService;
    @Autowired
    LeadSummaryViewRepository leadSummaryViewRepository;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadServiceTest;
    @Autowired
    LeadDialingSummaryViewService leadDialingSummaryViewService;
    @Autowired
    LeadDialingSummaryViewRepository leadDialingSummaryViewRepository;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> columnMappingsForLeadDialing;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.leadSummaryViewService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for lead summary--");
            Specification filters = LeadSummaryViewSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "campaign" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "campaign" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.leadSummaryViewRepository.findAll(filters, sort) : this.leadSummaryViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (LeadSummaryView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for lead summary", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading lead summary CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(LeadSummaryView item, String columnName) {
        switch (columnName) {
            case "leadUploadDate": {
                return this.checkNull((Object)item.getLeadUploadDate());
            }
            case "campaign": {
                return this.checkNull((Object)item.getCampaign());
            }
            case "fileName": {
                return this.checkNull((Object)item.getFileName());
            }
            case "campaignFromTime": {
                return this.checkNull((Object)item.getCampaignFromTime());
            }
            case "campaignEndTime": {
                return this.checkNull((Object)item.getCampaignEndTime());
            }
            case "status": {
                return this.checkNull((Object)item.getStatus());
            }
            case "upload": {
                return this.checkNull((Object)item.getUpload());
            }
            case "call": {
                return this.checkNull((Object)item.getCall());
            }
            case "duplicate": {
                return this.checkNull((Object)item.getDuplicate());
            }
            case "valid": {
                return this.checkNull((Object)item.getValid());
            }
            case "dialed": {
                return this.checkNull((Object)item.getDialed());
            }
            case "pending": {
                return this.checkNull((Object)item.getPending());
            }
            case "answered": {
                return this.checkNull((Object)item.getAnswered());
            }
            case "abandoned": {
                return this.checkNull((Object)item.getAbandoned());
            }
            case "markAsDelete": {
                return this.checkNull((Object)item.getMarkAsDelete());
            }
            case "filepath": {
                return this.checkNull((Object)item.getFilepath());
            }
        }
        return null;
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadServiceTest.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateInDialOut(@RequestBody LeadSummaryViewModel data) {
        RequestResponse returnValue = this.leadSummaryViewService.updateInDialOut(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/leadDialingSummary/list"})
    public ResponseEntity<RequestResponse> getAllLeadDialingSummary(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.leadDialingSummaryViewService.getAllLeadDialingSummary(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/leadDialingSummary/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForLeadDialingSummaryView(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for lead dial summary--");
            List cam = new ArrayList();
            for (AdvanceFilter filter : searchRequestData.advancedFilters) {
                if (!filter.getFieldName().equalsIgnoreCase("campaign")) continue;
                cam = this.leadDialingSummaryViewService.getCampaignList(filter.getValue());
            }
            Specification filters = LeadDialingSummaryViewSpecification.generateFilters((SearchRequest)searchRequestData, cam);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "campaign" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "campaign" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.leadDialingSummaryViewRepository.findAll(filters, sort) : this.leadDialingSummaryViewRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (LeadDialingSummaryView item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for lead dial summary", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading lead dial summary CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(LeadDialingSummaryView item, String columnName) {
        switch (columnName) {
            case "campaign": {
                return this.checkNull((Object)item.getCampaign());
            }
            case "phoneNumber": {
                return this.checkNull((Object)item.getPhoneNumber());
            }
            case "uploaded": {
                return this.checkNull((Object)item.getUploaded());
            }
            case "dialed": {
                return this.checkNull((Object)item.getDialed());
            }
            case "redialed": {
                return this.checkNull((Object)item.getRedialed());
            }
            case "redialedOn": {
                return this.checkNull((Object)item.getRedialed());
            }
            case "dialingPending": {
                return this.checkNull((Object)item.getDialingPending());
            }
            case "answered": {
                return this.checkNull((Object)item.getAnswered());
            }
            case "userBusy": {
                return this.checkNull((Object)item.getUserBusy());
            }
            case "notReachable": {
                return this.checkNull((Object)item.getNotReachable());
            }
            case "others": {
                return this.checkNull((Object)item.getOthers());
            }
            case "hangupCause": {
                return this.checkNull((Object)item.getHangupCause());
            }
            case "coralDialId": {
                return this.checkNull((Object)item.getCoralDialId());
            }
            case "ccAgent": {
                return this.checkNull((Object)item.getCcAgent());
            }
            case "duration": {
                return this.checkNull((Object)item.getDuration());
            }
            case "billSec": {
                return this.checkNull((Object)item.getBillSec());
            }
            case "bridgeUuid": {
                return this.checkNull((Object)item.getBridgeUuid());
            }
        }
        return null;
    }

    static {
        columnMappings.put("leadUploadDate", "Lead Uploaded On");
        columnMappings.put("campaign", "Campaign");
        columnMappings.put("fileName", "Lead Name");
        columnMappings.put("campaignFromTime", "Campaign Start Date");
        columnMappings.put("campaignEndTime", "Campaign End Date");
        columnMappings.put("status", "Campaign Status");
        columnMappings.put("upload", "Total Upload");
        columnMappings.put("call", "Total DMCL");
        columnMappings.put("duplicate", "Total Duplicate");
        columnMappings.put("valid", "Total Valid");
        columnMappings.put("dialed", "Total Dialed");
        columnMappings.put("pending", "Total Pending");
        columnMappings.put("answered", "Total Answered");
        columnMappings.put("abandoned", "Total Abandoned");
        columnMappings.put("markAsDelete", "Lead Marked as Canceled");
        columnMappings.put("filepath", "File Path");
        columnMappingsForLeadDialing = new ConcurrentHashMap();
        columnMappingsForLeadDialing.put("campaign", "Campaign");
        columnMappingsForLeadDialing.put("phoneNumber", "Dialed No");
        columnMappingsForLeadDialing.put("uploaded", "Uploaded");
        columnMappingsForLeadDialing.put("dialed", "Dialed");
        columnMappingsForLeadDialing.put("redialed", "Redialed");
        columnMappingsForLeadDialing.put("redialedOn", "Redialed On");
        columnMappingsForLeadDialing.put("dialingPending", "Pending");
        columnMappingsForLeadDialing.put("answered", "Answered");
        columnMappingsForLeadDialing.put("userBusy", "User Busy");
        columnMappingsForLeadDialing.put("notReachable", "Not Reachable");
        columnMappingsForLeadDialing.put("others", "Others");
        columnMappingsForLeadDialing.put("hangupCause", "Hangup Cause");
        columnMappingsForLeadDialing.put("coralDialId", "Called On");
        columnMappingsForLeadDialing.put("ccAgent", "Agent");
        columnMappingsForLeadDialing.put("duration", "Duration (Sec)");
        columnMappingsForLeadDialing.put("billSec", "Talk Time (Sec)");
        columnMappingsForLeadDialing.put("bridgeUuid", "Bridge Uuid");
    }
}

