/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.log.service;

import com.coraltele.db.billing.log.entity.UserLogs;
import com.coraltele.helper.HttpUtils;
import com.coraltele.service.billing.log.service.UserLogsStoreService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class UserLogsActivityService
implements HandlerInterceptor {
    private static final Logger logger = LogManager.getLogger(UserLogsActivityService.class);
    @Autowired
    private UserLogsStoreService userLogsStoreService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String loggedInUser = this.userLogsStoreService.getLoggedInUser();
        String requestMethod = request.getMethod();
        String url = request.getRequestURL().toString();
        String clientIp = HttpUtils.getRequestIp((HttpServletRequest)request);
        String ipHolder = HttpUtils.getIpHolder((HttpServletRequest)request);
        Long epochValue = System.currentTimeMillis();
        UserLogs userLogs = new UserLogs();
        userLogs.setUsername(loggedInUser);
        userLogs.setMethod(requestMethod);
        userLogs.setUrl(url);
        userLogs.setClientIp(clientIp);
        userLogs.setIpHolder(ipHolder);
        userLogs.setChangeEpoch(epochValue);
        try {
            this.userLogsStoreService.saveUserLogs(userLogs);
        }
        catch (Exception ex) {
            logger.error("Error while creating user logs ", (Throwable)ex);
        }
        logger.info("URL {} method {}", (Object)url, (Object)requestMethod);
        return true;
    }
}

