/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.archiving.billingCdrHistorical.model;

import com.coraltele.service.archiving.billingCdrHistorical.model.RestoreResult;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class RestoreResult {
    private String ipAddress;
    private int port;
    private boolean connectionSuccess;
    private String connectionError;
    private long startTime;
    private long endTime;
    private int totalTables;
    private int successCount;
    private int failureCount;
    private int skippedCount;
    private List<TableRestoreResult> tableResults = new ArrayList();
    private List<String> errors = new ArrayList();

    public RestoreResult(String ipAddress, int port) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.startTime = System.currentTimeMillis();
    }

    public void addTableResult(TableRestoreResult result) {
        this.tableResults.add(result);
        if (result.isSuccess()) {
            ++this.successCount;
        } else {
            ++this.failureCount;
        }
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public void markComplete() {
        this.endTime = System.currentTimeMillis();
    }

    public long getDurationMs() {
        return this.endTime - this.startTime;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public boolean isConnectionSuccess() {
        return this.connectionSuccess;
    }

    @Generated
    public String getConnectionError() {
        return this.connectionError;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public int getTotalTables() {
        return this.totalTables;
    }

    @Generated
    public int getSuccessCount() {
        return this.successCount;
    }

    @Generated
    public int getFailureCount() {
        return this.failureCount;
    }

    @Generated
    public int getSkippedCount() {
        return this.skippedCount;
    }

    @Generated
    public List<TableRestoreResult> getTableResults() {
        return this.tableResults;
    }

    @Generated
    public List<String> getErrors() {
        return this.errors;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setConnectionSuccess(boolean connectionSuccess) {
        this.connectionSuccess = connectionSuccess;
    }

    @Generated
    public void setConnectionError(String connectionError) {
        this.connectionError = connectionError;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setTotalTables(int totalTables) {
        this.totalTables = totalTables;
    }

    @Generated
    public void setSuccessCount(int successCount) {
        this.successCount = successCount;
    }

    @Generated
    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    @Generated
    public void setSkippedCount(int skippedCount) {
        this.skippedCount = skippedCount;
    }

    @Generated
    public void setTableResults(List<TableRestoreResult> tableResults) {
        this.tableResults = tableResults;
    }

    @Generated
    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestoreResult)) {
            return false;
        }
        RestoreResult other = (RestoreResult)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isConnectionSuccess() != other.isConnectionSuccess()) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getEndTime() != other.getEndTime()) {
            return false;
        }
        if (this.getTotalTables() != other.getTotalTables()) {
            return false;
        }
        if (this.getSuccessCount() != other.getSuccessCount()) {
            return false;
        }
        if (this.getFailureCount() != other.getFailureCount()) {
            return false;
        }
        if (this.getSkippedCount() != other.getSkippedCount()) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$connectionError = this.getConnectionError();
        String other$connectionError = other.getConnectionError();
        if (this$connectionError == null ? other$connectionError != null : !this$connectionError.equals(other$connectionError)) {
            return false;
        }
        List this$tableResults = this.getTableResults();
        List other$tableResults = other.getTableResults();
        if (this$tableResults == null ? other$tableResults != null : !((Object)this$tableResults).equals(other$tableResults)) {
            return false;
        }
        List this$errors = this.getErrors();
        List other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RestoreResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isConnectionSuccess() ? 79 : 97);
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $endTime = this.getEndTime();
        result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
        result = result * 59 + this.getTotalTables();
        result = result * 59 + this.getSuccessCount();
        result = result * 59 + this.getFailureCount();
        result = result * 59 + this.getSkippedCount();
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $connectionError = this.getConnectionError();
        result = result * 59 + ($connectionError == null ? 43 : $connectionError.hashCode());
        List $tableResults = this.getTableResults();
        result = result * 59 + ($tableResults == null ? 43 : ((Object)$tableResults).hashCode());
        List $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RestoreResult(ipAddress=" + this.getIpAddress() + ", port=" + this.getPort() + ", connectionSuccess=" + this.isConnectionSuccess() + ", connectionError=" + this.getConnectionError() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", totalTables=" + this.getTotalTables() + ", successCount=" + this.getSuccessCount() + ", failureCount=" + this.getFailureCount() + ", skippedCount=" + this.getSkippedCount() + ", tableResults=" + this.getTableResults() + ", errors=" + this.getErrors() + ")";
    }
}

