/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.users.main.entity;

import com.coraltele.helper.UuidUpdatable;
import com.coraltele.helper.UuidUpdateListener;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDateTime;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="autologinhistory")
@EntityListeners(value={UuidUpdateListener.class})
public class AutoLogHistory
implements UuidUpdatable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @Column(name="application", columnDefinition="TEXT")
    private String application;
    @Column(name="uuid", columnDefinition="TEXT")
    private String uuid;
    @Column(name="ipaddress", columnDefinition="TEXT")
    private String ipAddress;
    @Column(name="requesturl", columnDefinition="TEXT")
    private String requestUrl;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Column(name="logindate", columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP", nullable=true)
    private LocalDateTime loginDate;
    @Column(name="userid", columnDefinition="TEXT")
    private String userId;
    @Column(name="useraction", columnDefinition="TEXT")
    private String userAction;
    @Column(name="useractiontime")
    private LocalDateTime userActionTime;
    @Column(name="requeststatus", columnDefinition="TEXT")
    private String requestStatus;
    @Column(name="session", columnDefinition="TEXT")
    private String session;

    @PrePersist
    public void generateUniqueId() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
    }

    @Generated
    public AutoLogHistory() {
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public String getRequestUrl() {
        return this.requestUrl;
    }

    @Generated
    public LocalDateTime getLoginDate() {
        return this.loginDate;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getUserAction() {
        return this.userAction;
    }

    @Generated
    public LocalDateTime getUserActionTime() {
        return this.userActionTime;
    }

    @Generated
    public String getRequestStatus() {
        return this.requestStatus;
    }

    @Generated
    public String getSession() {
        return this.session;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setApplication(String application) {
        this.application = application;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setLoginDate(LocalDateTime loginDate) {
        this.loginDate = loginDate;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setUserAction(String userAction) {
        this.userAction = userAction;
    }

    @Generated
    public void setUserActionTime(LocalDateTime userActionTime) {
        this.userActionTime = userActionTime;
    }

    @Generated
    public void setRequestStatus(String requestStatus) {
        this.requestStatus = requestStatus;
    }

    @Generated
    public void setSession(String session) {
        this.session = session;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoLogHistory)) {
            return false;
        }
        AutoLogHistory other = (AutoLogHistory)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$requestUrl = this.getRequestUrl();
        String other$requestUrl = other.getRequestUrl();
        if (this$requestUrl == null ? other$requestUrl != null : !this$requestUrl.equals(other$requestUrl)) {
            return false;
        }
        LocalDateTime this$loginDate = this.getLoginDate();
        LocalDateTime other$loginDate = other.getLoginDate();
        if (this$loginDate == null ? other$loginDate != null : !((Object)this$loginDate).equals(other$loginDate)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userAction = this.getUserAction();
        String other$userAction = other.getUserAction();
        if (this$userAction == null ? other$userAction != null : !this$userAction.equals(other$userAction)) {
            return false;
        }
        LocalDateTime this$userActionTime = this.getUserActionTime();
        LocalDateTime other$userActionTime = other.getUserActionTime();
        if (this$userActionTime == null ? other$userActionTime != null : !((Object)this$userActionTime).equals(other$userActionTime)) {
            return false;
        }
        String this$requestStatus = this.getRequestStatus();
        String other$requestStatus = other.getRequestStatus();
        if (this$requestStatus == null ? other$requestStatus != null : !this$requestStatus.equals(other$requestStatus)) {
            return false;
        }
        String this$session = this.getSession();
        String other$session = other.getSession();
        return !(this$session == null ? other$session != null : !this$session.equals(other$session));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AutoLogHistory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $requestUrl = this.getRequestUrl();
        result = result * 59 + ($requestUrl == null ? 43 : $requestUrl.hashCode());
        LocalDateTime $loginDate = this.getLoginDate();
        result = result * 59 + ($loginDate == null ? 43 : ((Object)$loginDate).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userAction = this.getUserAction();
        result = result * 59 + ($userAction == null ? 43 : $userAction.hashCode());
        LocalDateTime $userActionTime = this.getUserActionTime();
        result = result * 59 + ($userActionTime == null ? 43 : ((Object)$userActionTime).hashCode());
        String $requestStatus = this.getRequestStatus();
        result = result * 59 + ($requestStatus == null ? 43 : $requestStatus.hashCode());
        String $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : $session.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AutoLogHistory(id=" + this.getId() + ", application=" + this.getApplication() + ", uuid=" + this.getUuid() + ", ipAddress=" + this.getIpAddress() + ", requestUrl=" + this.getRequestUrl() + ", loginDate=" + this.getLoginDate() + ", userId=" + this.getUserId() + ", userAction=" + this.getUserAction() + ", userActionTime=" + this.getUserActionTime() + ", requestStatus=" + this.getRequestStatus() + ", session=" + this.getSession() + ")";
    }
}

