/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.config;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"com.coraltele.db.billing.main.repository", "com.coraltele.db.billing.log.repository"}, entityManagerFactoryRef="billingEntityManagerFactory", transactionManagerRef="billingTransactionManager")
public class BillingDataSourceConfiguration {
    private static final Logger logger = LogManager.getLogger(BillingDataSourceConfiguration.class);
    @Autowired
    private Environment environment;

    @Bean
    @ConfigurationProperties(value="spring.datasource.billing")
    public DataSource billingDataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name={"billingEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean billingEntityManagerFactory() {
        String activeProfile = this.environment.getProperty("spring.profiles.active");
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(this.billingDataSource());
        em.setPackagesToScan(new String[]{"com.coraltele.db.billing"});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.dialect", "org.hibernate.dialect.PostgreSQL10Dialect");
        properties.put("hibernate.hbm2ddl.auto", "update");
        em.setJpaPropertyMap(properties);
        return em;
    }

    @Bean(name={"billingTransactionManager"})
    public PlatformTransactionManager billingTransactionManager(@Qualifier(value="billingEntityManagerFactory") EntityManagerFactory billingEntityManagerFactory) {
        return new JpaTransactionManager(billingEntityManagerFactory);
    }
}

