/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.passwordConfig.service;

import com.coraltele.db.billing.main.repository.AgentStatusRepository;
import com.coraltele.db.coralapps.main.entity.Agent;
import com.coraltele.db.coralapps.main.entity.Member;
import com.coraltele.db.coralapps.main.repository.AgentRepository;
import com.coraltele.db.coralapps.main.repository.MemberRepository;
import com.coraltele.db.users.main.entity.PasswordConfig;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.PasswordConfigRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.Telephony;
import com.coraltele.service.billing.main.agentStatus.model.AgentStatusModel;
import com.coraltele.service.user.passwordConfig.model.PasswordConfigModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PasswordConfigService {
    private static final Logger logger = LogManager.getLogger(PasswordConfigService.class);
    @Autowired
    PasswordConfigRepository passwordConfigRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    AgentStatusRepository statusRepository;
    @Autowired
    AgentRepository agentRepository;
    @Autowired
    MemberRepository memberRepository;

    public RequestResponse createData(PasswordConfigModel data, Principal principal) {
        logger.debug("Create new PasswordConfig : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            List list = this.passwordConfigRepository.findAll();
            if (!list.isEmpty()) {
                this.passwordConfigRepository.deleteAll((Iterable)list);
            }
            PasswordConfig passwordConfig = new PasswordConfig();
            passwordConfig.setAcceptLastPassword(data.getAcceptLastPassword());
            passwordConfig.setCreatedBy(principal.getName());
            passwordConfig.setCreatedOn(LocalDateTime.now());
            passwordConfig.setDefaultPwd(data.getDefaultPwd());
            passwordConfig.setExpiredCredential(data.getExpiredCredential());
            passwordConfig.setIdealTimeout(data.getIdealTimeout());
            passwordConfig.setLastLogin(data.getLastLogin());
            passwordConfig.setMaxAttempt(data.getMaxAttempt());
            passwordConfig.setPwdChangeHistory(data.getPwdChangeHistory());
            passwordConfig.setPwdChangeNotice(data.getPwdChangeNotice());
            passwordConfig.setPwdComplication(data.getPwdComplication());
            passwordConfig.setSingleLogin(data.getSingleLogin());
            this.passwordConfigRepository.save((Object)passwordConfig);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("PasswordConfig Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create PasswordConfig");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = this.passwordConfigRepository.findAll();
        ArrayList<PasswordConfigModel> addValue = new ArrayList<PasswordConfigModel>();
        RequestResponse returnValue = new RequestResponse();
        for (PasswordConfig passwordConfig : list) {
            PasswordConfigModel data = new PasswordConfigModel();
            data.setAcceptLastPassword(passwordConfig.getAcceptLastPassword());
            data.setCreatedBy(passwordConfig.getCreatedBy());
            data.setCreatedOn(passwordConfig.getCreatedOn());
            data.setDefaultPwd(passwordConfig.getDefaultPwd());
            data.setExpiredCredential(passwordConfig.getExpiredCredential());
            data.setId(passwordConfig.getId());
            data.setIdealTimeout(passwordConfig.getIdealTimeout());
            data.setLastLogin(passwordConfig.getLastLogin());
            data.setMaxAttempt(passwordConfig.getMaxAttempt());
            data.setPwdChangeHistory(passwordConfig.getPwdChangeHistory());
            data.setPwdChangeNotice(passwordConfig.getPwdChangeNotice());
            data.setPwdComplication(passwordConfig.getPwdComplication());
            data.setSingleLogin(passwordConfig.getSingleLogin());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateLogout(AgentStatusModel data) {
        logger.debug("update logout : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            for (Integer row : data.getId()) {
                List memberList;
                Optional userInfo = this.userRepository.findById((Object)row);
                if (!userInfo.isPresent()) continue;
                ((User)userInfo.get()).setStatus("Logout");
                ((User)userInfo.get()).setIpAddress("");
                String contactNo = ((User)userInfo.get()).getContactNo();
                Optional agentOptional = this.agentRepository.findByName(contactNo);
                if (agentOptional.isPresent()) {
                    ((Agent)agentOptional.get()).setStatus("Logged Out");
                    this.agentRepository.save(agentOptional.get());
                } else {
                    Optional agentNameOptional = this.agentRepository.findByName(((User)userInfo.get()).getUsername());
                    if (agentNameOptional.isPresent()) {
                        ((Agent)agentNameOptional.get()).setStatus("Logged Out");
                        this.agentRepository.save(agentNameOptional.get());
                    }
                }
                if (contactNo != null && !(memberList = this.memberRepository.findByServingAgentAndState(contactNo, "Answered")).isEmpty()) {
                    for (Member member : memberList) {
                        String sessionUuid = member.getSessionUuid();
                        logger.info("uuid to kill:{}", (Object)sessionUuid);
                        String command = String.format("fs_cli -x \"uuid_kill %s\"", sessionUuid);
                        logger.info("command to kill uuid :{}", (Object)command);
                        Telephony.makeCallBackCall((String)command);
                    }
                }
                this.userRepository.save(userInfo.get());
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Logout Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Logout");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    private long getEpochSeconds(LocalDateTime localDateTime) {
        return localDateTime.toEpochSecond(ZoneOffset.UTC);
    }
}

