/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.userZone.service;

import com.coraltele.db.telemetry.main.entity.UserZone;
import com.coraltele.db.telemetry.main.repository.UserZoneRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.service.telemetry.main.userZone.model.UserZoneModel;
import com.coraltele.service.user.service.UserService;
import com.coraltele.service.user.userGroupMaster.model.CoordinateModel;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserZoneService {
    private static final Logger logger = LogManager.getLogger(UserZoneService.class);
    @Autowired
    UserZoneRepository userZoneRepository;
    @Autowired
    UserService userService;

    public RequestResponse createData(UserZoneModel data) {
        logger.debug("Create new UserZone : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            UserZone userZone = new UserZone();
            userZone.setCode(data.getCode());
            userZone.setDescription(data.getDescription());
            userZone.setNorthEastX(data.getNorthEastX());
            userZone.setNorthEastY(data.getNorthEastY());
            userZone.setSouthWestX(data.getSouthWestX());
            userZone.setSouthWestY(data.getSouthWestY());
            this.userZoneRepository.save((Object)userZone);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("UserZone Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create UserZone");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(UserZoneModel data) {
        logger.debug("Update UserZone {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional userZone = this.userZoneRepository.findById((Object)data.getId());
        if (!userZone.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("UserZone Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCode() != null) {
            ((UserZone)userZone.get()).setCode(data.getCode());
        }
        if (data.getDescription() != null) {
            ((UserZone)userZone.get()).setDescription(data.getDescription());
        }
        if (data.getNorthEastX() != null) {
            ((UserZone)userZone.get()).setNorthEastX(data.getNorthEastX());
        }
        if (data.getNorthEastY() != null) {
            ((UserZone)userZone.get()).setNorthEastY(data.getNorthEastY());
        }
        if (data.getSouthWestX() != null) {
            ((UserZone)userZone.get()).setSouthWestX(data.getSouthWestX());
        }
        if (data.getSouthWestY() != null) {
            ((UserZone)userZone.get()).setSouthWestY(data.getSouthWestY());
        }
        this.userZoneRepository.save(userZone.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("UserZone Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteUserZoneById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional userZone = this.userZoneRepository.findById((Object)ids);
            if (userZone.isPresent()) {
                addValue.add(userZone.get());
                this.userZoneRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll(Principal principal) {
        List list = (List)this.userZoneRepository.findAll();
        ArrayList<UserZoneModel> addValue = new ArrayList<UserZoneModel>();
        RequestResponse returnValue = new RequestResponse();
        boolean isDispatcher = this.userService.checkRoleDispatcher(principal.getName());
        List zoneId = new ArrayList();
        if (isDispatcher) {
            zoneId = this.userService.getAssignedZone(principal.getName());
        }
        for (UserZone userZone : list) {
            if (isDispatcher && !zoneId.contains(userZone.getId())) continue;
            UserZoneModel data = new UserZoneModel();
            data.setCode(userZone.getType());
            data.setDescription(userZone.getName());
            data.setId(userZone.getId());
            data.setNorthEastX(userZone.getNorthEastX());
            data.setNorthEastY(userZone.getNorthEastY());
            data.setSouthWestX(userZone.getSouthWestX());
            data.setSouthWestY(userZone.getSouthWestY());
            data.setName(userZone.getName());
            data.setShapeId(userZone.getType());
            if (userZone.getCoordinate() != null) {
                ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
                for (Coordinate coordinate : userZone.getCoordinate().getCoordinates()) {
                    CoordinateModel coordModel = new CoordinateModel();
                    coordModel.setLat(String.valueOf(coordinate.x));
                    coordModel.setLng(String.valueOf(coordinate.y));
                    coordinateModels.add(coordModel);
                }
                data.setCoordinates(coordinateModels);
            }
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public UserZone getZoneData(Integer id) {
        Optional zone = this.userZoneRepository.findById((Object)id);
        if (zone.isPresent()) {
            return (UserZone)zone.get();
        }
        return null;
    }
}

