/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.userWidget.iframe.service;

import com.coraltele.db.telemetry.coralnms.entity.WidgetType;
import com.coraltele.db.telemetry.coralnms.repository.WidgetTypeRepository;
import com.coraltele.db.telemetry.main.entity.UserWidget;
import com.coraltele.db.telemetry.main.repository.IframeViewRepository;
import com.coraltele.db.telemetry.main.repository.UserWidgetRepository;
import com.coraltele.db.telemetry.main.specification.IframeViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.userWidget.iframe.model.IframeModel;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class IframeService {
    private static final Logger logger = LogManager.getLogger(IframeService.class);
    @Autowired
    UserWidgetRepository userWidgetRepository;
    @Autowired
    WidgetTypeRepository widgetTypeRepository;
    @Autowired
    IframeViewRepository iframeViewRepository;

    public RequestResponse createData(IframeModel data, Principal principal) {
        logger.debug("Create New Iframe : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            UserWidget userWidget = new UserWidget();
            Optional widgetType = this.widgetTypeRepository.findById(Integer.valueOf(10));
            if (widgetType.isPresent()) {
                userWidget.setApiURL(data.getApiURL());
                userWidget.setChartType(data.getChartType());
                userWidget.setName(data.getName());
                userWidget.setRefreshInterval(data.getRefreshInterval());
                userWidget.setCode(data.getCode());
                userWidget.setWidgetType((WidgetType)widgetType.get());
                userWidget.setUuid(UUID.randomUUID().toString());
                userWidget.setCreatedBy(principal.getName());
                userWidget.setCreatedOn(LocalDateTime.now());
                userWidget.setDashboardLayout(data.getDashboardLayout());
                this.userWidgetRepository.save((Object)userWidget);
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Not Found");
                returnValue.setMessageDetail("Iframe Not Found");
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Iframe created successfully");
            returnValue.setData((Object)userWidget.getUuid());
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create Iframe");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(IframeModel data) {
        logger.debug("Update Iframe {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional userWidget = this.userWidgetRepository.findById((Object)data.getId());
        if (!userWidget.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not found");
            returnValue.setMessageDetail("Iframe Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCode() != null) {
            ((UserWidget)userWidget.get()).setCode(data.getCode());
        }
        if (data.getApiURL() != null) {
            ((UserWidget)userWidget.get()).setApiURL(data.getApiURL());
        }
        if (data.getChartType() != null) {
            ((UserWidget)userWidget.get()).setChartType(data.getChartType());
        }
        if (data.getName() != null) {
            ((UserWidget)userWidget.get()).setName(data.getName());
        }
        if (data.getRefreshInterval() != null) {
            ((UserWidget)userWidget.get()).setRefreshInterval(data.getRefreshInterval());
        }
        if (data.getDashboardLayout() != null) {
            ((UserWidget)userWidget.get()).setDashboardLayout(data.getDashboardLayout());
        }
        this.userWidgetRepository.save(userWidget.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Iframe Updated Successfully");
        returnValue.setData((Object)((UserWidget)userWidget.get()).getUuid());
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteIframeById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional userWidget = this.userWidgetRepository.findById((Object)ids);
            if (userWidget.isPresent()) {
                addValue.add(userWidget.get());
                this.userWidgetRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllIframeByFilter(SearchRequest searchRequestData, String currentUser) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = IframeViewSpecification.generateFilters((SearchRequest)searchRequestData, (String)currentUser);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.iframeViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.iframeViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

