/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.task.service;

import com.coraltele.db.telemetry.main.entity.Task;
import com.coraltele.db.telemetry.main.entity.TaskDetails;
import com.coraltele.db.telemetry.main.repository.TaskDetailsRepository;
import com.coraltele.db.telemetry.main.repository.TaskRepository;
import com.coraltele.db.telemetry.main.specification.TaskSpecification;
import com.coraltele.db.telemetry.main.specification.TaskStatusSpecification;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.entity.UserGroup;
import com.coraltele.db.users.main.entity.UserGroupMaster;
import com.coraltele.db.users.main.repository.UserGroupMasterRepository;
import com.coraltele.db.users.main.repository.UserGroupRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.EventNotifyModel;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.task.model.TaskCreateModel;
import com.coraltele.service.telemetry.main.task.model.TaskModel;
import com.coraltele.service.user.service.UserService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TaskService {
    private static final Logger logger = LogManager.getLogger(TaskService.class);
    private static final String UPLOAD_DIR = "/usr/local/freeswitch/sounds/tasks/";
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private TaskDetailsRepository taskDetailsRepository;
    @Autowired
    UserService userService;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    UserGroupMasterRepository userGroupMasterRepository;
    @Autowired
    UserRepository userRepository;

    private String userInGroup(Principal principal) {
        Optional optionalUser = this.userRepository.findByUsername(principal.getName());
        List optionalUserGroup = this.userGroupRepository.findByUsers(Long.valueOf(((User)optionalUser.get()).getId().longValue()));
        Integer groupId = ((UserGroup)optionalUserGroup.get(0)).getGroup().intValue();
        Optional optionalUserGroupMasters = this.userGroupMasterRepository.findById((Object)groupId);
        return ((UserGroupMaster)optionalUserGroupMasters.get()).getCode();
    }

    public RequestResponse getAllTasks(Principal principal) {
        List list = (List)this.taskRepository.findAll();
        ArrayList<TaskModel> taskModels = new ArrayList<TaskModel>();
        RequestResponse returnValue = new RequestResponse();
        String loggedInUser = principal.getName();
        boolean adminUser = this.userService.checkAdminUser(loggedInUser);
        boolean dispatcher = this.userService.checkRoleDispatcher(loggedInUser);
        boolean teamLeaderUser = this.userService.checkRoleTaskManager(loggedInUser);
        for (Task task : list) {
            boolean includeTask = false;
            if (adminUser || dispatcher) {
                includeTask = true;
            } else if (teamLeaderUser) {
                includeTask = loggedInUser.equals(task.getReviewer());
            } else if (task.getAssignedUser() != null) {
                includeTask = loggedInUser.equals(task.getAssignedUser());
            } else if (task.getAssignedGroup() != null) {
                includeTask = task.getAssignedGroup().equals(this.userInGroup(principal));
            }
            if (!includeTask) continue;
            TaskModel model = new TaskModel();
            model.setId(task.getId());
            model.setTasksName(task.getTasksName());
            model.setTaskDescription(task.getTaskDescription());
            model.setTaskType(task.getTaskType());
            model.setTaskPriority(task.getTaskPriority());
            model.setAssignedTo(task.getAssignedTo());
            if (task.getExpectedCompletionDate() != null) {
                model.setExpectedCompletionDate(DateFormatUtility.epochToLocalDateTime((Long)task.getExpectedCompletionDate()));
            }
            model.setAssignedGroup(task.getAssignedGroup());
            model.setAssignedUser(task.getAssignedUser());
            model.setAssignedUserDesignation(this.userService.getDesignationByUsername(task.getAssignedUser()));
            if (task.getAssignedOn() != null) {
                model.setAssignedOn(DateFormatUtility.epochToLocalDateTime((Long)task.getAssignedOn()));
            }
            model.setReviewer(task.getReviewer());
            model.setReviewerDesignation(this.userService.getDesignationByUsername(task.getReviewer()));
            model.setCurrentStats(task.getCurrentStats());
            model.setIsTaskCompleted(task.getIsTaskCompleted());
            if (task.getTaskCompletedOn() != null) {
                model.setTaskCompletedOn(DateFormatUtility.epochToLocalDateTime((Long)task.getTaskCompletedOn()));
            }
            model.setCreatedBy(task.getCreatedBy());
            model.setCreatedByDesignation(this.userService.getDesignationByUsername(task.getCreatedBy()));
            if (task.getCreatedOn() != null) {
                model.setCreatedOn(DateFormatUtility.epochToLocalDateTime((Long)task.getCreatedOn()));
            }
            model.setUpdatedBy(task.getUpdatedBy());
            model.setUpdatedByDesignation(this.userService.getDesignationByUsername(task.getUpdatedBy()));
            if (task.getUpdatedOn() != null) {
                model.setUpdatedOn(DateFormatUtility.epochToLocalDateTime((Long)task.getUpdatedOn()));
            }
            model.setFilePath(task.getFilePath());
            taskModels.add(model);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(taskModels);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public EventNotifyModel sendTaskEvents(String assignedUser, String status, Principal principal) {
        EventNotifyModel eventData = new EventNotifyModel();
        long epoch = System.currentTimeMillis() / 1000L;
        eventData.setReadByUser(Boolean.valueOf(false));
        if (status.equalsIgnoreCase("New")) {
            eventData.setEventData((Object)"Task-created");
            eventData.setEventId(Constants.EventStatus.TASK_CREATE_EVENT);
            eventData.setEventMessage("New task is created");
            eventData.setEventSeverity(Integer.valueOf(0));
        } else if (status.equalsIgnoreCase("Closed")) {
            eventData.setEventData((Object)"Task-closed");
            eventData.setEventId(Constants.EventStatus.TASK_CLOSED_EVENT);
            eventData.setEventMessage("Task is closed");
            eventData.setEventSeverity(Integer.valueOf(0));
        } else if (status.equalsIgnoreCase("Urgent")) {
            eventData.setEventData((Object)"This Task requires immediate attention as it is urgent");
            eventData.setEventMessage("task is in priority");
            eventData.setEventId(Constants.EventStatus.TASK_URGENT_EVENT);
            eventData.setEventSeverity(Integer.valueOf(2));
        } else if (status.equalsIgnoreCase("In progress")) {
            eventData.setEventData((Object)"Task is in-progress");
            eventData.setEventMessage("Task is inProgress");
            eventData.setEventId(Constants.EventStatus.TASK_IN_PROGRESS_EVENT);
            eventData.setEventSeverity(Integer.valueOf(1));
        } else {
            eventData.setEventData((Object)"Updated");
            eventData.setEventMessage("Task-Updated");
            eventData.setEventId(Constants.EventStatus.TASK_UPDATE_EVENT);
            eventData.setEventSeverity(Integer.valueOf(0));
        }
        eventData.setEventUUID(UUID.randomUUID().toString());
        eventData.setEventEpoch(Long.valueOf(epoch));
        eventData.setEventSource(principal.getName());
        eventData.setEventDestination(assignedUser);
        return eventData;
    }

    private void sendNotificationToUserAndReviewer(TaskCreateModel data, Principal principal, String assignedUser, String reviewer) {
        if (StringUtils.hasLength((String)assignedUser)) {
            logger.info("Sending notification to assigned user: {}", (Object)assignedUser);
            this.userService.sendNotifyToSubscriber(this.sendTaskEvents(assignedUser, data.getCurrentStats(), principal));
        }
        if (StringUtils.hasLength((String)reviewer)) {
            logger.info("Sending notification to reviewer: {}", (Object)reviewer);
            this.userService.sendNotifyToSubscriber(this.sendTaskEvents(reviewer, data.getCurrentStats(), principal));
        }
    }

    private void sendNotificationToUserAdminAndReviewer(TaskCreateModel data, Principal principal, String assignedUser, String reviewer) {
        if (StringUtils.hasLength((String)assignedUser)) {
            logger.info("Sending notification to assigned user: {}", (Object)assignedUser);
            this.userService.sendNotifyToSubscriber(this.sendTaskEvents(assignedUser, data.getCurrentStats(), principal));
        }
        logger.info("Sending notification to admin: admin");
        this.userService.sendNotifyToSubscriber(this.sendTaskEvents("admin", data.getCurrentStats(), principal));
        if (StringUtils.hasLength((String)reviewer)) {
            logger.info("Sending notification to reviewer: {}", (Object)reviewer);
            this.userService.sendNotifyToSubscriber(this.sendTaskEvents(reviewer, data.getCurrentStats(), principal));
        }
    }

    private void sendNotificationToAdminAndReviewer(TaskCreateModel data, Principal principal, String assignedUser, String reviewer) {
        if (StringUtils.hasLength((String)reviewer)) {
            logger.info("Sending notification to reviewer: {}", (Object)reviewer);
            this.userService.sendNotifyToSubscriber(this.sendTaskEvents(reviewer, data.getCurrentStats(), principal));
        }
        logger.info("Sending notification to admin: admin");
        this.userService.sendNotifyToSubscriber(this.sendTaskEvents("admin", data.getCurrentStats(), principal));
    }

    public RequestResponse createTask(TaskCreateModel data, Principal principal) {
        logger.debug("Creating new task: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Task task = new Task();
            this.setCommonTaskFields(task, data, principal);
            this.taskRepository.save((Object)task);
            boolean adminUser = this.userService.checkAdminUser(principal.getName());
            boolean reviewer = this.userService.checkRoleTaskManager(principal.getName());
            if (adminUser) {
                List group;
                if (data.getAssignedUser() != null) {
                    this.sendNotificationToUserAndReviewer(data, principal, data.getAssignedUser(), data.getReviewer());
                } else if (data.getAssignedGroup() != null && !(group = this.userGroupMasterRepository.findByCode(data.getAssignedGroup())).isEmpty()) {
                    List list = this.userGroupRepository.findByGroup(Long.valueOf(((UserGroupMaster)group.get(0)).getId().longValue()));
                    for (UserGroup userGroup : list) {
                        User assignedUser = this.userRepository.findById(userGroup.getUsers().intValue()).orElse(null);
                        if (assignedUser == null) continue;
                        this.sendNotificationToUserAndReviewer(data, principal, assignedUser.getUsername(), data.getReviewer());
                    }
                }
            } else if (reviewer) {
                List group;
                if (data.getAssignedUser() != null) {
                    this.sendNotificationToUserAdminAndReviewer(data, principal, data.getAssignedUser(), data.getReviewer());
                } else if (data.getAssignedGroup() != null && !(group = this.userGroupMasterRepository.findByCode(data.getAssignedGroup())).isEmpty()) {
                    List list = this.userGroupRepository.findByGroup(Long.valueOf(((UserGroupMaster)group.get(0)).getId().longValue()));
                    for (UserGroup userGroup : list) {
                        User assignedUser = this.userRepository.findById(userGroup.getUsers().intValue()).orElse(null);
                        if (assignedUser == null) continue;
                        this.sendNotificationToUserAdminAndReviewer(data, principal, assignedUser.getUsername(), data.getReviewer());
                    }
                }
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("created successfully");
            returnValue.setMessageDetail("Task created successfully");
            logger.info("Task saved: {}", (Object)returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to create task");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    private void setCommonTaskFields(Task task, TaskCreateModel data, Principal principal) {
        boolean mcxUser = false;
        if (this.userService.checkRoleMCXUser(data.getAssignedUser())) {
            mcxUser = true;
        }
        task.setCreatedOn(Long.valueOf(System.currentTimeMillis() / 1000L));
        task.setCreatedBy(principal.getName());
        if (data.getTasksName() != null) {
            task.setTasksName(data.getTasksName());
        }
        if (data.getTaskDescription() != null) {
            task.setTaskDescription(data.getTaskDescription());
        }
        if (data.getTaskType() != null) {
            task.setTaskType(data.getTaskType());
        }
        if (data.getTaskPriority() != null) {
            task.setTaskPriority(data.getTaskPriority());
        }
        if (data.getAssignedTo() != null) {
            task.setAssignedTo(data.getAssignedTo());
        }
        if (data.getAssignedUser() != null) {
            task.setAssignedUser(data.getAssignedUser());
            if (data.getReviewer() != null) {
                task.setReviewer(data.getReviewer());
            } else {
                Optional userId = this.userRepository.findByUsername(data.getAssignedUser());
                List groupMaster = this.userGroupRepository.findByUsers(Long.valueOf(((User)userId.get()).getId().longValue()));
                if (!groupMaster.isEmpty()) {
                    Optional groupMOptional = this.userGroupMasterRepository.findById((Object)((UserGroup)groupMaster.get(0)).getId());
                    if (groupMOptional.isPresent()) {
                        task.setReviewer(((UserGroupMaster)groupMOptional.get()).getGroupOwner());
                    } else {
                        task.setReviewer(principal.getName());
                    }
                } else {
                    task.setReviewer(principal.getName());
                }
            }
        }
        if (data.getExpectedCompletionDate() != null) {
            task.setExpectedCompletionDate(DateFormatUtility.localDateTimeToEpoch((LocalDateTime)data.getExpectedCompletionDate()));
        }
        if (data.getAssignedGroup() != null) {
            task.setAssignedGroup(data.getAssignedGroup());
            List group = this.userGroupMasterRepository.findByCode(data.getAssignedGroup());
            if (StringUtils.hasLength((String)((UserGroupMaster)group.get(0)).getGroupOwner())) {
                task.setReviewer(((UserGroupMaster)group.get(0)).getGroupOwner());
            } else {
                task.setReviewer("");
            }
        }
        if (data.getAssignedOn() != null) {
            task.setAssignedOn(DateFormatUtility.localDateTimeToEpoch((LocalDateTime)data.getAssignedOn()));
        }
        task.setCurrentStats(data.getCurrentStats());
        if (data.getIsTaskCompleted() != null) {
            task.setIsTaskCompleted(data.getIsTaskCompleted());
        } else {
            task.setIsTaskCompleted(Boolean.valueOf(false));
        }
        if (data.getFilePath() != null) {
            task.setFilePath(data.getFilePath());
        }
        if (data.getChangedCompletionOn() != null) {
            task.setChangedCompletionOn(DateFormatUtility.localDateTimeToEpoch((LocalDateTime)data.getChangedCompletionOn()));
        }
        if (data.getTaskCompletedOn() != null) {
            task.setTaskCompletedOn(DateFormatUtility.localDateTimeToEpoch((LocalDateTime)data.getTaskCompletedOn()));
        }
    }

    public RequestResponse updateTask(TaskCreateModel data, Principal principal) {
        logger.debug("Updating Task: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            List group;
            boolean adminUser = false;
            boolean reviewer = false;
            boolean loggedAssignedUser = false;
            boolean dispatcher = false;
            boolean mcxUser = false;
            if (this.userService.checkAdminUser(principal.getName())) {
                adminUser = true;
            } else if (this.userService.checkRoleTaskManager(principal.getName())) {
                reviewer = true;
            } else if (data.getAssignedUser() == principal.getName()) {
                loggedAssignedUser = true;
            } else if (this.userService.checkRoleDispatcher(principal.getName())) {
                dispatcher = true;
            } else if (this.userService.checkRoleMCXUser(principal.getName())) {
                mcxUser = true;
            }
            Optional task = this.taskRepository.findById((Object)data.getId());
            TaskDetails taskDetails = new TaskDetails();
            if (data.getTaskDescription() != null) {
                ((Task)task.get()).setTaskDescription(data.getTaskDescription());
            }
            if (data.getTaskType() != null) {
                ((Task)task.get()).setTaskType(data.getTaskType());
            }
            if (data.getTaskPriority() != null) {
                ((Task)task.get()).setTaskPriority(data.getTaskPriority());
            }
            if (data.getAssignedTo() != null) {
                ((Task)task.get()).setAssignedTo(data.getAssignedTo());
            }
            if (data.getAssignedUser() != null) {
                ((Task)task.get()).setAssignedUser(data.getAssignedUser());
                if (data.getReviewer() != null) {
                    ((Task)task.get()).setReviewer(data.getReviewer());
                }
            }
            if (adminUser || reviewer || dispatcher) {
                if (data.getCurrentStats().equalsIgnoreCase("completed")) {
                    ((Task)task.get()).setCurrentStats(data.getCurrentStats());
                    ((Task)task.get()).setTaskCompletedOn(Long.valueOf(System.currentTimeMillis() / 1000L));
                    ((Task)task.get()).setIsTaskCompleted(Boolean.valueOf(true));
                } else {
                    ((Task)task.get()).setCurrentStats(data.getCurrentStats());
                }
            } else if (mcxUser) {
                if (principal.getName().equals(((Task)task.get()).getCreatedBy())) {
                    if (data.getCurrentStats().equalsIgnoreCase("closed")) {
                        ((Task)task.get()).setCurrentStats("completed");
                        ((Task)task.get()).setTaskCompletedOn(Long.valueOf(System.currentTimeMillis() / 1000L));
                        ((Task)task.get()).setIsTaskCompleted(Boolean.valueOf(true));
                    } else {
                        ((Task)task.get()).setCurrentStats(data.getCurrentStats());
                    }
                } else {
                    ((Task)task.get()).setCurrentStats(data.getCurrentStats());
                }
            } else if (data.getCurrentStats().equalsIgnoreCase("closed")) {
                ((Task)task.get()).setCurrentStats("pending for approval");
            } else {
                ((Task)task.get()).setCurrentStats(data.getCurrentStats());
            }
            if (data.getAssignedGroup() != null) {
                ((Task)task.get()).setAssignedGroup(data.getAssignedGroup());
                group = this.userGroupMasterRepository.findByCode(data.getAssignedGroup());
                if (StringUtils.hasLength((String)((UserGroupMaster)group.get(0)).getGroupOwner())) {
                    ((Task)task.get()).setReviewer(((UserGroupMaster)group.get(0)).getGroupOwner());
                } else {
                    ((Task)task.get()).setReviewer("");
                }
            }
            if (data.getAssignedOn() != null) {
                ((Task)task.get()).setAssignedOn(DateFormatUtility.localDateTimeToEpoch((LocalDateTime)data.getAssignedOn()));
            }
            if (data.getIsTaskCompleted() != null) {
                ((Task)task.get()).setIsTaskCompleted(data.getIsTaskCompleted());
            }
            if (data.getTaskCompletedOn() != null) {
                ((Task)task.get()).setTaskCompletedOn(DateFormatUtility.localDateTimeToEpoch((LocalDateTime)data.getTaskCompletedOn()));
            }
            if (data.getExpectedCompletionDate() != null) {
                ((Task)task.get()).setExpectedCompletionDate(DateFormatUtility.localDateTimeToEpoch((LocalDateTime)data.getExpectedCompletionDate()));
            }
            if (data.getChangedCompletionOn() != null) {
                ((Task)task.get()).setChangedCompletionOn(DateFormatUtility.localDateTimeToEpoch((LocalDateTime)data.getChangedCompletionOn()));
            }
            ((Task)task.get()).setUpdatedBy(principal.getName());
            ((Task)task.get()).setUpdatedOn(Long.valueOf(System.currentTimeMillis() / 1000L));
            if (data.getFilePath() != null) {
                ((Task)task.get()).setFilePath(data.getFilePath());
            }
            if (data.getCurrentStats().equals("Completed")) {
                ((Task)task.get()).setRemarks("User");
            }
            this.taskRepository.save(task.get());
            taskDetails.setTaskId(((Task)task.get()).getId());
            taskDetails.setStatusUpdatedBy(principal.getName());
            taskDetails.setStatusUpdatedOn(Long.valueOf(System.currentTimeMillis() / 1000L));
            if (data.getIsDelay() != null) {
                if (data.getIsDelay().booleanValue()) {
                    taskDetails.setIsDelay(Boolean.valueOf(true));
                    taskDetails.setChangedCompletionOn(DateFormatUtility.localDateTimeToEpoch((LocalDateTime)data.getChangedCompletionOn()));
                } else {
                    taskDetails.setIsDelay(Boolean.valueOf(false));
                }
            }
            taskDetails.setTaskStats(data.getCurrentStats());
            taskDetails.setRemarks(data.getRemarks());
            this.taskDetailsRepository.save((Object)taskDetails);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Updated successfully");
            returnValue.setMessageDetail("Tasks updated successfully");
            logger.info(returnValue.getMessage());
            if (adminUser) {
                if (data.getAssignedUser() != null) {
                    this.sendNotificationToUserAndReviewer(data, principal, data.getAssignedUser(), data.getReviewer());
                } else if (data.getAssignedGroup() != null && !(group = this.userGroupMasterRepository.findByCode(data.getAssignedGroup())).isEmpty()) {
                    List userGroupList = this.userGroupRepository.findByGroup(Long.valueOf(((UserGroupMaster)group.get(0)).getId().longValue()));
                    for (UserGroup userGroup : userGroupList) {
                        User assignedUser = this.userRepository.findById(userGroup.getUsers().intValue()).orElse(null);
                        if (assignedUser == null) continue;
                        this.sendNotificationToUserAndReviewer(data, principal, assignedUser.getUsername(), data.getReviewer());
                    }
                }
            } else if (reviewer) {
                if (data.getAssignedUser() != null) {
                    this.sendNotificationToUserAdminAndReviewer(data, principal, data.getAssignedUser(), data.getReviewer());
                } else if (data.getAssignedGroup() != null && !(group = this.userGroupMasterRepository.findByCode(data.getAssignedGroup())).isEmpty()) {
                    List userGroupList = this.userGroupRepository.findByGroup(Long.valueOf(((UserGroupMaster)group.get(0)).getId().longValue()));
                    for (UserGroup userGroup : userGroupList) {
                        User assignedUser = this.userRepository.findById(userGroup.getUsers().intValue()).orElse(null);
                        if (assignedUser == null) continue;
                        this.sendNotificationToUserAdminAndReviewer(data, principal, assignedUser.getUsername(), data.getReviewer());
                    }
                }
            } else if (loggedAssignedUser) {
                this.sendNotificationToAdminAndReviewer(data, principal, data.getAssignedUser(), data.getReviewer());
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Updated successfully");
            returnValue.setMessageDetail("Tasks updated successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update task");
            returnValue.setMessageDetail("Please contact the administrator");
            logger.error("Error while updating the task.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getFilterTasks(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        boolean adminUser = false;
        boolean teamLeaderUser = false;
        boolean dispatcher = false;
        if (this.userService.checkAdminUser(principal.getName())) {
            adminUser = true;
        } else if (this.userService.checkRoleDispatcher(principal.getName())) {
            dispatcher = true;
        } else if (this.userService.checkRoleTaskManager(principal.getName())) {
            teamLeaderUser = true;
        }
        Specification filters = TaskSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)dispatcher, (boolean)teamLeaderUser, (UserRepository)this.userRepository, (UserGroupRepository)this.userGroupRepository, (UserGroupMasterRepository)this.userGroupMasterRepository, (TaskRepository)this.taskRepository);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.taskRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.taskRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<TaskModel> entityToModelConversion(List<Task> list) {
        ArrayList<TaskModel> addValue = new ArrayList<TaskModel>();
        for (Task row : list) {
            TaskModel data = new TaskModel();
            List taskDetails = this.taskDetailsRepository.findByTaskIdOrderByIdDesc(row.getId());
            data.setId(row.getId());
            data.setTasksName(row.getTasksName());
            data.setTaskType(row.getTaskType());
            data.setCreatedOn(DateFormatUtility.epochToLocalDateTime((Long)row.getCreatedOn()));
            data.setTaskPriority(row.getTaskPriority());
            data.setTaskDescription(row.getTaskDescription());
            if (row.getAssignedOn() != null) {
                data.setAssignedOn(DateFormatUtility.epochToLocalDateTime((Long)row.getAssignedOn()));
            }
            if (row.getExpectedCompletionDate() != null) {
                data.setExpectedCompletionDate(DateFormatUtility.epochToLocalDateTime((Long)row.getExpectedCompletionDate()));
            }
            if (row.getChangedCompletionOn() != null) {
                data.setChangedCompletionOn(DateFormatUtility.epochToLocalDateTime((Long)row.getChangedCompletionOn()));
            }
            data.setCurrentStats(row.getCurrentStats());
            data.setAssignedGroup(row.getAssignedGroup());
            data.setAssignedUser(row.getAssignedUser());
            data.setAssignedUserDesignation(this.userService.getDesignationByUsername(row.getAssignedUser()));
            if (!taskDetails.isEmpty()) {
                data.setIsDelay(((TaskDetails)taskDetails.get(0)).getIsDelay());
                data.setRemarks(((TaskDetails)taskDetails.get(0)).getRemarks());
            }
            data.setReviewer(row.getReviewer());
            data.setUpdatedBy(row.getUpdatedBy());
            data.setUpdatedByDesignation(this.userService.getDesignationByUsername(row.getUpdatedBy()));
            data.setCreatedBy(row.getCreatedBy());
            data.setCreatedByDesignation(this.userService.getDesignationByUsername(row.getCreatedBy()));
            data.setReviewerDesignation(this.userService.getDesignationByUsername(row.getReviewer()));
            if (row.getTaskCompletedOn() != null) {
                data.setTaskCompletedOn(DateFormatUtility.epochToLocalDateTime((Long)row.getTaskCompletedOn()));
            }
            data.setAssignedTo(row.getAssignedTo());
            data.setFilePath(row.getFilePath());
            data.setIsTaskCompleted(row.getIsTaskCompleted());
            boolean isDelayState = false;
            if (row.getTaskCompletedOn() != null && row.getExpectedCompletionDate() != null) {
                isDelayState = row.getTaskCompletedOn() > row.getExpectedCompletionDate();
            } else if (row.getExpectedCompletionDate() != null) {
                boolean bl = isDelayState = row.getExpectedCompletionDate() < System.currentTimeMillis() / 1000L;
            }
            if (row.getRemarks() != null) {
                data.setTaskClosedBy(row.getRemarks());
            }
            data.setIsDelayState(Boolean.valueOf(isDelayState));
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse deleteTaskById(InputIdModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional task = this.taskRepository.findById((Object)ids);
            if (task.isPresent()) {
                Task task1 = (Task)task.get();
                if (task1.getAssignedUser() != null) {
                    addValue.add(task.get());
                    this.taskRepository.deleteAll(addValue);
                    EventNotifyModel eventData = new EventNotifyModel();
                    long epoch = System.currentTimeMillis() / 1000L;
                    eventData.setReadByUser(Boolean.valueOf(false));
                    eventData.setEventData((Object)("Task is deleted for the User :: " + task1.getAssignedUser()));
                    eventData.setEventId(Constants.EventStatus.TASK_CLOSED_EVENT);
                    eventData.setEventSeverity(Integer.valueOf(1));
                    eventData.setEventUUID(UUID.randomUUID().toString());
                    eventData.setEventMessage("Task deleted");
                    eventData.setEventEpoch(Long.valueOf(epoch));
                    eventData.setEventSource(principal.getName());
                    eventData.setEventDestination(task1.getAssignedUser());
                    this.userService.sendNotifyToSubscriber(eventData);
                    continue;
                }
                if (((Task)task.get()).getAssignedGroup() == null) continue;
                List userGroupMasterList = this.userGroupMasterRepository.findByCode(((Task)task.get()).getAssignedGroup());
                List userGroupList = this.userGroupRepository.findByGroup(Long.valueOf(((UserGroupMaster)userGroupMasterList.get(0)).getId().longValue()));
                ArrayList userList = new ArrayList();
                for (UserGroup userGroup : userGroupList) {
                    Optional userOptional = this.userRepository.findById(userGroup.getUsers().intValue());
                    userOptional.ifPresent(userList::add);
                }
                for (User user : userList) {
                    addValue.add(task.get());
                    this.taskRepository.deleteAll(addValue);
                    EventNotifyModel eventData = new EventNotifyModel();
                    long epoch = System.currentTimeMillis() / 1000L;
                    eventData.setReadByUser(Boolean.valueOf(false));
                    eventData.setEventData((Object)("Task is deleted for the User :: " + user.getUsername()));
                    eventData.setEventId(Constants.EventStatus.TASK_DELETE_EVENT);
                    eventData.setEventSeverity(Integer.valueOf(1));
                    eventData.setEventUUID(UUID.randomUUID().toString());
                    eventData.setEventMessage("Task deleted");
                    eventData.setEventEpoch(Long.valueOf(epoch));
                    eventData.setEventSource(principal.getName());
                    eventData.setEventDestination(user.getUsername());
                    this.userService.sendNotifyToSubscriber(eventData);
                }
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessage("Record Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse saveFile(MultipartFile file) {
        RequestResponse response = new RequestResponse();
        Path destinationPath = Paths.get(UPLOAD_DIR, new String[0]).toAbsolutePath().normalize();
        try {
            if (file.isEmpty()) {
                response.setStatus(Constants.Error.ERROR);
                response.setMessage("Not uploaded");
                response.setMessageDetail("Failed to store empty file.");
                return response;
            }
            Files.createDirectories(destinationPath, new FileAttribute[0]);
            Path filePath = destinationPath.resolve(file.getOriginalFilename());
            if (Files.exists(filePath, new LinkOption[0])) {
                try {
                    Files.delete(filePath);
                }
                catch (IOException deleteException) {
                    response.setStatus(Constants.Error.ERROR);
                    response.setMessage("Failed to delete existing file.");
                    response.setMessageDetail(deleteException.getMessage());
                    return response;
                }
            }
            Files.copy(file.getInputStream(), filePath, StandardCopyOption.REPLACE_EXISTING);
            response.setStatus(Constants.Error.OK);
            response.setMessage("File uploaded successfully.");
            response.setMessageDetail(filePath.toString());
        }
        catch (IOException e) {
            response.setStatus(Constants.Error.ERROR);
            response.setMessage("Could not upload file.");
            response.setMessageDetail(e.getMessage());
        }
        return response;
    }

    public RequestResponse getUserGroupOwnerByUserName(String username) {
        Optional userGroupMasterOptional;
        List userGroupsList;
        RequestResponse returnValue = new RequestResponse();
        TaskModel task = new TaskModel();
        Optional userOptional = this.userRepository.findByUsername(username);
        if (userOptional.isPresent() && !(userGroupsList = this.userGroupRepository.findByUsers(Long.valueOf(((User)userOptional.get()).getId().longValue()))).isEmpty() && (userGroupMasterOptional = this.userGroupMasterRepository.findById((Object)((UserGroup)userGroupsList.get(0)).getGroup().intValue())).isPresent()) {
            task.setReviewer(((UserGroupMaster)userGroupMasterOptional.get()).getGroupOwner());
            returnValue.setData((Object)task);
        }
        return returnValue;
    }

    public RequestResponse getFilterTasksWithStatus(SearchRequest searchRequestData, Principal principal, String status) {
        RequestResponse returnValue = new RequestResponse();
        boolean adminUser = false;
        boolean teamLeaderUser = false;
        boolean dispatcher = false;
        if (this.userService.checkAdminUser(principal.getName())) {
            adminUser = true;
        } else if (this.userService.checkRoleDispatcher(principal.getName())) {
            dispatcher = true;
        } else if (this.userService.checkRoleTaskManager(principal.getName())) {
            teamLeaderUser = true;
        }
        Specification filters = TaskStatusSpecification.generateFilters((SearchRequest)searchRequestData, (String)principal.getName(), (boolean)adminUser, (boolean)dispatcher, (boolean)teamLeaderUser, (UserRepository)this.userRepository, (UserGroupRepository)this.userGroupRepository, (UserGroupMasterRepository)this.userGroupMasterRepository, (TaskRepository)this.taskRepository, (String)status);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "createdOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.taskRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.taskRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getByTaskName(Integer id) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<TaskModel> taskModels = new ArrayList<TaskModel>();
        Optional row = this.taskRepository.findById((Object)id);
        try {
            TaskModel data = new TaskModel();
            data.setId(((Task)row.get()).getId());
            data.setTasksName(((Task)row.get()).getTasksName() != null ? ((Task)row.get()).getTasksName() : "");
            data.setTaskDescription(((Task)row.get()).getTaskDescription() != null ? ((Task)row.get()).getTaskDescription() : "");
            data.setTaskType(((Task)row.get()).getTaskType() != null ? ((Task)row.get()).getTaskType() : "");
            data.setTaskPriority(((Task)row.get()).getTaskPriority() != null ? ((Task)row.get()).getTaskPriority() : "");
            data.setAssignedTo(Integer.valueOf(((Task)row.get()).getAssignedTo() != null ? ((Task)row.get()).getAssignedTo() : 0));
            data.setExpectedCompletionDate(((Task)row.get()).getExpectedCompletionDate() != null ? DateFormatUtility.epochToLocalDateTime((Long)((Task)row.get()).getExpectedCompletionDate()) : null);
            data.setAssignedGroup(((Task)row.get()).getAssignedGroup() != null ? ((Task)row.get()).getAssignedGroup() : "");
            data.setAssignedUser(((Task)row.get()).getAssignedUser() != null ? ((Task)row.get()).getAssignedUser() : "");
            data.setAssignedOn(((Task)row.get()).getAssignedOn() != null ? DateFormatUtility.epochToLocalDateTime((Long)((Task)row.get()).getAssignedOn()) : null);
            data.setReviewer(((Task)row.get()).getReviewer() != null ? ((Task)row.get()).getReviewer() : "");
            data.setCurrentStats(((Task)row.get()).getCurrentStats() != null ? ((Task)row.get()).getCurrentStats() : "");
            data.setIsTaskCompleted(Boolean.valueOf(((Task)row.get()).getIsTaskCompleted() != null ? ((Task)row.get()).getIsTaskCompleted() : false));
            data.setTaskCompletedOn(((Task)row.get()).getTaskCompletedOn() != null ? DateFormatUtility.epochToLocalDateTime((Long)((Task)row.get()).getTaskCompletedOn()) : null);
            data.setCreatedBy(((Task)row.get()).getCreatedBy() != null ? ((Task)row.get()).getCreatedBy() : "");
            data.setCreatedOn(((Task)row.get()).getCreatedOn() != null ? DateFormatUtility.epochToLocalDateTime((Long)((Task)row.get()).getCreatedOn()) : null);
            data.setUpdatedBy(((Task)row.get()).getUpdatedBy() != null ? ((Task)row.get()).getUpdatedBy() : "");
            data.setUpdatedOn(((Task)row.get()).getUpdatedOn() != null ? DateFormatUtility.epochToLocalDateTime((Long)((Task)row.get()).getUpdatedOn()) : null);
            data.setChangedCompletionOn(((Task)row.get()).getChangedCompletionOn() != null ? DateFormatUtility.epochToLocalDateTime((Long)((Task)row.get()).getChangedCompletionOn()) : null);
            data.setFilePath(((Task)row.get()).getFilePath() != null ? ((Task)row.get()).getFilePath() : "");
            taskModels.add(data);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setData(taskModels);
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to get task details");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public String getFilePath(Integer id) {
        Optional list = this.taskRepository.findById((Object)id);
        if (list.isPresent()) {
            return ((Task)list.get()).getFilePath();
        }
        return "Id doesn't exist";
    }
}

