/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.dashboardGroup.service;

import com.coraltele.db.telemetry.main.entity.DashboardGroup;
import com.coraltele.db.telemetry.main.repository.DashboardGroupRepository;
import com.coraltele.db.telemetry.main.specification.DashboardGroupSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.dashboardGroup.model.DashboardGroupModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DashboardGroupService {
    private static final Logger logger = LogManager.getLogger(DashboardGroupService.class);
    @Autowired
    DashboardGroupRepository dashboardGroupRepository;

    public RequestResponse createData(DashboardGroupModel data) {
        logger.debug("Create New DashboardGroup : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            DashboardGroup dashboardGroup = new DashboardGroup();
            dashboardGroup.setCode(data.getCode());
            dashboardGroup.setIcon(data.getIcon());
            dashboardGroup.setName(data.getName());
            this.dashboardGroupRepository.save((Object)dashboardGroup);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("DashboardGroup Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable To Create DashboardGroup");
            returnValue.setMessageDetail("Contact With Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(DashboardGroupModel data) {
        logger.debug("Update DashboardGroup {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional dashboardGroup = this.dashboardGroupRepository.findById((Object)data.getId());
        if (!dashboardGroup.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("DashboardGroup Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getIcon() != null) {
            ((DashboardGroup)dashboardGroup.get()).setIcon(data.getIcon());
        }
        if (data.getCode() != null) {
            ((DashboardGroup)dashboardGroup.get()).setCode(data.getCode());
        }
        if (data.getName() != null) {
            ((DashboardGroup)dashboardGroup.get()).setName(data.getName());
        }
        this.dashboardGroupRepository.save(dashboardGroup.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("DashboardGroup Updated Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (String ids : data.getStringId()) {
            Optional dashboardGroup = this.dashboardGroupRepository.findById((Object)ids);
            if (dashboardGroup.isPresent()) {
                addValue.add(dashboardGroup.get());
                this.dashboardGroupRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = DashboardGroupSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.dashboardGroupRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.dashboardGroupRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.dashboardGroupRepository.findAll();
        ArrayList<DashboardGroupModel> addValue = new ArrayList<DashboardGroupModel>();
        RequestResponse returnValue = new RequestResponse();
        for (DashboardGroup dashboardGroup : list) {
            DashboardGroupModel data = new DashboardGroupModel();
            data.setCode(dashboardGroup.getCode());
            data.setIcon(dashboardGroup.getIcon());
            data.setId(dashboardGroup.getId());
            data.setName(dashboardGroup.getName());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

