/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.billingCDRSummary.controller;

import com.coraltele.db.telemetry.main.entity.BillingCDRSummary;
import com.coraltele.db.telemetry.main.repository.BillingCDRSummaryRepository;
import com.coraltele.db.telemetry.main.specification.BillingCDRSummarySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.telemetry.main.billingCDRSummary.service.BillingCDRSummaryService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/billingCDRSummary"})
public class BillingCDRSummaryController {
    private static final Logger logger = LogManager.getLogger(BillingCDRSummaryController.class);
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    BillingCDRSummaryService billingCDRSummaryService;
    @Autowired
    BillingCDRSummaryRepository billingCDRSummaryRepository;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.billingCDRSummaryService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData) {
        try {
            Object extension;
            logger.info("CSV file download started for Billing-CDR-Summary--");
            Specification filters = BillingCDRSummarySpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "recordEpoch" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "recordEpoch" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.billingCDRSummaryRepository.findAll(filters, sort) : this.billingCDRSummaryRepository.findAll(filters);
            HashMap extensionSums = new HashMap();
            for (BillingCDRSummary item : filteredData) {
                extension = item.getExtension();
                extensionSums.putIfAbsent((String)extension, new HashMap());
                Map sums = (Map)extensionSums.get(extension);
                sums.put("externalDialed", sums.getOrDefault("externalDialed", 0L) + (long)item.getExternalDialed());
                sums.put("externalReceived", sums.getOrDefault("externalReceived", 0L) + (long)item.getExternalReceived());
                sums.put("externalReceivedAnswered", sums.getOrDefault("externalReceivedAnswered", 0L) + (long)item.getExternalReceivedAnswered());
                sums.put("externalReceivedAbandoned", sums.getOrDefault("externalReceivedAbandoned", 0L) + (long)item.getExternalReceivedAbandoned());
                sums.put("internalDialed", sums.getOrDefault("internalDialed", 0L) + (long)item.getInternalDialed());
                sums.put("internalReceived", sums.getOrDefault("internalReceived", 0L) + (long)item.getInternalReceived());
                sums.put("internalReceivedAbandoned", sums.getOrDefault("internalReceivedAbandoned", 0L) + (long)item.getInternalReceivedAbandoned());
                sums.put("internalReceivedAnswered", sums.getOrDefault("internalReceivedAnswered", 0L) + (long)item.getInternalReceivedAnswered());
            }
            StringWriter stringWriter = new StringWriter();
            try {
                CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);
                extension = null;
                try {
                    List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                    csvPrinter.printRecord(displayNames);
                    for (Map.Entry entry : extensionSums.entrySet()) {
                        String extension2 = (String)entry.getKey();
                        Map sums = (Map)entry.getValue();
                        ArrayList<Object> values = new ArrayList<Object>();
                        for (String columnName2 : searchRequestData.getColumnNames()) {
                            if ("extension".equals(columnName2)) {
                                values.add(extension2);
                                continue;
                            }
                            values.add(sums.getOrDefault(columnName2, 0L));
                        }
                        csvPrinter.printRecord(values);
                    }
                }
                catch (Throwable displayNames) {
                    extension = displayNames;
                    throw displayNames;
                }
                finally {
                    if (csvPrinter != null) {
                        if (extension != null) {
                            try {
                                csvPrinter.close();
                            }
                            catch (Throwable displayNames) {
                                ((Throwable)extension).addSuppressed(displayNames);
                            }
                        } else {
                            csvPrinter.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Billing-CDR-Summary", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Billing-CDR-Summary CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    static {
        columnMappings.put("extension", "Extension");
        columnMappings.put("externalDialed", "External Dialed");
        columnMappings.put("externalReceived", "External Received");
        columnMappings.put("externalReceivedAnswered", "External Received Answered");
        columnMappings.put("externalReceivedAbandoned", "External Received Abandoned");
        columnMappings.put("internalDialed", "Internal Dialed");
        columnMappings.put("internalReceived", "Internal Received");
        columnMappings.put("internalReceivedAbandoned", "Internal Received Abandoned");
        columnMappings.put("internalReceivedAnswered", "Internal Received Answered");
    }
}

