/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.ExtensionSummary.service;

import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.db.telemetry.main.repository.BillingCdrCallerSummaryRepository;
import com.coraltele.db.telemetry.main.specification.ExtensionSummaryDetailSpecification;
import com.coraltele.db.telemetry.main.specification.ExtensionSummarySpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.ExtensionSummary.model.CallerSummaryModel;
import com.coraltele.service.telemetry.main.ExtensionSummary.model.ExtensionWiseReportModel;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtensionSummaryService {
    private static final Logger logger = LogManager.getLogger(ExtensionSummaryService.class);
    @Autowired
    ExtensionSummarySpecification ExtensionSummarySpecification;
    @Autowired
    BillingCdrCallerSummaryRepository repository;
    @Autowired
    BillingCDRRepository billingCdrRepository;
    @Autowired
    ExtensionSummaryDetailSpecification extensionSummaryDetailSpecification;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        List list;
        int totalRecords;
        int totalPages;
        RequestResponse returnValue = new RequestResponse();
        int pageNo = searchRequestData.getCurrentPage() != null ? searchRequestData.getCurrentPage() : 0;
        int pageSize = searchRequestData.getPageSize() != null ? searchRequestData.getPageSize() : 10;
        LocalDate fromDate = null;
        LocalDate toDate = null;
        String extension = null;
        String callerId = null;
        String callType = null;
        String search = searchRequestData.getSearch();
        String sortBy = searchRequestData.getSortBy();
        if (search != null && (search = search.trim()).isEmpty()) {
            search = null;
        }
        if (searchRequestData.getAdvancedFilters() != null) {
            for (AdvanceFilter f : searchRequestData.getAdvancedFilters()) {
                if ("date".equalsIgnoreCase(f.getDataType()) && "callDate".equalsIgnoreCase(f.getFieldName())) {
                    if ("from".equalsIgnoreCase(f.getDirection())) {
                        fromDate = this.parseDateSafely(f.getValue());
                    }
                    if ("to".equalsIgnoreCase(f.getDirection())) {
                        toDate = this.parseDateSafely(f.getValue());
                    }
                }
                if (!"extensionNo".equalsIgnoreCase(f.getFieldName())) continue;
                if (f.getValue() != null && !f.getValue().trim().isEmpty()) {
                    extension = f.getValue().trim();
                    continue;
                }
                extension = null;
            }
        }
        if (search != null && sortBy != null) {
            switch (sortBy) {
                case "extensionNo": {
                    extension = search;
                    break;
                }
                case "calledNo": {
                    callerId = search;
                    break;
                }
                case "callType": {
                    callType = search;
                    break;
                }
            }
        }
        if (pageNo >= (totalPages = (int)Math.ceil((double)(totalRecords = (list = this.billingCdrRepository.extensionDetailsIn(fromDate, toDate, extension, callerId, callType)).size()) / (double)pageSize))) {
            pageNo = 0;
        }
        int start = pageNo * pageSize;
        int end = Math.min(start + pageSize, totalRecords);
        List pageData = totalRecords == 0 ? Collections.emptyList() : list.subList(start, end);
        List models = this.entityToModelConversion(pageData);
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage((long)pageNo);
        responseData.setPageSize((long)pageSize);
        responseData.setTotalPages((long)totalPages);
        responseData.setTotalRecords((long)totalRecords);
        responseData.setCurrentPageData((Object)models);
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        returnValue.setStatus(Constants.Error.OK);
        return returnValue;
    }

    private LocalDate parseDateSafely(String v) {
        try {
            if (v == null) {
                return null;
            }
            if ((v = v.trim()).isEmpty()) {
                return null;
            }
            return LocalDate.parse(v);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<ExtensionWiseReportModel> entityToModelConversion(List<Object[]> rows) {
        ArrayList<ExtensionWiseReportModel> result = new ArrayList<ExtensionWiseReportModel>();
        for (Object[] row : rows) {
            ExtensionWiseReportModel m = new ExtensionWiseReportModel();
            m.setExtensionNo(row[0] != null ? row[0].toString() : null);
            m.setCallDate(row[1] != null ? row[1].toString() : null);
            m.setCalledNo(row[2] != null ? row[2].toString() : null);
            m.setCallType(row[3] != null ? row[3].toString() : null);
            m.setTalkDuration(row[4] != null ? DateFormatUtility.findLocalTime((Long)this.toLong(row[4])) : null);
            m.setRingDuration(row[5] != null ? DateFormatUtility.findLocalTime((Long)this.toLong(row[5])) : null);
            m.setCallDirection(row[6] != null ? row[6].toString() : null);
            m.setFeatureCode(row[7] != null ? row[7].toString() : null);
            m.setConnected(row[8] != null ? row[8].toString() : null);
            m.setTransferAgent(row[9] != null ? row[9].toString() : null);
            m.setTransfer(row[10] != null ? row[10].toString() : null);
            result.add(m);
        }
        return result;
    }

    public RequestResponse getCallerSummary(SearchRequest request) {
        List<Object[]> pageRows;
        List allRows;
        long totalRecords;
        String fromDate = null;
        String toDate = null;
        String callerId = null;
        if (request.getAdvancedFilters() != null) {
            for (AdvanceFilter f : request.getAdvancedFilters()) {
                if ("date".equalsIgnoreCase(f.getDataType()) && "callDate".equalsIgnoreCase(f.getFieldName())) {
                    if ("from".equalsIgnoreCase(f.getDirection())) {
                        fromDate = f.getValue();
                    }
                    if ("to".equalsIgnoreCase(f.getDirection())) {
                        toDate = f.getValue();
                    }
                }
                if (!"callerId".equalsIgnoreCase(f.getFieldName())) continue;
                callerId = f.getValue();
            }
        }
        if (callerId != null && callerId.trim().isEmpty()) {
            callerId = null;
        }
        LocalDate from = this.parseDate(fromDate);
        LocalDate to = this.parseDate(toDate);
        int pageSize = request.getPageSize() != null && request.getPageSize() > 0 ? request.getPageSize() : 50;
        int page = request.getCurrentPage() != null && request.getCurrentPage() >= 0 ? request.getCurrentPage() : 0;
        int offset = page * pageSize;
        String search = request.getSearch();
        if (search != null) {
            search = search.trim();
        }
        long l = totalRecords = (allRows = this.billingCdrRepository.getCallerSummary(from, to, callerId, search)) != null ? (long)allRows.size() : 0L;
        if (allRows == null || allRows.isEmpty()) {
            pageRows = Collections.emptyList();
        } else {
            int fromIndex = Math.min(offset, allRows.size());
            int toIndex = Math.min(fromIndex + pageSize, allRows.size());
            pageRows = new ArrayList<Object[]>(allRows.subList(fromIndex, toIndex));
        }
        ArrayList<CallerSummaryModel> result = new ArrayList<CallerSummaryModel>();
        for (Object[] r : pageRows) {
            CallerSummaryModel model = new CallerSummaryModel();
            model.setCallerId((String)r[0]);
            model.setIntercomCall(this.toLong(r[1]));
            model.setIntercomCost(this.formatAmount(this.toLong(r[2])));
            model.setLocalCall(this.toLong(r[3]));
            model.setLocalCost(this.formatAmount(this.toLong(r[4])));
            model.setStdCall(this.toLong(r[5]));
            model.setStdCost(this.formatAmount(this.toLong(r[6])));
            model.setIsdCall(this.toLong(r[7]));
            model.setIsdCost(this.formatAmount(this.toLong(r[8])));
            model.setTotalCall(this.toLong(r[9]));
            model.setTotalCost(this.formatAmount(this.toLong(r[10])));
            result.add(model);
        }
        int totalPages = pageSize == 0 ? 0 : (int)Math.ceil((double)totalRecords / (double)pageSize);
        SearchResponse response = new SearchResponse();
        response.setCurrentPage((long)page);
        response.setPageSize((long)pageSize);
        response.setCurrentPageData(result);
        response.setTotalRecords(totalRecords);
        response.setTotalPages((long)totalPages);
        RequestResponse finalResponse = new RequestResponse();
        finalResponse.setStatus(Constants.Error.OK);
        finalResponse.setMessage("Caller wise summary fetched successfully");
        finalResponse.setData((Object)response);
        return finalResponse;
    }

    private Long toLong(Object val) {
        if (val == null) {
            return 0L;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        if (val instanceof String) {
            String s = ((String)val).trim();
            if (s.isEmpty()) {
                return 0L;
            }
            try {
                BigDecimal bd = new BigDecimal(s);
                return bd.longValue();
            }
            catch (NumberFormatException e) {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException ex) {
                    return 0L;
                }
            }
        }
        return 0L;
    }

    private LocalDate parseDate(String v) {
        try {
            return v == null || v.trim().isEmpty() ? null : LocalDate.parse(v);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String formatAmount(Long val) {
        Long costInPaise = val != null ? val : 0L;
        double costInRupees = (double)costInPaise.longValue() / 100.0;
        return String.valueOf(costInRupees);
    }
}

