/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.fwdExtension.controller;

import com.coraltele.db.telephony.pbx.entity.FwdExtension;
import com.coraltele.db.telephony.pbx.repository.FwdExtensionRepository;
import com.coraltele.db.telephony.pbx.specification.FwdExtensionSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.pbx.fwdExtension.model.FwdExtModel;
import com.coraltele.service.pbx.fwdExtension.service.FwdExtensionService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/fwdExtension"})
@RestController
public class FwdExtensionController {
    private static final Logger logger = LogManager.getLogger(FwdExtensionController.class);
    @Autowired
    FwdExtensionService fwdExtensionService;
    @Autowired
    FwdExtensionRepository fwdExtensionRepository;
    @Autowired
    DynamicPdfThreadService generatingReports;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> addUser(@RequestBody FwdExtModel data, Principal principal) {
        RequestResponse returnValue = this.fwdExtensionService.createData(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> getUserById(@RequestBody FwdExtModel data, Principal principal) {
        RequestResponse returnValue = this.fwdExtensionService.update(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/{day}/{ext}/list"})
    public ResponseEntity<RequestResponse> getListByDayAndExt(@PathVariable(value="day") String day, @PathVariable(value="ext") String extension) {
        RequestResponse returnValue = this.fwdExtensionService.getListByDayAndExt(day, extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllFwdExtensionByFilter(@RequestBody SearchRequest searchRequestData) {
        RequestResponse returnValue = this.fwdExtensionService.getAllFwdExtensionByFilter(searchRequestData);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for cmsReport--");
            Specification filters = FwdExtensionSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "complaintTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.fwdExtensionRepository.findAll(filters, sort) : this.fwdExtensionRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (FwdExtension item : filteredData) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for cmsReport", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading cmsReport CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private String getColumnValue(FwdExtension item, String columnName) {
        switch (columnName) {
            case "id": {
                return this.checkNull((Object)item.getId());
            }
            case "createdOn": {
                return this.checkNull((Object)item.getCreatedOn());
            }
            case "createdBy": {
                return this.checkNull((Object)item.getCreatedBy());
            }
            case "extension": {
                return this.checkNull((Object)item.getExtension());
            }
            case "sunday": {
                if (item.getSunday() != null && item.getSunday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "monday": {
                if (item.getMonday() != null && item.getMonday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "tuesday": {
                if (item.getTuesday() != null && item.getTuesday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "wednesday": {
                if (item.getWednesday() != null && item.getWednesday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "thursday": {
                if (item.getThursday() != null && item.getThursday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "friday": {
                if (item.getFriday() != null && item.getFriday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "saturday": {
                if (item.getSaturday() != null && item.getSaturday() == 1) {
                    return "Yes";
                }
                return "No";
            }
            case "fromTime": {
                return this.checkNull((Object)item.getFromTime());
            }
            case "toTime": {
                return this.checkNull((Object)item.getToTime());
            }
            case "forwardExtension": {
                return this.checkNull((Object)item.getForwardExtension());
            }
            case "updatedOn": {
                return this.checkNull((Object)item.getUpdatedOn());
            }
            case "updatedBy": {
                return this.checkNull((Object)item.getUpdatedBy());
            }
        }
        return "";
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteMeeting(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.fwdExtensionService.deleteById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    static {
        columnMappings.put("id", "ID");
        columnMappings.put("createdOn", "Created On");
        columnMappings.put("createdBy", "Created By");
        columnMappings.put("extension", "Extension");
        columnMappings.put("sunday", "Sunday");
        columnMappings.put("monday", "Monday");
        columnMappings.put("tuesday", "Tuesday");
        columnMappings.put("wednesday", "Wednesday");
        columnMappings.put("thursday", "Thursday");
        columnMappings.put("friday", "Friday");
        columnMappings.put("saturday", "Saturday");
        columnMappings.put("fromTime", "From Time");
        columnMappings.put("toTime", "To Time");
        columnMappings.put("forwardExtension", "Forward Extension");
        columnMappings.put("updatedOn", "Updated On");
        columnMappings.put("updatedBy", "Updated By");
    }
}

