/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.fileConfiguration.sipTrunkConfiguration.service;

import com.coraltele.helper.Constants;
import com.coraltele.helper.IVRUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.fileConfiguration.sipTrunkConfiguration.model.DataModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SipTrunkConfigurationService {
    private static final Logger logger = LogManager.getLogger(SipTrunkConfigurationService.class);
    @Autowired
    IVRUtility iVRUtility;
    private String defaultPath = "/etc/coraltele/siptrunk/default/";
    private String activePath = "/etc/coraltele/siptrunk/active/";

    public String createCompleteDefaultPath(String fileName) {
        String finalPath = this.defaultPath + fileName + ".json";
        return finalPath;
    }

    public String createCompleteActivePath(String fileName) {
        String finalPath = this.activePath + fileName + ".json";
        return finalPath;
    }

    public boolean existenceOfFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            logger.info("File Exists");
            return true;
        }
        return false;
    }

    public RequestResponse getAllFiles() {
        RequestResponse returnValue = new RequestResponse();
        List data = this.iVRUtility.getCustomFiles(this.defaultPath);
        if (data != null) {
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Files Found");
            returnValue.setMessageDetail("All Files Retrieved Successfully.");
            returnValue.setData((Object)data);
            logger.info("All Files Retrieved Successfully: ");
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Record is Empty");
            returnValue.setMessageDetail("Empty Data Found, Files Not Present At The Server.");
            logger.error("Empty Data Found, Files Not Present At The Server. ");
        }
        return returnValue;
    }

    public RequestResponse storeFile(DataModel model, String fileName) {
        RequestResponse returnValue = new RequestResponse();
        ObjectMapper objectMapper = new ObjectMapper();
        String finalPath = this.createCompleteActivePath(fileName);
        try {
            File file = new File(finalPath);
            if (!file.exists()) {
                file.createNewFile();
                logger.info("New File Created Successfully");
            } else {
                logger.info("File Already Exists");
            }
            FileWriter fileWriter = new FileWriter(finalPath);
            String dataReceived = objectMapper.writeValueAsString((Object)model.getSipTrunk());
            fileWriter.write(dataReceived);
            fileWriter.close();
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Stored ");
            returnValue.setMessageDetail("Data Stored Successfully");
            logger.info("Data Have Been Stored Successfully ");
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Present At The Server.");
            logger.error("Error while saving data logs ", (Throwable)e);
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while Storing Data Into File. ");
            returnValue.setMessageDetail("Unable To Store Data Into File");
            logger.error("Error while saving data logs::", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("Unable To Store Data Into File");
            logger.error("Error while saving data logs", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse retrieveData(String fileName) {
        RequestResponse returnValue = new RequestResponse();
        String finalPath = null;
        String content = null;
        try {
            finalPath = this.createCompleteActivePath(fileName);
            boolean flag = this.existenceOfFile(finalPath);
            if (flag) {
                content = new String(Files.readAllBytes(Paths.get(finalPath, new String[0])));
            } else {
                finalPath = this.createCompleteDefaultPath(fileName);
                flag = this.existenceOfFile(finalPath);
                if (!flag) {
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("File Not Found");
                    returnValue.setMessageDetail("File Not Present, Neither In default folder Nor In active folder.");
                    logger.error("File Not Present, Neither In default folder Nor In active folder. ");
                    return returnValue;
                }
                content = new String(Files.readAllBytes(Paths.get(finalPath, new String[0])));
            }
            Object dataToShow = new ObjectMapper().readValue(content, Object.class);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Retrieved ");
            returnValue.setMessageDetail("Data Retrieved Successfully");
            returnValue.setData(dataToShow);
            logger.info("Data Have Been Retrieved Successfully ");
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Present At The Server.");
            logger.error("Error while saving data logs ", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("Unable To Retrieve Data From File");
            logger.error("Error while saving data logs", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse storeDFile(DataModel model, String fileName) {
        RequestResponse returnValue = new RequestResponse();
        ObjectMapper objectMapper = new ObjectMapper();
        String finalPath = this.createCompleteDefaultPath(fileName);
        try {
            File file = new File(finalPath);
            if (!file.exists()) {
                file.createNewFile();
                logger.info("New File Created Successfully");
            } else {
                logger.info("File Already Exists");
            }
            FileWriter fileWriter = new FileWriter(finalPath);
            String dataReceived = objectMapper.writeValueAsString((Object)model.getSipTrunk());
            fileWriter.write(dataReceived);
            fileWriter.close();
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Stored ");
            returnValue.setMessageDetail("Data Stored Successfully");
            logger.info("Data Have Been Stored Successfully ");
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Present At The Server.");
            logger.error("Error while saving data logs ", (Throwable)e);
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while Storing Data Into File. ");
            returnValue.setMessageDetail("Unable To Store Data Into File");
            logger.error("Error while saving data logs::", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("Unable To Store Data Into File");
            logger.error("Error while saving data logs", (Throwable)e);
        }
        return returnValue;
    }
}

