/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.extension.service;

import com.coraltele.db.mongo.entity.HSS;
import com.coraltele.db.mongo.model.BitRate;
import com.coraltele.db.mongo.model.PCCRule;
import com.coraltele.db.mongo.model.QOS;
import com.coraltele.db.mongo.model.Session;
import com.coraltele.db.mongo.model.Slice;
import com.coraltele.db.mongo.repository.HSSRepository;
import com.coraltele.db.telephony.billing.entity.Department;
import com.coraltele.db.telephony.billing.repository.DepartmentRepository;
import com.coraltele.db.telephony.main.entity.ActiveParticipant;
import com.coraltele.db.telephony.main.entity.LocationSwitch;
import com.coraltele.db.telephony.main.entity.McxParticipant;
import com.coraltele.db.telephony.main.entity.SipRegistrations;
import com.coraltele.db.telephony.main.repository.ActiveParticipantRepository;
import com.coraltele.db.telephony.main.repository.LocationSwitchRepository;
import com.coraltele.db.telephony.main.repository.McxParticipantRepository;
import com.coraltele.db.telephony.main.repository.SipRegistrationRepository;
import com.coraltele.db.telephony.pbx.entity.CLIServerCommandLog;
import com.coraltele.db.telephony.pbx.entity.DidMapping;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.entity.ExtensionsServices;
import com.coraltele.db.telephony.pbx.entity.Manufacturer;
import com.coraltele.db.telephony.pbx.entity.ModelDetail;
import com.coraltele.db.telephony.pbx.entity.TenantMaster;
import com.coraltele.db.telephony.pbx.entity.view.ExtensionRegisteredView;
import com.coraltele.db.telephony.pbx.entity.view.ExtensionView;
import com.coraltele.db.telephony.pbx.repository.CallingFeatureRepository;
import com.coraltele.db.telephony.pbx.repository.CodeBlueRepository;
import com.coraltele.db.telephony.pbx.repository.CodecRepository;
import com.coraltele.db.telephony.pbx.repository.CosRepository;
import com.coraltele.db.telephony.pbx.repository.DidMappingRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionFeatureRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionRegisteredViewRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionViewRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsServicesRepository;
import com.coraltele.db.telephony.pbx.repository.ManufacturerRepository;
import com.coraltele.db.telephony.pbx.repository.ModeRepository;
import com.coraltele.db.telephony.pbx.repository.ModelDetailRepository;
import com.coraltele.db.telephony.pbx.repository.ProvisioningFeatureRepository;
import com.coraltele.db.telephony.pbx.repository.SecurityRepository;
import com.coraltele.db.telephony.pbx.repository.SetOperationDayAndTimeRepository;
import com.coraltele.db.telephony.pbx.repository.TenantMasterRepository;
import com.coraltele.db.telephony.pbx.repository.UCFeatureRepository;
import com.coraltele.db.telephony.pbx.repository.VoNrVoLteRepository;
import com.coraltele.db.telephony.pbx.specification.CallingFeatureSpecification;
import com.coraltele.db.telephony.pbx.specification.CodeBlueSpecification;
import com.coraltele.db.telephony.pbx.specification.CodecSpecification;
import com.coraltele.db.telephony.pbx.specification.CosSpecification;
import com.coraltele.db.telephony.pbx.specification.ExtensionFeatureSpecification;
import com.coraltele.db.telephony.pbx.specification.ExtensionSpecification;
import com.coraltele.db.telephony.pbx.specification.ExtensionTypeSpecification;
import com.coraltele.db.telephony.pbx.specification.ExtensionViewSpecification;
import com.coraltele.db.telephony.pbx.specification.ModeSpecification;
import com.coraltele.db.telephony.pbx.specification.ProvisioningFeatureSpecification;
import com.coraltele.db.telephony.pbx.specification.SecuritySpecification;
import com.coraltele.db.telephony.pbx.specification.SetOperationDayAndTimeSpecification;
import com.coraltele.db.telephony.pbx.specification.UCFeatureSpecification;
import com.coraltele.db.telephony.pbx.specification.VoNrVoLteSpecification;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.HttpUtils;
import com.coraltele.helper.PasswordConversion;
import com.coraltele.helper.RequestResponse;
import com.coraltele.helper.Telephony;
import com.coraltele.model.CliCommandData;
import com.coraltele.model.CodeValue;
import com.coraltele.model.InputAction;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.model.VoiceMessageModel;
import com.coraltele.service.coralApps.pbx.service.CDRService;
import com.coraltele.service.pbx.cLIServerCommandLog.service.CLIServerCommandLogService;
import com.coraltele.service.pbx.controlRluServer.service.ControlRluServerService;
import com.coraltele.service.pbx.cos.service.InboundCosService;
import com.coraltele.service.pbx.cos.service.OutboundCosService;
import com.coraltele.service.pbx.didmapping.service.DidMappingService;
import com.coraltele.service.pbx.extension.model.ContactData;
import com.coraltele.service.pbx.extension.model.ExtensionCreateModel;
import com.coraltele.service.pbx.extension.model.ExtensionDepartmentModel;
import com.coraltele.service.pbx.extension.model.ExtensionModelCreate;
import com.coraltele.service.pbx.extension.model.ExtensionNumberModel;
import com.coraltele.service.pbx.extension.model.ExtensionParticipantsModel;
import com.coraltele.service.pbx.extension.model.ExtensionRightsModel;
import com.coraltele.service.pbx.extension.model.ExtensionRluCodeModel;
import com.coraltele.service.pbx.extension.model.ExtensionTypeModel;
import com.coraltele.service.pbx.extension.model.ExtensionZoneModel;
import com.coraltele.service.pbx.extension.model.ExtensionsModel;
import com.coraltele.service.pbx.extension.model.MCXCallModel;
import com.coraltele.service.pbx.extension.model.PlayFileModel;
import com.coraltele.service.pbx.extension.model.group.CallingFeatureModel;
import com.coraltele.service.pbx.extension.model.group.CodeBlueModel;
import com.coraltele.service.pbx.extension.model.group.CodecModel;
import com.coraltele.service.pbx.extension.model.group.CosModel;
import com.coraltele.service.pbx.extension.model.group.ExtensionFeatureModel;
import com.coraltele.service.pbx.extension.model.group.ModeModel;
import com.coraltele.service.pbx.extension.model.group.ProvisioningFeatureModel;
import com.coraltele.service.pbx.extension.model.group.SecurityModel;
import com.coraltele.service.pbx.extension.model.group.SetOperationDayAndTimeModel;
import com.coraltele.service.pbx.extension.model.group.UCFeatureModel;
import com.coraltele.service.pbx.extension.model.group.VoNrVoLteModel;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.CallingFeatureMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.CodeBlueMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.CodecMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.CosMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.ExtensionFeatureMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.ModeMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.ProvisioningFeaturesMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.SecurityMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.SetOperationDayAndTimeMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.UCFeaturesMultipleUpdate;
import com.coraltele.service.pbx.extension.model.groupMultipleUpdates.VoNrVoLteMultipleUpdate;
import com.coraltele.service.pbx.extension.model.searchAttribute.ExtensionSearchAttribute;
import com.coraltele.service.pbx.extension_service.model.ServiceCodeAttribute;
import com.coraltele.service.pbx.extension_service.service.ExtensionsServicesService;
import com.coraltele.service.pbx.fileConfiguration.defaultConfiguration.service.DefaultConfigurationService;
import com.coraltele.service.pbx.m_modeldetail.service.ModelDetailService;
import com.coraltele.service.pbx.m_tenantmaster.service.TenantMasterService;
import com.coraltele.service.pbx.manufacturer.service.ManufacturerService;
import com.coraltele.service.uc.service.CustomerAccountService;
import com.coraltele.service.user.service.UserRoleService;
import com.coraltele.service.user.service.UserService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ExtensionsService {
    private static final Logger logger = LogManager.getLogger(ExtensionsService.class);
    @Autowired
    private ExtensionsRepository extensionsRepository;
    @Autowired
    private ExtensionsServicesRepository extensionsServicesRepository;
    @Autowired
    private DidMappingRepository didMappingRepository;
    @Autowired
    private TenantMasterRepository tenantMasterRepository;
    @Autowired
    private ManufacturerRepository manufacturerRepository;
    @Autowired
    PasswordConversion sIPPasswordConversion;
    @Autowired
    private ModelDetailRepository modelDetailRepository;
    @Autowired
    private ExtensionsServicesService extensionsServicesService;
    @Autowired
    private DidMappingService didMappingService;
    @Autowired
    private TenantMasterService tenantMasterService;
    @Autowired
    private ManufacturerService manufacturerService;
    @Autowired
    private ModelDetailService modelDetailService;
    @Autowired
    private InboundCosService inBoundCosService;
    @Autowired
    private OutboundCosService outBoundCosService;
    @Autowired
    private PasswordEncoder bcryptEncoder;
    @Autowired
    DefaultConfigurationService extensionFileConfigurationService;
    @Autowired
    HSSRepository hssRepository;
    @Autowired
    CodeBlueRepository codeBlueRepository;
    @Autowired
    SecurityRepository securityRepository;
    @Autowired
    CodecRepository codecRepository;
    @Autowired
    CosRepository cosRepository;
    @Autowired
    UserService userService;
    @Autowired
    UserRoleService userRoleService;
    @Autowired
    ModeRepository modeRepository;
    @Autowired
    VoNrVoLteRepository voNrVoLteRepository;
    @Autowired
    UCFeatureRepository uCFeatureRepository;
    @Autowired
    SetOperationDayAndTimeRepository setOperationDayAndTimeRepository;
    @Autowired
    ProvisioningFeatureRepository provisioningFeatureRepository;
    @Autowired
    ExtensionFeatureRepository extensionFeatureRepository;
    @Autowired
    CallingFeatureRepository callingFeatureRepository;
    @Autowired
    ExtensionViewRepository extensionViewRepository;
    @Autowired
    private CLIServerCommandLogService cLIServerCommandLogService;
    @Autowired
    ExtensionRegisteredViewRepository extensionRegisteredViewRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    CDRService cdrService;
    @Autowired
    ControlRluServerService controlRluServerService;
    @Autowired
    DepartmentRepository departmentRepository;
    @Autowired
    SipRegistrationRepository sipRegistrationRepository;
    @Autowired
    McxParticipantRepository mcxParticipantRepository;
    @Autowired
    ActiveParticipantRepository activeParticipantRepository;
    @Autowired
    LocationSwitchRepository locationSwitchRepository;
    @Autowired
    CustomerAccountService customerAccountService;

    public boolean checkExtensionsFromGivenRange(ServiceCodeAttribute range) {
        for (int i = Integer.parseInt(range.getFrom()); i <= Integer.parseInt(range.getTo()); ++i) {
            Optional extensions = this.extensionsRepository.findByExtension(String.valueOf(i));
            if (!extensions.isPresent()) continue;
            return true;
        }
        return false;
    }

    public RequestResponse createExtensionByGivenRange(HttpServletRequest request, ServiceCodeAttribute extensionRange) {
        logger.debug("create new extension : {} ==> {}", (Object)extensionRange.getFrom(), (Object)extensionRange.getTo());
        RequestResponse returnValue = new RequestResponse();
        boolean checkOutbound = this.outBoundCosService.checkOutboundCosWithZerosCos();
        boolean checkInbound = this.inBoundCosService.checkInboundCosWithZerosCos();
        boolean checkExtensionRange = this.checkExtensionsFromGivenRange(extensionRange);
        try {
            if (!checkExtensionRange) {
                if (!checkOutbound) {
                    this.outBoundCosService.createOutboundCoswithZerosCos();
                }
                if (!checkInbound) {
                    this.inBoundCosService.createInboundCosWithZerosCos();
                }
                this.extensionsServicesService.createMultipleExtensionServices(extensionRange);
                for (int i = Integer.parseInt(extensionRange.getFrom()); i <= Integer.parseInt(extensionRange.getTo()); ++i) {
                    Extension extensions = new Extension();
                    extensions.setExtension(String.valueOf(i));
                    extensions.setExtensionType("phone");
                    extensions.setDayOutboundCos("0");
                    extensions.setDayInboundCos("0");
                    extensions.setNightOutboundCos("0");
                    extensions.setNightInboundCos("0");
                    this.extensionsRepository.save((Object)extensions);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Extensions created");
                returnValue.setMessageDetail("All extensions have created successfully");
                logger.info("Extension saved : {}", (Object)returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.EXTENSION_RANGE_ALREADY_EXISTS);
                returnValue.setMessage("Can't create");
                returnValue.setMessageDetail("Extensions already created");
                logger.error(returnValue.getMessageDetail());
            }
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.EXTENSION_RANGE_ALREADY_EXISTS);
            returnValue.setMessage("Can't Create ");
            returnValue.setMessageDetail("Extension already present, from given range");
            logger.error(returnValue.getMessageDetail(), (Throwable)ex);
        }
        return returnValue;
    }

    public void saveData(HttpServletRequest request, Extension data, Authentication authentication) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules();
        ArrayList<InputAction> addValue = new ArrayList<InputAction>();
        CliCommandData cliCommandData = new CliCommandData();
        Map newMap = (Map)new ObjectMapper().readValue((InputStream)request.getInputStream(), Map.class);
        Set entrySet = newMap.entrySet();
        Iterator iterator = entrySet.iterator();
        try {
            if (data.getId() != null && this.extensionsRepository.findById((Object)data.getId()).isPresent()) {
                Optional oldData = this.extensionsRepository.findById((Object)data.getId());
                Map oldMap = (Map)objectMapper.convertValue(oldData.get(), Map.class);
                while (iterator.hasNext()) {
                    Map.Entry mapEntry = iterator.next();
                    InputAction inputValue = new InputAction();
                    inputValue.setFieldName(mapEntry.getKey());
                    inputValue.setNewValue(mapEntry.getValue());
                    for (Map.Entry compare : oldMap.entrySet()) {
                        if (!mapEntry.getKey().equals(compare.getKey())) continue;
                        inputValue.setOldValue(compare.getValue());
                    }
                    addValue.add(inputValue);
                }
                cliCommandData.setData(addValue);
                cliCommandData.setEntity("extensions");
                String dataReceived = objectMapper.writeValueAsString(addValue);
                CLIServerCommandLog dataLogs = new CLIServerCommandLog();
                dataLogs.setCLICommand(dataReceived);
                dataLogs.setRecordSource("dl");
                dataLogs.setServerCode("");
                dataLogs.setRecordCreatedBy(authentication.getName());
                dataLogs.setRecordCreatedOn(LocalDateTime.now());
                dataLogs.setOutputFileName("Name");
                dataLogs.setOutputFilePath("");
                this.cLIServerCommandLogService.save(dataLogs);
            }
        }
        catch (JsonProcessingException e) {
            logger.error("saveDataError" + (Object)((Object)e));
        }
    }

    public RequestResponse deleteBySingleExtensionValue(String extension) {
        logger.debug("Delete extension {}", (Object)extension);
        RequestResponse returnValue = new RequestResponse();
        Optional data = this.extensionsRepository.findByExtension(extension);
        if (!data.isPresent()) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to delete");
            returnValue.setMessageDetail("Record Not Found");
        } else {
            if (((Extension)data.get()).getExtension() != null) {
                this.extensionsServicesService.deleteByExtension(((Extension)data.get()).getExtension());
            }
            if (((Extension)data.get()).getExtension() != null) {
                this.didMappingService.deleteDidMapping(((Extension)data.get()).getExtension());
            }
            if (((Extension)data.get()).getColumn11() != null) {
                this.tenantMasterService.deleteTenantMaster(Integer.parseInt(((Extension)data.get()).getColumn11()));
            }
            if (((Extension)data.get()).getManufacturerId() != null) {
                this.manufacturerService.deleteManufacturer(((Extension)data.get()).getManufacturerId().intValue());
            }
            if (((Extension)data.get()).getModelDetailId() != null) {
                this.modelDetailService.deleteModelDetail(((Extension)data.get()).getModelDetailId().intValue());
            }
            this.extensionsRepository.deleteById((Object)((Extension)data.get()).getId());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Deleted");
            returnValue.setMessageDetail("Data deleted successfully");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse deleteMultipleExtensions(List<String> extensions) {
        logger.debug("Delete Extension {}", extensions);
        RequestResponse returnValue = new RequestResponse();
        for (String data : extensions) {
            Optional extension = this.extensionsRepository.findByExtension(data);
            if (!extension.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Can't Delete");
                returnValue.setMessageDetail(String.format("  %s not found in Extension ", data));
                logger.error(returnValue.getMessageDetail());
                return returnValue;
            }
            if (((Extension)extension.get()).getExtension() != null) {
                this.extensionsServicesService.deleteByExtension(((Extension)extension.get()).getExtension());
            }
            if (((Extension)extension.get()).getExtension() != null) {
                this.didMappingService.deleteDidMapping(((Extension)extension.get()).getExtension());
            }
            if (((Extension)extension.get()).getColumn11() != null) {
                this.tenantMasterService.deleteTenantMaster(Integer.parseInt(((Extension)extension.get()).getColumn11()));
            }
            if (((Extension)extension.get()).getManufacturerId() != null) {
                this.manufacturerService.deleteManufacturer(((Extension)extension.get()).getManufacturerId().intValue());
            }
            if (((Extension)extension.get()).getModelDetailId() != null) {
                this.modelDetailService.deleteModelDetail(((Extension)extension.get()).getModelDetailId().intValue());
            }
            this.extensionsRepository.deleteById((Object)((Extension)extension.get()).getId());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Deleted");
        returnValue.setMessageDetail(" Data deleted successfully ");
        logger.info(" Extension deleted  : {}", (Object)returnValue.getMessage());
        return returnValue;
    }

    public List<ExtensionSearchAttribute> getModelData(List<ExtensionView> list) {
        ArrayList<ExtensionSearchAttribute> addValue = new ArrayList<ExtensionSearchAttribute>();
        for (ExtensionView extension : list) {
            ExtensionSearchAttribute data = new ExtensionSearchAttribute();
            data.setExtension(extension.getExtension());
            data.setDayInboundCos(extension.getDayInboundCos());
            data.setNightInboundCos(extension.getNightInboundCos());
            data.setDayOutboundCos(extension.getDayOutboundCos());
            data.setNightOutboundCos(extension.getNightOutboundCos());
            data.setAccountCode(extension.getAccountCode());
            data.setCFnaTime(extension.getCFnaTime());
            data.setVideoCall(extension.getVideoCall());
            data.setWavFileName(extension.getWavFileName());
            data.setPCma(extension.getPCma());
            data.setPCmu(extension.getPCmu());
            data.setG722(extension.getG722());
            data.setG723(extension.getG723());
            data.setG726(extension.getG726());
            data.setG729(extension.getG729());
            data.setOpus(extension.getOpus());
            data.setVp8(extension.getVp8());
            data.setH264(extension.getH264());
            data.setH263(extension.getH263());
            data.setPrimaryDayInboundCos(extension.getPrimaryDayInboundCos());
            data.setPrimaryNightInboundCos(extension.getPrimaryNightInboundCos());
            data.setSecondaryDayOutboundCos(extension.getSecondaryDayOutboundCos());
            data.setSecondaryNightOutboundCos(extension.getSecondaryNightOutboundCos());
            data.setSecondaryDayInboundCos(extension.getSecondaryDayInboundCos());
            data.setSecondaryNightInboundCos(extension.getSecondaryNightInboundCos());
            data.setPrimaryDayOutboundCos(extension.getPrimaryDayOutboundCos());
            data.setPrimaryNightOutboundCos(extension.getPrimaryNightOutboundCos());
            data.setIMeiNumber(extension.getIMeiNumber());
            data.setTimeoutInSecond(extension.getTimeoutInSecond());
            data.setRingTime(extension.getRingTime());
            data.setCompany(extension.getCompany());
            data.setDepartment(extension.getDepartment());
            data.setDesignation(extension.getDesignation());
            data.setSecretary(extension.getSecretary());
            data.setCollaboration(extension.getCollaboration());
            data.setData(extension.getData());
            data.setExtGroupId(extension.getExtGroupId());
            data.setPforkStr(extension.getPforkStr());
            data.setRecord(extension.getRecord());
            data.setAutoLift(extension.getAutoLift());
            data.setEmailId(extension.getEmailId());
            data.setRluCode(extension.getRluCode());
            data.setCallWaitingStatus(extension.getCallWaitingStatus());
            data.setRingBackTone(extension.getRingBackTone());
            data.setGroupCode(extension.getGroupCode());
            data.setIsCampOnMode(extension.getIsCampOnMode());
            data.setCampOnHoldMusic(extension.getCampOnHoldMusic());
            data.setCallerOverrideToHoldParty(extension.getCallerOverrideToHoldParty());
            data.setPersonalVmGreeting(extension.getPersonalVmGreeting());
            data.setCallTransferToVm(extension.getCallTransferToVm());
            data.setWelcomeGreeting(extension.getWelcomeGreeting());
            data.setOverflowToBoss(extension.getOverflowToBoss());
            data.setSplitRecordingFileInMinutes(extension.getSplitRecordingFileInMinutes());
            data.setPhoneStatus(extension.getPhoneStatus());
            data.setDayMode(extension.getDayMode());
            data.setNightMode(extension.getNightMode());
            data.setNonworkingData(extension.getNonworkingData());
            data.setNonworkingApp(extension.getNonworkingApp());
            data.setManufacturerId(extension.getManufacturerId());
            data.setModelDetailId(extension.getModelDetailId());
            data.setMacId(extension.getMacId());
            data.setModelCode(extension.getModelCode());
            data.setSRtp(extension.getSRtp());
            data.setZRtp(extension.getZRtp());
            data.setDSun(extension.getDSun());
            data.setDMon(extension.getDMon());
            data.setDThu(extension.getDThu());
            data.setDTue(extension.getDTue());
            data.setDWed(extension.getDWed());
            data.setDFri(extension.getDFri());
            data.setDSat(extension.getDSat());
            data.setFromTime(extension.getFromTime());
            data.setToTime(extension.getToTime());
            data.setTimezone(extension.getTimezone());
            data.setFlexibleTimings(extension.getFlexibleTimings());
            data.setMonFromTime(extension.getMonFromTime());
            data.setMonToTime(extension.getMonToTime());
            data.setTueFromTime(extension.getTueFromTime());
            data.setTueToTime(extension.getTueToTime());
            data.setWedFromTime(extension.getWedFromTime());
            data.setWedToTime(extension.getWedToTime());
            data.setThuFromTime(extension.getThuFromTime());
            data.setThuToTime(extension.getThuToTime());
            data.setFriFromTime(extension.getFriFromTime());
            data.setFriToTime(extension.getFriToTime());
            data.setSatFromTime(extension.getSatFromTime());
            data.setSatToTime(extension.getSatToTime());
            data.setSunFromTime(extension.getSunFromTime());
            data.setSunToTime(extension.getSunToTime());
            data.setNightRingTime(extension.getNightRingTime());
            data.setXMppId(extension.getXMppId());
            data.setXMppPassword(extension.getXMppPassword());
            data.setAssignedUser(extension.getAssignedUser());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getSingleExtension(String extension) {
        logger.debug("Get extension list");
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        ExtensionRightsModel extensionRights = new ExtensionRightsModel();
        try {
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
            } else {
                extensionRights.setId(((Extension)extensions.get()).getId().intValue());
                extensionRights.setExtension(((Extension)extensions.get()).getExtension());
                extensionRights.setExtensionType(((Extension)extensions.get()).getExtensionType());
                extensionRights.setName(((Extension)extensions.get()).getName());
                extensionRights.setCFNATime(((Extension)extensions.get()).getCFNATime());
                extensionRights.setVideoCall(((Extension)extensions.get()).getVideoCall());
                extensionRights.setWavFilename(((Extension)extensions.get()).getWavFilename());
                extensionRights.setPCMA(((Extension)extensions.get()).getPCMA());
                extensionRights.setPCMU(((Extension)extensions.get()).getPCMU());
                extensionRights.setG722(((Extension)extensions.get()).getG722());
                extensionRights.setG726(((Extension)extensions.get()).getG726());
                extensionRights.setG729(((Extension)extensions.get()).getG729());
                extensionRights.setG723(((Extension)extensions.get()).getG723());
                extensionRights.setOpus(((Extension)extensions.get()).getOpus());
                extensionRights.setVp8(((Extension)extensions.get()).getVp8());
                extensionRights.setH263(((Extension)extensions.get()).getH263());
                extensionRights.setH264(((Extension)extensions.get()).getH264());
                extensionRights.setDayInboundCos(((Extension)extensions.get()).getDayInboundCos());
                extensionRights.setNightInboundCos(((Extension)extensions.get()).getNightInboundCos());
                extensionRights.setDayOutboundCos(((Extension)extensions.get()).getDayOutboundCos());
                extensionRights.setNightOutboundCos(((Extension)extensions.get()).getNightOutboundCos());
                extensionRights.setSecondaryDayInboundCos(((Extension)extensions.get()).getSecondaryDayInboundCos());
                extensionRights.setSecondaryDayOutboundCos(((Extension)extensions.get()).getSecondaryDayOutboundCos());
                extensionRights.setSecondaryNightInboundCos(((Extension)extensions.get()).getSecondaryNightInboundCos());
                extensionRights.setSecondaryNightOutboundCos(((Extension)extensions.get()).getSecondaryNightOutboundCos());
                extensionRights.setPrimaryDayInboundCos(((Extension)extensions.get()).getPrimaryDayInboundCos());
                extensionRights.setPrimaryDayOutboundCos(((Extension)extensions.get()).getPrimaryDayOutboundCos());
                extensionRights.setIMEINumber(((Extension)extensions.get()).getIMEINumber());
                extensionRights.setTimeOutInSecond(((Extension)extensions.get()).getTimeOutInSecond());
                extensionRights.setRingTime(((Extension)extensions.get()).getRingTime());
                extensionRights.setCompany(((Extension)extensions.get()).getCompany());
                extensionRights.setDepartment(((Extension)extensions.get()).getDepartment());
                extensionRights.setDesignation(((Extension)extensions.get()).getDesignation());
                extensionRights.setSecretary(((Extension)extensions.get()).getSecretary());
                extensionRights.setCollaboration(((Extension)extensions.get()).getCollaboration());
                extensionRights.setAccountCode(((Extension)extensions.get()).getAccountCode());
                extensionRights.setData(((Extension)extensions.get()).getData());
                extensionRights.setExtGroupId(((Extension)extensions.get()).getExtGroupId());
                extensionRights.setPforkStr(((Extension)extensions.get()).getPforkStr());
                extensionRights.setRecords(((Extension)extensions.get()).getRecord());
                extensionRights.setAutoLift(((Extension)extensions.get()).getAutoLift());
                extensionRights.setEmailId(((Extension)extensions.get()).getEmailId());
                extensionRights.setRluCode(((Extension)extensions.get()).getRluCode());
                extensionRights.setCallWaitingStatus(((Extension)extensions.get()).getCallWaitingStatus());
                extensionRights.setRingBackTone(((Extension)extensions.get()).getRingBackTone());
                extensionRights.setGroupCode(((Extension)extensions.get()).getGroupCode());
                extensionRights.setIsCampOnMode(((Extension)extensions.get()).getIsCampOnMode());
                extensionRights.setCampOnHoldMusic(((Extension)extensions.get()).getCampOnHoldMusic());
                extensionRights.setCallerOverrideToHoldParty(((Extension)extensions.get()).getCallerOverrideToHoldParty());
                extensionRights.setCallTransferToVm(((Extension)extensions.get()).getCallTransferToVm());
                extensionRights.setWelcomeGreeting(((Extension)extensions.get()).getWelcomeGreeting());
                extensionRights.setOverflowToBoss(((Extension)extensions.get()).getOverflowToBoss());
                extensionRights.setSplitRecordingFileInMinutes(((Extension)extensions.get()).getSplitRecordingFileInMinutes());
                extensionRights.setPhoneStatus(((Extension)extensions.get()).getPhoneStatus());
                extensionRights.setDayMode(((Extension)extensions.get()).getDayMode());
                extensionRights.setNightMode(((Extension)extensions.get()).getNightMode());
                extensionRights.setNonworkingData(((Extension)extensions.get()).getNonworkingData());
                extensionRights.setNonworkingApp(((Extension)extensions.get()).getNonworkingApp());
                extensionRights.setManufacturerId(((Extension)extensions.get()).getManufacturerId());
                extensionRights.setModelDetailId(((Extension)extensions.get()).getModelDetailId());
                extensionRights.setPersonalVmGreeting(((Extension)extensions.get()).getPersonalVmGreeting());
                extensionRights.setMacId(((Extension)extensions.get()).getMacId());
                extensionRights.setSrtP(((Extension)extensions.get()).getSrtP());
                extensionRights.setZrtP(((Extension)extensions.get()).getZrtP());
                extensionRights.setDSun(((Extension)extensions.get()).getDSun());
                extensionRights.setDMon(((Extension)extensions.get()).getDMon());
                extensionRights.setDTue(((Extension)extensions.get()).getDTue());
                extensionRights.setDWed(((Extension)extensions.get()).getDWed());
                extensionRights.setDThu(((Extension)extensions.get()).getDThu());
                extensionRights.setDFri(((Extension)extensions.get()).getDFri());
                extensionRights.setDSat(((Extension)extensions.get()).getDSat());
                extensionRights.setFriFromTime(((Extension)extensions.get()).getFriFromTime());
                extensionRights.setToTime(((Extension)extensions.get()).getFriToTime());
                extensionRights.setFlexibleTimings(((Extension)extensions.get()).getFlexibleTimings());
                extensionRights.setMonFromTime(((Extension)extensions.get()).getMonFromTime());
                extensionRights.setMonToTime(((Extension)extensions.get()).getMonToTime());
                extensionRights.setTueFromTime(((Extension)extensions.get()).getTueFromTime());
                extensionRights.setTueToTime(((Extension)extensions.get()).getTueToTime());
                extensionRights.setWedFromTime(((Extension)extensions.get()).getWedFromTime());
                extensionRights.setWedToTime(((Extension)extensions.get()).getWedToTime());
                extensionRights.setThuFromTime(((Extension)extensions.get()).getThuFromTime());
                extensionRights.setThuToTime(((Extension)extensions.get()).getThuToTime());
                extensionRights.setFriFromTime(((Extension)extensions.get()).getFriFromTime());
                extensionRights.setFriToTime(((Extension)extensions.get()).getFriToTime());
                extensionRights.setSatFromTime(((Extension)extensions.get()).getSatFromTime());
                extensionRights.setSatToTime(((Extension)extensions.get()).getSatToTime());
                extensionRights.setNightRingTime(((Extension)extensions.get()).getNightRingTime());
                extensionRights.setXmpPId(((Extension)extensions.get()).getXmpPId());
                extensionRights.setAssignedUser(((Extension)extensions.get()).getAssignedUser());
                if (this.didMappingRepository.findByExtNumber(((Extension)extensions.get()).getExtension()).isPresent()) {
                    Optional didMapping = this.didMappingRepository.findByExtNumber(((Extension)extensions.get()).getExtension());
                    extensionRights.setDidNumber(((DidMapping)didMapping.get()).getDidNumber());
                    extensionRights.setDodNumber(((DidMapping)didMapping.get()).getDodNumber());
                }
                if (!this.extensionsServicesRepository.findAllByExtension(((Extension)extensions.get()).getExtension()).isEmpty()) {
                    List extensionsServicesList = this.extensionsServicesRepository.findAllByExtension(((Extension)extensions.get()).getExtension());
                    for (ExtensionsServices extensionService : extensionsServicesList) {
                        if (extensionService.getServiceCode().equals("dnd")) {
                            extensionRights.setDnd(1);
                        }
                        if (extensionService.getServiceCode().equals("dialing-intercom")) {
                            extensionRights.setIntercom(1);
                        }
                        if (extensionService.getServiceCode().equals("dialing-isd")) {
                            extensionRights.setIsd(1);
                        }
                        if (extensionService.getServiceCode().equals("dialing-local")) {
                            extensionRights.setLocal(1);
                        }
                        if (extensionService.getServiceCode().equals("dialing-std")) {
                            extensionRights.setStd(1);
                        }
                        if (!extensionService.getServiceCode().equals("VM")) continue;
                        extensionRights.setVm(1);
                    }
                }
                if (((Extension)extensions.get()).getColumn11() != null) {
                    if (((Extension)extensions.get()).getColumn11().equals("")) {
                        extensionRights.setCode("");
                    } else if (this.tenantMasterRepository.findById(Integer.valueOf(Integer.parseInt(((Extension)extensions.get()).getColumn11()))).isPresent()) {
                        Optional tenantMaster = this.tenantMasterRepository.findById(Integer.valueOf(Integer.parseInt(((Extension)extensions.get()).getColumn11())));
                        extensionRights.setCode(((TenantMaster)tenantMaster.get()).getCode());
                    }
                } else {
                    extensionRights.setCode(null);
                }
                if (((Extension)extensions.get()).getManufacturerId() != null) {
                    if (this.manufacturerRepository.findById(((Extension)extensions.get()).getManufacturerId()).isPresent()) {
                        Optional manufacturers = this.manufacturerRepository.findById(((Extension)extensions.get()).getManufacturerId());
                        extensionRights.setManufacturerCode(((Manufacturer)manufacturers.get()).getCode());
                    }
                } else {
                    extensionRights.setManufacturerCode(null);
                }
                if (((Extension)extensions.get()).getModelDetailId() != null) {
                    if (this.modelDetailRepository.findById(((Extension)extensions.get()).getModelDetailId()).isPresent()) {
                        Optional modelDetail = this.modelDetailRepository.findById(((Extension)extensions.get()).getModelDetailId());
                        extensionRights.setModelCode(((ModelDetail)modelDetail.get()).getModelCode());
                    }
                } else {
                    extensionRights.setModelCode(null);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setData((Object)extensionRights);
                returnValue.setMessage("data");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("data");
            logger.error("error while fetching the data.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getSingleCallingFeatures(String extension) {
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        CallingFeatureModel callingFeatures = new CallingFeatureModel();
        if (extensions.isPresent()) {
            try {
                callingFeatures.setExtension(((Extension)extensions.get()).getExtension());
                callingFeatures.setCfnatime(((Extension)extensions.get()).getCFNATime());
                callingFeatures.setVideoCall(((Extension)extensions.get()).getVideoCall());
                if (!this.extensionsServicesRepository.findAllByExtension(((Extension)extensions.get()).getExtension()).isEmpty()) {
                    List extensionsServicesList = this.extensionsServicesRepository.findAllByExtension(((Extension)extensions.get()).getExtension());
                    for (ExtensionsServices extensionService : extensionsServicesList) {
                        if (extensionService.getServiceCode().equalsIgnoreCase("cfa")) {
                            callingFeatures.setCfa(extensionService.getServiceCode());
                        }
                        if (extensionService.getServiceCode().equalsIgnoreCase("eCFA")) {
                            callingFeatures.setEcfa(extensionService.getServiceCode());
                        }
                        if (extensionService.getServiceCode().equalsIgnoreCase("cFB")) {
                            callingFeatures.setCfb(extensionService.getServiceCode());
                        }
                        if (extensionService.getServiceCode().equalsIgnoreCase("eCFB")) {
                            callingFeatures.setEcfb(extensionService.getServiceCode());
                        }
                        if (extensionService.getServiceCode().equalsIgnoreCase("eCFNA")) {
                            callingFeatures.setEcfna(extensionService.getServiceCode());
                        }
                        if (extensionService.getServiceCode().equalsIgnoreCase("dialing-isd")) {
                            callingFeatures.setIsd(extensionService.getServiceCode());
                        }
                        if (extensionService.getServiceCode().equalsIgnoreCase("dialing-local")) {
                            callingFeatures.setLocal(extensionService.getServiceCode());
                        }
                        if (extensionService.getServiceCode().equalsIgnoreCase("iC")) {
                            callingFeatures.setIc(extensionService.getServiceCode());
                        }
                        if (extensionService.getServiceCode().equalsIgnoreCase("VM")) {
                            callingFeatures.setVm(extensionService.getServiceCode());
                        }
                        if (extensionService.getServiceCode().equalsIgnoreCase("dnd")) {
                            callingFeatures.setDnd(extensionService.getServiceCode());
                        }
                        if (!extensionService.getServiceCode().equalsIgnoreCase("dialing-intercom")) continue;
                        callingFeatures.setIntercom(extensionService.getServiceCode());
                    }
                }
                if (this.didMappingRepository.findByExtNumber(((Extension)extensions.get()).getExtension()).isPresent()) {
                    Optional didMapping = this.didMappingRepository.findByExtNumber(((Extension)extensions.get()).getExtension());
                    callingFeatures.setDidNo(((DidMapping)didMapping.get()).getDidNumber());
                    callingFeatures.setDodNo(((DidMapping)didMapping.get()).getDodNumber());
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setData((Object)callingFeatures);
                returnValue.setMessage("data");
                logger.info(returnValue.getMessage());
            }
            catch (Exception e) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Data not found");
                logger.error("error while fetching the data.", (Throwable)e);
            }
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Data not found");
        }
        return returnValue;
    }

    public RequestResponse getAllCodeBlue(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CodeBlueSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.codeBlueRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.codeBlueRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getSingleCodeBlue(String extension) {
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        CodeBlueModel codeBlueModel = new CodeBlueModel();
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
        } else {
            codeBlueModel.setExtension(((Extension)extensions.get()).getExtension());
            codeBlueModel.setWavFilename(((Extension)extensions.get()).getWavFilename());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("data");
            returnValue.setData((Object)codeBlueModel);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAllCodec(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CodecSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.codecRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.codecRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getSingleCodec(String extension) {
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        CodecModel codec = new CodecModel();
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
        } else {
            codec.setExtension(((Extension)extensions.get()).getExtension());
            codec.setPcma(((Extension)extensions.get()).getPCMA());
            codec.setPcmu(((Extension)extensions.get()).getPCMU());
            codec.setG722(((Extension)extensions.get()).getG722());
            codec.setG726(((Extension)extensions.get()).getG726());
            codec.setG729(((Extension)extensions.get()).getG729());
            codec.setG723(((Extension)extensions.get()).getG723());
            codec.setOpus(((Extension)extensions.get()).getOpus());
            codec.setVp8(((Extension)extensions.get()).getVp8());
            codec.setH263(((Extension)extensions.get()).getH263());
            codec.setH264(((Extension)extensions.get()).getH264());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("data");
            returnValue.setData((Object)codec);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAllCos(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CosSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.cosRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.cosRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getSingleCos(String extension) {
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        CosModel cos = new CosModel();
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
        } else {
            cos.setExtension(((Extension)extensions.get()).getExtension());
            cos.setDayInboundCos(((Extension)extensions.get()).getDayInboundCos());
            cos.setDayOutboundCos(((Extension)extensions.get()).getDayOutboundCos());
            cos.setNightInboundCos(((Extension)extensions.get()).getNightInboundCos());
            cos.setNightOutboundCos(((Extension)extensions.get()).getNightOutboundCos());
            cos.setSecondaryDayInboundCos(((Extension)extensions.get()).getSecondaryDayInboundCos());
            cos.setSecondaryDayOutboundCos(((Extension)extensions.get()).getSecondaryDayOutboundCos());
            cos.setSecondaryNightInboundCos(((Extension)extensions.get()).getSecondaryNightInboundCos());
            cos.setSecondaryNightOutboundCos(((Extension)extensions.get()).getSecondaryNightOutboundCos());
            cos.setPrimaryDayInboundCos(((Extension)extensions.get()).getPrimaryDayInboundCos());
            cos.setPrimaryDayOutboundCos(((Extension)extensions.get()).getPrimaryDayOutboundCos());
            cos.setPrimaryNightInboundCos(((Extension)extensions.get()).getPrimaryNightInboundCos());
            cos.setPrimaryNightOutboundCos(((Extension)extensions.get()).getPrimaryNightOutboundCos());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("data");
            returnValue.setData((Object)cos);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAllExtensionFeature(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ExtensionFeatureSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.extensionFeatureRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.extensionFeatureRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getSingleExtensionFeature(String extension) {
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        ExtensionFeatureModel extensionFeature = new ExtensionFeatureModel();
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
        } else {
            extensionFeature.setExtension(((Extension)extensions.get()).getExtension());
            extensionFeature.setName(((Extension)extensions.get()).getName());
            extensionFeature.setIMEINumber(((Extension)extensions.get()).getIMEINumber());
            extensionFeature.setTimeOutInSecond(((Extension)extensions.get()).getTimeOutInSecond());
            extensionFeature.setRingTime(((Extension)extensions.get()).getRingTime());
            extensionFeature.setCompany(((Extension)extensions.get()).getCompany());
            extensionFeature.setDepartment(((Extension)extensions.get()).getDepartment());
            extensionFeature.setDesignation(((Extension)extensions.get()).getDesignation());
            extensionFeature.setSecretary(((Extension)extensions.get()).getSecretary());
            extensionFeature.setCollaboration(((Extension)extensions.get()).getCollaboration());
            extensionFeature.setAccountCode(((Extension)extensions.get()).getAccountCode());
            extensionFeature.setData(((Extension)extensions.get()).getData());
            extensionFeature.setExtGroupId(((Extension)extensions.get()).getExtGroupId());
            extensionFeature.setPforkStr(((Extension)extensions.get()).getPforkStr());
            extensionFeature.setRecord(((Extension)extensions.get()).getRecord());
            extensionFeature.setVideoCall(((Extension)extensions.get()).getVideoCall());
            extensionFeature.setAutoLift(((Extension)extensions.get()).getAutoLift());
            extensionFeature.setRluCode(((Extension)extensions.get()).getRluCode());
            extensionFeature.setCallWaitingStatus(((Extension)extensions.get()).getCallWaitingStatus());
            extensionFeature.setRingBackTone(((Extension)extensions.get()).getRingBackTone());
            extensionFeature.setGroupCode(((Extension)extensions.get()).getGroupCode());
            extensionFeature.setIsCampOnMode(((Extension)extensions.get()).getIsCampOnMode());
            extensionFeature.setCampOnHoldMusic(((Extension)extensions.get()).getCampOnHoldMusic());
            extensionFeature.setCallerOverrideToHoldParty(((Extension)extensions.get()).getCallerOverrideToHoldParty());
            extensionFeature.setCallTransferToVm(((Extension)extensions.get()).getCallTransferToVm());
            extensionFeature.setWelcomeGreeting(((Extension)extensions.get()).getWelcomeGreeting());
            extensionFeature.setOverflowToBoss(((Extension)extensions.get()).getOverflowToBoss());
            extensionFeature.setSplitRecordingFileInMinutes(((Extension)extensions.get()).getSplitRecordingFileInMinutes());
            extensionFeature.setPhoneStatus(((Extension)extensions.get()).getPhoneStatus());
            extensionFeature.setPersonalVmGreeting(((Extension)extensions.get()).getPersonalVmGreeting());
            if (((Extension)extensions.get()).getColumn11() != null) {
                if (((Extension)extensions.get()).getColumn11().equals("")) {
                    extensionFeature.setCode("");
                } else if (this.tenantMasterRepository.findById(Integer.valueOf(Integer.parseInt(((Extension)extensions.get()).getColumn11()))).isPresent()) {
                    Optional tenantMaster = this.tenantMasterRepository.findById(Integer.valueOf(Integer.parseInt(((Extension)extensions.get()).getColumn11())));
                    extensionFeature.setCode(((TenantMaster)tenantMaster.get()).getCode());
                }
            } else {
                extensionFeature.setCode(null);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("data");
            returnValue.setData((Object)extensionFeature);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getSingleUC(String extension) {
        RequestResponse returnValue = new RequestResponse();
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        try {
            if (extensions.isPresent()) {
                UCFeatureModel data = new UCFeatureModel();
                data.setExtension(((Extension)extensions.get()).getExtension());
                data.setXmpPId(((Extension)extensions.get()).getXmpPId());
                data.setXmpPPassword(((Extension)extensions.get()).getXmpPPassword());
                data.setAssignedUser(((Extension)extensions.get()).getAssignedUser());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("UC Found");
                returnValue.setData((Object)data);
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
        }
        return returnValue;
    }

    public RequestResponse getAllUCFeature(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = UCFeatureSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.uCFeatureRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.uCFeatureRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getSingleSecurity(String extension) {
        RequestResponse returnValue = new RequestResponse();
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        try {
            if (extensions.isPresent()) {
                SecurityModel data = new SecurityModel();
                data.setExtension(((Extension)extensions.get()).getExtension());
                data.setPassword(((Extension)extensions.get()).getPassword());
                data.setSipPassword(((Extension)extensions.get()).getSipPassword());
                data.setSrtP(((Extension)extensions.get()).getSrtP());
                data.setZrtP(((Extension)extensions.get()).getZrtP());
                data.setVmPassword(((Extension)extensions.get()).getVmPassword());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Security Found");
                returnValue.setData((Object)data);
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
        }
        return returnValue;
    }

    public RequestResponse getAllSecurity(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = SecuritySpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.securityRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.securityRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getSingleProvisioning(String extension) {
        logger.debug("Get extension list");
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        ProvisioningFeatureModel provisioningFeaturesModel = new ProvisioningFeatureModel();
        try {
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
            } else {
                provisioningFeaturesModel.setExtension(((Extension)extensions.get()).getExtension());
                provisioningFeaturesModel.setManufacturerId(((Extension)extensions.get()).getManufacturerId());
                provisioningFeaturesModel.setModelDetailId(((Extension)extensions.get()).getModelDetailId());
                provisioningFeaturesModel.setMacId(((Extension)extensions.get()).getMacId());
                if (((Extension)extensions.get()).getModelDetailId() != null) {
                    if (this.modelDetailRepository.findById(((Extension)extensions.get()).getModelDetailId()).isPresent()) {
                        Optional modelDetail = this.modelDetailRepository.findById(((Extension)extensions.get()).getModelDetailId());
                        provisioningFeaturesModel.setModelCode(((ModelDetail)modelDetail.get()).getModelCode());
                    }
                } else {
                    provisioningFeaturesModel.setModelCode(null);
                }
                logger.info(returnValue.getMessage());
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setData((Object)provisioningFeaturesModel);
            returnValue.setMessage("data");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("data");
            logger.error("error while fetching the data.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllProvisioning(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ProvisioningFeatureSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.provisioningFeatureRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.provisioningFeatureRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getSingleSetOperationDayAndTime(String extension) {
        logger.debug("Get extension list of SetOperationDayAndTime");
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        SetOperationDayAndTimeModel data = new SetOperationDayAndTimeModel();
        try {
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
            } else {
                data.setExtension(((Extension)extensions.get()).getExtension());
                data.setDsun(((Extension)extensions.get()).getDSun());
                data.setDMon(((Extension)extensions.get()).getDMon());
                data.setDTue(((Extension)extensions.get()).getDTue());
                data.setDWed(((Extension)extensions.get()).getDWed());
                data.setDThu(((Extension)extensions.get()).getDThu());
                data.setDFri(((Extension)extensions.get()).getDFri());
                data.setDSat(((Extension)extensions.get()).getDSat());
                data.setFromTime(((Extension)extensions.get()).getFromTime());
                data.setToTime(((Extension)extensions.get()).getToTime());
                data.setTimezone(((Extension)extensions.get()).getTimezone());
                data.setFlexibleTimings(((Extension)extensions.get()).getFlexibleTimings());
                data.setMonFromTime(((Extension)extensions.get()).getMonFromTime());
                data.setMonToTime(((Extension)extensions.get()).getMonToTime());
                data.setTueFromTime(((Extension)extensions.get()).getTueFromTime());
                data.setTueToTime(((Extension)extensions.get()).getTueToTime());
                data.setWedFromTime(((Extension)extensions.get()).getWedFromTime());
                data.setWedToTime(((Extension)extensions.get()).getWedToTime());
                data.setThuFromTime(((Extension)extensions.get()).getThuFromTime());
                data.setThuToTime(((Extension)extensions.get()).getThuToTime());
                data.setFriFromTime(((Extension)extensions.get()).getFriFromTime());
                data.setFriToTime(((Extension)extensions.get()).getFriToTime());
                data.setSatFromTime(((Extension)extensions.get()).getSatFromTime());
                data.setSatToTime(((Extension)extensions.get()).getSatToTime());
                data.setSunFromTime(((Extension)extensions.get()).getSunFromTime());
                data.setSunToTime(((Extension)extensions.get()).getSunToTime());
                data.setNightRingTime(((Extension)extensions.get()).getNightRingTime());
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setData((Object)data);
            returnValue.setMessage("data");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("data");
            logger.error("error while fetching the data.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllSetOperationDayAndTime(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = SetOperationDayAndTimeSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.setOperationDayAndTimeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.setOperationDayAndTimeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getSingleMode(String extension) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (extensions.isPresent()) {
                ModeModel data = new ModeModel();
                data.setExtension(((Extension)extensions.get()).getExtension());
                data.setDayMode(((Extension)extensions.get()).getDayMode());
                data.setNightMode(((Extension)extensions.get()).getNightMode());
                data.setNonworkingApp(((Extension)extensions.get()).getNonworkingApp());
                data.setNonworkingData(((Extension)extensions.get()).getNonworkingData());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Mode Found");
                returnValue.setData((Object)data);
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
        }
        return returnValue;
    }

    public RequestResponse getAllMode(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ModeSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.modeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.modeRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllVoNrVoLte(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = VoNrVoLteSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.voNrVoLteRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.voNrVoLteRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllCallingFeature(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CallingFeatureSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.callingFeatureRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.callingFeatureRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getVoNrVoLte(String extension) {
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        VoNrVoLteModel voNrVoLte = new VoNrVoLteModel();
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
        } else {
            voNrVoLte.setExtension(((Extension)extensions.get()).getExtension());
            voNrVoLte.setExtensionSubtype(((Extension)extensions.get()).getExtensionSubtype());
            voNrVoLte.setIMsi(((Extension)extensions.get()).getIMSI());
            voNrVoLte.setKValue(((Extension)extensions.get()).getKValue());
            voNrVoLte.setOPopc(((Extension)extensions.get()).getOPopc());
            voNrVoLte.setMsiSdn(((Extension)extensions.get()).getMsiSdn());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("data");
            returnValue.setData((Object)voNrVoLte);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateSingleCallingFeature(HttpServletRequest request, String extensionNumber, CallingFeatureModel callingFeature, Authentication authentication) throws IOException {
        Optional extensions = this.extensionsRepository.findByExtension(extensionNumber);
        RequestResponse returnValue = new RequestResponse();
        if (extensions.isPresent()) {
            this.saveData(request, (Extension)extensions.get(), authentication);
            try {
                if (callingFeature.getCfnatime() != null) {
                    ((Extension)extensions.get()).setCFNATime(callingFeature.getCfnatime());
                }
                if (callingFeature.getVideoCall() != null) {
                    ((Extension)extensions.get()).setVideoCall(callingFeature.getVideoCall());
                }
                this.extensionsRepository.save(extensions.get());
                if (!this.extensionsServicesRepository.findAllByExtension(((Extension)extensions.get()).getExtension()).isEmpty()) {
                    List extensionsServicesList = this.extensionsServicesRepository.findAllByExtension(((Extension)extensions.get()).getExtension());
                    for (ExtensionsServices extensionService : extensionsServicesList) {
                        if (callingFeature.getCfa() != null && extensionService.getServiceCode().equalsIgnoreCase("CFA")) {
                            extensionService.setServiceCode(callingFeature.getCfa());
                        }
                        if (callingFeature.getEcfa() != null && extensionService.getServiceCode().equalsIgnoreCase("ECFA")) {
                            extensionService.setServiceCode(callingFeature.getEcfa());
                        }
                        if (callingFeature.getCfb() != null && extensionService.getServiceCode().equalsIgnoreCase("CFB")) {
                            extensionService.setServiceCode(callingFeature.getCfb());
                        }
                        if (callingFeature.getEcfb() != null && extensionService.getServiceCode().equalsIgnoreCase("ECFB")) {
                            extensionService.setServiceCode(callingFeature.getEcfb());
                        }
                        if (callingFeature.getIsd() != null && extensionService.getServiceCode().equalsIgnoreCase("ISD")) {
                            extensionService.setServiceCode(callingFeature.getIsd());
                        }
                        if (callingFeature.getLocal() != null && extensionService.getServiceCode().equalsIgnoreCase("Local")) {
                            extensionService.setServiceCode(callingFeature.getLocal());
                        }
                        if (callingFeature.getVm() != null && extensionService.getServiceCode().equalsIgnoreCase("VM")) {
                            extensionService.setServiceCode(callingFeature.getVm());
                        }
                        if (callingFeature.getDnd() != null && extensionService.getServiceCode().equalsIgnoreCase("DND")) {
                            extensionService.setServiceCode(callingFeature.getDnd());
                        }
                        this.extensionsServicesRepository.save((Object)extensionService);
                    }
                }
                if (this.didMappingRepository.findByExtNumber(((Extension)extensions.get()).getExtension()).isPresent()) {
                    Optional didMapping = this.didMappingRepository.findByExtNumber(((Extension)extensions.get()).getExtension());
                    if (callingFeature.getDidNo() != null) {
                        ((DidMapping)didMapping.get()).setDidNumber(callingFeature.getDidNo());
                    }
                    if (callingFeature.getDodNo() != null) {
                        ((DidMapping)didMapping.get()).setDodNumber(callingFeature.getDodNo());
                    }
                    this.didMappingRepository.save(didMapping.get());
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Updated ");
                returnValue.setMessageDetail("Data updated successfully ");
                logger.info(returnValue.getMessage());
            }
            catch (Exception e) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Data not found");
                logger.error("error while fetching the data.", (Throwable)e);
            }
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Data not found");
        }
        return returnValue;
    }

    public RequestResponse updateMultipleCallingFeatures(CallingFeatureMultipleUpdate callingFeatureMultipleUpdate) {
        RequestResponse returnValue = new RequestResponse();
        for (String extension : callingFeatureMultipleUpdate.getExtensions()) {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (extensions.isPresent()) {
                try {
                    if (callingFeatureMultipleUpdate.getCfnatime() != null) {
                        ((Extension)extensions.get()).setCFNATime(callingFeatureMultipleUpdate.getCfnatime());
                    }
                    if (callingFeatureMultipleUpdate.getVideoCall() != null) {
                        ((Extension)extensions.get()).setVideoCall(callingFeatureMultipleUpdate.getVideoCall());
                    }
                    this.extensionsRepository.save(extensions.get());
                    if (!this.extensionsServicesRepository.findAllByExtension(((Extension)extensions.get()).getExtension()).isEmpty()) {
                        List extensionsServicesList = this.extensionsServicesRepository.findAllByExtension(((Extension)extensions.get()).getExtension());
                        for (ExtensionsServices extensionService : extensionsServicesList) {
                            if (callingFeatureMultipleUpdate.getCfa() != null && extensionService.getServiceCode().equalsIgnoreCase("CFA")) {
                                extensionService.setServiceCode(callingFeatureMultipleUpdate.getCfa());
                            }
                            if (callingFeatureMultipleUpdate.getEcfa() != null && extensionService.getServiceCode().equalsIgnoreCase("ECFA")) {
                                extensionService.setServiceCode(callingFeatureMultipleUpdate.getEcfa());
                            }
                            if (callingFeatureMultipleUpdate.getCfb() != null && extensionService.getServiceCode().equalsIgnoreCase("CFB")) {
                                extensionService.setServiceCode(callingFeatureMultipleUpdate.getCfb());
                            }
                            if (callingFeatureMultipleUpdate.getEcfb() != null && extensionService.getServiceCode().equalsIgnoreCase("ECFB")) {
                                extensionService.setServiceCode(callingFeatureMultipleUpdate.getEcfb());
                            }
                            if (callingFeatureMultipleUpdate.getIsd() != null && extensionService.getServiceCode().equalsIgnoreCase("ISD")) {
                                extensionService.setServiceCode(callingFeatureMultipleUpdate.getIsd());
                            }
                            if (callingFeatureMultipleUpdate.getLocal() != null && extensionService.getServiceCode().equalsIgnoreCase("Local")) {
                                extensionService.setServiceCode(callingFeatureMultipleUpdate.getLocal());
                            }
                            if (callingFeatureMultipleUpdate.getIc() != null && extensionService.getServiceCode().equalsIgnoreCase("IC")) {
                                extensionService.setServiceCode(callingFeatureMultipleUpdate.getIc());
                            }
                            if (callingFeatureMultipleUpdate.getVm() != null && extensionService.getServiceCode().equalsIgnoreCase("VM")) {
                                extensionService.setServiceCode(callingFeatureMultipleUpdate.getVm());
                            }
                            if (callingFeatureMultipleUpdate.getFm() != null && extensionService.getServiceCode().equalsIgnoreCase("FM")) {
                                extensionService.setServiceCode(callingFeatureMultipleUpdate.getFm());
                            }
                            if (callingFeatureMultipleUpdate.getDnd() != null && extensionService.getServiceCode().equalsIgnoreCase("DND")) {
                                extensionService.setServiceCode(callingFeatureMultipleUpdate.getDnd());
                            }
                            this.extensionsServicesRepository.save((Object)extensionService);
                        }
                    }
                    if (!this.didMappingRepository.findByExtNumber(((Extension)extensions.get()).getExtension()).isPresent()) continue;
                    Optional didMapping = this.didMappingRepository.findByExtNumber(((Extension)extensions.get()).getExtension());
                    if (callingFeatureMultipleUpdate.getDidNo() != null) {
                        ((DidMapping)didMapping.get()).setDidNumber(callingFeatureMultipleUpdate.getDidNo());
                    }
                    if (callingFeatureMultipleUpdate.getDodNo() != null) {
                        ((DidMapping)didMapping.get()).setDodNumber(callingFeatureMultipleUpdate.getDodNo());
                    }
                    this.didMappingRepository.save(didMapping.get());
                }
                catch (Exception e) {
                    returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                    returnValue.setMessage("Data not found");
                    logger.error("error while fetching the data.", (Throwable)e);
                }
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Data not found");
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateSingleProvisioning(String extension, ProvisioningFeatureModel provisioningFeature) {
        logger.debug("Get extension list");
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)extensions.get()).getModelDetailId() != null && this.modelDetailRepository.findById(((Extension)extensions.get()).getModelDetailId()).isPresent()) {
            Optional modelDetail = this.modelDetailRepository.findById(((Extension)extensions.get()).getModelDetailId());
            if (provisioningFeature.getModelCode() != null) {
                ((ModelDetail)modelDetail.get()).setModelCode(provisioningFeature.getModelCode());
            }
            this.modelDetailRepository.save(modelDetail.get());
        }
        if (provisioningFeature.getManufacturerId() != null) {
            ((Extension)extensions.get()).setManufacturerId(provisioningFeature.getManufacturerId());
        }
        if (provisioningFeature.getModelDetailId() != null) {
            ((Extension)extensions.get()).setModelDetailId(provisioningFeature.getModelDetailId());
        }
        if (provisioningFeature.getMacId() != null) {
            ((Extension)extensions.get()).setMacId(provisioningFeature.getMacId());
        }
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMultipleProvisioning(ProvisioningFeaturesMultipleUpdate provisioningFeaturesMultipleUpdate) {
        logger.debug("Get extension list");
        RequestResponse returnValue = new RequestResponse();
        for (String extension : provisioningFeaturesMultipleUpdate.getExtensions()) {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            if (((Extension)extensions.get()).getModelDetailId() != null && this.modelDetailRepository.findById(((Extension)extensions.get()).getModelDetailId()).isPresent()) {
                Optional modelDetail = this.modelDetailRepository.findById(((Extension)extensions.get()).getModelDetailId());
                ((ModelDetail)modelDetail.get()).setModelCode(provisioningFeaturesMultipleUpdate.getModelCode());
                this.modelDetailRepository.save(modelDetail.get());
            }
            if (provisioningFeaturesMultipleUpdate.getManufacturerId() != null) {
                ((Extension)extensions.get()).setManufacturerId(provisioningFeaturesMultipleUpdate.getManufacturerId());
            }
            if (provisioningFeaturesMultipleUpdate.getModelDetailId() != null) {
                ((Extension)extensions.get()).setModelDetailId(provisioningFeaturesMultipleUpdate.getModelDetailId());
            }
            if (provisioningFeaturesMultipleUpdate.getMacId() != null) {
                ((Extension)extensions.get()).setMacId(provisioningFeaturesMultipleUpdate.getMacId());
            }
            if (provisioningFeaturesMultipleUpdate.getModelCode() != null) {
                ((Extension)extensions.get()).setModelCode(provisioningFeaturesMultipleUpdate.getModelCode());
            }
            this.extensionsRepository.save(extensions.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateSingleExtensionFeature(String extension, ExtensionFeatureModel extensionFeature) {
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (((Extension)extensions.get()).getColumn11() != null && !((Extension)extensions.get()).getColumn11().equals("") && this.tenantMasterRepository.findById(Integer.valueOf(Integer.parseInt(((Extension)extensions.get()).getColumn11()))).isPresent()) {
            Optional tenantMaster = this.tenantMasterRepository.findById(Integer.valueOf(Integer.parseInt(((Extension)extensions.get()).getColumn11())));
            ((TenantMaster)tenantMaster.get()).setCode(extensionFeature.getCode());
            this.tenantMasterRepository.save(tenantMaster.get());
        }
        if (extensionFeature.getAccountCode() != null) {
            ((Extension)extensions.get()).setAccountCode(extensionFeature.getAccountCode());
        }
        if (extensionFeature.getAutoLift() != null) {
            ((Extension)extensions.get()).setAutoLift(extensionFeature.getAutoLift());
        }
        if (extensionFeature.getCallTransferToVm() != null) {
            ((Extension)extensions.get()).setCallTransferToVm(extensionFeature.getCallTransferToVm());
        }
        if (extensionFeature.getCallWaitingStatus() != null) {
            ((Extension)extensions.get()).setCallWaitingStatus(extensionFeature.getCallWaitingStatus());
        }
        if (extensionFeature.getCallerOverrideToHoldParty() != null) {
            ((Extension)extensions.get()).setCallerOverrideToHoldParty(extensionFeature.getCallerOverrideToHoldParty());
        }
        if (extensionFeature.getCampOnHoldMusic() != null) {
            ((Extension)extensions.get()).setCampOnHoldMusic(extensionFeature.getCampOnHoldMusic());
        }
        if (extensionFeature.getCollaboration() != null) {
            ((Extension)extensions.get()).setCollaboration(extensionFeature.getCollaboration());
        }
        if (extensionFeature.getCompany() != null) {
            ((Extension)extensions.get()).setCompany(extensionFeature.getCompany());
        }
        if (extensionFeature.getData() != null) {
            ((Extension)extensions.get()).setData(extensionFeature.getData());
        }
        if (extensionFeature.getDepartment() != null) {
            ((Extension)extensions.get()).setDepartment(extensionFeature.getDepartment());
        }
        if (extensionFeature.getDesignation() != null) {
            ((Extension)extensions.get()).setDesignation(extensionFeature.getDesignation());
        }
        if (extensionFeature.getExtGroupId() != null) {
            ((Extension)extensions.get()).setExtGroupId(extensionFeature.getExtGroupId());
        }
        if (extensionFeature.getGroupCode() != null) {
            ((Extension)extensions.get()).setGroupCode(extensionFeature.getGroupCode());
        }
        if (extensionFeature.getIMEINumber() != null) {
            ((Extension)extensions.get()).setIMEINumber(extensionFeature.getIMEINumber());
        }
        if (extensionFeature.getIsCampOnMode() != null) {
            ((Extension)extensions.get()).setIsCampOnMode(extensionFeature.getIsCampOnMode());
        }
        if (extensionFeature.getName() != null) {
            ((Extension)extensions.get()).setName(extensionFeature.getName());
        }
        if (extensionFeature.getOverflowToBoss() != null) {
            ((Extension)extensions.get()).setOverflowToBoss(extensionFeature.getOverflowToBoss());
        }
        if (extensionFeature.getPforkStr() != null) {
            ((Extension)extensions.get()).setPforkStr(extensionFeature.getPforkStr());
        }
        if (extensionFeature.getPersonalVmGreeting() != null) {
            ((Extension)extensions.get()).setPersonalVmGreeting(extensionFeature.getPersonalVmGreeting());
        }
        if (extensionFeature.getPhoneStatus() != null) {
            ((Extension)extensions.get()).setPhoneStatus(extensionFeature.getPhoneStatus());
        }
        if (extensionFeature.getRecord() != null) {
            ((Extension)extensions.get()).setRecord(extensionFeature.getRecord());
        }
        if (extensionFeature.getRingBackTone() != null) {
            ((Extension)extensions.get()).setRingBackTone(extensionFeature.getRingBackTone());
        }
        if (extensionFeature.getRingTime() != null) {
            ((Extension)extensions.get()).setRingTime(extensionFeature.getRingTime());
        }
        if (extensionFeature.getRluCode() != null) {
            ((Extension)extensions.get()).setRluCode(extensionFeature.getRluCode());
        }
        if (extensionFeature.getSecretary() != null) {
            ((Extension)extensions.get()).setSecretary(extensionFeature.getSecretary());
        }
        if (extensionFeature.getSplitRecordingFileInMinutes() != null) {
            ((Extension)extensions.get()).setSplitRecordingFileInMinutes(extensionFeature.getSplitRecordingFileInMinutes());
        }
        if (extensionFeature.getTimeOutInSecond() != null) {
            ((Extension)extensions.get()).setTimeOutInSecond(extensionFeature.getTimeOutInSecond());
        }
        if (extensionFeature.getVideoCall() != null) {
            ((Extension)extensions.get()).setVideoCall(extensionFeature.getVideoCall());
        }
        if (extensionFeature.getWelcomeGreeting() != null) {
            ((Extension)extensions.get()).setWelcomeGreeting(extensionFeature.getWelcomeGreeting());
        }
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMultipleExtensionFeature(ExtensionFeatureMultipleUpdate extensionFeatureMultipleUpdate) {
        RequestResponse returnValue = new RequestResponse();
        for (String extension : extensionFeatureMultipleUpdate.getExtensions()) {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            if (((Extension)extensions.get()).getColumn11() != null && !((Extension)extensions.get()).getColumn11().equals("") && this.tenantMasterRepository.findById(Integer.valueOf(Integer.parseInt(((Extension)extensions.get()).getColumn11()))).isPresent()) {
                Optional tenantMaster = this.tenantMasterRepository.findById(Integer.valueOf(Integer.parseInt(((Extension)extensions.get()).getColumn11())));
                ((TenantMaster)tenantMaster.get()).setCode(extensionFeatureMultipleUpdate.getTenantCode());
                this.tenantMasterRepository.save(tenantMaster.get());
            }
            if (extensionFeatureMultipleUpdate.getName() != null) {
                ((Extension)extensions.get()).setName(extensionFeatureMultipleUpdate.getName());
            }
            if (extensionFeatureMultipleUpdate.getIMEINumber() != null) {
                ((Extension)extensions.get()).setIMEINumber(extensionFeatureMultipleUpdate.getIMEINumber());
            }
            if (extensionFeatureMultipleUpdate.getTimeOutInSecond() != null) {
                ((Extension)extensions.get()).setTimeOutInSecond(extensionFeatureMultipleUpdate.getTimeOutInSecond());
            }
            if (extensionFeatureMultipleUpdate.getRingTime() != null) {
                ((Extension)extensions.get()).setRingTime(extensionFeatureMultipleUpdate.getRingTime());
            }
            if (extensionFeatureMultipleUpdate.getCompany() != null) {
                ((Extension)extensions.get()).setCompany(extensionFeatureMultipleUpdate.getCompany());
            }
            if (extensionFeatureMultipleUpdate.getDepartment() != null) {
                ((Extension)extensions.get()).setDepartment(extensionFeatureMultipleUpdate.getDepartment());
            }
            if (extensionFeatureMultipleUpdate.getDesignation() != null) {
                ((Extension)extensions.get()).setDesignation(extensionFeatureMultipleUpdate.getDesignation());
            }
            if (extensionFeatureMultipleUpdate.getSecretary() != null) {
                ((Extension)extensions.get()).setSecretary(extensionFeatureMultipleUpdate.getSecretary());
            }
            if (extensionFeatureMultipleUpdate.getCollaboration() != null) {
                ((Extension)extensions.get()).setCollaboration(extensionFeatureMultipleUpdate.getCollaboration());
            }
            if (extensionFeatureMultipleUpdate.getAccountCode() != null) {
                ((Extension)extensions.get()).setAccountCode(extensionFeatureMultipleUpdate.getAccountCode());
            }
            if (extensionFeatureMultipleUpdate.getData() != null) {
                ((Extension)extensions.get()).setData(extensionFeatureMultipleUpdate.getData());
            }
            if (extensionFeatureMultipleUpdate.getExtGroupId() != null) {
                ((Extension)extensions.get()).setExtGroupId(extensionFeatureMultipleUpdate.getExtGroupId());
            }
            if (extensionFeatureMultipleUpdate.getPforkStr() != null) {
                ((Extension)extensions.get()).setPforkStr(extensionFeatureMultipleUpdate.getPforkStr());
            }
            if (extensionFeatureMultipleUpdate.getRecords() != null) {
                ((Extension)extensions.get()).setRecord(extensionFeatureMultipleUpdate.getRecords());
            }
            if (extensionFeatureMultipleUpdate.getVideoCall() != null) {
                ((Extension)extensions.get()).setVideoCall(extensionFeatureMultipleUpdate.getVideoCall());
            }
            if (extensionFeatureMultipleUpdate.getAutoLift() != null) {
                ((Extension)extensions.get()).setAutoLift(extensionFeatureMultipleUpdate.getAutoLift());
            }
            if (extensionFeatureMultipleUpdate.getRluCode() != null) {
                ((Extension)extensions.get()).setRluCode(extensionFeatureMultipleUpdate.getRluCode());
            }
            if (extensionFeatureMultipleUpdate.getCallWaitingStatus() != null) {
                ((Extension)extensions.get()).setCallWaitingStatus(extensionFeatureMultipleUpdate.getCallWaitingStatus());
            }
            if (extensionFeatureMultipleUpdate.getRingBackTone() != null) {
                ((Extension)extensions.get()).setRingBackTone(extensionFeatureMultipleUpdate.getRingBackTone());
            }
            if (extensionFeatureMultipleUpdate.getGroupCode() != null) {
                ((Extension)extensions.get()).setGroupCode(extensionFeatureMultipleUpdate.getGroupCode());
            }
            if (extensionFeatureMultipleUpdate.getIsCampOnMode() != null) {
                ((Extension)extensions.get()).setIsCampOnMode(extensionFeatureMultipleUpdate.getIsCampOnMode());
            }
            if (extensionFeatureMultipleUpdate.getCampOnHoldMusic() != null) {
                ((Extension)extensions.get()).setCampOnHoldMusic(extensionFeatureMultipleUpdate.getCampOnHoldMusic());
            }
            if (extensionFeatureMultipleUpdate.getCallerOverrideToHoldParty() != null) {
                ((Extension)extensions.get()).setCallerOverrideToHoldParty(extensionFeatureMultipleUpdate.getCallerOverrideToHoldParty());
            }
            if (extensionFeatureMultipleUpdate.getCallTransferToVm() != null) {
                ((Extension)extensions.get()).setCallTransferToVm(extensionFeatureMultipleUpdate.getCallTransferToVm());
            }
            if (extensionFeatureMultipleUpdate.getWelcomeGreeting() != null) {
                ((Extension)extensions.get()).setWelcomeGreeting(extensionFeatureMultipleUpdate.getWelcomeGreeting());
            }
            if (extensionFeatureMultipleUpdate.getOverflowToBoss() != null) {
                ((Extension)extensions.get()).setOverflowToBoss(extensionFeatureMultipleUpdate.getOverflowToBoss());
            }
            if (extensionFeatureMultipleUpdate.getSplitRecordingFileInMinutes() != null) {
                ((Extension)extensions.get()).setSplitRecordingFileInMinutes(extensionFeatureMultipleUpdate.getSplitRecordingFileInMinutes());
            }
            if (extensionFeatureMultipleUpdate.getPhoneStatus() != null) {
                ((Extension)extensions.get()).setPhoneStatus(extensionFeatureMultipleUpdate.getPhoneStatus());
            }
            if (extensionFeatureMultipleUpdate.getPersonalVmGreeting() != null) {
                ((Extension)extensions.get()).setPersonalVmGreeting(extensionFeatureMultipleUpdate.getPersonalVmGreeting());
            }
            this.extensionsRepository.save(extensions.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateSingleCodeBlue(HttpServletRequest request, String extension, CodeBlueModel codeBlue, Authentication authentication) throws IOException {
        logger.debug("Get extension list");
        RequestResponse returnValue = new RequestResponse();
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.saveData(request, (Extension)extensions.get(), authentication);
        if (codeBlue.getWavFilename() != null) {
            ((Extension)extensions.get()).setWavFilename(codeBlue.getWavFilename());
        }
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMultipleCodeBlue(HttpServletRequest request, CodeBlueMultipleUpdate codeBlueMultipleUpdate, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        for (String extension : codeBlueMultipleUpdate.getExtensions()) {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            this.saveData(request, (Extension)extensions.get(), authentication);
            if (codeBlueMultipleUpdate.getWavFilename() != null) {
                ((Extension)extensions.get()).setWavFilename(codeBlueMultipleUpdate.getWavFilename());
            }
            this.extensionsRepository.save(extensions.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateSingleCodec(HttpServletRequest request, String extension, CodecModel codec, Authentication authentication) throws IOException {
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.saveData(request, (Extension)extensions.get(), authentication);
        if (codec.getG722() != null) {
            ((Extension)extensions.get()).setG722(codec.getG722());
        }
        if (codec.getG723() != null) {
            ((Extension)extensions.get()).setG723(codec.getG723());
        }
        if (codec.getG726() != null) {
            ((Extension)extensions.get()).setG726(codec.getG726());
        }
        if (codec.getG729() != null) {
            ((Extension)extensions.get()).setG729(codec.getG729());
        }
        if (codec.getH263() != null) {
            ((Extension)extensions.get()).setH263(codec.getH263());
        }
        if (codec.getH264() != null) {
            ((Extension)extensions.get()).setH264(codec.getH264());
        }
        if (codec.getOpus() != null) {
            ((Extension)extensions.get()).setOpus(codec.getOpus());
        }
        if (codec.getPcma() != null) {
            ((Extension)extensions.get()).setPCMA(codec.getPcma());
        }
        if (codec.getPcmu() != null) {
            ((Extension)extensions.get()).setPCMU(codec.getPcmu());
        }
        if (codec.getVp8() != null) {
            ((Extension)extensions.get()).setVp8(codec.getVp8());
        }
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMultipleCodec(HttpServletRequest request, CodecMultipleUpdate codecMultipleUpdate, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        for (String extension : codecMultipleUpdate.getExtensions()) {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            this.saveData(request, (Extension)extensions.get(), authentication);
            if (codecMultipleUpdate.getPcma() != null) {
                ((Extension)extensions.get()).setPCMA(codecMultipleUpdate.getPcma());
            }
            if (codecMultipleUpdate.getPcmu() != null) {
                ((Extension)extensions.get()).setPCMU(codecMultipleUpdate.getPcmu());
            }
            if (codecMultipleUpdate.getG722() != null) {
                ((Extension)extensions.get()).setG722(codecMultipleUpdate.getG722());
            }
            if (codecMultipleUpdate.getG723() != null) {
                ((Extension)extensions.get()).setG723(codecMultipleUpdate.getG723());
            }
            if (codecMultipleUpdate.getG726() != null) {
                ((Extension)extensions.get()).setG726(codecMultipleUpdate.getG726());
            }
            if (codecMultipleUpdate.getG729() != null) {
                ((Extension)extensions.get()).setG729(codecMultipleUpdate.getG729());
            }
            if (codecMultipleUpdate.getH263() != null) {
                ((Extension)extensions.get()).setH263(codecMultipleUpdate.getH263());
            }
            if (codecMultipleUpdate.getH264() != null) {
                ((Extension)extensions.get()).setH264(codecMultipleUpdate.getH264());
            }
            if (codecMultipleUpdate.getOpus() != null) {
                ((Extension)extensions.get()).setOpus(codecMultipleUpdate.getOpus());
            }
            if (codecMultipleUpdate.getVp8() != null) {
                ((Extension)extensions.get()).setVp8(codecMultipleUpdate.getVp8());
            }
            this.extensionsRepository.save(extensions.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateSingleCos(HttpServletRequest request, String extension, CosModel cos, Authentication authentication) throws IOException {
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.saveData(request, (Extension)extensions.get(), authentication);
        if (cos.getDayInboundCos() != null) {
            ((Extension)extensions.get()).setDayInboundCos(cos.getDayInboundCos());
        }
        if (cos.getDayOutboundCos() != null) {
            ((Extension)extensions.get()).setDayOutboundCos(cos.getDayOutboundCos());
        }
        if (cos.getNightInboundCos() != null) {
            ((Extension)extensions.get()).setNightInboundCos(cos.getNightInboundCos());
        }
        if (cos.getNightOutboundCos() != null) {
            ((Extension)extensions.get()).setNightOutboundCos(cos.getNightOutboundCos());
        }
        if (cos.getPrimaryDayInboundCos() != null) {
            ((Extension)extensions.get()).setPrimaryDayInboundCos(cos.getPrimaryDayInboundCos());
        }
        if (cos.getPrimaryDayOutboundCos() != null) {
            ((Extension)extensions.get()).setPrimaryDayOutboundCos(cos.getPrimaryDayOutboundCos());
        }
        if (cos.getPrimaryNightInboundCos() != null) {
            ((Extension)extensions.get()).setPrimaryNightInboundCos(cos.getPrimaryNightInboundCos());
        }
        if (cos.getPrimaryNightOutboundCos() != null) {
            ((Extension)extensions.get()).setPrimaryNightOutboundCos(cos.getPrimaryNightOutboundCos());
        }
        if (cos.getSecondaryDayInboundCos() != null) {
            ((Extension)extensions.get()).setSecondaryDayInboundCos(cos.getSecondaryDayInboundCos());
        }
        if (cos.getSecondaryDayOutboundCos() != null) {
            ((Extension)extensions.get()).setSecondaryDayOutboundCos(cos.getSecondaryDayOutboundCos());
        }
        if (cos.getSecondaryNightInboundCos() != null) {
            ((Extension)extensions.get()).setSecondaryNightInboundCos(cos.getSecondaryNightInboundCos());
        }
        if (cos.getSecondaryNightOutboundCos() != null) {
            ((Extension)extensions.get()).setSecondaryNightOutboundCos(cos.getSecondaryNightOutboundCos());
        }
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMultipleCos(HttpServletRequest request, CosMultipleUpdate cosMultipleUpdate, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        for (String extension : cosMultipleUpdate.getExtensions()) {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            this.saveData(request, (Extension)extensions.get(), authentication);
            if (cosMultipleUpdate.getDayInboundCos() != null) {
                ((Extension)extensions.get()).setDayInboundCos(cosMultipleUpdate.getDayInboundCos());
            }
            if (cosMultipleUpdate.getDayOutboundCos() != null) {
                ((Extension)extensions.get()).setDayOutboundCos(cosMultipleUpdate.getDayOutboundCos());
            }
            if (cosMultipleUpdate.getNightInboundCos() != null) {
                ((Extension)extensions.get()).setNightInboundCos(cosMultipleUpdate.getNightInboundCos());
            }
            if (cosMultipleUpdate.getNightOutboundCos() != null) {
                ((Extension)extensions.get()).setNightOutboundCos(cosMultipleUpdate.getNightOutboundCos());
            }
            if (cosMultipleUpdate.getPrimaryDayInboundCos() != null) {
                ((Extension)extensions.get()).setPrimaryDayInboundCos(cosMultipleUpdate.getPrimaryDayInboundCos());
            }
            if (cosMultipleUpdate.getPrimaryDayOutboundCos() != null) {
                ((Extension)extensions.get()).setPrimaryDayOutboundCos(cosMultipleUpdate.getPrimaryDayOutboundCos());
            }
            if (cosMultipleUpdate.getPrimaryNightInboundCos() != null) {
                ((Extension)extensions.get()).setPrimaryNightInboundCos(cosMultipleUpdate.getPrimaryNightInboundCos());
            }
            if (cosMultipleUpdate.getPrimaryNightOutboundCos() != null) {
                ((Extension)extensions.get()).setPrimaryNightOutboundCos(cosMultipleUpdate.getPrimaryNightOutboundCos());
            }
            if (cosMultipleUpdate.getSecondaryDayInboundCos() != null) {
                ((Extension)extensions.get()).setSecondaryDayInboundCos(cosMultipleUpdate.getSecondaryDayInboundCos());
            }
            if (cosMultipleUpdate.getSecondaryDayOutboundCos() != null) {
                ((Extension)extensions.get()).setSecondaryDayOutboundCos(cosMultipleUpdate.getSecondaryDayOutboundCos());
            }
            if (cosMultipleUpdate.getSecondaryNightInboundCos() != null) {
                ((Extension)extensions.get()).setSecondaryNightInboundCos(cosMultipleUpdate.getSecondaryNightInboundCos());
            }
            if (cosMultipleUpdate.getSecondaryNightOutboundCos() != null) {
                ((Extension)extensions.get()).setSecondaryNightOutboundCos(cosMultipleUpdate.getSecondaryNightOutboundCos());
            }
            this.extensionsRepository.save(extensions.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateSingleMode(HttpServletRequest request, String extension, ModeModel mode, Authentication authentication) throws IOException {
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        RequestResponse returnValue = new RequestResponse();
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.saveData(request, (Extension)extensions.get(), authentication);
        if (mode.getDayMode() != null) {
            ((Extension)extensions.get()).setDayMode(mode.getDayMode());
        }
        if (mode.getNightMode() != null) {
            ((Extension)extensions.get()).setNightMode(mode.getNightMode());
        }
        if (mode.getNonworkingApp() != null) {
            ((Extension)extensions.get()).setNonworkingApp(mode.getNonworkingApp());
        }
        if (mode.getNonworkingData() != null) {
            ((Extension)extensions.get()).setNonworkingData(mode.getNonworkingData());
        }
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMultipleMode(HttpServletRequest request, ModeMultipleUpdate modeMultipleUpdate, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        for (String extension : modeMultipleUpdate.getExtensions()) {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            this.saveData(request, (Extension)extensions.get(), authentication);
            if (modeMultipleUpdate.getDayMode() != null) {
                ((Extension)extensions.get()).setDayMode(modeMultipleUpdate.getDayMode());
            }
            if (modeMultipleUpdate.getNightMode() != null) {
                ((Extension)extensions.get()).setNightMode(modeMultipleUpdate.getNightMode());
            }
            if (modeMultipleUpdate.getNonworkingApp() != null) {
                ((Extension)extensions.get()).setNonworkingApp(modeMultipleUpdate.getNonworkingApp());
            }
            if (modeMultipleUpdate.getNonworkingData() != null) {
                ((Extension)extensions.get()).setNonworkingData(modeMultipleUpdate.getNonworkingData());
            }
            this.extensionsRepository.save(extensions.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateSingleSecurity(HttpServletRequest request, String extension, SecurityModel security, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("Records not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.saveData(request, (Extension)extensions.get(), authentication);
        if (security.getPassword() != null) {
            ((Extension)extensions.get()).setPassword(security.getPassword());
        }
        if (security.getSipPassword() != null) {
            ((Extension)extensions.get()).setSipPassword(security.getSipPassword());
        }
        if (security.getSrtP() != null) {
            ((Extension)extensions.get()).setSrtP(security.getSrtP());
        }
        if (security.getVmPassword() != null) {
            ((Extension)extensions.get()).setVmPassword(security.getVmPassword());
        }
        if (security.getZrtP() != null) {
            ((Extension)extensions.get()).setZrtP(security.getZrtP());
        }
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMultipleSecurity(HttpServletRequest request, SecurityMultipleUpdate securityMultipleUpdate, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        for (String extension : securityMultipleUpdate.getExtensions()) {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            this.saveData(request, (Extension)extensions.get(), authentication);
            if (securityMultipleUpdate.getPassword() != null) {
                ((Extension)extensions.get()).setPassword(securityMultipleUpdate.getPassword());
            }
            if (securityMultipleUpdate.getSipPassword() != null) {
                ((Extension)extensions.get()).setSipPassword(securityMultipleUpdate.getSipPassword());
            }
            if (securityMultipleUpdate.getSrtP() != null) {
                ((Extension)extensions.get()).setSrtP(securityMultipleUpdate.getSrtP());
            }
            if (securityMultipleUpdate.getVmPassword() != null) {
                ((Extension)extensions.get()).setVmPassword(securityMultipleUpdate.getVmPassword());
            }
            if (securityMultipleUpdate.getZrtP() != null) {
                ((Extension)extensions.get()).setZrtP(securityMultipleUpdate.getZrtP());
            }
            this.extensionsRepository.save(extensions.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateSingleSetOperationDayAndTime(HttpServletRequest request, String extension, SetOperationDayAndTimeModel setOperationDayAndTime, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("Records not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.saveData(request, (Extension)extensions.get(), authentication);
        if (setOperationDayAndTime.getDFri() != null) {
            ((Extension)extensions.get()).setDFri(setOperationDayAndTime.getDFri());
        }
        if (setOperationDayAndTime.getDMon() != null) {
            ((Extension)extensions.get()).setDMon(setOperationDayAndTime.getDMon());
        }
        if (setOperationDayAndTime.getDSat() != null) {
            ((Extension)extensions.get()).setDSat(setOperationDayAndTime.getDSat());
        }
        if (setOperationDayAndTime.getDThu() != null) {
            ((Extension)extensions.get()).setDThu(setOperationDayAndTime.getDThu());
        }
        if (setOperationDayAndTime.getDTue() != null) {
            ((Extension)extensions.get()).setDTue(setOperationDayAndTime.getDTue());
        }
        if (setOperationDayAndTime.getDWed() != null) {
            ((Extension)extensions.get()).setDWed(setOperationDayAndTime.getDWed());
        }
        if (setOperationDayAndTime.getDsun() != null) {
            ((Extension)extensions.get()).setDSun(setOperationDayAndTime.getDsun());
        }
        if (setOperationDayAndTime.getFlexibleTimings() != null) {
            ((Extension)extensions.get()).setFlexibleTimings(setOperationDayAndTime.getFlexibleTimings());
        }
        if (setOperationDayAndTime.getFriFromTime() != null) {
            ((Extension)extensions.get()).setFriFromTime(setOperationDayAndTime.getFriFromTime());
        }
        if (setOperationDayAndTime.getFriToTime() != null) {
            ((Extension)extensions.get()).setFriToTime(setOperationDayAndTime.getFriToTime());
        }
        if (setOperationDayAndTime.getFromTime() != null) {
            ((Extension)extensions.get()).setFromTime(setOperationDayAndTime.getFromTime());
        }
        if (setOperationDayAndTime.getMonFromTime() != null) {
            ((Extension)extensions.get()).setMonFromTime(setOperationDayAndTime.getMonFromTime());
        }
        if (setOperationDayAndTime.getMonToTime() != null) {
            ((Extension)extensions.get()).setMonToTime(setOperationDayAndTime.getMonToTime());
        }
        if (setOperationDayAndTime.getNightRingTime() != null) {
            ((Extension)extensions.get()).setNightRingTime(setOperationDayAndTime.getNightRingTime());
        }
        if (setOperationDayAndTime.getSatFromTime() != null) {
            ((Extension)extensions.get()).setSatFromTime(setOperationDayAndTime.getSatFromTime());
        }
        if (setOperationDayAndTime.getSatToTime() != null) {
            ((Extension)extensions.get()).setSatToTime(setOperationDayAndTime.getSatToTime());
        }
        if (setOperationDayAndTime.getThuFromTime() != null) {
            ((Extension)extensions.get()).setThuFromTime(setOperationDayAndTime.getThuFromTime());
        }
        if (setOperationDayAndTime.getThuToTime() != null) {
            ((Extension)extensions.get()).setThuToTime(setOperationDayAndTime.getThuToTime());
        }
        if (setOperationDayAndTime.getSunFromTime() != null) {
            ((Extension)extensions.get()).setSunFromTime(setOperationDayAndTime.getSunFromTime());
        }
        if (setOperationDayAndTime.getSunToTime() != null) {
            ((Extension)extensions.get()).setSunToTime(setOperationDayAndTime.getSunToTime());
        }
        if (setOperationDayAndTime.getTimezone() != null) {
            ((Extension)extensions.get()).setTimezone(setOperationDayAndTime.getTimezone());
        }
        if (setOperationDayAndTime.getToTime() != null) {
            ((Extension)extensions.get()).setToTime(setOperationDayAndTime.getToTime());
        }
        if (setOperationDayAndTime.getTueFromTime() != null) {
            ((Extension)extensions.get()).setTueFromTime(setOperationDayAndTime.getTueFromTime());
        }
        if (setOperationDayAndTime.getTueToTime() != null) {
            ((Extension)extensions.get()).setTueToTime(setOperationDayAndTime.getTueToTime());
        }
        if (setOperationDayAndTime.getWedFromTime() != null) {
            ((Extension)extensions.get()).setWedFromTime(setOperationDayAndTime.getWedFromTime());
        }
        if (setOperationDayAndTime.getWedToTime() != null) {
            ((Extension)extensions.get()).setWedToTime(setOperationDayAndTime.getWedToTime());
        }
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMultipleSetOperationDayAndTime(HttpServletRequest request, SetOperationDayAndTimeMultipleUpdate setOperationDayAndTimeMultipleUpdate, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        for (String extension : setOperationDayAndTimeMultipleUpdate.getExtensions()) {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            this.saveData(request, (Extension)extensions.get(), authentication);
            if (setOperationDayAndTimeMultipleUpdate.getDFri() != null) {
                ((Extension)extensions.get()).setDFri(setOperationDayAndTimeMultipleUpdate.getDFri());
            }
            if (setOperationDayAndTimeMultipleUpdate.getDMon() != null) {
                ((Extension)extensions.get()).setDMon(setOperationDayAndTimeMultipleUpdate.getDMon());
            }
            if (setOperationDayAndTimeMultipleUpdate.getDSat() != null) {
                ((Extension)extensions.get()).setDSat(setOperationDayAndTimeMultipleUpdate.getDSat());
            }
            if (setOperationDayAndTimeMultipleUpdate.getDSun() != null) {
                ((Extension)extensions.get()).setDSun(setOperationDayAndTimeMultipleUpdate.getDSun());
            }
            if (setOperationDayAndTimeMultipleUpdate.getDThu() != null) {
                ((Extension)extensions.get()).setDThu(setOperationDayAndTimeMultipleUpdate.getDThu());
            }
            if (setOperationDayAndTimeMultipleUpdate.getDTue() != null) {
                ((Extension)extensions.get()).setDTue(setOperationDayAndTimeMultipleUpdate.getDTue());
            }
            if (setOperationDayAndTimeMultipleUpdate.getDWed() != null) {
                ((Extension)extensions.get()).setDWed(setOperationDayAndTimeMultipleUpdate.getDWed());
            }
            if (setOperationDayAndTimeMultipleUpdate.getFlexibleTimings() != null) {
                ((Extension)extensions.get()).setFlexibleTimings(setOperationDayAndTimeMultipleUpdate.getFlexibleTimings());
            }
            if (setOperationDayAndTimeMultipleUpdate.getFriFromTime() != null) {
                ((Extension)extensions.get()).setFriFromTime(setOperationDayAndTimeMultipleUpdate.getFriFromTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getFriToTime() != null) {
                ((Extension)extensions.get()).setFriToTime(setOperationDayAndTimeMultipleUpdate.getFriToTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getFromTime() != null) {
                ((Extension)extensions.get()).setFromTime(setOperationDayAndTimeMultipleUpdate.getFromTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getMonFromTime() != null) {
                ((Extension)extensions.get()).setMonFromTime(setOperationDayAndTimeMultipleUpdate.getMonFromTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getMonToTime() != null) {
                ((Extension)extensions.get()).setMonToTime(setOperationDayAndTimeMultipleUpdate.getMonToTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getNightRingTime() != null) {
                ((Extension)extensions.get()).setNightRingTime(setOperationDayAndTimeMultipleUpdate.getNightRingTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getSatFromTime() != null) {
                ((Extension)extensions.get()).setSatFromTime(setOperationDayAndTimeMultipleUpdate.getSatFromTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getSatToTime() != null) {
                ((Extension)extensions.get()).setSatToTime(setOperationDayAndTimeMultipleUpdate.getSatToTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getSunFromTime() != null) {
                ((Extension)extensions.get()).setSunFromTime(setOperationDayAndTimeMultipleUpdate.getSunFromTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getSunToTime() != null) {
                ((Extension)extensions.get()).setSunToTime(setOperationDayAndTimeMultipleUpdate.getSunToTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getThuFromTime() != null) {
                ((Extension)extensions.get()).setThuFromTime(setOperationDayAndTimeMultipleUpdate.getThuFromTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getThuToTime() != null) {
                ((Extension)extensions.get()).setThuToTime(setOperationDayAndTimeMultipleUpdate.getThuToTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getTimezone() != null) {
                ((Extension)extensions.get()).setTimezone(setOperationDayAndTimeMultipleUpdate.getTimezone());
            }
            if (setOperationDayAndTimeMultipleUpdate.getToTime() != null) {
                ((Extension)extensions.get()).setToTime(setOperationDayAndTimeMultipleUpdate.getToTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getTueFromTime() != null) {
                ((Extension)extensions.get()).setTueFromTime(setOperationDayAndTimeMultipleUpdate.getTueFromTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getTueToTime() != null) {
                ((Extension)extensions.get()).setTueToTime(setOperationDayAndTimeMultipleUpdate.getTueToTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getWedFromTime() != null) {
                ((Extension)extensions.get()).setWedFromTime(setOperationDayAndTimeMultipleUpdate.getWedFromTime());
            }
            if (setOperationDayAndTimeMultipleUpdate.getWedToTime() != null) {
                ((Extension)extensions.get()).setWedToTime(setOperationDayAndTimeMultipleUpdate.getWedToTime());
            }
            this.extensionsRepository.save(extensions.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateSingleUCFeatures(HttpServletRequest request, String extension, UCFeatureModel ucFeatures, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("Records not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.saveData(request, (Extension)extensions.get(), authentication);
        if (ucFeatures.getAssignedUser() != null) {
            ((Extension)extensions.get()).setAssignedUser(ucFeatures.getAssignedUser());
        }
        if (ucFeatures.getXmpPId() != null) {
            ((Extension)extensions.get()).setXmpPId(ucFeatures.getXmpPId());
        }
        if (ucFeatures.getXmpPPassword() != null) {
            ((Extension)extensions.get()).setXmpPPassword(this.bcryptEncoder.encode((CharSequence)ucFeatures.getXmpPPassword()));
        }
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMultipleUCFeatures(HttpServletRequest request, UCFeaturesMultipleUpdate ucFeaturesMultipleUpdate, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        for (String extension : ucFeaturesMultipleUpdate.getExtensions()) {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            this.saveData(request, (Extension)extensions.get(), authentication);
            if (ucFeaturesMultipleUpdate.getAssignedUser() != null) {
                ((Extension)extensions.get()).setAssignedUser(ucFeaturesMultipleUpdate.getAssignedUser());
            }
            if (ucFeaturesMultipleUpdate.getXmpPId() != null) {
                ((Extension)extensions.get()).setXmpPId(ucFeaturesMultipleUpdate.getXmpPId());
            }
            if (ucFeaturesMultipleUpdate.getXmpPPassword() != null) {
                ((Extension)extensions.get()).setXmpPPassword(this.bcryptEncoder.encode((CharSequence)ucFeaturesMultipleUpdate.getXmpPPassword()));
            }
            this.extensionsRepository.save(extensions.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateSingleVoNrVoLte(HttpServletRequest request, String extension, VoNrVoLteModel voNrVoLte, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        Optional extensions = this.extensionsRepository.findByExtension(extension);
        if (!extensions.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("Records not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.saveData(request, (Extension)extensions.get(), authentication);
        if (voNrVoLte.getExtensionSubtype() != null) {
            ((Extension)extensions.get()).setExtensionSubtype(voNrVoLte.getExtensionSubtype());
        }
        if (voNrVoLte.getIMsi() != null) {
            ((Extension)extensions.get()).setIMSI(voNrVoLte.getIMsi());
        }
        if (voNrVoLte.getKValue() != null) {
            ((Extension)extensions.get()).setKValue(voNrVoLte.getKValue());
        }
        if (voNrVoLte.getOPopc() != null) {
            ((Extension)extensions.get()).setOPopc(voNrVoLte.getOPopc());
        }
        if (voNrVoLte.getMsiSdn() != null) {
            ((Extension)extensions.get()).setMsiSdn(voNrVoLte.getMsiSdn());
        }
        this.extensionsRepository.save(extensions.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMultipleVoNrVoLte(HttpServletRequest request, VoNrVoLteMultipleUpdate voNrVoLteMultipleUpdate, Authentication authentication) throws IOException {
        RequestResponse returnValue = new RequestResponse();
        for (String extension : voNrVoLteMultipleUpdate.getExtensions()) {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (!extensions.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Records not found ");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            this.saveData(request, (Extension)extensions.get(), authentication);
            if (voNrVoLteMultipleUpdate.getExtensionSubtype() != null) {
                ((Extension)extensions.get()).setExtensionSubtype(voNrVoLteMultipleUpdate.getExtensionSubtype());
            }
            if (voNrVoLteMultipleUpdate.getIMsi() != null) {
                ((Extension)extensions.get()).setIMSI(voNrVoLteMultipleUpdate.getIMsi());
            }
            if (voNrVoLteMultipleUpdate.getKValue() != null) {
                ((Extension)extensions.get()).setKValue(voNrVoLteMultipleUpdate.getKValue());
            }
            if (voNrVoLteMultipleUpdate.getMsiSdn() != null) {
                ((Extension)extensions.get()).setMsiSdn(voNrVoLteMultipleUpdate.getMsiSdn());
            }
            if (voNrVoLteMultipleUpdate.getOPopc() != null) {
                ((Extension)extensions.get()).setOPopc(voNrVoLteMultipleUpdate.getOPopc());
            }
            this.extensionsRepository.save(extensions.get());
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated ");
        returnValue.setMessageDetail("Data updated successfully ");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateHSS(String extensionNumber) {
        RequestResponse returnValue = new RequestResponse();
        Optional extension = this.extensionsRepository.findByExtension(extensionNumber);
        if (extension.isPresent()) {
            String imsi = ((Extension)extension.get()).getIMSI();
            String kValue = ((Extension)extension.get()).getKValue();
            String opc = Constants.MobilityDefaults.opcAsPassType ? ((Extension)extension.get()).getOPopc() : null;
            String op = Constants.MobilityDefaults.opcAsPassType ? null : ((Extension)extension.get()).getOPopc();
            String msisdn = extensionNumber;
            String amf = Constants.MobilityDefaults.amf;
            String mmeHost = MessageFormat.format("mme.epc.mnc{0}.mcc{1}.3gppnetwork.org", Constants.MobilityDefaults.mnc, Constants.MobilityDefaults.mcc);
            String mmeRealm = MessageFormat.format("epc.mnc{0}.mcc{1}.3gppnetwork.org", Constants.MobilityDefaults.mnc, Constants.MobilityDefaults.mcc);
            Optional data = this.hssRepository.findByImsi(imsi);
            HSS subscriber = null;
            if (data.isPresent()) {
                subscriber = (HSS)data.get();
                subscriber.getSecurity().setK(kValue);
                subscriber.getSecurity().setAmf(amf);
                subscriber.getSecurity().setOp(op);
                subscriber.getSecurity().setOpc(opc);
            } else {
                subscriber = new HSS();
                subscriber.setImsi(imsi);
                subscriber.getMsisdn().add(msisdn);
                subscriber.setSubscribed_RAU_TAU_Timer(Integer.valueOf(12));
                subscriber.setNetworkAccessMode(Integer.valueOf(0));
                subscriber.setSubscriberStatus(Integer.valueOf(0));
                subscriber.setAccessRestrictionData(Integer.valueOf(12));
                subscriber.setSchemaVersion(Integer.valueOf(1));
                subscriber.setV(Integer.valueOf(0));
                subscriber.setMmeHost(mmeHost);
                subscriber.setMmeRealm(mmeRealm);
                subscriber.setPurgeFlag(Boolean.valueOf(false));
                subscriber.getSecurity().setK(kValue);
                subscriber.getSecurity().setAmf(amf);
                subscriber.getSecurity().setOp(op);
                subscriber.getSecurity().setOpc(opc);
                subscriber.getAggregateMaximumBitRate().getDownlink().setUnit(Integer.valueOf(2));
                subscriber.getAggregateMaximumBitRate().getDownlink().setValue(Integer.valueOf(75));
                subscriber.getAggregateMaximumBitRate().getUplink().setUnit(Integer.valueOf(2));
                subscriber.getAggregateMaximumBitRate().getUplink().setValue(Integer.valueOf(20));
                Slice slice = new Slice();
                slice.setSst(Integer.valueOf(1));
                slice.setDefaultIndicator(Boolean.valueOf(true));
                Session internetSession = new Session();
                internetSession.setName("internet");
                internetSession.setType(Integer.valueOf(1));
                internetSession.getAmbr().getDownlink().setUnit(Integer.valueOf(2));
                internetSession.getAmbr().getDownlink().setValue(Integer.valueOf(75));
                internetSession.getAmbr().getUplink().setUnit(Integer.valueOf(2));
                internetSession.getAmbr().getUplink().setValue(Integer.valueOf(20));
                internetSession.getQos().setIndex(Integer.valueOf(9));
                internetSession.getQos().getArp().setPriorityLevel(Integer.valueOf(8));
                internetSession.getQos().getArp().setPreemptionCapability(Integer.valueOf(1));
                internetSession.getQos().getArp().setPreemptionVulnerability(Integer.valueOf(1));
                slice.getSession().add(internetSession);
                Session imsSession = new Session();
                imsSession.setName("ims");
                imsSession.setType(Integer.valueOf(1));
                imsSession.getAmbr().getDownlink().setUnit(Integer.valueOf(1));
                imsSession.getAmbr().getDownlink().setValue(Integer.valueOf(3850));
                imsSession.getAmbr().getUplink().setUnit(Integer.valueOf(1));
                imsSession.getAmbr().getUplink().setValue(Integer.valueOf(1530));
                imsSession.getQos().setIndex(Integer.valueOf(5));
                imsSession.getQos().getArp().setPriorityLevel(Integer.valueOf(1));
                imsSession.getQos().getArp().setPreemptionCapability(Integer.valueOf(1));
                imsSession.getQos().getArp().setPreemptionVulnerability(Integer.valueOf(1));
                PCCRule rule1 = new PCCRule();
                rule1.setQos(new QOS());
                rule1.getQos().setIndex(Integer.valueOf(1));
                rule1.getQos().setGbr(new BitRate());
                rule1.getQos().getGbr().getUplink().setUnit(Integer.valueOf(1));
                rule1.getQos().getGbr().getUplink().setValue(Integer.valueOf(128));
                rule1.getQos().getGbr().getDownlink().setUnit(Integer.valueOf(1));
                rule1.getQos().getGbr().getDownlink().setValue(Integer.valueOf(128));
                rule1.getQos().setMbr(new BitRate());
                rule1.getQos().getMbr().getUplink().setUnit(Integer.valueOf(1));
                rule1.getQos().getMbr().getUplink().setValue(Integer.valueOf(128));
                rule1.getQos().getMbr().getDownlink().setUnit(Integer.valueOf(1));
                rule1.getQos().getMbr().getDownlink().setValue(Integer.valueOf(128));
                rule1.getQos().getArp().setPriorityLevel(Integer.valueOf(2));
                rule1.getQos().getArp().setPreemptionCapability(Integer.valueOf(2));
                rule1.getQos().getArp().setPreemptionVulnerability(Integer.valueOf(2));
                imsSession.getPccRule().add(rule1);
                PCCRule rule2 = new PCCRule();
                rule2.setQos(new QOS());
                rule2.getQos().setIndex(Integer.valueOf(2));
                rule2.getQos().setGbr(new BitRate());
                rule2.getQos().getGbr().getUplink().setUnit(Integer.valueOf(1));
                rule2.getQos().getGbr().getUplink().setValue(Integer.valueOf(128));
                rule2.getQos().getGbr().getDownlink().setUnit(Integer.valueOf(1));
                rule2.getQos().getGbr().getDownlink().setValue(Integer.valueOf(128));
                rule2.getQos().setMbr(new BitRate());
                rule2.getQos().getMbr().getUplink().setUnit(Integer.valueOf(1));
                rule2.getQos().getMbr().getUplink().setValue(Integer.valueOf(128));
                rule2.getQos().getMbr().getDownlink().setUnit(Integer.valueOf(1));
                rule2.getQos().getMbr().getDownlink().setValue(Integer.valueOf(128));
                rule2.getQos().getArp().setPriorityLevel(Integer.valueOf(4));
                rule2.getQos().getArp().setPreemptionCapability(Integer.valueOf(2));
                rule2.getQos().getArp().setPreemptionVulnerability(Integer.valueOf(2));
                imsSession.getPccRule().add(rule2);
                slice.getSession().add(imsSession);
                subscriber.getSlice().add(slice);
            }
            this.hssRepository.save((Object)subscriber);
            returnValue.setData((Object)this.hssRepository.findByImsi(extensionNumber));
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage(MessageFormat.format("Extension {0} not found.", extensionNumber));
        }
        return returnValue;
    }

    public RequestResponse deleteHSS(String extensionNumber) {
        RequestResponse returnValue = new RequestResponse();
        Optional extension = this.extensionsRepository.findByExtension(extensionNumber);
        if (extension.isPresent()) {
            String imsi = ((Extension)extension.get()).getIMSI();
            Optional data = this.hssRepository.findByImsi(imsi);
            if (data.isPresent()) {
                this.hssRepository.delete(data.get());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage(MessageFormat.format("IMSI {0} for extension {1} not found in Core HSS.", imsi, extensionNumber));
            }
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage(MessageFormat.format("Extension {0} not found.", extensionNumber));
        }
        return returnValue;
    }

    public String extensionForCallBack(Authentication authentication) {
        return ((Extension)this.extensionsRepository.findByAssignedUserAndExtensionType(authentication.getName(), "phone").get()).getExtension();
    }

    public String getExtension(String username, String extensionType) {
        Optional data = this.extensionsRepository.findByAssignedUserAndExtensionType(username, extensionType);
        if (data.isPresent()) {
            return ((Extension)data.get()).getExtension();
        }
        return "";
    }

    public String getRluCodeForAll(String extension) {
        Optional data = this.extensionsRepository.findByExtension(extension);
        if (data.isPresent()) {
            return ((Extension)data.get()).getRluCode() == null ? "" : ((Extension)data.get()).getRluCode();
        }
        return "";
    }

    public String getSipPassword(String username) {
        Optional data = this.extensionsRepository.findByAssignedUserAndExtensionType(username, "phone");
        if (data.isPresent()) {
            return ((Extension)data.get()).getSipPassword();
        }
        return null;
    }

    public String getRluCode(String username, String extensionType) {
        Optional data = this.extensionsRepository.findByAssignedUserAndExtensionType(username, extensionType);
        if (data.isPresent()) {
            return ((Extension)data.get()).getRluCode();
        }
        return "";
    }

    public String getExtRluCode(String extension) {
        Optional data = this.extensionsRepository.findByExtension(extension);
        if (data.isPresent()) {
            return ((Extension)data.get()).getRluCode();
        }
        return "";
    }

    public String getRluCodeForCaller(String extension) {
        Optional data = this.extensionsRepository.findByExtension(extension);
        if (data.isPresent()) {
            return ((Extension)data.get()).getRluCode();
        }
        return "";
    }

    public String getExtensionName(String extension) {
        Optional data = this.extensionsRepository.findByExtension(extension);
        if (data.isPresent()) {
            return ((Extension)data.get()).getName();
        }
        return "";
    }

    public String getAssignedUser(String extension) {
        Optional data = this.extensionsRepository.findByExtension(extension);
        if (data.isPresent()) {
            if (((Extension)data.get()).getAssignedUser() != null && StringUtils.hasText((String)((Extension)data.get()).getAssignedUser())) {
                return ((Extension)data.get()).getAssignedUser();
            }
            List userData = this.userRepository.findByContactNo(extension);
            if (!userData.isEmpty()) {
                return ((User)userData.get(0)).getUsername();
            }
        }
        return "";
    }

    public String getExtensionOfUser(String username) {
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            String contactNo = ((User)user.get()).getContactNo();
            Optional data = this.extensionsRepository.findByExtension(contactNo);
            if (data.isPresent() && contactNo.equals(((Extension)data.get()).getExtension())) {
                String extensionType = ((Extension)data.get()).getExtensionType();
                if ("agent".equals(extensionType) || "phone".equals(extensionType)) {
                    return contactNo;
                }
            } else {
                Optional extension = this.extensionsRepository.findByAssignedUserAndExtensionType(username, "phone");
                if (extension.isPresent()) {
                    return ((Extension)extension.get()).getExtension();
                }
                return "";
            }
        }
        return "";
    }

    public RequestResponse getAllExtensionView(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ExtensionViewSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.extensionViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.extensionViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteAgentExtension(String extension) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional extensions = this.extensionsRepository.findByExtension(extension);
            if (extensions.isPresent()) {
                this.extensionsRepository.deleteById((Object)((Extension)extensions.get()).getId());
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("deleted");
                returnValue.setMessageDetail("Records deleted successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Agent not exist in extension");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to delete records");
            returnValue.setMessageDetail("Please contact the administrator");
            logger.info("error while deleting data", (Throwable)e);
        }
        return returnValue;
    }

    public List<String> getExtensionNumber() {
        List extensions = this.extensionsRepository.findAll();
        ArrayList<String> data = new ArrayList<String>();
        for (Extension row : extensions) {
            data.add(row.getExtension());
        }
        return data;
    }

    public RequestResponse getExtensionTypeEC() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ExtensionParticipantsModel> addValue = new ArrayList<ExtensionParticipantsModel>();
        List extensions = this.extensionsRepository.findAllByExtensionType("ec");
        if (extensions.isEmpty()) {
            returnValue.setMessage("List is empty");
            logger.error("unable to fetch data: ", (Object)returnValue.getMessage());
        } else {
            for (Extension row : extensions) {
                ExtensionParticipantsModel data = new ExtensionParticipantsModel();
                data.setId(row.getId());
                data.setConferenceNumber(row.getExtension());
                data.setExtensionType(row.getExtensionType());
                data.setZone(row.getZone());
                data.setDepartment(row.getDepartment());
                data.setParticipants(row.getData());
                addValue.add(data);
            }
        }
        returnValue.setData(addValue);
        returnValue.setMessage("List of Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllConferenceNumberAsExtensionNumber() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ExtensionNumberModel> addValue = new ArrayList<ExtensionNumberModel>();
        List list = this.extensionsRepository.findAll();
        if (list.isEmpty()) {
            returnValue.setMessage("List is empty");
            logger.error("unable to fetch data: ", (Object)returnValue.getMessage());
        } else {
            for (Extension extension : list) {
                if (extension.getExtensionType() == null || !extension.getExtensionType().equals("conf")) continue;
                ExtensionNumberModel data = new ExtensionNumberModel();
                data.setId(extension.getId());
                data.setExtension(extension.getExtension());
                data.setName(extension.getName());
                data.setExtensionType(extension.getExtensionType());
                addValue.add(data);
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        return returnValue;
    }

    public RequestResponse extensionList() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        List extension = this.extensionsRepository.findAll();
        if (extension.isEmpty()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Empty List ");
            logger.error("List Of Extension Is Empty");
        } else {
            extension.forEach(element -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", element.getExtension());
                map.put("name", element.getExtension() + "-" + element.getExtensionType());
                addValue.add(map);
            });
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("List Of Extension ");
            returnValue.setData(addValue);
            logger.info("List Of the Extension Has Been Retrieved ");
        }
        return returnValue;
    }

    public RequestResponse getRegisteredAndUnregistered() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        List extensionRegisteredView = this.extensionRegisteredViewRepository.findAll();
        if (extensionRegisteredView.isEmpty()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("List Is Empty");
            logger.error("Empty List Found");
        } else {
            for (ExtensionRegisteredView extension : extensionRegisteredView) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("extension", extension.getExtension());
                map.put("extensionType", extension.getExtensionType());
                if (extension.getName() != null && extension.getName() != "") {
                    map.put("name", extension.getName());
                } else {
                    map.put("name", extension.getExtension());
                }
                map.put("extensionSubtype", extension.getExtensionSubtype() != null ? extension.getExtensionSubtype() : " ");
                map.put("assignedUser", extension.getAssignedUser() != null ? extension.getAssignedUser() : " ");
                map.put("rluCode", extension.getRluCode() != null ? extension.getRluCode() : " ");
                map.put("registeredOn", extension.getCreatedOn() != null ? extension.getCreatedOn() : " ");
                map.put("userAgent", extension.getUserAgent() != null ? extension.getUserAgent() : " ");
                map.put("contact", extension.getContact() != null ? extension.getContact() : " ");
                map.put("expiredOn", extension.getExpires() != null ? extension.getExpires() : " ");
                map.put("status", extension.isStatus());
                map.put("currentEpoch", Instant.now().getEpochSecond());
                addValue.add(map);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("List retrieved successfully");
            returnValue.setData(addValue);
        }
        return returnValue;
    }

    public RequestResponse getAllRLUCode() {
        List list = this.extensionsRepository.findAll();
        HashSet<String> uniqueRluCode = new HashSet<String>();
        RequestResponse returnValue = new RequestResponse();
        for (Extension extension : list) {
            uniqueRluCode.add(extension.getRluCode());
        }
        ArrayList<ExtensionRluCodeModel> addValue = new ArrayList<ExtensionRluCodeModel>();
        for (String rluCode : uniqueRluCode) {
            ExtensionRluCodeModel data = new ExtensionRluCodeModel();
            data.setRluCode(rluCode);
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllAgent() {
        List list = this.extensionsRepository.findByExtensionType("agent");
        ArrayList<ExtensionNumberModel> addValue = new ArrayList<ExtensionNumberModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Extension extension : list) {
            ExtensionNumberModel data = new ExtensionNumberModel();
            data.setId(extension.getId());
            data.setExtension(extension.getExtension());
            data.setName(extension.getName());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getContacts() {
        RequestResponse returnValue = new RequestResponse();
        ContactData data = new ContactData();
        ArrayList<String> extType = new ArrayList<String>();
        extType.add("phone");
        extType.add("acd");
        extType.add("dialplan");
        List extensions = this.extensionsRepository.findByExtensionTypeIn(extType);
        for (Extension extension : extensions) {
            CodeValue dataElement;
            data.getContacts().add(new CodeValue(extension.getExtension(), extension.getName(), extension.getDesignation(), this.userService.getUserByExtension(extension.getExtension())));
            if (StringUtils.hasLength((String)extension.getDepartment())) {
                dataElement = new CodeValue(extension.getDepartment(), extension.getDepartment(), extension.getDesignation(), this.userService.getUserByExtension(extension.getExtension()));
                if (!data.getDepartments().contains(dataElement)) {
                    data.getDepartments().add(dataElement);
                }
            }
            if (!StringUtils.hasLength((String)extension.getZone())) continue;
            dataElement = new CodeValue(extension.getZone(), extension.getZone(), extension.getDesignation(), this.userService.getUserByExtension(extension.getExtension()));
            if (data.getZone().contains(dataElement)) continue;
            data.getZone().add(dataElement);
        }
        returnValue.setData((Object)data);
        return returnValue;
    }

    public RequestResponse getFilteredExtension(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ExtensionSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.extensionsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.extensionsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getListOfExtensionTypePhoneWithDepartmentNotNull() {
        List list = this.extensionsRepository.findAllByExtensionType("ec");
        HashSet distinctDepartments = new HashSet();
        List addValue = list.stream().filter(extension -> extension.getDepartment() != null && !extension.getDepartment().isEmpty()).filter(extension -> distinctDepartments.add(extension.getDepartment())).map(extension -> {
            ExtensionDepartmentModel data = new ExtensionDepartmentModel();
            data.setId(extension.getId());
            data.setExtension(extension.getExtension());
            data.setName(extension.getName());
            data.setExtensionType(extension.getExtensionType());
            data.setDepartment(extension.getDepartment());
            Optional departmentOptional = this.departmentRepository.findByCode(extension.getDepartment());
            if (departmentOptional.isPresent()) {
                data.setDepartmentDescription(((Department)departmentOptional.get()).getDescription());
            }
            data.setColor(this.getColorOfDepartment(extension.getDepartment()));
            return data;
        }).collect(Collectors.toList());
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getListOfExtensionTypePhoneWithZoneNotNull() {
        List list = this.extensionsRepository.findAllByExtensionType("ec");
        ArrayList<ExtensionZoneModel> addValue = new ArrayList<ExtensionZoneModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Extension extensions : list) {
            if (extensions.getZone() == null || extensions.getZone().equals("")) continue;
            ExtensionZoneModel data = new ExtensionZoneModel();
            data.setId(extensions.getId());
            data.setExtension(extensions.getExtension());
            data.setName(extensions.getName());
            data.setExtensionType(extensions.getExtensionType());
            data.setZone(extensions.getZone());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse departmentCall(Principal principal, MCXCallModel data) {
        RequestResponse returnValue;
        block11: {
            returnValue = new RequestResponse();
            String callerNumber = "";
            if (!StringUtils.hasLength((String)data.getDepartment()) || !StringUtils.hasLength((String)data.getCallType())) {
                logger.error("Invalid call type:{} or department:{}", (Object)data.getCallType(), (Object)data.getDepartment());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Invalid call type or department");
                return returnValue;
            }
            try {
                String loggedInNumber = this.getExtensionOfUser(principal.getName());
                String ip = this.cdrService.getIpProxyServer();
                ArrayList<String> destinationNumber = new ArrayList<String>();
                List groupNameList = this.extensionsRepository.findByExtensionTypeAndDepartment("ec", data.getDepartment());
                if (groupNameList.isEmpty()) {
                    logger.error("Not any record exist of given group department:{}", (Object)data.getDepartment());
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("No data present in given department");
                    return returnValue;
                }
                Extension groupNameData = (Extension)groupNameList.get(0);
                callerNumber = groupNameData.getExtension();
                logger.info("Caller number of selected group is:{}", (Object)callerNumber);
                String rluCode = this.controlRluServerService.getRluCodeFinal(callerNumber);
                String sofiaProfile = this.controlRluServerService.getProfileName(callerNumber);
                logger.info("RluCode is:{}", (Object)(rluCode + "SofiaProfile is:{}"), (Object)sofiaProfile);
                List extensionList = this.extensionsRepository.findByExtensionTypeAndDepartment("phone", data.getDepartment());
                if (!extensionList.isEmpty()) {
                    for (Extension extensionData : extensionList) {
                        String extensionNumber;
                        if (extensionData.getDepartment() == null || (extensionNumber = extensionData.getExtension()).equals(loggedInNumber)) continue;
                        destinationNumber.add(extensionNumber);
                    }
                } else {
                    logger.error("Not any record exist of given department:{}", (Object)data.getDepartment());
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("No data present in given department");
                    return returnValue;
                }
                logger.info("List of Destination number:{}", destinationNumber);
                if (destinationNumber.isEmpty()) break block11;
                for (String destination : destinationNumber) {
                    if (this.getRegisteredExtension().contains(destination)) {
                        String command;
                        logger.info("Caller:{} and destination:{}", (Object)callerNumber, (Object)destination);
                        logger.info("Type of call is:{}", (Object)data.getCallType());
                        if (data.getCallType().equalsIgnoreCase("presenter")) {
                            command = "";
                            command = data.getIsAudioOnly() != null && data.getIsAudioOnly().booleanValue() ? (data.getIsBroadCast() != null && data.getIsBroadCast().booleanValue() ? String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,absolute_codec_string='PCMU,PCMA', origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,absolute_codec_string='PCMU,PCMA', origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber)) : (data.getIsBroadCast() != null && data.getIsBroadCast() != false ? String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber));
                            logger.info("command to execute call is:::{}", (Object)command);
                            Telephony.makeCallBackCall((String)command);
                            returnValue.setStatus(Constants.Error.OK);
                            returnValue.setMessage("Call execute successfully");
                            continue;
                        }
                        if (data.getCallType().equalsIgnoreCase("muxing")) {
                            command = "";
                            command = data.getIsAudioOnly() != null && data.getIsAudioOnly().booleanValue() ? (data.getIsBroadCast() != null && data.getIsBroadCast().booleanValue() ? String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,absolute_codec_string='PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,absolute_codec_string='PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber)) : (data.getIsBroadCast() != null && data.getIsBroadCast() != false ? String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber));
                            logger.info("command to execute call is:::{}", (Object)command);
                            Telephony.makeCallBackCall((String)command);
                            returnValue.setStatus(Constants.Error.OK);
                            returnValue.setMessage("Call execute successfully");
                            continue;
                        }
                        returnValue.setStatus(Constants.Error.ERROR);
                        returnValue.setMessage("Invalid call type");
                        logger.error("Invalid call type select:{}", (Object)data.getCallType());
                        break;
                    }
                    logger.error("Not Registered:Call not originate for Number:{}", (Object)destination);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("error during call initiation:{}", (Object)e.getMessage());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Unable to execute call");
            }
        }
        return returnValue;
    }

    public RequestResponse zoneCall(Principal principal, MCXCallModel data) {
        RequestResponse returnValue;
        block10: {
            returnValue = new RequestResponse();
            String callerNumber = "";
            logger.info("Call initiate for Zone:{}", (Object)data.getZone());
            if (!StringUtils.hasLength((String)data.getZone()) || !StringUtils.hasLength((String)data.getCallType())) {
                logger.error("Invalid call type:{} or zone:{}", (Object)data.getCallType(), (Object)data.getZone());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Invalid call type or zone");
                return returnValue;
            }
            try {
                String loggedInNumber = this.getExtensionOfUser(principal.getName());
                String ip = this.cdrService.getIpProxyServer();
                ArrayList<String> destinationNumber = new ArrayList<String>();
                List groupNameList = this.extensionsRepository.findByExtensionTypeAndZone("ec", data.getZone());
                if (groupNameList.isEmpty()) {
                    logger.error("Not any record exist of given group zone:{}", (Object)data.getZone());
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("No data present in given zone");
                    return returnValue;
                }
                Extension groupNameData = (Extension)groupNameList.get(0);
                callerNumber = groupNameData.getExtension();
                logger.info("Caller number of selected group is:{}", (Object)callerNumber);
                String rluCode = this.controlRluServerService.getRluCodeFinal(callerNumber);
                String sofiaProfile = this.controlRluServerService.getProfileName(callerNumber);
                logger.info("RluCode is:{}", (Object)(rluCode + "SofiaProfile is:{}"), (Object)sofiaProfile);
                List extensionList = this.extensionsRepository.findByExtensionTypeAndZone("phone", data.getZone());
                if (!extensionList.isEmpty()) {
                    for (Extension extensionData : extensionList) {
                        String extensionNumber = extensionData.getExtension();
                        if (extensionNumber.equals(loggedInNumber)) continue;
                        destinationNumber.add(extensionNumber);
                    }
                } else {
                    logger.error("Not any record exist of given zone:{}", (Object)data.getZone());
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("No data present in given zone");
                    return returnValue;
                }
                logger.info("List of Destination number:{}", destinationNumber);
                if (destinationNumber.isEmpty()) break block10;
                for (String destination : destinationNumber) {
                    String command;
                    logger.info("Caller:{} and destination:{}", (Object)callerNumber, (Object)destination);
                    logger.info("Type of call is:{}", (Object)data.getCallType());
                    if (data.getCallType().equalsIgnoreCase("presenter")) {
                        command = "";
                        command = data.getIsAudioOnly() != null && data.getIsAudioOnly().booleanValue() ? (data.getIsBroadCast() != null && data.getIsBroadCast().booleanValue() ? String.format("fs_cli -x \"bgapi originate {absolute_codec_string='PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {absolute_codec_string='PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber)) : (data.getIsBroadCast() != null && data.getIsBroadCast() != false ? String.format("fs_cli -x \"bgapi originate {origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber));
                        logger.info("command to execute call is:::{}", (Object)command);
                        Telephony.makeCallBackCall((String)command);
                        returnValue.setStatus(Constants.Error.OK);
                        returnValue.setMessage("Call execute successfully");
                        continue;
                    }
                    if (data.getCallType().equalsIgnoreCase("muxing")) {
                        command = "";
                        command = data.getIsAudioOnly() != null && data.getIsAudioOnly().booleanValue() ? (data.getIsBroadCast() != null && data.getIsBroadCast().booleanValue() ? String.format("fs_cli -x \"bgapi originate {absolute_codec_string='PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {absolute_codec_string='PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber)) : (data.getIsBroadCast() != null && data.getIsBroadCast() != false ? String.format("fs_cli -x \"bgapi originate {origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber));
                        logger.info("command to execute call is:::{}", (Object)command);
                        Telephony.makeCallBackCall((String)command);
                        returnValue.setStatus(Constants.Error.OK);
                        returnValue.setMessage("Call execute successfully");
                        continue;
                    }
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Invalid call type");
                    logger.error("Invalid call type select:{}", (Object)data.getCallType());
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("error during call initiation:{}", (Object)e.getMessage());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Unable to execute call");
            }
        }
        return returnValue;
    }

    public RequestResponse updateApplicationIdByExtension(ExtensionsModel data) {
        logger.debug("Update ApplicationId {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional extension = this.extensionsRepository.findByExtension(data.getExtension());
        if (!extension.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("Extension not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getApplicationId() != null) {
            ((Extension)extension.get()).setApplicationId(data.getApplicationId());
        }
        this.extensionsRepository.save(extension.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("ApplicationId Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public synchronized RequestResponse createDataInExtension(ExtensionModelCreate data) {
        logger.debug("create new extension : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional info = this.extensionsRepository.findByExtension(data.getExtension());
            if (info.isPresent()) {
                returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
                returnValue.setMessage("Extension already exists");
                returnValue.setMessageDetail("Please enter different extension");
                return returnValue;
            }
            if (CustomerAccountService.getClickToCall() && (data.getExtensionType().equalsIgnoreCase("conference") || data.getExtensionType().equalsIgnoreCase("conf"))) {
                String frontendValue;
                String dbValue;
                CLIServerCommandLog log;
                CLIServerCommandLog cliServerCommandLog;
                Optional extension = info;
                Optional didMappingOptional = this.didMappingRepository.findByExtNumber(data.getExtension());
                if (StringUtils.hasLength((String)data.getExtension()) && data.getExtensionType().equalsIgnoreCase("conference")) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("conference create %s", data.getExtension()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info("conference create {}", (Object)data.getExtension());
                }
                if (StringUtils.hasLength((String)data.getExtension()) && data.getExtensionType().equalsIgnoreCase("conf")) {
                    cliServerCommandLog = new CLIServerCommandLog();
                    cliServerCommandLog.setCLICommand(String.format("extension create %s conferencenumber", data.getExtension()));
                    this.customerAccountService.cliServerCommandLog2(cliServerCommandLog);
                    logger.info("extension create {} conferencenumber", (Object)data.getExtension());
                }
                Thread.sleep(4000L);
                if (StringUtils.hasLength((String)data.getDid()) || didMappingOptional.isPresent() && StringUtils.hasLength((String)((DidMapping)didMappingOptional.get()).getDidNumber())) {
                    CLIServerCommandLog cliLog;
                    String dbDid = didMappingOptional.map(DidMapping::getDidNumber).orElse(null);
                    String frontendDid = data.getDid();
                    if (!StringUtils.hasLength((String)dbDid) && !StringUtils.hasLength((String)frontendDid)) {
                        logger.info("No DID change, skipping CLI command.");
                    } else if (StringUtils.hasLength((String)frontendDid) && !StringUtils.hasLength((String)dbDid)) {
                        cliLog = new CLIServerCommandLog();
                        String command = String.format("conference update %s did %s", data.getExtension(), frontendDid);
                        cliLog.setCLICommand(command);
                        this.customerAccountService.cliServerCommandLog2(cliLog);
                        logger.info(command);
                    } else if (StringUtils.hasLength((String)frontendDid) && !frontendDid.equals(dbDid)) {
                        cliLog = new CLIServerCommandLog();
                        String command = String.format("conference update %s did %s", data.getExtension(), frontendDid);
                        cliLog.setCLICommand(command);
                        this.customerAccountService.cliServerCommandLog2(cliLog);
                        logger.info(command);
                    } else {
                        logger.info("No change in DID, skipping CLI command.");
                    }
                }
                if (StringUtils.hasLength((String)data.getDod()) || didMappingOptional.isPresent() && StringUtils.hasLength((String)((DidMapping)didMappingOptional.get()).getDodNumber())) {
                    String dbDod = didMappingOptional.map(DidMapping::getDodNumber).orElse(null);
                    String frontendDod = data.getDod();
                    if (!StringUtils.hasLength((String)dbDod) && !StringUtils.hasLength((String)frontendDod)) {
                        logger.info("No DOD change, skipping CLI command.");
                    } else if (StringUtils.hasLength((String)frontendDod) && !StringUtils.hasLength((String)dbDod)) {
                        log = new CLIServerCommandLog();
                        log.setCLICommand(String.format("extension update %s dod %s", data.getExtension(), frontendDod));
                        this.customerAccountService.cliServerCommandLog2(log);
                        logger.info("extension update {} dod {}", (Object)data.getExtension(), (Object)frontendDod);
                    } else if (StringUtils.hasLength((String)frontendDod) && !frontendDod.equals(dbDod)) {
                        log = new CLIServerCommandLog();
                        log.setCLICommand(String.format("extension update %s dod %s", data.getExtension(), frontendDod));
                        this.customerAccountService.cliServerCommandLog2(log);
                        logger.info("extension update {} dod {}", (Object)data.getExtension(), (Object)frontendDod);
                    } else {
                        logger.info("No change in DOD, skipping CLI command.");
                    }
                }
                if (StringUtils.hasLength((String)data.getNonworkingApp()) || extension.isPresent() && StringUtils.hasLength((String)((Extension)extension.get()).getNonworkingApp())) {
                    dbValue = extension.isPresent() ? ((Extension)extension.get()).getNonworkingApp() : null;
                    frontendValue = data.getNonworkingApp();
                    if (StringUtils.hasLength((String)dbValue) || StringUtils.hasLength((String)frontendValue)) {
                        if (!StringUtils.hasLength((String)dbValue) && StringUtils.hasLength((String)frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s nbhapplication %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} nbhapplication {}", (Object)data.getExtension(), (Object)frontendValue);
                        } else if (StringUtils.hasLength((String)dbValue) && !StringUtils.hasLength((String)frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s nbhapplication reset", data.getExtension()));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} nbhapplication reset", (Object)data.getExtension());
                        } else if (!dbValue.equals(frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s nbhapplication %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} nbhapplication {}", (Object)data.getExtension(), (Object)frontendValue);
                        }
                    }
                }
                if (StringUtils.hasLength((String)data.getNonworkingData()) || extension.isPresent() && StringUtils.hasLength((String)((Extension)extension.get()).getNonworkingData())) {
                    dbValue = extension.isPresent() ? ((Extension)extension.get()).getNonworkingData() : null;
                    frontendValue = data.getNonworkingData();
                    if (StringUtils.hasLength((String)dbValue) || StringUtils.hasLength((String)frontendValue)) {
                        if (!StringUtils.hasLength((String)dbValue) && StringUtils.hasLength((String)frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s nbhtransfernum %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} nbhtransfernum {}", (Object)data.getExtension(), (Object)frontendValue);
                        } else if (StringUtils.hasLength((String)dbValue) && !StringUtils.hasLength((String)frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s nbhtransfernum reset", data.getExtension()));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} nbhtransfernum reset", (Object)data.getExtension());
                        } else if (!dbValue.equals(frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s nbhtransfernum %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} nbhtransfernum {}", (Object)data.getExtension(), (Object)frontendValue);
                        }
                    }
                }
                if (data.getFromTime() != null || data.getFromTime() == null && extension.isPresent() && ((Extension)extension.get()).getFromTime() != null) {
                    dbValue = extension.isPresent() && ((Extension)extension.get()).getFromTime() != null ? ((Extension)extension.get()).getFromTime().toString() : null;
                    String string = frontendValue = data.getFromTime() != null ? data.getFromTime().toString() : null;
                    if (dbValue != null || frontendValue != null) {
                        if (dbValue == null && frontendValue != null) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s fromtime %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} fromtime {}", (Object)data.getExtension(), (Object)frontendValue);
                        } else if (!dbValue.equals(frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s fromtime %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} fromtime {}", (Object)data.getExtension(), (Object)frontendValue);
                        }
                    }
                }
                if (data.getToTime() != null || data.getToTime() == null && extension.isPresent() && ((Extension)extension.get()).getToTime() != null) {
                    dbValue = extension.isPresent() && ((Extension)extension.get()).getToTime() != null ? ((Extension)extension.get()).getToTime().toString() : null;
                    String string = frontendValue = data.getToTime() != null ? data.getToTime().toString() : null;
                    if (dbValue != null || frontendValue != null) {
                        if (dbValue == null && frontendValue != null) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s totime %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} totime {}", (Object)data.getExtension(), (Object)frontendValue);
                        } else if (!dbValue.equals(frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s totime %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} totime {}", (Object)data.getExtension(), (Object)frontendValue);
                        }
                    }
                }
                if (data.getTpi() != null) {
                    dbValue = null;
                    if (extension.isPresent() && ((Extension)extension.get()).getTpi() != null) {
                        dbValue = ((Extension)extension.get()).getTpi() != false ? "on" : "off";
                    }
                    String string = frontendValue = data.getTpi() != false ? "on" : "off";
                    if (!Objects.equals(dbValue, frontendValue)) {
                        log = new CLIServerCommandLog();
                        log.setCLICommand(String.format("extension update %s tpi %s", data.getExtension(), frontendValue));
                        this.customerAccountService.cliServerCommandLog2(log);
                        logger.info("extension update {} tpi {}", (Object)data.getExtension(), (Object)frontendValue);
                    }
                }
                if (StringUtils.hasLength((String)data.getTimezone())) {
                    dbValue = null;
                    if (extension.isPresent() && StringUtils.hasLength((String)((Extension)extension.get()).getTimezone())) {
                        dbValue = ((Extension)extension.get()).getTimezone();
                    }
                    frontendValue = data.getTimezone();
                    if (!StringUtils.hasLength((String)dbValue) && StringUtils.hasLength((String)frontendValue)) {
                        log = new CLIServerCommandLog();
                        log.setCLICommand(String.format("extension update %s timezone %s", data.getExtension(), frontendValue));
                        this.customerAccountService.cliServerCommandLog2(log);
                        logger.info("extension update {} timezone {}", (Object)data.getExtension(), (Object)frontendValue);
                    } else if (StringUtils.hasLength((String)dbValue) && !dbValue.equals(frontendValue)) {
                        log = new CLIServerCommandLog();
                        log.setCLICommand(String.format("extension update %s timezone %s", data.getExtension(), frontendValue));
                        this.customerAccountService.cliServerCommandLog2(log);
                        logger.info("extension update {} timezone {}", (Object)data.getExtension(), (Object)frontendValue);
                    }
                }
                if (StringUtils.hasLength((String)data.getName()) || extension.isPresent() && StringUtils.hasLength((String)((Extension)extension.get()).getName())) {
                    String dbName = extension.isPresent() ? ((Extension)extension.get()).getName() : null;
                    String frontendName = data.getName();
                    if (StringUtils.hasLength((String)dbName) || StringUtils.hasLength((String)frontendName)) {
                        if (!StringUtils.hasLength((String)dbName) && StringUtils.hasLength((String)frontendName)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s name %s", data.getExtension(), frontendName));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} name {}", (Object)data.getExtension(), (Object)frontendName);
                        } else if (StringUtils.hasLength((String)dbName) && !StringUtils.hasLength((String)frontendName)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s name reset", data.getExtension()));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} name reset", (Object)data.getExtension());
                        } else if (!dbName.equals(frontendName)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s name %s", data.getExtension(), frontendName));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} name {}", (Object)data.getExtension(), (Object)frontendName);
                        }
                    }
                }
                Thread.sleep(4000L);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("Kindly wait for sometime to reflect changes");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            Extension extension = new Extension();
            extension.setFailOver(data.getFailOver());
            extension.setABarTimeout(data.getABarTimeout());
            extension.setAccountCode(data.getAccountCode());
            extension.setAcdCallback(data.getAcdCallback());
            extension.setAcdPickupGroup(data.getAcdPickupGroup());
            extension.setAlertInfo(data.getAlertInfo());
            extension.setAnonymousCallRejection(data.getAnonymousCallRejection());
            extension.setApplicationId(data.getApplicationId());
            extension.setAutoLift(data.getAutoLift());
            extension.setBrowserExt(data.getBrowserExt());
            extension.setBusyReleaseInterval(data.getBusyReleaseInterval());
            extension.setCFNATime(data.getCFNATime());
            extension.setCallContext(data.getCallContext());
            extension.setCallForwardNumber(data.getCallForwardNumber());
            extension.setCallTrace(data.getCallTrace());
            extension.setCallWaitingStatus(data.getCallWaitingStatus());
            extension.setCallerIdStatus(data.getCallerIdStatus());
            extension.setCallerOverrideToHoldParty(data.getCallerOverrideToHoldParty());
            extension.setCallerStrip(data.getCallerStrip());
            extension.setCampOnHoldMusic(data.getCampOnHoldMusic());
            extension.setCampOnRetryInterval(data.getCampOnRetryInterval());
            extension.setCanBroadcast(data.getCanBroadcast());
            extension.setCanMulticast(data.getCanMulticast());
            extension.setCheckIn(data.getCheckIn());
            extension.setCheckInEpoch(data.getCheckInEpoch());
            extension.setChimeInterval(data.getChimeInterval());
            extension.setChimePath(data.getChimePath());
            extension.setCodeBlueSentSmsConfig(data.getCodeBlueSentSmsConfig());
            extension.setCollaboration(data.getCollaboration());
            extension.setColumn1(data.getColumn1());
            extension.setColumn2(data.getColumn2());
            extension.setColumn3(data.getColumn3());
            extension.setColumn4(data.getColumn4());
            extension.setColumn5(data.getColumn5());
            extension.setColumn6(data.getColumn6());
            extension.setColumn7(data.getColumn7());
            extension.setColumn8(data.getColumn8());
            extension.setColumn9(data.getColumn9());
            extension.setColumn10(data.getColumn10());
            extension.setColumn11(data.getColumn11());
            extension.setColumn12(data.getColumn12());
            extension.setColumn13(data.getColumn13());
            extension.setColumn14(data.getColumn14());
            extension.setColumn15(data.getColumn15());
            extension.setColumn16(data.getColumn16());
            extension.setConfPwd(data.getConfPwd());
            extension.setConferenceMode(data.getConferenceMode());
            extension.setConfigEmailId(data.getConfigEmailId());
            extension.setConfirmationWavFile(data.getConfirmationWavFile());
            extension.setControlName(data.getControlName());
            extension.setCoralAcdCallType(data.getCoralAcdCallType());
            extension.setCurrentChannel(data.getCurrentChannel());
            extension.setCustomeDestination(data.getCustomeDestination());
            extension.setExtension(data.getExtension());
            extension.setExtensionType(data.getExtensionType());
            extension.setName(data.getName());
            extension.setCFNATime(data.getCFNATime());
            extension.setVideoCall(data.getVideoCall());
            extension.setWavFilename(data.getWavFilename());
            extension.setPCMA(data.getPCMA());
            extension.setPCMU(data.getPCMU());
            extension.setG722(data.getG722());
            extension.setG726(data.getG726());
            extension.setG729(data.getG729());
            extension.setG723(data.getG723());
            extension.setOpus(data.getOpus());
            extension.setVp8(data.getVp8());
            extension.setH263(data.getH263());
            extension.setH264(data.getH264());
            extension.setDayInboundCos(data.getDayInboundCos());
            extension.setNightInboundCos(data.getNightInboundCos());
            extension.setDayOutboundCos(data.getDayOutboundCos());
            extension.setNightOutboundCos(data.getNightOutboundCos());
            extension.setSecondaryDayInboundCos(data.getSecondaryDayInboundCos());
            extension.setSecondaryDayOutboundCos(data.getSecondaryDayOutboundCos());
            extension.setSecondaryNightInboundCos(data.getSecondaryNightInboundCos());
            extension.setSecondaryNightOutboundCos(data.getSecondaryNightOutboundCos());
            extension.setPrimaryDayInboundCos(data.getPrimaryDayInboundCos());
            extension.setPrimaryDayOutboundCos(data.getPrimaryDayOutboundCos());
            extension.setIMEINumber(data.getIMEINumber());
            extension.setTimeOutInSecond(data.getTimeOutInSecond());
            extension.setRingTime(data.getRingTime());
            extension.setCompany(data.getCompany());
            extension.setDepartment(data.getDepartment());
            extension.setDesignation(data.getDesignation());
            extension.setSecretary(data.getSecretary());
            extension.setCollaboration(data.getCollaboration());
            extension.setAccountCode(data.getAccountCode());
            extension.setData(data.getData());
            extension.setExtGroupId(data.getExtGroupId());
            extension.setPforkStr(data.getPforkStr());
            extension.setRecord(data.getRecord());
            extension.setEmailId(data.getEmailId());
            extension.setRluCode(data.getRluCode());
            extension.setCallWaitingStatus(data.getCallWaitingStatus());
            extension.setRingBackTone(data.getRingBackTone());
            extension.setGroupCode(data.getGroupCode());
            extension.setIsCampOnMode(data.getIsCampOnMode());
            extension.setCallTransferToVm(data.getCallTransferToVm());
            extension.setWelcomeGreeting(data.getWelcomeGreeting());
            extension.setOverflowToBoss(data.getOverflowToBoss());
            extension.setSplitRecordingFileInMinutes(data.getSplitRecordingFileInMinutes());
            extension.setPhoneStatus(data.getPhoneStatus());
            extension.setDayMode(data.getDayMode());
            extension.setNightMode(data.getNightMode());
            extension.setNonworkingData(data.getNonworkingData());
            extension.setNonworkingApp(data.getNonworkingApp());
            extension.setManufacturerId(data.getManufacturerId());
            extension.setModelDetailId(data.getModelDetailId());
            extension.setPersonalVmGreeting(data.getPersonalVmGreeting());
            extension.setMacId(data.getMacId());
            extension.setSrtP(data.getSrtP());
            extension.setZrtP(data.getZrtP());
            if (data.getDSun() != null && data.getDSun().booleanValue()) {
                extension.setDSun(Integer.valueOf(1));
            } else {
                extension.setDSun(Integer.valueOf(0));
            }
            if (data.getDMon() != null && data.getDMon().booleanValue()) {
                extension.setDMon(Integer.valueOf(1));
            } else {
                extension.setDMon(Integer.valueOf(0));
            }
            if (data.getDTue() != null && data.getDTue().booleanValue()) {
                extension.setDTue(Integer.valueOf(1));
            } else {
                extension.setDTue(Integer.valueOf(0));
            }
            if (data.getDWed() != null && data.getDWed().booleanValue()) {
                extension.setDWed(Integer.valueOf(1));
            } else {
                extension.setDWed(Integer.valueOf(0));
            }
            if (data.getDThu() != null && data.getDThu().booleanValue()) {
                extension.setDThu(Integer.valueOf(1));
            } else {
                extension.setDThu(Integer.valueOf(0));
            }
            if (data.getDFri() != null && data.getDFri().booleanValue()) {
                extension.setDFri(Integer.valueOf(1));
            } else {
                extension.setDFri(Integer.valueOf(0));
            }
            if (data.getDSat() != null && data.getDSat().booleanValue()) {
                extension.setDSat(Integer.valueOf(1));
            } else {
                extension.setDSat(Integer.valueOf(0));
            }
            extension.setFromTime(data.getFromTime());
            extension.setToTime(data.getToTime());
            extension.setFriFromTime(data.getFriFromTime());
            extension.setFriToTime(data.getFriToTime());
            extension.setFlexibleTimings(data.getFlexibleTimings());
            extension.setMonFromTime(data.getMonFromTime());
            extension.setMonToTime(data.getMonToTime());
            extension.setTueFromTime(data.getTueFromTime());
            extension.setTueToTime(data.getTueToTime());
            extension.setWedFromTime(data.getWedFromTime());
            extension.setWedToTime(data.getWedToTime());
            extension.setThuFromTime(data.getThuFromTime());
            extension.setThuToTime(data.getThuToTime());
            extension.setSatFromTime(data.getSatFromTime());
            extension.setSatToTime(data.getSatToTime());
            extension.setNightRingTime(data.getNightRingTime());
            extension.setXmpPId(data.getXmpPId());
            extension.setAssignedUser(data.getAssignedUser());
            extension.setSmsText(data.getSmsText());
            extension.setIsSent(data.getIsSent());
            extension.setNoOfRetry(data.getNoOfRetry());
            extension.setUrl(data.getUrl());
            extension.setDialNumber(data.getDialNumber());
            extension.setSmsNumber(data.getSmsNumber());
            extension.setStar(data.getStar());
            extension.setParkExpiryInterval(data.getParkExpiryInterval());
            extension.setDestinationStrip(data.getDestinationStrip());
            extension.setOutboundGatewayGroup(data.getOutboundGatewayGroup());
            extension.setMaxChannel(data.getMaxChannel());
            extension.setIsCliBaseRouting(data.getIsCliBaseRouting());
            extension.setIsCallCenterBased(data.getIsCallCenterBased());
            extension.setStrategy(data.getStrategy());
            extension.setRestrictFeatureAccess(data.getRestrictFeatureAccess());
            extension.setVoicemail(data.getVoicemail());
            extension.setQueryOn(data.getQueryOn());
            extension.setRetryVoiceMessage(data.getRetryVoiceMessage());
            extension.setGatewayControllerCode(data.getGatewayControllerCode());
            extension.setDenyPwdPrompt(data.getDenyPwdPrompt());
            extension.setTpi(data.getTpi());
            extension.setRingReady(data.getRingReady());
            extension.setOverrideMoh(data.getOverrideMoh());
            extension.setIsExtensionBasedAcd(data.getIsExtensionBasedAcd());
            extension.setDniBasedRouting(data.getDniBasedRouting());
            extension.setSide(data.getSide());
            extension.setPhysicalPlayerName(data.getPhysicalPlayerName());
            extension.setLogicalPlayerName(data.getLogicalPlayerName());
            extension.setTransferToAgentRingBack(data.getTransferToAgentRingBack());
            extension.setRadioNetCode(data.getRadioNetCode());
            extension.setHandleIsDnCause(data.getHandleIsDnCause());
            extension.setNetType(data.getNetType());
            extension.setRemoteUserIp(data.getRemoteUserIp());
            extension.setRemoteUserType(data.getRemoteUserType());
            extension.setNoAnsSmsTry(data.getNoAnsSmsTry());
            extension.setDialType(data.getDialType());
            extension.setEnableVideoCall(data.getEnableVideoCall());
            extension.setMasterCli(data.getMasterCli());
            extension.setUNma(data.getUNma());
            extension.setHomeRluCode(data.getHomeRluCode());
            extension.setSgwUser(data.getSgwUser());
            extension.setRegisterState(data.getRegisterState());
            extension.setIvrGroup(data.getIvrGroup());
            extension.setLevel(data.getHotelLevel());
            extension.setMissCallRedial(data.getMissCallRedial());
            extension.setMissCallDialDestination(data.getMissCallDialDestination());
            extension.setVmDiskQuota(data.getVmDiskQuota());
            extension.setWebApi(data.getWebApi());
            extension.setNoAnswerOverflowToBoss(data.getNoAnswerOverflowToBoss());
            extension.setPassword(data.getPassword());
            extension.setSipPassword(data.getSipPassword());
            extension.setVmPassword(data.getVmPassword());
            extension.setZone(data.getZone());
            extension.setExtensionIp(data.getExtensionIp());
            extension.setExtensionPort(data.getExtensionPort());
            extension.setModelCode(data.getModelCode());
            extension.setTimezone(data.getTimezone());
            extension.setSunFromTime(data.getSunFromTime());
            extension.setSunToTime(data.getSunToTime());
            extension.setExtensionSubtype(data.getExtensionSubtype());
            extension.setIMSI(data.getIMSI());
            extension.setKValue(data.getKValue());
            extension.setOPopc(data.getOPopc());
            extension.setMsiSdn(data.getMsiSdn());
            extension.setPremiumCustomer(data.getPremiumCustomer());
            extension.setGroupType(data.getGroupType());
            extension.setUuid(UUID.randomUUID().toString());
            extension.setIsFeedBack(data.getIsFeedBack());
            extension.setExtGroupCode(data.getExtGroupCode());
            extension.setPrimaryNightInboundCos(data.getPrimaryNightInboundCos());
            extension.setPrimaryNightOutboundCos(data.getPrimaryNightOutboundCos());
            extension.setXmpPPassword(data.getXmpPPassword());
            if (data.getCfa() != null && data.getCfa().booleanValue()) {
                extension.setCfa("fwd-all");
            } else {
                extension.setCfa("");
            }
            if (data.getECfa() != null && data.getECfa().booleanValue()) {
                extension.setECfa("ext-fwd-all");
            } else {
                extension.setECfa("");
            }
            if (data.getCfb() != null && data.getCfb().booleanValue()) {
                extension.setCfb("fwd-busy");
            } else {
                extension.setCfb("");
            }
            if (data.getECfb() != null && data.getECfb().booleanValue()) {
                extension.setECfb("ext-fwd-busy");
            } else {
                extension.setECfb("");
            }
            if (data.getCFna() != null && data.getCFna().booleanValue()) {
                extension.setCFna("fwd-no-ans");
            } else {
                extension.setCFna("");
            }
            if (data.getECFna() != null && data.getECFna().booleanValue()) {
                extension.setECFna("ext-fwd-no-ans");
            } else {
                extension.setECFna("");
            }
            if (data.getIsd() != null && data.getIsd().booleanValue()) {
                extension.setIsd("dialing-isd");
            } else {
                extension.setIsd("");
            }
            if (data.getStd() != null && data.getStd().booleanValue()) {
                extension.setStd("dialing-std");
            } else {
                extension.setStd("");
            }
            if (data.getLocal() != null && data.getLocal().booleanValue()) {
                extension.setLocal("dialing-local");
            } else {
                extension.setLocal("");
            }
            if (data.getIntercom() != null && data.getIntercom().booleanValue()) {
                extension.setIntercom("dialing-intercom");
            } else {
                extension.setIntercom("");
            }
            if (data.getVm() != null && data.getVm().booleanValue()) {
                extension.setVm("VM");
            } else {
                extension.setVm("");
            }
            if (data.getFm() != null && data.getFm().booleanValue()) {
                extension.setFm("follow-me");
            } else {
                extension.setFm("");
            }
            if (data.getDnd() != null && data.getDnd().booleanValue()) {
                extension.setDnd("dnd");
            } else {
                extension.setDnd("");
            }
            Optional didMappingOptional = this.didMappingRepository.findByExtNumber(data.getExtension());
            if (didMappingOptional.isPresent()) {
                DidMapping didMapping2 = (DidMapping)didMappingOptional.get();
                didMapping2.setDidNumber(data.getDid());
                didMapping2.setDodNumber(data.getDod());
                this.didMappingRepository.save((Object)didMapping2);
            } else {
                DidMapping didMapping3 = new DidMapping();
                didMapping3.setDidNumber(data.getDid());
                didMapping3.setDodNumber(data.getDod());
                this.didMappingRepository.save((Object)didMapping3);
            }
            extension.setDidNumber(data.getDid());
            extension.setDodNumber(data.getDod());
            extension.setCfaNumber(data.getCfaNumber());
            extension.setECfaNumber(data.getECfaNumber());
            extension.setCfbNumber(data.getCfbNumber());
            extension.setECfbNumber(data.getECfbNumber());
            extension.setCFnaNumber(data.getCFnaNumber());
            extension.setECfNaNumber(data.getECfNaNumber());
            this.extensionsRepository.save((Object)extension);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Extension Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create Extension");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteExtensionById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional extension = this.extensionsRepository.findById(ids.intValue());
            if (extension.isPresent()) {
                if (CustomerAccountService.getClickToCall() && (((Extension)extension.get()).getExtensionType().equalsIgnoreCase("conference") || ((Extension)extension.get()).getExtensionType().equalsIgnoreCase("conf"))) {
                    CLIServerCommandLog cliServerCommandLog1;
                    if (((Extension)extension.get()).getExtensionType().equals("conf")) {
                        cliServerCommandLog1 = new CLIServerCommandLog();
                        cliServerCommandLog1.setCLICommand(String.format("extension delete %s conferencenumber", ((Extension)extension.get()).getExtension()));
                        this.customerAccountService.cliServerCommandLog2(cliServerCommandLog1);
                        logger.info("extension delete {} conferencenumber", (Object)((Extension)extension.get()).getExtension());
                    } else if (((Extension)extension.get()).getExtensionType().equals("conference")) {
                        cliServerCommandLog1 = new CLIServerCommandLog();
                        cliServerCommandLog1.setCLICommand(String.format("conference delete %s", ((Extension)extension.get()).getExtension()));
                        this.customerAccountService.cliServerCommandLog2(cliServerCommandLog1);
                        logger.info("conference delete {}", (Object)((Extension)extension.get()).getExtension());
                    }
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException e) {
                        logger.error("Thread Inturrupted :: {}", (Object)e.getMessage());
                    }
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("OK");
                    returnValue.setMessageDetail("Kindly wait for sometime to reflect the changes");
                    logger.info(returnValue.getMessage());
                    return returnValue;
                }
                addValue.add(extension.get());
                this.extensionsRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Extensions Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getFilteredExtensionByType(SearchRequest searchRequestData, String extType) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ExtensionTypeSpecification.generateFilters((SearchRequest)searchRequestData, (String)extType);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "extension" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.extensionsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.extensionsRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<ExtensionModelCreate> entityToModelConversion(List<Extension> list) {
        ArrayList<ExtensionModelCreate> addValue = new ArrayList<ExtensionModelCreate>();
        for (Extension data : list) {
            ExtensionModelCreate extension = new ExtensionModelCreate();
            extension.setId(data.getId());
            extension.setFailOver(data.getFailOver());
            extension.setABarTimeout(data.getABarTimeout());
            extension.setAccountCode(data.getAccountCode());
            extension.setAcdCallback(data.getAcdCallback());
            extension.setAcdPickupGroup(data.getAcdPickupGroup());
            extension.setAlertInfo(data.getAlertInfo());
            extension.setAnonymousCallRejection(data.getAnonymousCallRejection());
            extension.setApplicationId(data.getApplicationId());
            extension.setAutoLift(data.getAutoLift());
            extension.setBrowserExt(data.getBrowserExt());
            extension.setBusyReleaseInterval(data.getBusyReleaseInterval());
            extension.setCFNATime(data.getCFNATime());
            extension.setCallContext(data.getCallContext());
            extension.setCallForwardNumber(data.getCallForwardNumber());
            extension.setCallTrace(data.getCallTrace());
            extension.setCallWaitingStatus(data.getCallWaitingStatus());
            extension.setCallerIdStatus(data.getCallerIdStatus());
            extension.setCallerOverrideToHoldParty(data.getCallerOverrideToHoldParty());
            extension.setCallerStrip(data.getCallerStrip());
            extension.setCampOnHoldMusic(data.getCampOnHoldMusic());
            extension.setCampOnRetryInterval(data.getCampOnRetryInterval());
            extension.setCanBroadcast(data.getCanBroadcast());
            extension.setCanMulticast(data.getCanMulticast());
            extension.setCheckIn(data.getCheckIn());
            extension.setCheckInEpoch(data.getCheckInEpoch());
            extension.setChimeInterval(data.getChimeInterval());
            extension.setChimePath(data.getChimePath());
            extension.setCodeBlueSentSmsConfig(data.getCodeBlueSentSmsConfig());
            extension.setCollaboration(data.getCollaboration());
            extension.setColumn1(data.getColumn1());
            extension.setColumn2(data.getColumn2());
            extension.setColumn3(data.getColumn3());
            extension.setColumn4(data.getColumn4());
            extension.setColumn5(data.getColumn5());
            extension.setColumn6(data.getColumn6());
            extension.setColumn7(data.getColumn7());
            extension.setColumn8(data.getColumn8());
            extension.setColumn9(data.getColumn9());
            extension.setColumn10(data.getColumn10());
            extension.setColumn11(data.getColumn11());
            extension.setColumn12(data.getColumn12());
            extension.setColumn13(data.getColumn13());
            extension.setColumn14(data.getColumn14());
            extension.setColumn15(data.getColumn15());
            extension.setColumn16(data.getColumn16());
            extension.setConfPwd(data.getConfPwd());
            extension.setConferenceMode(data.getConferenceMode());
            extension.setConfigEmailId(data.getConfigEmailId());
            extension.setConfirmationWavFile(data.getConfirmationWavFile());
            extension.setControlName(data.getControlName());
            extension.setCoralAcdCallType(data.getCoralAcdCallType());
            extension.setCurrentChannel(data.getCurrentChannel());
            extension.setCustomeDestination(data.getCustomeDestination());
            extension.setExtension(data.getExtension());
            extension.setExtensionType(data.getExtensionType());
            extension.setName(data.getName());
            extension.setCFNATime(data.getCFNATime());
            extension.setVideoCall(data.getVideoCall());
            extension.setWavFilename(data.getWavFilename());
            extension.setPCMA(data.getPCMA());
            extension.setPCMU(data.getPCMU());
            extension.setG722(data.getG722());
            extension.setG726(data.getG726());
            extension.setG729(data.getG729());
            extension.setG723(data.getG723());
            extension.setOpus(data.getOpus());
            extension.setVp8(data.getVp8());
            extension.setH263(data.getH263());
            extension.setH264(data.getH264());
            extension.setDayInboundCos(data.getDayInboundCos());
            extension.setNightInboundCos(data.getNightInboundCos());
            extension.setDayOutboundCos(data.getDayOutboundCos());
            extension.setNightOutboundCos(data.getNightOutboundCos());
            extension.setSecondaryDayInboundCos(data.getSecondaryDayInboundCos());
            extension.setSecondaryDayOutboundCos(data.getSecondaryDayOutboundCos());
            extension.setSecondaryNightInboundCos(data.getSecondaryNightInboundCos());
            extension.setSecondaryNightOutboundCos(data.getSecondaryNightOutboundCos());
            extension.setPrimaryDayInboundCos(data.getPrimaryDayInboundCos());
            extension.setPrimaryDayOutboundCos(data.getPrimaryDayOutboundCos());
            extension.setIMEINumber(data.getIMEINumber());
            extension.setTimeOutInSecond(data.getTimeOutInSecond());
            extension.setRingTime(data.getRingTime());
            extension.setCompany(data.getCompany());
            extension.setDepartment(data.getDepartment());
            extension.setDesignation(data.getDesignation());
            extension.setSecretary(data.getSecretary());
            extension.setCollaboration(data.getCollaboration());
            extension.setAccountCode(data.getAccountCode());
            extension.setData(data.getData());
            extension.setExtGroupId(data.getExtGroupId());
            extension.setPforkStr(data.getPforkStr());
            extension.setRecord(data.getRecord());
            extension.setEmailId(data.getEmailId());
            extension.setRluCode(data.getRluCode());
            extension.setCallWaitingStatus(data.getCallWaitingStatus());
            extension.setRingBackTone(data.getRingBackTone());
            extension.setGroupCode(data.getGroupCode());
            extension.setIsCampOnMode(data.getIsCampOnMode());
            extension.setCallTransferToVm(data.getCallTransferToVm());
            extension.setWelcomeGreeting(data.getWelcomeGreeting());
            extension.setOverflowToBoss(data.getOverflowToBoss());
            extension.setSplitRecordingFileInMinutes(data.getSplitRecordingFileInMinutes());
            extension.setPhoneStatus(data.getPhoneStatus());
            extension.setDayMode(data.getDayMode());
            extension.setNightMode(data.getNightMode());
            extension.setNonworkingData(data.getNonworkingData());
            extension.setNonworkingApp(data.getNonworkingApp());
            extension.setManufacturerId(data.getManufacturerId());
            extension.setModelDetailId(data.getModelDetailId());
            extension.setPersonalVmGreeting(data.getPersonalVmGreeting());
            extension.setMacId(data.getMacId());
            extension.setSrtP(data.getSrtP());
            extension.setZrtP(data.getZrtP());
            if (data.getDSun() != null && data.getDSun() != 0) {
                extension.setDSun(Boolean.valueOf(true));
            } else {
                extension.setDSun(Boolean.valueOf(false));
            }
            if (data.getDMon() != null && data.getDMon() != 0) {
                extension.setDMon(Boolean.valueOf(true));
            } else {
                extension.setDMon(Boolean.valueOf(false));
            }
            if (data.getDTue() != null && data.getDTue() != 0) {
                extension.setDTue(Boolean.valueOf(true));
            } else {
                extension.setDTue(Boolean.valueOf(false));
            }
            if (data.getDWed() != null && data.getDWed() != 0) {
                extension.setDWed(Boolean.valueOf(true));
            } else {
                extension.setDWed(Boolean.valueOf(false));
            }
            if (data.getDThu() != null && data.getDThu() != 0) {
                extension.setDThu(Boolean.valueOf(true));
            } else {
                extension.setDThu(Boolean.valueOf(false));
            }
            if (data.getDFri() != null && data.getDFri() != 0) {
                extension.setDFri(Boolean.valueOf(true));
            } else {
                extension.setDFri(Boolean.valueOf(false));
            }
            if (data.getDSat() != null && data.getDSat() != 0) {
                extension.setDSat(Boolean.valueOf(true));
            } else {
                extension.setDSat(Boolean.valueOf(false));
            }
            extension.setFromTime(data.getFromTime());
            extension.setToTime(data.getToTime());
            extension.setFriFromTime(data.getFriFromTime());
            extension.setFriToTime(data.getFriToTime());
            extension.setFlexibleTimings(data.getFlexibleTimings());
            extension.setMonFromTime(data.getMonFromTime());
            extension.setMonToTime(data.getMonToTime());
            extension.setTueFromTime(data.getTueFromTime());
            extension.setTueToTime(data.getTueToTime());
            extension.setWedFromTime(data.getWedFromTime());
            extension.setWedToTime(data.getWedToTime());
            extension.setThuFromTime(data.getThuFromTime());
            extension.setThuToTime(data.getThuToTime());
            extension.setSatFromTime(data.getSatFromTime());
            extension.setSatToTime(data.getSatToTime());
            extension.setNightRingTime(data.getNightRingTime());
            extension.setXmpPId(data.getXmpPId());
            extension.setAssignedUser(data.getAssignedUser());
            extension.setSmsText(data.getSmsText());
            extension.setIsSent(data.getIsSent());
            extension.setNoOfRetry(data.getNoOfRetry());
            extension.setUrl(data.getUrl());
            extension.setDialNumber(data.getDialNumber());
            extension.setSmsNumber(data.getSmsNumber());
            extension.setStar(data.getStar());
            extension.setParkExpiryInterval(data.getParkExpiryInterval());
            extension.setDestinationStrip(data.getDestinationStrip());
            extension.setOutboundGatewayGroup(data.getOutboundGatewayGroup());
            extension.setMaxChannel(data.getMaxChannel());
            extension.setIsCliBaseRouting(data.getIsCliBaseRouting());
            extension.setIsCallCenterBased(data.getIsCallCenterBased());
            extension.setStrategy(data.getStrategy());
            extension.setRestrictFeatureAccess(data.getRestrictFeatureAccess());
            extension.setVoicemail(data.getVoicemail());
            extension.setQueryOn(data.getQueryOn());
            extension.setRetryVoiceMessage(data.getRetryVoiceMessage());
            extension.setGatewayControllerCode(data.getGatewayControllerCode());
            extension.setDenyPwdPrompt(data.getDenyPwdPrompt());
            extension.setTpi(data.getTpi());
            extension.setRingReady(data.getRingReady());
            extension.setOverrideMoh(data.getOverrideMoh());
            extension.setIsExtensionBasedAcd(data.getIsExtensionBasedAcd());
            extension.setDniBasedRouting(data.getDniBasedRouting());
            extension.setSide(data.getSide());
            extension.setPhysicalPlayerName(data.getPhysicalPlayerName());
            extension.setLogicalPlayerName(data.getLogicalPlayerName());
            extension.setTransferToAgentRingBack(data.getTransferToAgentRingBack());
            extension.setRadioNetCode(data.getRadioNetCode());
            extension.setHandleIsDnCause(data.getHandleIsDnCause());
            extension.setNetType(data.getNetType());
            extension.setRemoteUserIp(data.getRemoteUserIp());
            extension.setRemoteUserType(data.getRemoteUserType());
            extension.setNoAnsSmsTry(data.getNoAnsSmsTry());
            extension.setDialType(data.getDialType());
            extension.setEnableVideoCall(data.getEnableVideoCall());
            extension.setMasterCli(data.getMasterCli());
            extension.setUNma(data.getUNma());
            extension.setHomeRluCode(data.getHomeRluCode());
            extension.setSgwUser(data.getSgwUser());
            extension.setRegisterState(data.getRegisterState());
            extension.setIvrGroup(data.getIvrGroup());
            extension.setHotelLevel(data.getLevel());
            extension.setMissCallRedial(data.getMissCallRedial());
            extension.setMissCallDialDestination(data.getMissCallDialDestination());
            extension.setVmDiskQuota(data.getVmDiskQuota());
            extension.setWebApi(data.getWebApi());
            extension.setNoAnswerOverflowToBoss(data.getNoAnswerOverflowToBoss());
            extension.setPassword(data.getPassword());
            extension.setSipPassword(data.getSipPassword());
            extension.setVmPassword(data.getVmPassword());
            extension.setZone(data.getZone());
            extension.setExtensionIp(data.getExtensionIp());
            extension.setExtensionPort(data.getExtensionPort());
            extension.setModelCode(data.getModelCode());
            extension.setTimezone(data.getTimezone());
            extension.setSunFromTime(data.getSunFromTime());
            extension.setSunToTime(data.getSunToTime());
            extension.setExtensionSubtype(data.getExtensionSubtype());
            extension.setIMSI(data.getIMSI());
            extension.setKValue(data.getKValue());
            extension.setOPopc(data.getOPopc());
            extension.setMsiSdn(data.getMsiSdn());
            extension.setPremiumCustomer(data.getPremiumCustomer());
            extension.setGroupType(data.getGroupType());
            extension.setUuid(data.getUuid());
            extension.setIsFeedBack(data.getIsFeedBack());
            extension.setExtGroupCode(data.getExtGroupCode());
            extension.setPrimaryNightInboundCos(data.getPrimaryNightInboundCos());
            extension.setPrimaryNightOutboundCos(data.getPrimaryNightOutboundCos());
            extension.setXmpPPassword(data.getXmpPPassword());
            if (data.getCfa() != null && data.getCfa().equals("fwd-all")) {
                extension.setCfa(Boolean.valueOf(true));
            } else {
                extension.setCfa(Boolean.valueOf(false));
            }
            if (data.getECfa() != null && data.getECfa().equals("ext-fwd-all")) {
                extension.setECfa(Boolean.valueOf(true));
            } else {
                extension.setECfa(Boolean.valueOf(false));
            }
            if (data.getCfb() != null && data.getCfb().equals("fwd-busy")) {
                extension.setCfb(Boolean.valueOf(true));
            } else {
                extension.setCfb(Boolean.valueOf(false));
            }
            if (data.getECfb() != null && data.getECfb().equals("ext-fwd-busy")) {
                extension.setECfb(Boolean.valueOf(true));
            } else {
                extension.setECfb(Boolean.valueOf(false));
            }
            if (data.getCFna() != null && data.getCFna().equals("fwd-no-ans")) {
                extension.setCFna(Boolean.valueOf(true));
            } else {
                extension.setCFna(Boolean.valueOf(false));
            }
            if (data.getECFna() != null && data.getECFna().equals("ext-fwd-no-ans")) {
                extension.setECFna(Boolean.valueOf(true));
            } else {
                extension.setECFna(Boolean.valueOf(false));
            }
            if (data.getIsd() != null && data.getIsd().equals("dialing-isd")) {
                extension.setIsd(Boolean.valueOf(true));
            } else {
                extension.setIsd(Boolean.valueOf(false));
            }
            if (data.getStd() != null && data.getStd().equals("dialing-std")) {
                extension.setStd(Boolean.valueOf(true));
            } else {
                extension.setStd(Boolean.valueOf(false));
            }
            if (data.getLocal() != null && data.getLocal().equals("dialing-local")) {
                extension.setLocal(Boolean.valueOf(true));
            } else {
                extension.setLocal(Boolean.valueOf(false));
            }
            if (data.getIntercom() != null && data.getIntercom().equals("dialing-intercom")) {
                extension.setIntercom(Boolean.valueOf(true));
            } else {
                extension.setIntercom(Boolean.valueOf(false));
            }
            if (data.getVm() != null && data.getVm().equals("VM")) {
                extension.setVm(Boolean.valueOf(true));
            } else {
                extension.setVm(Boolean.valueOf(false));
            }
            if (data.getFm() != null && data.getFm().equals("follow-me")) {
                extension.setFm(Boolean.valueOf(true));
            } else {
                extension.setFm(Boolean.valueOf(false));
            }
            if (data.getDnd() != null && data.getDnd().equals("dnd")) {
                extension.setDnd(Boolean.valueOf(true));
            } else {
                extension.setDnd(Boolean.valueOf(false));
            }
            Optional didMappingOptional = this.didMappingRepository.findByExtNumber(data.getExtension());
            if (didMappingOptional.isPresent()) {
                DidMapping didMapping = (DidMapping)didMappingOptional.get();
                if (StringUtils.hasLength((String)didMapping.getDidNumber())) {
                    extension.setDid(didMapping.getDidNumber());
                }
                if (StringUtils.hasLength((String)didMapping.getDodNumber())) {
                    extension.setDod(didMapping.getDodNumber());
                }
            }
            extension.setCfaNumber(data.getCfaNumber());
            extension.setECfaNumber(data.getECfaNumber());
            extension.setCfbNumber(data.getCfbNumber());
            extension.setECfbNumber(data.getECfbNumber());
            extension.setCFnaNumber(data.getCFnaNumber());
            extension.setECfNaNumber(data.getECfNaNumber());
            addValue.add(extension);
        }
        return addValue;
    }

    public RequestResponse updateExtensionById(ExtensionModelCreate data) {
        logger.debug("Update Extension {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional extension = this.extensionsRepository.findById((Object)data.getId());
        if (!extension.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("Queue not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        Optional didMappingOptional = this.didMappingRepository.findByExtNumber(data.getExtension());
        if (CustomerAccountService.getClickToCall() && (data.getExtensionType().equalsIgnoreCase("conference") || data.getExtensionType().equalsIgnoreCase("conf"))) {
            if (StringUtils.hasLength((String)data.getExtension()) && data.getExtensionType().equalsIgnoreCase("conference") || data.getExtensionType().equalsIgnoreCase("conf")) {
                String frontendValue;
                String dbValue;
                CLIServerCommandLog log;
                if (StringUtils.hasLength((String)data.getDid()) || didMappingOptional.isPresent() && StringUtils.hasLength((String)((DidMapping)didMappingOptional.get()).getDidNumber())) {
                    CLIServerCommandLog cliLog;
                    String dbDid = didMappingOptional.map(DidMapping::getDidNumber).orElse(null);
                    String frontendDid = data.getDid();
                    if (!StringUtils.hasLength((String)dbDid) && !StringUtils.hasLength((String)frontendDid)) {
                        logger.info("No DID change, skipping CLI command.");
                    } else if (StringUtils.hasLength((String)frontendDid) && !StringUtils.hasLength((String)dbDid)) {
                        cliLog = new CLIServerCommandLog();
                        String command = String.format("conference update %s did %s", data.getExtension(), frontendDid);
                        cliLog.setCLICommand(command);
                        this.customerAccountService.cliServerCommandLog2(cliLog);
                        logger.info(command);
                    } else if (StringUtils.hasLength((String)frontendDid) && !frontendDid.equals(dbDid)) {
                        cliLog = new CLIServerCommandLog();
                        String command = String.format("conference update %s did %s", data.getExtension(), frontendDid);
                        cliLog.setCLICommand(command);
                        this.customerAccountService.cliServerCommandLog2(cliLog);
                        logger.info(command);
                    } else {
                        logger.info("No change in DID, skipping CLI command.");
                    }
                }
                if (StringUtils.hasLength((String)data.getDod()) || didMappingOptional.isPresent() && StringUtils.hasLength((String)((DidMapping)didMappingOptional.get()).getDodNumber())) {
                    String dbDod = didMappingOptional.map(DidMapping::getDodNumber).orElse(null);
                    String frontendDod = data.getDod();
                    if (!StringUtils.hasLength((String)dbDod) && !StringUtils.hasLength((String)frontendDod)) {
                        logger.info("No DOD change, skipping CLI command.");
                    } else if (!StringUtils.hasLength((String)dbDod) && StringUtils.hasLength((String)frontendDod)) {
                        log = new CLIServerCommandLog();
                        log.setCLICommand(String.format("extension update %s dod %s", data.getExtension(), frontendDod));
                        this.customerAccountService.cliServerCommandLog2(log);
                        logger.info("extension update {} dod {}", (Object)data.getExtension(), (Object)frontendDod);
                    } else if (StringUtils.hasLength((String)frontendDod) && !frontendDod.equals(dbDod)) {
                        log = new CLIServerCommandLog();
                        log.setCLICommand(String.format("extension update %s dod %s", data.getExtension(), frontendDod));
                        this.customerAccountService.cliServerCommandLog2(log);
                        logger.info("extension update {} dod {}", (Object)data.getExtension(), (Object)frontendDod);
                    } else {
                        logger.info("No change in DOD, skipping CLI command.");
                    }
                }
                if (StringUtils.hasLength((String)data.getNonworkingApp()) || extension.isPresent() && StringUtils.hasLength((String)((Extension)extension.get()).getNonworkingApp())) {
                    dbValue = extension.isPresent() ? ((Extension)extension.get()).getNonworkingApp() : null;
                    frontendValue = data.getNonworkingApp();
                    if (StringUtils.hasLength((String)dbValue) || StringUtils.hasLength((String)frontendValue)) {
                        if (!StringUtils.hasLength((String)dbValue) && StringUtils.hasLength((String)frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s nbhapplication %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} nbhapplication {}", (Object)data.getExtension(), (Object)frontendValue);
                        } else if (StringUtils.hasLength((String)dbValue) && !StringUtils.hasLength((String)frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s nbhapplication reset", data.getExtension()));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} nbhapplication reset", (Object)data.getExtension());
                        } else if (!dbValue.equals(frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s nbhapplication %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} nbhapplication {}", (Object)data.getExtension(), (Object)frontendValue);
                        }
                    }
                }
                if (StringUtils.hasLength((String)data.getNonworkingData()) || extension.isPresent() && StringUtils.hasLength((String)((Extension)extension.get()).getNonworkingData())) {
                    dbValue = extension.isPresent() ? ((Extension)extension.get()).getNonworkingData() : null;
                    frontendValue = data.getNonworkingData();
                    if (StringUtils.hasLength((String)dbValue) || StringUtils.hasLength((String)frontendValue)) {
                        if (!StringUtils.hasLength((String)dbValue) && StringUtils.hasLength((String)frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s nbhtransfernum %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} nbhtransfernum {}", (Object)data.getExtension(), (Object)frontendValue);
                        } else if (StringUtils.hasLength((String)dbValue) && !StringUtils.hasLength((String)frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s nbhtransfernum reset", data.getExtension()));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} nbhtransfernum reset", (Object)data.getExtension());
                        } else if (!dbValue.equals(frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s nbhtransfernum %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} nbhtransfernum {}", (Object)data.getExtension(), (Object)frontendValue);
                        }
                    }
                }
                if (data.getFromTime() != null || data.getFromTime() == null && extension.isPresent() && ((Extension)extension.get()).getFromTime() != null) {
                    dbValue = extension.isPresent() && ((Extension)extension.get()).getFromTime() != null ? ((Extension)extension.get()).getFromTime().toString() : null;
                    String string = frontendValue = data.getFromTime() != null ? data.getFromTime().toString() : null;
                    if (dbValue != null || frontendValue != null) {
                        if (dbValue == null && frontendValue != null) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s fromtime %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} fromtime {}", (Object)data.getExtension(), (Object)frontendValue);
                        } else if (!dbValue.equals(frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s fromtime %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} fromtime {}", (Object)data.getExtension(), (Object)frontendValue);
                        }
                    }
                }
                if (data.getToTime() != null || data.getToTime() == null && extension.isPresent() && ((Extension)extension.get()).getToTime() != null) {
                    dbValue = extension.isPresent() && ((Extension)extension.get()).getToTime() != null ? ((Extension)extension.get()).getToTime().toString() : null;
                    String string = frontendValue = data.getToTime() != null ? data.getToTime().toString() : null;
                    if (dbValue != null || frontendValue != null) {
                        if (dbValue == null && frontendValue != null) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s totime %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} totime {}", (Object)data.getExtension(), (Object)frontendValue);
                        } else if (!dbValue.equals(frontendValue)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s totime %s", data.getExtension(), frontendValue));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} totime {}", (Object)data.getExtension(), (Object)frontendValue);
                        }
                    }
                }
                if (data.getTpi() != null) {
                    dbValue = null;
                    if (extension.isPresent() && ((Extension)extension.get()).getTpi() != null) {
                        dbValue = ((Extension)extension.get()).getTpi() != false ? "on" : "off";
                    }
                    String string = frontendValue = data.getTpi() != false ? "on" : "off";
                    if (!Objects.equals(dbValue, frontendValue)) {
                        log = new CLIServerCommandLog();
                        log.setCLICommand(String.format("extension update %s tpi %s", data.getExtension(), frontendValue));
                        this.customerAccountService.cliServerCommandLog2(log);
                        logger.info("extension update {} tpi {}", (Object)data.getExtension(), (Object)frontendValue);
                    }
                }
                if (StringUtils.hasLength((String)data.getTimezone())) {
                    dbValue = null;
                    if (extension.isPresent() && StringUtils.hasLength((String)((Extension)extension.get()).getTimezone())) {
                        dbValue = ((Extension)extension.get()).getTimezone();
                    }
                    frontendValue = data.getTimezone();
                    if (!StringUtils.hasLength((String)dbValue) && StringUtils.hasLength((String)frontendValue)) {
                        log = new CLIServerCommandLog();
                        log.setCLICommand(String.format("extension update %s timezone %s", data.getExtension(), frontendValue));
                        this.customerAccountService.cliServerCommandLog2(log);
                        logger.info("extension update {} timezone {}", (Object)data.getExtension(), (Object)frontendValue);
                    } else if (StringUtils.hasLength((String)dbValue) && !dbValue.equals(frontendValue)) {
                        log = new CLIServerCommandLog();
                        log.setCLICommand(String.format("extension update %s timezone %s", data.getExtension(), frontendValue));
                        this.customerAccountService.cliServerCommandLog2(log);
                        logger.info("extension update {} timezone {}", (Object)data.getExtension(), (Object)frontendValue);
                    }
                }
                if (StringUtils.hasLength((String)data.getName()) || extension.isPresent() && StringUtils.hasLength((String)((Extension)extension.get()).getName())) {
                    String dbName = extension.isPresent() ? ((Extension)extension.get()).getName() : null;
                    String frontendName = data.getName();
                    if (StringUtils.hasLength((String)dbName) || StringUtils.hasLength((String)frontendName)) {
                        if (!StringUtils.hasLength((String)dbName) && StringUtils.hasLength((String)frontendName)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s name %s", data.getExtension(), frontendName));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} name {}", (Object)data.getExtension(), (Object)frontendName);
                        } else if (StringUtils.hasLength((String)dbName) && !StringUtils.hasLength((String)frontendName)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s name reset", data.getExtension()));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} name reset", (Object)data.getExtension());
                        } else if (!dbName.equals(frontendName)) {
                            log = new CLIServerCommandLog();
                            log.setCLICommand(String.format("extension update %s name %s", data.getExtension(), frontendName));
                            this.customerAccountService.cliServerCommandLog2(log);
                            logger.info("extension update {} name {}", (Object)data.getExtension(), (Object)frontendName);
                        }
                    }
                }
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException e) {
                    logger.error("Thread Inturrupted :: {}", (Object)e.getMessage());
                    e.printStackTrace();
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("Kindly wait for sometime to reflect changes");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
        } else {
            if (data.getABarTimeout() != null) {
                ((Extension)extension.get()).setABarTimeout(data.getABarTimeout());
            }
            if (data.getFailOver() != null) {
                ((Extension)extension.get()).setFailOver(data.getFailOver());
            }
            if (data.getAccountCode() != null) {
                ((Extension)extension.get()).setAccountCode(data.getAccountCode());
            }
            if (data.getAcdCallback() != null) {
                ((Extension)extension.get()).setAcdCallback(data.getAcdCallback());
            }
            if (data.getAcdPickupGroup() != null) {
                ((Extension)extension.get()).setAcdPickupGroup(data.getAcdPickupGroup());
            }
            if (data.getAlertInfo() != null) {
                ((Extension)extension.get()).setAlertInfo(data.getAlertInfo());
            }
            if (data.getAnonymousCallRejection() != null) {
                ((Extension)extension.get()).setAnonymousCallRejection(data.getAnonymousCallRejection());
            }
            if (data.getApplicationId() != null) {
                ((Extension)extension.get()).setApplicationId(data.getApplicationId());
            }
            if (data.getAutoLift() != null) {
                ((Extension)extension.get()).setAutoLift(data.getAutoLift());
            }
            if (data.getBrowserExt() != null) {
                ((Extension)extension.get()).setBrowserExt(data.getBrowserExt());
            }
            if (data.getBusyReleaseInterval() != null) {
                ((Extension)extension.get()).setBusyReleaseInterval(data.getBusyReleaseInterval());
            }
            if (data.getCFNATime() != null) {
                ((Extension)extension.get()).setCFNATime(data.getCFNATime());
            }
            if (data.getCallContext() != null) {
                ((Extension)extension.get()).setCallContext(data.getCallContext());
            }
            if (data.getCallForwardNumber() != null) {
                ((Extension)extension.get()).setCallForwardNumber(data.getCallForwardNumber());
            }
            if (data.getCallTrace() != null) {
                ((Extension)extension.get()).setCallTrace(data.getCallTrace());
            }
            if (data.getCallTransferToVm() != null) {
                ((Extension)extension.get()).setCallTransferToVm(data.getCallTransferToVm());
            }
            if (data.getCallWaitingStatus() != null) {
                ((Extension)extension.get()).setCallWaitingStatus(data.getCallWaitingStatus());
            }
            if (data.getCallerIdStatus() != null) {
                ((Extension)extension.get()).setCallerIdStatus(data.getCallerIdStatus());
            }
            if (data.getCallerOverrideToHoldParty() != null) {
                ((Extension)extension.get()).setCallerOverrideToHoldParty(data.getCallerOverrideToHoldParty());
            }
            if (data.getCallerStrip() != null) {
                ((Extension)extension.get()).setCallerStrip(data.getCallerStrip());
            }
            if (data.getCampOnHoldMusic() != null) {
                ((Extension)extension.get()).setCampOnHoldMusic(data.getCampOnHoldMusic());
            }
            if (data.getCampOnRetryInterval() != null) {
                ((Extension)extension.get()).setCampOnRetryInterval(data.getCampOnRetryInterval());
            }
            if (data.getCanBroadcast() != null) {
                ((Extension)extension.get()).setCanBroadcast(data.getCanBroadcast());
            }
            if (data.getCanMulticast() != null) {
                ((Extension)extension.get()).setCanMulticast(data.getCanMulticast());
            }
            if (data.getCheckIn() != null) {
                ((Extension)extension.get()).setCheckIn(data.getCheckIn());
            }
            if (data.getCheckInEpoch() != null) {
                ((Extension)extension.get()).setCheckInEpoch(data.getCheckInEpoch());
            }
            if (data.getChimeInterval() != null) {
                ((Extension)extension.get()).setChimeInterval(data.getChimeInterval());
            }
            if (data.getChimePath() != null) {
                ((Extension)extension.get()).setChimePath(data.getChimePath());
            }
            if (data.getCodeBlueSentSmsConfig() != null) {
                ((Extension)extension.get()).setCodeBlueSentSmsConfig(data.getCodeBlueSentSmsConfig());
            }
            if (data.getCollaboration() != null) {
                ((Extension)extension.get()).setCollaboration(data.getCollaboration());
            }
            if (data.getColumn1() != null) {
                ((Extension)extension.get()).setColumn1(data.getColumn1());
            }
            if (data.getColumn2() != null) {
                ((Extension)extension.get()).setColumn2(data.getColumn2());
            }
            if (data.getColumn3() != null) {
                ((Extension)extension.get()).setColumn3(data.getColumn3());
            }
            if (data.getColumn4() != null) {
                ((Extension)extension.get()).setColumn4(data.getColumn4());
            }
            if (data.getColumn5() != null) {
                ((Extension)extension.get()).setColumn5(data.getColumn5());
            }
            if (data.getColumn6() != null) {
                ((Extension)extension.get()).setColumn6(data.getColumn6());
            }
            if (data.getColumn7() != null) {
                ((Extension)extension.get()).setColumn7(data.getColumn7());
            }
            if (data.getColumn8() != null) {
                ((Extension)extension.get()).setColumn8(data.getColumn8());
            }
            if (data.getColumn9() != null) {
                ((Extension)extension.get()).setColumn9(data.getColumn9());
            }
            if (data.getColumn10() != null) {
                ((Extension)extension.get()).setColumn10(data.getColumn10());
            }
            if (data.getColumn11() != null) {
                ((Extension)extension.get()).setColumn11(data.getColumn11());
            }
            if (data.getColumn12() != null) {
                ((Extension)extension.get()).setColumn12(data.getColumn12());
            }
            if (data.getColumn13() != null) {
                ((Extension)extension.get()).setColumn13(data.getColumn13());
            }
            if (data.getColumn14() != null) {
                ((Extension)extension.get()).setColumn14(data.getColumn14());
            }
            if (data.getColumn15() != null) {
                ((Extension)extension.get()).setColumn15(data.getColumn15());
            }
            if (data.getColumn16() != null) {
                ((Extension)extension.get()).setColumn16(data.getColumn16());
            }
            if (data.getConfPwd() != null) {
                ((Extension)extension.get()).setConfPwd(data.getConfPwd());
            }
            if (data.getConferenceMode() != null) {
                ((Extension)extension.get()).setConferenceMode(data.getConferenceMode());
            }
            if (data.getConfigEmailId() != null) {
                ((Extension)extension.get()).setConfigEmailId(data.getConfigEmailId());
            }
            if (data.getConfirmationWavFile() != null) {
                ((Extension)extension.get()).setConfirmationWavFile(data.getConfirmationWavFile());
            }
            if (data.getControlName() != null) {
                ((Extension)extension.get()).setControlName(data.getControlName());
            }
            if (data.getCoralAcdCallType() != null) {
                ((Extension)extension.get()).setCoralAcdCallType(data.getCoralAcdCallType());
            }
            if (data.getCurrentChannel() != null) {
                ((Extension)extension.get()).setCurrentChannel(data.getCurrentChannel());
            }
            if (data.getCustomeDestination() != null) {
                ((Extension)extension.get()).setCustomeDestination(data.getCustomeDestination());
            }
            if (data.getExtension() != null) {
                ((Extension)extension.get()).setExtension(data.getExtension());
            }
            if (data.getExtensionType() != null) {
                ((Extension)extension.get()).setExtensionType(data.getExtensionType());
            }
            if (data.getName() != null) {
                ((Extension)extension.get()).setName(data.getName());
            }
            if (data.getCFNATime() != null) {
                ((Extension)extension.get()).setCFNATime(data.getCFNATime());
            }
            if (data.getVideoCall() != null) {
                ((Extension)extension.get()).setVideoCall(data.getVideoCall());
            }
            if (data.getWavFilename() != null) {
                ((Extension)extension.get()).setWavFilename(data.getWavFilename());
            }
            if (data.getPCMA() != null) {
                ((Extension)extension.get()).setPCMA(data.getPCMA());
            }
            if (data.getPCMU() != null) {
                ((Extension)extension.get()).setPCMU(data.getPCMU());
            }
            if (data.getG722() != null) {
                ((Extension)extension.get()).setG722(data.getG722());
            }
            if (data.getG726() != null) {
                ((Extension)extension.get()).setG726(data.getG726());
            }
            if (data.getG729() != null) {
                ((Extension)extension.get()).setG729(data.getG729());
            }
            if (data.getG723() != null) {
                ((Extension)extension.get()).setG723(data.getG723());
            }
            if (data.getOpus() != null) {
                ((Extension)extension.get()).setOpus(data.getOpus());
            }
            if (data.getVp8() != null) {
                ((Extension)extension.get()).setVp8(data.getVp8());
            }
            if (data.getH263() != null) {
                ((Extension)extension.get()).setH263(data.getH263());
            }
            if (data.getH264() != null) {
                ((Extension)extension.get()).setH264(data.getH264());
            }
            if (data.getDayInboundCos() != null) {
                ((Extension)extension.get()).setDayInboundCos(data.getDayInboundCos());
            }
            if (data.getNightInboundCos() != null) {
                ((Extension)extension.get()).setNightInboundCos(data.getNightInboundCos());
            }
            if (data.getSecondaryDayInboundCos() != null) {
                ((Extension)extension.get()).setSecondaryDayInboundCos(data.getSecondaryDayInboundCos());
            }
            if (data.getDayOutboundCos() != null) {
                ((Extension)extension.get()).setDayOutboundCos(data.getDayOutboundCos());
            }
            if (data.getNightOutboundCos() != null) {
                ((Extension)extension.get()).setNightOutboundCos(data.getNightOutboundCos());
            }
            if (data.getSecondaryDayOutboundCos() != null) {
                ((Extension)extension.get()).setSecondaryDayOutboundCos(data.getSecondaryDayOutboundCos());
            }
            if (data.getSecondaryNightInboundCos() != null) {
                ((Extension)extension.get()).setSecondaryNightInboundCos(data.getSecondaryNightInboundCos());
            }
            if (data.getSecondaryNightOutboundCos() != null) {
                ((Extension)extension.get()).setSecondaryNightOutboundCos(data.getSecondaryNightOutboundCos());
            }
            if (data.getPrimaryDayInboundCos() != null) {
                ((Extension)extension.get()).setPrimaryDayInboundCos(data.getPrimaryDayInboundCos());
            }
            if (data.getPrimaryDayOutboundCos() != null) {
                ((Extension)extension.get()).setPrimaryDayOutboundCos(data.getPrimaryDayOutboundCos());
            }
            if (data.getIMEINumber() != null) {
                ((Extension)extension.get()).setIMEINumber(data.getIMEINumber());
            }
            if (data.getTimeOutInSecond() != null) {
                ((Extension)extension.get()).setTimeOutInSecond(data.getTimeOutInSecond());
            }
            if (data.getCompany() != null) {
                ((Extension)extension.get()).setCompany(data.getCompany());
            }
            if (data.getDepartment() != null) {
                ((Extension)extension.get()).setDepartment(data.getDepartment());
            }
            if (data.getDesignation() != null) {
                ((Extension)extension.get()).setDesignation(data.getDesignation());
            }
            if (data.getSecretary() != null) {
                ((Extension)extension.get()).setSecretary(data.getSecretary());
            }
            if (data.getCollaboration() != null) {
                ((Extension)extension.get()).setCollaboration(data.getCollaboration());
            }
            if (data.getAccountCode() != null) {
                ((Extension)extension.get()).setAccountCode(data.getColumn11());
            }
            if (data.getData() != null) {
                ((Extension)extension.get()).setData(data.getData());
            }
            if (data.getExtGroupId() != null) {
                ((Extension)extension.get()).setExtGroupId(data.getExtGroupId());
            }
            if (data.getPforkStr() != null) {
                ((Extension)extension.get()).setPforkStr(data.getPforkStr());
            }
            if (data.getRecord() != null) {
                ((Extension)extension.get()).setRecord(data.getRecord());
            }
            if (data.getEmailId() != null) {
                ((Extension)extension.get()).setEmailId(data.getEmailId());
            }
            if (data.getRluCode() != null) {
                ((Extension)extension.get()).setRluCode(data.getRluCode());
            }
            if (data.getCallWaitingStatus() != null) {
                ((Extension)extension.get()).setCallWaitingStatus(data.getCallWaitingStatus());
            }
            if (data.getRingBackTone() != null) {
                ((Extension)extension.get()).setRingBackTone(data.getRingBackTone());
            }
            if (data.getGroupCode() != null) {
                ((Extension)extension.get()).setGroupCode(data.getGroupCode());
            }
            if (data.getIsCampOnMode() != null) {
                ((Extension)extension.get()).setIsCampOnMode(data.getIsCampOnMode());
            }
            if (data.getWelcomeGreeting() != null) {
                ((Extension)extension.get()).setWelcomeGreeting(data.getWelcomeGreeting());
            }
            if (data.getOverflowToBoss() != null) {
                ((Extension)extension.get()).setOverflowToBoss(data.getOverflowToBoss());
            }
            if (data.getSplitRecordingFileInMinutes() != null) {
                ((Extension)extension.get()).setSplitRecordingFileInMinutes(data.getSplitRecordingFileInMinutes());
            }
            if (data.getPhoneStatus() != null) {
                ((Extension)extension.get()).setPhoneStatus(data.getPhoneStatus());
            }
            if (data.getDayMode() != null) {
                ((Extension)extension.get()).setDayMode(data.getDayMode());
            }
            if (data.getNightMode() != null) {
                ((Extension)extension.get()).setNightMode(data.getNightMode());
            }
            if (data.getNonworkingData() != null) {
                ((Extension)extension.get()).setNonworkingData(data.getNonworkingData());
            }
            if (data.getNonworkingApp() != null) {
                ((Extension)extension.get()).setNonworkingApp(data.getNonworkingApp());
            }
            if (data.getManufacturerId() != null) {
                ((Extension)extension.get()).setManufacturerId(data.getManufacturerId());
            }
            if (data.getModelDetailId() != null) {
                ((Extension)extension.get()).setModelDetailId(data.getModelDetailId());
            }
            if (data.getPersonalVmGreeting() != null) {
                ((Extension)extension.get()).setPersonalVmGreeting(data.getPersonalVmGreeting());
            }
            if (data.getMacId() != null) {
                ((Extension)extension.get()).setMacId(data.getMacId());
            }
            if (data.getSrtP() != null) {
                ((Extension)extension.get()).setSrtP(data.getSrtP());
            }
            if (data.getZrtP() != null) {
                ((Extension)extension.get()).setZrtP(data.getZrtP());
            }
            if (data.getDSun() != null) {
                if (data.getDSun().equals(true)) {
                    ((Extension)extension.get()).setDSun(Integer.valueOf(1));
                } else {
                    ((Extension)extension.get()).setDSun(Integer.valueOf(0));
                }
            }
            if (data.getDMon() != null) {
                if (data.getDMon().equals(true)) {
                    ((Extension)extension.get()).setDMon(Integer.valueOf(1));
                } else {
                    ((Extension)extension.get()).setDMon(Integer.valueOf(0));
                }
            }
            if (data.getDTue() != null) {
                if (data.getDTue().equals(true)) {
                    ((Extension)extension.get()).setDTue(Integer.valueOf(1));
                } else {
                    ((Extension)extension.get()).setDTue(Integer.valueOf(0));
                }
            }
            if (data.getDWed() != null) {
                if (data.getDWed().equals(true)) {
                    ((Extension)extension.get()).setDWed(Integer.valueOf(1));
                } else {
                    ((Extension)extension.get()).setDWed(Integer.valueOf(0));
                }
            }
            if (data.getDThu() != null) {
                if (data.getDThu().equals(true)) {
                    ((Extension)extension.get()).setDThu(Integer.valueOf(1));
                } else {
                    ((Extension)extension.get()).setDThu(Integer.valueOf(0));
                }
            }
            if (data.getDFri() != null) {
                if (data.getDFri().equals(true)) {
                    ((Extension)extension.get()).setDFri(Integer.valueOf(1));
                } else {
                    ((Extension)extension.get()).setDFri(Integer.valueOf(0));
                }
            }
            if (data.getDSat() != null) {
                if (data.getDSat().equals(true)) {
                    ((Extension)extension.get()).setDSat(Integer.valueOf(1));
                } else {
                    ((Extension)extension.get()).setDSat(Integer.valueOf(0));
                }
            }
            if (data.getFriFromTime() != null) {
                ((Extension)extension.get()).setFriFromTime(data.getFriFromTime());
            }
            if (data.getFriToTime() != null) {
                ((Extension)extension.get()).setFriToTime(data.getFriToTime());
            }
            if (data.getFlexibleTimings() != null) {
                ((Extension)extension.get()).setFlexibleTimings(data.getFlexibleTimings());
            }
            if (data.getMonFromTime() != null) {
                ((Extension)extension.get()).setMonFromTime(data.getMonFromTime());
            }
            if (data.getMonToTime() != null) {
                ((Extension)extension.get()).setMonToTime(data.getMonToTime());
            }
            if (data.getTueFromTime() != null) {
                ((Extension)extension.get()).setTueFromTime(data.getTueFromTime());
            }
            if (data.getTueToTime() != null) {
                ((Extension)extension.get()).setTueToTime(data.getTueToTime());
            }
            if (data.getWedFromTime() != null) {
                ((Extension)extension.get()).setWedFromTime(data.getWedFromTime());
            }
            if (data.getWedToTime() != null) {
                ((Extension)extension.get()).setWedToTime(data.getWedToTime());
            }
            if (data.getThuFromTime() != null) {
                ((Extension)extension.get()).setThuFromTime(data.getThuFromTime());
            }
            if (data.getThuToTime() != null) {
                ((Extension)extension.get()).setThuToTime(data.getThuToTime());
            }
            if (data.getSatFromTime() != null) {
                ((Extension)extension.get()).setSatFromTime(data.getSatFromTime());
            }
            if (data.getSatToTime() != null) {
                ((Extension)extension.get()).setSatToTime(data.getSatToTime());
            }
            if (data.getNightRingTime() != null) {
                ((Extension)extension.get()).setNightRingTime(data.getNightRingTime());
            }
            if (data.getAssignedUser() != null) {
                ((Extension)extension.get()).setAssignedUser(data.getAssignedUser());
            }
            if (data.getSmsText() != null) {
                ((Extension)extension.get()).setSmsText(data.getSmsText());
            }
            if (data.getIsSent() != null) {
                ((Extension)extension.get()).setIsSent(data.getIsSent());
            }
            if (data.getNoOfRetry() != null) {
                ((Extension)extension.get()).setNoOfRetry(data.getNoOfRetry());
            }
            if (data.getUrl() != null) {
                ((Extension)extension.get()).setUrl(data.getUrl());
            }
            if (data.getDialNumber() != null) {
                ((Extension)extension.get()).setDialNumber(data.getDialNumber());
            }
            if (data.getSmsNumber() != null) {
                ((Extension)extension.get()).setSmsNumber(data.getSmsNumber());
            }
            if (data.getStar() != null) {
                ((Extension)extension.get()).setStar(data.getStar());
            }
            if (data.getParkExpiryInterval() != null) {
                ((Extension)extension.get()).setParkExpiryInterval(data.getParkExpiryInterval());
            }
            if (data.getMaxChannel() != null) {
                ((Extension)extension.get()).setMaxChannel(data.getMaxChannel());
            }
            if (data.getIsCliBaseRouting() != null) {
                ((Extension)extension.get()).setIsCliBaseRouting(data.getIsCliBaseRouting());
            }
            if (data.getIsCallCenterBased() != null) {
                ((Extension)extension.get()).setIsCallCenterBased(data.getIsCallCenterBased());
            }
            if (data.getStrategy() != null) {
                ((Extension)extension.get()).setStrategy(data.getStrategy());
            }
            if (data.getRestrictFeatureAccess() != null) {
                ((Extension)extension.get()).setRestrictFeatureAccess(data.getRestrictFeatureAccess());
            }
            if (data.getVoicemail() != null) {
                ((Extension)extension.get()).setVoicemail(data.getVoicemail());
            }
            if (data.getQueryOn() != null) {
                ((Extension)extension.get()).setQueryOn(data.getQueryOn());
            }
            if (data.getRetryVoiceMessage() != null) {
                ((Extension)extension.get()).setRetryVoiceMessage(data.getRetryVoiceMessage());
            }
            if (data.getGatewayControllerCode() != null) {
                ((Extension)extension.get()).setGatewayControllerCode(data.getGatewayControllerCode());
            }
            if (data.getDenyPwdPrompt() != null) {
                ((Extension)extension.get()).setDenyPwdPrompt(data.getDenyPwdPrompt());
            }
            if (data.getTpi() != null) {
                ((Extension)extension.get()).setTpi(data.getTpi());
            }
            if (data.getRingReady() != null) {
                ((Extension)extension.get()).setRingReady(data.getRingReady());
            }
            if (data.getOverrideMoh() != null) {
                ((Extension)extension.get()).setOverrideMoh(data.getOverrideMoh());
            }
            if (data.getIsExtensionBasedAcd() != null) {
                ((Extension)extension.get()).setIsExtensionBasedAcd(data.getIsExtensionBasedAcd());
            }
            if (data.getDniBasedRouting() != null) {
                ((Extension)extension.get()).setDniBasedRouting(data.getDniBasedRouting());
            }
            if (data.getSide() != null) {
                ((Extension)extension.get()).setSide(data.getSide());
            }
            if (data.getPhysicalPlayerName() != null) {
                ((Extension)extension.get()).setPhysicalPlayerName(data.getPhysicalPlayerName());
            }
            if (data.getLogicalPlayerName() != null) {
                ((Extension)extension.get()).setLogicalPlayerName(data.getLogicalPlayerName());
            }
            if (data.getTransferToAgentRingBack() != null) {
                ((Extension)extension.get()).setTransferToAgentRingBack(data.getTransferToAgentRingBack());
            }
            if (data.getRadioNetCode() != null) {
                ((Extension)extension.get()).setRadioNetCode(data.getRadioNetCode());
            }
            if (data.getHandleIsDnCause() != null) {
                ((Extension)extension.get()).setHandleIsDnCause(data.getHandleIsDnCause());
            }
            if (data.getNetType() != null) {
                ((Extension)extension.get()).setNetType(data.getNetType());
            }
            if (data.getRemoteUserIp() != null) {
                ((Extension)extension.get()).setRemoteUserIp(data.getRemoteUserIp());
            }
            if (data.getRemoteUserType() != null) {
                ((Extension)extension.get()).setRemoteUserType(data.getRemoteUserType());
            }
            if (data.getNoAnsSmsTry() != null) {
                ((Extension)extension.get()).setNoAnsSmsTry(data.getNoAnsSmsTry());
            }
            if (data.getDialType() != null) {
                ((Extension)extension.get()).setDialType(data.getDialType());
            }
            if (data.getEnableVideoCall() != null) {
                ((Extension)extension.get()).setEnableVideoCall(data.getEnableVideoCall());
            }
            if (data.getMasterCli() != null) {
                ((Extension)extension.get()).setMasterCli(data.getMasterCli());
            }
            if (data.getUNma() != null) {
                ((Extension)extension.get()).setUNma(data.getUNma());
            }
            if (data.getHomeRluCode() != null) {
                ((Extension)extension.get()).setHomeRluCode(data.getHomeRluCode());
            }
            if (data.getSgwUser() != null) {
                ((Extension)extension.get()).setSgwUser(data.getSgwUser());
            }
            if (data.getRegisterState() != null) {
                ((Extension)extension.get()).setRegisterState(data.getRegisterState());
            }
            if (data.getIvrGroup() != null) {
                ((Extension)extension.get()).setIvrGroup(data.getIvrGroup());
            }
            if (data.getHotelLevel() != null) {
                ((Extension)extension.get()).setLevel(data.getHotelLevel());
            }
            if (data.getMissCallRedial() != null) {
                ((Extension)extension.get()).setMissCallRedial(data.getMissCallRedial());
            }
            if (data.getMissCallDialDestination() != null) {
                ((Extension)extension.get()).setMissCallDialDestination(data.getMissCallDialDestination());
            }
            if (data.getVmDiskQuota() != null) {
                ((Extension)extension.get()).setVmDiskQuota(data.getVmDiskQuota());
            }
            if (data.getWebApi() != null) {
                ((Extension)extension.get()).setWebApi(data.getWebApi());
            }
            if (data.getNoAnswerOverflowToBoss() != null) {
                ((Extension)extension.get()).setNoAnswerOverflowToBoss(data.getNoAnswerOverflowToBoss());
            }
            if (data.getPassword() != null) {
                ((Extension)extension.get()).setPassword(data.getPassword());
            }
            if (data.getSipPassword() != null) {
                ((Extension)extension.get()).setSipPassword(data.getSipPassword());
            }
            if (data.getVmPassword() != null) {
                ((Extension)extension.get()).setVmPassword(data.getVmPassword());
            }
            if (data.getZone() != null) {
                ((Extension)extension.get()).setZone(data.getColumn4());
            }
            if (data.getExtensionIp() != null) {
                ((Extension)extension.get()).setExtensionIp(data.getExtensionIp());
            }
            if (data.getExtensionPort() != null) {
                ((Extension)extension.get()).setExtensionPort(data.getExtensionPort());
            }
            if (data.getModelCode() != null) {
                ((Extension)extension.get()).setModelCode(data.getModelCode());
            }
            if (data.getTimezone() != null) {
                ((Extension)extension.get()).setTimezone(data.getTimezone());
            }
            if (data.getSunFromTime() != null) {
                ((Extension)extension.get()).setSunFromTime(data.getSunFromTime());
            }
            if (data.getSunToTime() != null) {
                ((Extension)extension.get()).setSunToTime(data.getSunToTime());
            }
            if (data.getExtensionSubtype() != null) {
                ((Extension)extension.get()).setExtensionSubtype(data.getExtensionSubtype());
            }
            if (data.getIMSI() != null) {
                ((Extension)extension.get()).setIMSI(data.getIMSI());
            }
            if (data.getKValue() != null) {
                ((Extension)extension.get()).setKValue(data.getKValue());
            }
            if (data.getOPopc() != null) {
                ((Extension)extension.get()).setOPopc(data.getOPopc());
            }
            if (data.getMsiSdn() != null) {
                ((Extension)extension.get()).setMsiSdn(data.getMsiSdn());
            }
            if (data.getPremiumCustomer() != null) {
                ((Extension)extension.get()).setPremiumCustomer(data.getPremiumCustomer());
            }
            if (data.getGroupType() != null) {
                ((Extension)extension.get()).setGroupType(data.getGroupType());
            }
            if (data.getIsFeedBack() != null) {
                ((Extension)extension.get()).setIsFeedBack(data.getIsFeedBack());
            }
            if (data.getExtGroupCode() != null) {
                ((Extension)extension.get()).setExtGroupCode(data.getExtGroupCode());
            }
            if (data.getFromTime() != null) {
                ((Extension)extension.get()).setFromTime(data.getFromTime());
            }
            if (data.getToTime() != null) {
                ((Extension)extension.get()).setToTime(data.getToTime());
            }
            if (data.getPrimaryNightInboundCos() != null) {
                ((Extension)extension.get()).setPrimaryNightInboundCos(data.getPrimaryNightInboundCos());
            }
            if (data.getPrimaryNightOutboundCos() != null) {
                ((Extension)extension.get()).setPrimaryNightOutboundCos(data.getPrimaryNightOutboundCos());
            }
            if (data.getXmpPPassword() != null) {
                ((Extension)extension.get()).setXmpPPassword(data.getXmpPPassword());
            }
            if (data.getCfa() != null) {
                if (data.getCfa().equals(true)) {
                    ((Extension)extension.get()).setCfa("fwd-all");
                } else {
                    ((Extension)extension.get()).setCfa("");
                }
            }
            if (data.getECfa() != null) {
                if (data.getECfa().equals(true)) {
                    ((Extension)extension.get()).setECfa("ext-fwd-all");
                } else {
                    ((Extension)extension.get()).setECfa("");
                }
            }
            if (data.getCfb() != null) {
                if (data.getCfb().equals(true)) {
                    ((Extension)extension.get()).setCfb("fwd-busy");
                } else {
                    ((Extension)extension.get()).setCfb("");
                }
            }
            if (data.getECfb() != null) {
                if (data.getECfb().equals(true)) {
                    ((Extension)extension.get()).setECfb("ext-fwd-busy");
                } else {
                    ((Extension)extension.get()).setECfb("");
                }
            }
            if (data.getCFna() != null) {
                if (data.getCFna().equals(true)) {
                    ((Extension)extension.get()).setCFna("fwd-no-ans");
                } else {
                    ((Extension)extension.get()).setCFna("");
                }
            }
            if (data.getECFna() != null) {
                if (data.getECFna().equals(true)) {
                    ((Extension)extension.get()).setECFna("ext-fwd-no-ans");
                } else {
                    ((Extension)extension.get()).setECFna("");
                }
            }
            if (data.getIsd() != null) {
                if (data.getIsd().equals(true)) {
                    ((Extension)extension.get()).setIsd("dialing-isd");
                } else {
                    ((Extension)extension.get()).setIsd("");
                }
            }
            if (data.getStd() != null) {
                if (data.getStd().equals(true)) {
                    ((Extension)extension.get()).setStd("dialing-std");
                } else {
                    ((Extension)extension.get()).setStd("");
                }
            }
            if (data.getLocal() != null) {
                if (data.getLocal().equals(true)) {
                    ((Extension)extension.get()).setLocal("dialing-local");
                } else {
                    ((Extension)extension.get()).setLocal("");
                }
            }
            if (data.getIntercom() != null) {
                if (data.getIntercom().equals(true)) {
                    ((Extension)extension.get()).setIntercom("dialing-intercom");
                } else {
                    ((Extension)extension.get()).setIntercom("");
                }
            }
            if (data.getVm() != null) {
                if (data.getVm().equals(true)) {
                    ((Extension)extension.get()).setVm("VM");
                } else {
                    ((Extension)extension.get()).setVm("");
                }
            }
            if (data.getFm() != null) {
                if (data.getFm().equals(true)) {
                    ((Extension)extension.get()).setFm("follow-me");
                } else {
                    ((Extension)extension.get()).setFm("");
                }
            }
            if (data.getDnd() != null) {
                if (data.getDnd().equals(true)) {
                    ((Extension)extension.get()).setDnd("dnd");
                } else {
                    ((Extension)extension.get()).setDnd("");
                }
            }
            if (didMappingOptional.isPresent()) {
                DidMapping didMapping1 = (DidMapping)didMappingOptional.get();
                didMapping1.setDidNumber(data.getDid());
                didMapping1.setDodNumber(data.getDod());
                this.didMappingRepository.save((Object)didMapping1);
            }
            if (data.getCfaNumber() != null) {
                ((Extension)extension.get()).setCfaNumber(data.getCfaNumber());
            }
            if (data.getECfaNumber() != null) {
                ((Extension)extension.get()).setECfaNumber(data.getECfaNumber());
            }
            if (data.getCfbNumber() != null) {
                ((Extension)extension.get()).setCfbNumber(data.getCfbNumber());
            }
            if (data.getECfbNumber() != null) {
                ((Extension)extension.get()).setECfbNumber(data.getECfbNumber());
            }
            if (data.getCFnaNumber() != null) {
                ((Extension)extension.get()).setCFnaNumber(data.getCFnaNumber());
            }
            if (data.getECfNaNumber() != null) {
                ((Extension)extension.get()).setECfNaNumber(data.getECfNaNumber());
            }
            this.extensionsRepository.save(extension.get());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Updated");
            returnValue.setMessageDetail("Extension Updated successfully");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAcdPickUpGroup(List<String> extTypeList) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("get list of extension by extensionType:{}", extTypeList);
        List list = this.extensionsRepository.findByExtensionTypeIn(extTypeList);
        ArrayList<ExtensionCreateModel> addValue = new ArrayList<ExtensionCreateModel>();
        for (Extension data : list) {
            ExtensionCreateModel extension = new ExtensionCreateModel();
            extension.setId(data.getId());
            extension.setABarTimeout(data.getABarTimeout());
            extension.setAccountCode(data.getAccountCode());
            extension.setAcdCallback(data.getAcdCallback());
            extension.setAcdPickupGroup(data.getAcdPickupGroup());
            extension.setAlertInfo(data.getAlertInfo());
            extension.setAnonymousCallRejection(data.getAnonymousCallRejection());
            extension.setApplicationId(data.getApplicationId());
            extension.setAutoLift(data.getAutoLift());
            extension.setBrowserExt(data.getBrowserExt());
            extension.setBusyReleaseInterval(data.getBusyReleaseInterval());
            extension.setCFNATime(data.getCFNATime());
            extension.setCallContext(data.getCallContext());
            extension.setCallForwardNumber(data.getCallForwardNumber());
            extension.setCallTrace(data.getCallTrace());
            extension.setCallWaitingStatus(data.getCallWaitingStatus());
            extension.setCallerIdStatus(data.getCallerIdStatus());
            extension.setCallerOverrideToHoldParty(data.getCallerOverrideToHoldParty());
            extension.setCallerStrip(data.getCallerStrip());
            extension.setCampOnHoldMusic(data.getCampOnHoldMusic());
            extension.setCampOnRetryInterval(data.getCampOnRetryInterval());
            extension.setCanBroadcast(data.getCanBroadcast());
            extension.setCanMulticast(data.getCanMulticast());
            extension.setCheckIn(data.getCheckIn());
            extension.setCheckInEpoch(data.getCheckInEpoch());
            extension.setChimeInterval(data.getChimeInterval());
            extension.setChimePath(data.getChimePath());
            extension.setCodeBlueSentSmsConfig(data.getCodeBlueSentSmsConfig());
            extension.setCollaboration(data.getCollaboration());
            extension.setColumn1(data.getColumn1());
            extension.setColumn2(data.getColumn2());
            extension.setColumn3(data.getColumn3());
            extension.setColumn4(data.getColumn4());
            extension.setColumn5(data.getColumn5());
            extension.setColumn6(data.getColumn6());
            extension.setColumn7(data.getColumn7());
            extension.setColumn8(data.getColumn8());
            extension.setColumn9(data.getColumn9());
            extension.setColumn10(data.getColumn10());
            extension.setColumn11(data.getColumn11());
            extension.setColumn12(data.getColumn12());
            extension.setColumn13(data.getColumn13());
            extension.setColumn14(data.getColumn14());
            extension.setColumn15(data.getColumn15());
            extension.setColumn16(data.getColumn16());
            extension.setConfPwd(data.getConfPwd());
            extension.setConferenceMode(data.getConferenceMode());
            extension.setConfigEmailId(data.getConfigEmailId());
            extension.setConfirmationWavFile(data.getConfirmationWavFile());
            extension.setControlName(data.getControlName());
            extension.setCoralAcdCallType(data.getCoralAcdCallType());
            extension.setCurrentChannel(data.getCurrentChannel());
            extension.setCustomeDestination(data.getCustomeDestination());
            extension.setExtension(data.getExtension());
            extension.setExtensionType(data.getExtensionType());
            extension.setName(data.getName());
            extension.setCFNATime(data.getCFNATime());
            extension.setVideoCall(data.getVideoCall());
            extension.setWavFilename(data.getWavFilename());
            extension.setPCMA(data.getPCMA());
            extension.setPCMU(data.getPCMU());
            extension.setG722(data.getG722());
            extension.setG726(data.getG726());
            extension.setG729(data.getG729());
            extension.setG723(data.getG723());
            extension.setOpus(data.getOpus());
            extension.setVp8(data.getVp8());
            extension.setH263(data.getH263());
            extension.setH264(data.getH264());
            extension.setDayInboundCos(data.getDayInboundCos());
            extension.setNightInboundCos(data.getNightInboundCos());
            extension.setDayOutboundCos(data.getDayOutboundCos());
            extension.setNightOutboundCos(data.getNightOutboundCos());
            extension.setSecondaryDayInboundCos(data.getSecondaryDayInboundCos());
            extension.setSecondaryDayOutboundCos(data.getSecondaryDayOutboundCos());
            extension.setSecondaryNightInboundCos(data.getSecondaryNightInboundCos());
            extension.setSecondaryNightOutboundCos(data.getSecondaryNightOutboundCos());
            extension.setPrimaryDayInboundCos(data.getPrimaryDayInboundCos());
            extension.setPrimaryDayOutboundCos(data.getPrimaryDayOutboundCos());
            extension.setIMEINumber(data.getIMEINumber());
            extension.setTimeOutInSecond(data.getTimeOutInSecond());
            extension.setRingTime(data.getRingTime());
            extension.setCompany(data.getCompany());
            extension.setDepartment(data.getDepartment());
            extension.setDesignation(data.getDesignation());
            extension.setSecretary(data.getSecretary());
            extension.setCollaboration(data.getCollaboration());
            extension.setAccountCode(data.getAccountCode());
            extension.setData(data.getData());
            extension.setExtGroupId(data.getExtGroupId());
            extension.setPforkStr(data.getPforkStr());
            extension.setRecord(data.getRecord());
            extension.setEmailId(data.getEmailId());
            extension.setRluCode(data.getRluCode());
            extension.setCallWaitingStatus(data.getCallWaitingStatus());
            extension.setRingBackTone(data.getRingBackTone());
            extension.setGroupCode(data.getGroupCode());
            extension.setIsCampOnMode(data.getIsCampOnMode());
            extension.setCallTransferToVm(data.getCallTransferToVm());
            extension.setWelcomeGreeting(data.getWelcomeGreeting());
            extension.setOverflowToBoss(data.getOverflowToBoss());
            extension.setSplitRecordingFileInMinutes(data.getSplitRecordingFileInMinutes());
            extension.setPhoneStatus(data.getPhoneStatus());
            extension.setDayMode(data.getDayMode());
            extension.setNightMode(data.getNightMode());
            extension.setNonworkingData(data.getNonworkingData());
            extension.setNonworkingApp(data.getNonworkingApp());
            extension.setManufacturerId(data.getManufacturerId());
            extension.setModelDetailId(data.getModelDetailId());
            extension.setPersonalVmGreeting(data.getPersonalVmGreeting());
            extension.setMacId(data.getMacId());
            extension.setSrtP(data.getSrtP());
            extension.setZrtP(data.getZrtP());
            if (data.getDSun() != null && data.getDSun() != 0) {
                extension.setDSun(Boolean.valueOf(true));
            } else {
                extension.setDSun(Boolean.valueOf(false));
            }
            if (data.getDMon() != null && data.getDMon() != 0) {
                extension.setDMon(Boolean.valueOf(true));
            } else {
                extension.setDMon(Boolean.valueOf(false));
            }
            if (data.getDTue() != null && data.getDTue() != 0) {
                extension.setDTue(Boolean.valueOf(true));
            } else {
                extension.setDTue(Boolean.valueOf(false));
            }
            if (data.getDWed() != null && data.getDWed() != 0) {
                extension.setDWed(Boolean.valueOf(true));
            } else {
                extension.setDWed(Boolean.valueOf(false));
            }
            if (data.getDThu() != null && data.getDThu() != 0) {
                extension.setDThu(Boolean.valueOf(true));
            } else {
                extension.setDThu(Boolean.valueOf(false));
            }
            if (data.getDFri() != null && data.getDFri() != 0) {
                extension.setDFri(Boolean.valueOf(true));
            } else {
                extension.setDFri(Boolean.valueOf(false));
            }
            if (data.getDSat() != null && data.getDSat() != 0) {
                extension.setDSat(Boolean.valueOf(true));
            } else {
                extension.setDSat(Boolean.valueOf(false));
            }
            extension.setFromTime(data.getFromTime());
            extension.setToTime(data.getToTime());
            extension.setFriFromTime(data.getFriFromTime());
            extension.setFriToTime(data.getFriToTime());
            extension.setFlexibleTimings(data.getFlexibleTimings());
            extension.setMonFromTime(data.getMonFromTime());
            extension.setMonToTime(data.getMonToTime());
            extension.setTueFromTime(data.getTueFromTime());
            extension.setTueToTime(data.getTueToTime());
            extension.setWedFromTime(data.getWedFromTime());
            extension.setWedToTime(data.getWedToTime());
            extension.setThuFromTime(data.getThuFromTime());
            extension.setThuToTime(data.getThuToTime());
            extension.setSatFromTime(data.getSatFromTime());
            extension.setSatToTime(data.getSatToTime());
            extension.setNightRingTime(data.getNightRingTime());
            extension.setXmpPId(data.getXmpPId());
            extension.setAssignedUser(data.getAssignedUser());
            extension.setSmsText(data.getSmsText());
            extension.setIsSent(data.getIsSent());
            extension.setNoOfRetry(data.getNoOfRetry());
            extension.setUrl(data.getUrl());
            extension.setDialNumber(data.getDialNumber());
            extension.setSmsNumber(data.getSmsNumber());
            extension.setStar(data.getStar());
            extension.setParkExpiryInterval(data.getParkExpiryInterval());
            extension.setDestinationStrip(data.getDestinationStrip());
            extension.setOutboundGatewayGroup(data.getOutboundGatewayGroup());
            extension.setMaxChannel(data.getMaxChannel());
            extension.setIsCliBaseRouting(data.getIsCliBaseRouting());
            extension.setIsCallCenterBased(data.getIsCallCenterBased());
            extension.setStrategy(data.getStrategy());
            extension.setRestrictFeatureAccess(data.getRestrictFeatureAccess());
            extension.setVoicemail(data.getVoicemail());
            extension.setQueryOn(data.getQueryOn());
            extension.setRetryVoiceMessage(data.getRetryVoiceMessage());
            extension.setGatewayControllerCode(data.getGatewayControllerCode());
            extension.setDenyPwdPrompt(data.getDenyPwdPrompt());
            extension.setTpi(data.getTpi());
            extension.setRingReady(data.getRingReady());
            extension.setOverrideMoh(data.getOverrideMoh());
            extension.setIsExtensionBasedAcd(data.getIsExtensionBasedAcd());
            extension.setDniBasedRouting(data.getDniBasedRouting());
            extension.setSide(data.getSide());
            extension.setPhysicalPlayerName(data.getPhysicalPlayerName());
            extension.setLogicalPlayerName(data.getLogicalPlayerName());
            extension.setTransferToAgentRingBack(data.getTransferToAgentRingBack());
            extension.setRadioNetCode(data.getRadioNetCode());
            extension.setHandleIsDnCause(data.getHandleIsDnCause());
            extension.setNetType(data.getNetType());
            extension.setRemoteUserIp(data.getRemoteUserIp());
            extension.setRemoteUserType(data.getRemoteUserType());
            extension.setNoAnsSmsTry(data.getNoAnsSmsTry());
            extension.setDialType(data.getDialType());
            extension.setEnableVideoCall(data.getEnableVideoCall());
            extension.setMasterCli(data.getMasterCli());
            extension.setUNma(data.getUNma());
            extension.setHomeRluCode(data.getHomeRluCode());
            extension.setSgwUser(data.getSgwUser());
            extension.setRegisterState(data.getRegisterState());
            extension.setIvrGroup(data.getIvrGroup());
            extension.setHotelLevel(data.getLevel());
            extension.setMissCallRedial(data.getMissCallRedial());
            extension.setMissCallDialDestination(data.getMissCallDialDestination());
            extension.setVmDiskQuota(data.getVmDiskQuota());
            extension.setWebApi(data.getWebApi());
            extension.setNoAnswerOverflowToBoss(data.getNoAnswerOverflowToBoss());
            extension.setPassword(data.getPassword());
            extension.setSipPassword(data.getSipPassword());
            extension.setVmPassword(data.getVmPassword());
            extension.setZone(data.getZone());
            extension.setExtensionIp(data.getExtensionIp());
            extension.setExtensionPort(data.getExtensionPort());
            extension.setModelCode(data.getModelCode());
            extension.setTimezone(data.getTimezone());
            extension.setSunFromTime(data.getSunFromTime());
            extension.setSunToTime(data.getSunToTime());
            extension.setExtensionSubtype(data.getExtensionSubtype());
            extension.setIMSI(data.getIMSI());
            extension.setKValue(data.getKValue());
            extension.setOPopc(data.getOPopc());
            extension.setMsiSdn(data.getMsiSdn());
            extension.setPremiumCustomer(data.getPremiumCustomer());
            extension.setGroupType(data.getGroupType());
            extension.setUuid(data.getUuid());
            extension.setIsFeedBack(data.getIsFeedBack());
            extension.setExtGroupCode(data.getExtGroupCode());
            extension.setPrimaryNightInboundCos(data.getPrimaryNightInboundCos());
            extension.setPrimaryNightOutboundCos(data.getPrimaryNightOutboundCos());
            extension.setXmpPPassword(data.getXmpPPassword());
            extension.setCfa(data.getCfa());
            extension.setECfa(data.getECfa());
            extension.setCfb(data.getCfb());
            extension.setECfb(data.getECfb());
            extension.setCFna(data.getCFna());
            extension.setECFna(data.getECFna());
            extension.setIsd(data.getIsd());
            extension.setStd(data.getStd());
            extension.setLocal(data.getLocal());
            extension.setIntercom(data.getIntercom());
            extension.setVm(data.getVm());
            extension.setFm(data.getFm());
            extension.setDnd(data.getDnd());
            extension.setDid(data.getDidNumber());
            extension.setDod(data.getDodNumber());
            extension.setCfaNumber(data.getCfaNumber());
            extension.setECfaNumber(data.getECfaNumber());
            extension.setCfbNumber(data.getCfbNumber());
            extension.setECfbNumber(data.getECfbNumber());
            extension.setCFnaNumber(data.getCFnaNumber());
            extension.setECfNaNumber(data.getECfNaNumber());
            addValue.add(extension);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("list of extension by ExtensionType");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse playFileForZone(Principal principal, PlayFileModel data) {
        RequestResponse returnValue = new RequestResponse();
        String callerNumber = "";
        logger.info("play file initiate for Zone:{}", (Object)data.getZone());
        if (!StringUtils.hasLength((String)data.getZone()) || !StringUtils.hasLength((String)data.getZone())) {
            logger.error("Invalid Zone type:{}", (Object)data.getZone());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid Zone");
            return returnValue;
        }
        try {
            List groupNameList = this.extensionsRepository.findByExtensionTypeAndZone("ec", data.getZone());
            if (groupNameList.isEmpty()) {
                logger.error("Not any record exist of given group zone:{}", (Object)data.getZone());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present in given zone");
                return returnValue;
            }
            Extension groupNameData = (Extension)groupNameList.get(0);
            callerNumber = groupNameData.getExtension();
            logger.info("Caller number of selected group is:{}", (Object)callerNumber);
            String rluCode = this.controlRluServerService.getRluCodeFinal(callerNumber);
            String sofiaProfile = this.controlRluServerService.getProfileName(callerNumber);
            logger.info("sofiaProfile:{}", (Object)(sofiaProfile + ",RluCode:{}"), (Object)rluCode);
            String loggedInNumber = this.getExtensionOfUser(principal.getName());
            String ip = this.cdrService.getIpProxyServer();
            ArrayList<String> destinationNumber = new ArrayList<String>();
            List extensionList = this.extensionsRepository.findByExtensionTypeAndZone("phone", data.getZone());
            if (!extensionList.isEmpty()) {
                for (Extension extensionData : extensionList) {
                    String extensionNumber = extensionData.getExtension();
                    if (extensionNumber.equals(loggedInNumber)) continue;
                    destinationNumber.add(extensionNumber);
                }
            } else {
                logger.error("Not any record exist of given zone:{}", (Object)data.getZone());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present in given zone");
                return returnValue;
            }
            logger.info("List of Destination number:{}", destinationNumber);
            if (!destinationNumber.isEmpty()) {
                for (String destination : destinationNumber) {
                    String command = String.format("fs_cli -x \"bgapi originate {absolute_codec_string='PCMU,PCMA',origination_caller_id_number=%s}sofia/%s/%s@%s &playback('/home/coralswitch/queuesounds/%s')\"", callerNumber, sofiaProfile, destination, ip, data.getWavFile());
                    logger.info("command to execute call is:::{}", (Object)command);
                    Telephony.makeCallBackCall((String)command);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Play file execute successfully");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error during call initiation:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to execute call");
        }
        return returnValue;
    }

    public RequestResponse playFileForDepartment(Principal principal, PlayFileModel data) {
        RequestResponse returnValue = new RequestResponse();
        String callerNumber = "";
        logger.info("play file initiate for Department:{}", (Object)data.getDepartment());
        if (!StringUtils.hasLength((String)data.getDepartment()) || !StringUtils.hasLength((String)data.getDepartment())) {
            logger.error("Invalid Department type:{}", (Object)data.getDepartment());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid Department");
            return returnValue;
        }
        try {
            List groupNameList = this.extensionsRepository.findByExtensionTypeAndDepartment("ec", data.getDepartment());
            if (groupNameList.isEmpty()) {
                logger.error("Not any record exist of given group department:{}", (Object)data.getDepartment());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present in given department");
                return returnValue;
            }
            Extension groupNameData = (Extension)groupNameList.get(0);
            callerNumber = groupNameData.getExtension();
            logger.info("Caller number of selected group is:{}", (Object)callerNumber);
            String rluCode = this.controlRluServerService.getRluCodeFinal(callerNumber);
            String sofiaProfile = this.controlRluServerService.getProfileName(callerNumber);
            logger.info("sofiaProfile:{}", (Object)(sofiaProfile + ",RluCode:{}"), (Object)rluCode);
            String ip = this.cdrService.getIpProxyServer();
            String loggedInNumber = this.getExtensionOfUser(principal.getName());
            ArrayList<String> destinationNumber = new ArrayList<String>();
            List extensionList = this.extensionsRepository.findByExtensionTypeAndDepartment("phone", data.getDepartment());
            if (!extensionList.isEmpty()) {
                for (Extension extensionData : extensionList) {
                    String extensionNumber = extensionData.getExtension();
                    if (extensionNumber.equals(loggedInNumber)) continue;
                    destinationNumber.add(extensionNumber);
                }
            } else {
                logger.error("Not any record exist of given Department:{}", (Object)data.getDepartment());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present in given Department");
                return returnValue;
            }
            logger.info("List of Destination number:{}", destinationNumber);
            if (!destinationNumber.isEmpty()) {
                for (String destination : destinationNumber) {
                    if (this.getRegisteredExtension().contains(destination)) {
                        String command = String.format("fs_cli -x \"bgapi originate {sip_h_X-Broadcast_Speaker=true,ignore_early_media=true,absolute_codec_string='OPUS,PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=paging}sofia/%s/%s@%s &playback('/home/coralswitch/queuesounds/%s')\"", callerNumber, sofiaProfile, destination, ip, data.getWavFile());
                        logger.info("command to execute call is:::{}", (Object)command);
                        Telephony.makeCallBackCall((String)command);
                        this.userService.uploadAnnouncementFile(destination, "/home/coralswitch/queuesounds/" + data.getWavFile(), Long.valueOf(System.currentTimeMillis() / 1000L), "Announcement for Selected Group", principal.getName());
                        continue;
                    }
                    logger.error("Not Registered:Call not originate for Number:{}", (Object)destination);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Play file execute successfully");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error during call initiation:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to execute call");
        }
        return returnValue;
    }

    public boolean isExtensionUCType(String extension) {
        Optional extensionExist = this.extensionsRepository.findByExtension(extension);
        try {
            Optional checkUcUSer;
            String assignedUser;
            return extensionExist.isPresent() && StringUtils.hasText((String)(assignedUser = ((Extension)extensionExist.get()).getAssignedUser())) && (checkUcUSer = this.extensionsRepository.findByAssignedUserAndExtensionType(assignedUser, "uc")).isPresent();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public RequestResponse selectedZoneList(String zone) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("Call initiate for Zone:{}", (Object)zone);
        if (!StringUtils.hasLength((String)zone)) {
            logger.error("Invalid zone:{}", (Object)zone);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid zone");
            return returnValue;
        }
        try {
            ArrayList<ExtensionZoneModel> addValue = new ArrayList<ExtensionZoneModel>();
            List extensionList = this.extensionsRepository.findByExtensionTypeAndZone("phone", zone);
            if (!extensionList.isEmpty()) {
                for (Extension extensionData : extensionList) {
                    ExtensionZoneModel data = new ExtensionZoneModel();
                    data.setId(extensionData.getId());
                    data.setExtension(extensionData.getExtension());
                    data.setName(extensionData.getName());
                    data.setExtensionType(extensionData.getExtensionType());
                    data.setZone(extensionData.getZone());
                    addValue.add(data);
                }
                logger.info("list retrieve successfully of zone:{}", (Object)zone);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("List of records");
                returnValue.setData(addValue);
                return returnValue;
            }
            logger.error("Not any record exist of given zone:{}", (Object)zone);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("No data present in given zone");
            return returnValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error on getting zoneList:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to return data");
            return returnValue;
        }
    }

    public RequestResponse selectedDepartmentList(String department) {
        RequestResponse returnValue = new RequestResponse();
        if (!StringUtils.hasLength((String)department)) {
            logger.error("Invalid department:{}", (Object)department);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid department");
            return returnValue;
        }
        try {
            ArrayList<ExtensionDepartmentModel> addValue = new ArrayList<ExtensionDepartmentModel>();
            List extensionList = this.extensionsRepository.findByExtensionTypeAndDepartment("phone", department);
            if (!extensionList.isEmpty()) {
                for (Extension extensionData : extensionList) {
                    ExtensionDepartmentModel data = new ExtensionDepartmentModel();
                    data.setId(extensionData.getId());
                    data.setExtension(extensionData.getExtension());
                    data.setName(extensionData.getName());
                    data.setExtensionType(extensionData.getExtensionType());
                    data.setDepartment(extensionData.getDepartment());
                    addValue.add(data);
                }
                logger.info("list retrieve successfully of department:{}", (Object)department);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("List of records");
                returnValue.setData(addValue);
                return returnValue;
            }
            logger.error("Not any record exist of given department:{}", (Object)department);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("No data present in given department");
            return returnValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error on getting departmentList:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to return data");
            return returnValue;
        }
    }

    public String getColorOfDepartment(String department) {
        List departmentColor = this.departmentRepository.findByDescriptionOrderByIdDesc(department);
        if (!departmentColor.isEmpty()) {
            Department data = (Department)departmentColor.get(0);
            if (data.getColor() != null) {
                return data.getColor();
            }
            return "";
        }
        return "";
    }

    public Integer getSerialOfDepartment(String department) {
        List departmentColor = this.departmentRepository.findByDescriptionOrderByIdDesc(department);
        if (!departmentColor.isEmpty()) {
            Department data = (Department)departmentColor.get(0);
            if (data.getSerialNo() != null) {
                return data.getSerialNo();
            }
            return 0;
        }
        return 0;
    }

    public RequestResponse updateDidByExtension(String extension, String didNumber) {
        RequestResponse returnValue = new RequestResponse();
        if (!StringUtils.hasLength((String)didNumber) || !StringUtils.hasLength((String)extension)) {
            logger.error("Invalid didNumber:{},extension:{}", (Object)didNumber, (Object)extension);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid didNumber");
            return returnValue;
        }
        if (didNumber.equals("reset")) {
            this.didMappingRepository.findAllByExtNumber(extension).forEach(didMapping -> {
                didMapping.setDidNumber("");
                didMapping.setDodNumber("");
                this.didMappingRepository.save(didMapping);
            });
            logger.error("DidMapping reset successfully of extension{}", (Object)extension);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("DidMapping reset successfully");
            return returnValue;
        }
        try {
            this.extensionsRepository.findAllByName(didNumber).forEach(extensionData -> {
                extensionData.setName(extensionData.getExtension());
                this.extensionsRepository.save(extensionData);
            });
            this.didMappingRepository.findAllByDidNumber(didNumber).forEach(didMapping -> {
                didMapping.setDidNumber("");
                didMapping.setDodNumber("");
                this.didMappingRepository.save(didMapping);
            });
            Optional extensionToUpdate = this.extensionsRepository.findByExtension(extension);
            if (extensionToUpdate.isPresent()) {
                ((Extension)extensionToUpdate.get()).setName(didNumber);
                this.extensionsRepository.save(extensionToUpdate.get());
                logger.info("Extension updated successfully");
            } else {
                logger.error("Not any record exist of Selected extension:{}", (Object)extension);
            }
            Optional didExist = this.didMappingRepository.findByExtNumber(extension);
            if (didExist.isPresent()) {
                ((DidMapping)didExist.get()).setDidNumber(didNumber);
                ((DidMapping)didExist.get()).setDodNumber(didNumber);
                this.didMappingRepository.save(didExist.get());
                logger.info("didMapping updated successfully");
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("DidMapping updated");
                return returnValue;
            }
            logger.error("Not any record exist of Selected extension:{}", (Object)extension);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("No data present in DidMapping");
            return returnValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error on updating did:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to return data");
            return returnValue;
        }
    }

    public boolean getSgwUser(String extension) {
        Optional extensionData = this.extensionsRepository.findByExtension(extension);
        if (extensionData.isPresent()) {
            if (((Extension)extensionData.get()).getSgwUser() != null) {
                return ((Extension)extensionData.get()).getSgwUser();
            }
            return false;
        }
        return false;
    }

    public List<String> getRegisteredExtension() {
        List locationUsers = this.locationSwitchRepository.findAll().stream().map(LocationSwitch::getUsername).collect(Collectors.toList());
        List sipUsers = this.sipRegistrationRepository.findAll().stream().map(SipRegistrations::getSipuser).collect(Collectors.toList());
        Set distinctUsers = Stream.concat(locationUsers.stream(), sipUsers.stream()).collect(Collectors.toSet());
        return distinctUsers.stream().collect(Collectors.toList());
    }

    public List<String> getActiveParticipantByConfNumber(String conferenceNumber) {
        try {
            return this.mcxParticipantRepository.findByJoinConference(conferenceNumber).stream().map(McxParticipant::getParticipantNo).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("Error while getting data from mcxParticipant: {}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public List<String> getActiveParticipantAll() {
        try {
            return this.mcxParticipantRepository.findAll().stream().map(McxParticipant::getParticipantNo).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("Error while getting data from mcxParticipant: {}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public String getEcExtensionByGroupName(String groupName) {
        List getData = this.extensionsRepository.findByExtensionTypeAndDepartment("ec", groupName);
        if (!getData.isEmpty()) {
            return ((Extension)getData.get(0)).getExtension();
        }
        return "";
    }

    public RequestResponse playFileForDepartment1(Principal principal, PlayFileModel data) {
        RequestResponse returnValue = new RequestResponse();
        String callerNumber = "";
        logger.info("play file initiate for Department:{}", (Object)data.getDepartment());
        if (!StringUtils.hasLength((String)data.getDepartment()) || !StringUtils.hasLength((String)data.getDepartment())) {
            logger.error("Invalid Department type:{}", (Object)data.getDepartment());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Invalid Department");
            return returnValue;
        }
        try {
            List groupNameList = this.extensionsRepository.findByExtensionTypeAndDepartment("ec", data.getDepartment());
            if (groupNameList.isEmpty()) {
                logger.error("Not any record exist of given group department:{}", (Object)data.getDepartment());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present in given department");
                return returnValue;
            }
            Extension groupNameData = (Extension)groupNameList.get(0);
            callerNumber = groupNameData.getExtension();
            logger.info("Caller number of selected group is:{}", (Object)callerNumber);
            String rluCode = this.controlRluServerService.getRluCodeFinal(callerNumber);
            String sofiaProfile = this.controlRluServerService.getProfileName(callerNumber);
            logger.info("sofiaProfile:{}", (Object)(sofiaProfile + ",RluCode:{}"), (Object)rluCode);
            String loggedInNumber = this.getExtensionOfUser(principal.getName());
            ArrayList<String> destinationNumber = new ArrayList<String>();
            List extensionList = this.activeParticipantRepository.findByActiveDepartment(data.getDepartment());
            if (!extensionList.isEmpty()) {
                for (ActiveParticipant extensionData : extensionList) {
                    String extensionNumber = extensionData.getParticipantNo();
                    if (extensionNumber.equals(loggedInNumber)) continue;
                    destinationNumber.add(extensionNumber);
                }
            } else {
                logger.error("Not any record exist of given Department:{}", (Object)data.getDepartment());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("No data present in given Department.");
                return returnValue;
            }
            logger.info("List of Destination number:{}", destinationNumber);
            if (!destinationNumber.isEmpty()) {
                if (Constants.CONFERENCE_PROVIDER == 4) {
                    Optional currentUser = this.userService.getUserByName(principal.getName());
                    String dispatcherNumber = Constants.DISPATCHER_NUMBER;
                    if (currentUser.isPresent() && StringUtils.hasText((String)((User)currentUser.get()).getContactNo())) {
                        dispatcherNumber = ((User)currentUser.get()).getContactNo();
                    }
                    VoiceMessageModel voiceMessage = new VoiceMessageModel();
                    voiceMessage.setBroadcastSourceNumber(dispatcherNumber);
                    voiceMessage.setBroadcastType(StringUtils.hasText((String)data.getAnnouncementType()) ? data.getAnnouncementType() : data.getWavFile().split("\\.")[0]);
                    voiceMessage.setRecipients(destinationNumber.toArray(new String[0]));
                    voiceMessage.setBroadcastDialNumber(dispatcherNumber);
                    voiceMessage.setBroadcastUUID(UUID.randomUUID().toString());
                    voiceMessage.setMessageFile(data.getWavFile());
                    HttpUtils.sendVoiceMessagePPDR((VoiceMessageModel)voiceMessage);
                    logger.info("Announcement sent {}", (Object)voiceMessage);
                } else {
                    for (String destination : destinationNumber) {
                        if (this.getRegisteredExtension().contains(destination)) {
                            String command = String.format("fs_cli -x \"bgapi originate {sip_h_X-Broadcast_Speaker=true,ignore_early_media=true,absolute_codec_string='OPUS,PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=paging}sofia/%s/%s@%s &playback('/home/coralswitch/queuesounds/%s')\"", callerNumber, sofiaProfile, destination, Constants.DISPATCHER_SIP_SERVER, data.getWavFile());
                            logger.info("command to execute call is:::{}", (Object)command);
                            Telephony.makeCallBackCall((String)command);
                            this.userService.uploadAnnouncementFile(destination, "/home/coralswitch/queuesounds/" + data.getWavFile(), Long.valueOf(System.currentTimeMillis() / 1000L), "Announcement for Selected Group", principal.getName());
                            continue;
                        }
                        logger.error("Not Registered:Call not originate for Number:{}", (Object)destination);
                    }
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Play file execute successfully");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error during call initiation:{}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to execute call");
        }
        return returnValue;
    }

    public RequestResponse departmentCall1(Principal principal, MCXCallModel data) {
        RequestResponse returnValue;
        block11: {
            returnValue = new RequestResponse();
            String callerNumber = "";
            if (!StringUtils.hasLength((String)data.getDepartment()) || !StringUtils.hasLength((String)data.getCallType())) {
                logger.error("Invalid call type:{} or department:{}", (Object)data.getCallType(), (Object)data.getDepartment());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Invalid call type or department");
                return returnValue;
            }
            try {
                String loggedInNumber = this.getExtensionOfUser(principal.getName());
                String ip = this.cdrService.getIpProxyServer();
                ArrayList<String> destinationNumber = new ArrayList<String>();
                List groupNameList = this.extensionsRepository.findByExtensionTypeAndDepartment("ec", data.getDepartment());
                if (groupNameList.isEmpty()) {
                    logger.error("Not any record exist of given group department:{}", (Object)data.getDepartment());
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("No data present in given department");
                    return returnValue;
                }
                Extension groupNameData = (Extension)groupNameList.get(0);
                callerNumber = groupNameData.getExtension();
                logger.info("Caller number of selected group is:{}", (Object)callerNumber);
                String rluCode = this.controlRluServerService.getRluCodeFinal(callerNumber);
                String sofiaProfile = this.controlRluServerService.getProfileName(callerNumber);
                logger.info("sofiaProfile:{}", (Object)(sofiaProfile + ",RluCode:{}"), (Object)rluCode);
                List extensionList = this.activeParticipantRepository.findByActiveDepartment(data.getDepartment());
                if (!extensionList.isEmpty()) {
                    for (ActiveParticipant extensionData : extensionList) {
                        if (extensionData.getParticipantNo() == null || extensionData.getParticipantNo().equals(loggedInNumber)) continue;
                        destinationNumber.add(extensionData.getParticipantNo());
                    }
                } else {
                    logger.error("Not any record exist of given department:{}", (Object)data.getDepartment());
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("No data present in given department");
                    return returnValue;
                }
                logger.info("List of Destination number:{}", destinationNumber);
                if (destinationNumber.isEmpty()) break block11;
                for (String destination : destinationNumber) {
                    if (this.getRegisteredExtension().contains(destination)) {
                        String command;
                        logger.info("Caller:{} and destination:{}", (Object)callerNumber, (Object)destination);
                        logger.info("Type of call is:{}", (Object)data.getCallType());
                        if (data.getCallType().equalsIgnoreCase("presenter")) {
                            command = "";
                            command = data.getIsAudioOnly() != null && data.getIsAudioOnly().booleanValue() ? (data.getIsBroadCast() != null && data.getIsBroadCast().booleanValue() ? String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,absolute_codec_string='PCMU,PCMA', origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,absolute_codec_string='PCMU,PCMA', origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber)) : (data.getIsBroadCast() != null && data.getIsBroadCast() != false ? String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@video-mcu-stereo)\"", callerNumber, sofiaProfile, destination, ip, callerNumber));
                            logger.info("command to execute call is:::{}", (Object)command);
                            Telephony.makeCallBackCall((String)command);
                            returnValue.setStatus(Constants.Error.OK);
                            returnValue.setMessage("Call execute successfully");
                            continue;
                        }
                        if (data.getCallType().equalsIgnoreCase("muxing")) {
                            command = "";
                            command = data.getIsAudioOnly() != null && data.getIsAudioOnly().booleanValue() ? (data.getIsBroadCast() != null && data.getIsBroadCast().booleanValue() ? String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,absolute_codec_string='PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,absolute_codec_string='PCMU,PCMA',origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber)) : (data.getIsBroadCast() != null && data.getIsBroadCast() != false ? String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=0}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber) : String.format("fs_cli -x \"bgapi originate {ignore_early_media=true,origination_caller_id_number=%s,sip_h_X-coral_dial_type=ec,sip_h_X-mcxvideo=1}sofia/%s/%s@%s &conference(%s@videomux)\"", callerNumber, sofiaProfile, destination, ip, callerNumber));
                            logger.info("command to execute call is:::{}", (Object)command);
                            Telephony.makeCallBackCall((String)command);
                            returnValue.setStatus(Constants.Error.OK);
                            returnValue.setMessage("Call execute successfully");
                            continue;
                        }
                        returnValue.setStatus(Constants.Error.ERROR);
                        returnValue.setMessage("Invalid call type");
                        logger.error("Invalid call type select:{}", (Object)data.getCallType());
                        break;
                    }
                    logger.error("Not Registered:Call not originate for Number:{}", (Object)destination);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("error during call initiation:{}", (Object)e.getMessage());
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Unable to execute call");
            }
        }
        return returnValue;
    }

    public RequestResponse getExtensionTypeList() {
        RequestResponse returnValue = new RequestResponse();
        List uniqueTypes = this.extensionsRepository.findDistinctExtensionTypes();
        if (uniqueTypes.isEmpty()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("No unique extension types found");
            logger.error("No unique extension types found");
            return returnValue;
        }
        ArrayList responseList = new ArrayList();
        for (String type : uniqueTypes) {
            List extensions = this.extensionsRepository.findExtensionsByType(type);
            if (extensions.isEmpty()) continue;
            HashMap<String, Object> typeMap = new HashMap<String, Object>();
            typeMap.put("extensions", extensions);
            typeMap.put("ExtensionType", type);
            responseList.add(typeMap);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("List of unique extensions");
        returnValue.setMessageDetail(null);
        returnValue.setData(responseList);
        logger.info("Fetched unique extensions successfully");
        return returnValue;
    }

    public RequestResponse getExtnsionTypeFilter(ExtensionTypeModel extTypeList) {
        RequestResponse returnValue = new RequestResponse();
        try {
            List extensions = this.extensionsRepository.findByExtensionTypeIn(extTypeList.getRequestExtensionType());
            if (extensions.isEmpty()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("No extensions found for the provided types");
                logger.error("No extensions found for the provided types: {}", (Object)extTypeList.getRequestExtensionType());
                return returnValue;
            }
            List result = extensions.stream().map(r -> new ExtensionTypeModel(r.getExtension(), r.getName(), r.getRluCode(), r.getExtensionType())).collect(Collectors.toList());
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Filtered extensions retrieved successfully");
            returnValue.setData(result);
            logger.info("Filtered extensions retrieved successfully for types: {}", (Object)extTypeList);
        }
        catch (Exception e) {
            logger.error("Error while fetching filtered extensions: {}", (Object)e.getMessage());
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Unable to retrieve filtered extensions");
        }
        return returnValue;
    }
}

