/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.conferenceMeeting.configureConferencer.service;

import com.coraltele.db.telephony.pbx.entity.ConferenceParticipant;
import com.coraltele.db.telephony.pbx.entity.ConferenceRoom;
import com.coraltele.db.telephony.pbx.entity.ConfigureConference;
import com.coraltele.db.telephony.pbx.entity.EmailDetail;
import com.coraltele.db.telephony.pbx.entity.view.ConferenceDetails;
import com.coraltele.db.telephony.pbx.repository.ConferenceDetailsRepository;
import com.coraltele.db.telephony.pbx.repository.ConferenceParticipantRepository;
import com.coraltele.db.telephony.pbx.repository.ConferenceRoomRepository;
import com.coraltele.db.telephony.pbx.repository.ConfigureConferenceRepository;
import com.coraltele.db.telephony.pbx.repository.EmailDetailRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.conferenceMeeting.conferenceMeetingRoom.model.ConferenceMeetingModel;
import com.coraltele.service.pbx.conferenceMeeting.configureConferencer.model.ConferenceDateModel;
import com.coraltele.service.pbx.conferenceMeeting.configureConferencer.model.ConferenceDateTimeModel;
import com.coraltele.service.pbx.conferenceMeeting.configureConferencer.model.ConferenceReturnModel;
import com.coraltele.service.pbx.conferenceMeeting.configureConferencer.model.ConferenceUpdateModel;
import java.security.Principal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ConferenceService {
    private static final Logger logger = LogManager.getLogger(ConferenceService.class);
    @Autowired
    ConfigureConferenceRepository conferenceRepository;
    @Autowired
    EmailDetailRepository emailDetailsRepository;
    @Autowired
    ConferenceRoomRepository conferenceRoomRepository;
    @Autowired
    ConferenceParticipantRepository conferenceParticipantRepository;
    @Autowired
    ConferenceDetailsRepository conferenceDetailsRepository;

    public RequestResponse getConferenceList() {
        RequestResponse returnValue = new RequestResponse();
        try {
            HashSet<LocalDate> uniqueScheduledDates = new HashSet<LocalDate>();
            List data = this.conferenceRepository.findByScheduledDateGreaterThanEqualAndStatusNotOrderByScheduledDateAsc(LocalDate.now(), "C");
            if (data != null && !data.isEmpty()) {
                ArrayList<ConferenceDateModel> result = new ArrayList<ConferenceDateModel>();
                for (ConfigureConference row : data) {
                    LocalDate scheduledDate = row.getScheduledDate();
                    if (!uniqueScheduledDates.add(scheduledDate)) continue;
                    ConferenceDateModel record = new ConferenceDateModel();
                    record.setId(row.getId());
                    record.setScheduledDate(row.getScheduledDate());
                    result.add(record);
                }
                returnValue.setData(result);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("list of upcoming conference");
                logger.info("scheduled conference list rendered successfully");
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Empty records");
                logger.error("Not any upcoming conference available");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getByScheduleDate(ConferenceDateModel date) {
        RequestResponse returnValue;
        block8: {
            returnValue = new RequestResponse();
            try {
                List configureConferenceList = this.conferenceRepository.findByScheduledDate(date.getScheduledDate());
                if (!configureConferenceList.isEmpty()) {
                    ArrayList<ConferenceDateTimeModel> dataList = new ArrayList<ConferenceDateTimeModel>();
                    for (ConfigureConference conference : configureConferenceList) {
                        ConferenceDateTimeModel data = new ConferenceDateTimeModel();
                        Optional meetingRoomDetail = this.conferenceRoomRepository.findById(conference.getRoomId());
                        if (meetingRoomDetail.isPresent()) {
                            data.setMeetingRoom(((ConferenceRoom)meetingRoomDetail.get()).getRoomName());
                        }
                        try {
                            List participantData = this.conferenceParticipantRepository.findByConfigureConferrerIdAndIsModeratorRecord(conference.getId(), Integer.valueOf(1));
                            if (!participantData.isEmpty()) {
                                ConferenceParticipant participantData1 = (ConferenceParticipant)participantData.get(0);
                                data.setAccessCode(participantData1.getAccessCode());
                                data.setConferencePassword(participantData1.getConferencePassword());
                            }
                        }
                        catch (Exception e) {
                            logger.error("Duplicate moderator present:" + e.getMessage());
                        }
                        data.setId(conference.getId());
                        data.setFromTime(conference.getFromTime());
                        data.setToTime(conference.getToTime());
                        dataList.add(data);
                    }
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Records Found");
                    returnValue.setData(dataList);
                    logger.info(returnValue.getMessage());
                    break block8;
                }
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("No records found for the given date");
                logger.info(returnValue.getMessage());
            }
            catch (Exception e) {
                returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
                returnValue.setMessage("Unable to retrieve records");
                returnValue.setMessageDetail("Contact the administrator");
                logger.error(returnValue.getMessage(), (Throwable)e);
            }
        }
        return returnValue;
    }

    public RequestResponse updateByConfigureConferenceId(ConferenceUpdateModel data, Authentication authentication) {
        logger.debug("Update configureConference {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional configureConference = this.conferenceRepository.findById(data.getModId());
        if (!configureConference.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("configureConference Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getFromTime() != null) {
            ((ConfigureConference)configureConference.get()).setFromTime(data.getFromTime());
        }
        if (data.getToTime() != null) {
            ((ConfigureConference)configureConference.get()).setToTime(data.getToTime());
        }
        if (data.getMeetingScheduledDate() != null) {
            ((ConfigureConference)configureConference.get()).setScheduledDate(data.getMeetingScheduledDate());
        }
        if (data.getScheduledToDate() != null) {
            ((ConfigureConference)configureConference.get()).setScheduledToDate(data.getScheduledToDate());
        }
        ((ConfigureConference)configureConference.get()).setStatus("R");
        ((ConfigureConference)configureConference.get()).setModifiedBy(authentication.getName());
        ((ConfigureConference)configureConference.get()).setModifiedOn(LocalDateTime.now());
        List list = this.conferenceParticipantRepository.findByConfigureConferrerId(data.getModId());
        if (list == null || list.isEmpty()) {
            returnValue.setMessage("Participant list is empty");
            logger.error("unable to fetch data: " + returnValue.getMessage());
        } else {
            for (ConferenceParticipant conferenceParticipant : list) {
                EmailDetail emailDetails = new EmailDetail();
                emailDetails.setType("conf");
                emailDetails.setAccessCode(conferenceParticipant.getAccessCode());
                emailDetails.setConferencePassword(conferenceParticipant.getConferencePassword());
                emailDetails.setCreatedTime(LocalDateTime.now());
                emailDetails.setEmailId(conferenceParticipant.getEmailId());
                emailDetails.setMailSubject("reschedule");
                emailDetails.setParticipant(conferenceParticipant.getParticipantName());
                if (data.getMeetingScheduledDate() != null) {
                    emailDetails.setMeetingDate(data.getMeetingScheduledDate());
                }
                if (data.getFromTime() != null) {
                    emailDetails.setMeetingFromTime(data.getFromTime());
                }
                if (data.getToTime() != null) {
                    emailDetails.setMeetingToTime(data.getToTime());
                }
                this.emailDetailsRepository.save((Object)emailDetails);
            }
        }
        this.conferenceRepository.save(configureConference.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Conference re-schedule Successfully");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse updateByCancel(ConferenceUpdateModel data, Principal authentication) {
        logger.debug("Update configureConference {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional configureConference = this.conferenceRepository.findById(data.getModId());
        if (!configureConference.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("configureConference Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        ((ConfigureConference)configureConference.get()).setStatus("C");
        ((ConfigureConference)configureConference.get()).setModifiedBy(authentication.getName());
        ((ConfigureConference)configureConference.get()).setModifiedOn(LocalDateTime.now());
        List list = this.conferenceParticipantRepository.findByConfigureConferrerId(data.getModId());
        if (list == null || list.isEmpty()) {
            returnValue.setMessage("Participant list is empty");
            logger.error("unable to fetch data: " + returnValue.getMessage());
        } else {
            for (ConferenceParticipant conferenceParticipant : list) {
                EmailDetail emailDetails = new EmailDetail();
                emailDetails.setType("conf");
                emailDetails.setAccessCode(conferenceParticipant.getAccessCode());
                emailDetails.setConferencePassword(conferenceParticipant.getConferencePassword());
                emailDetails.setCreatedTime(LocalDateTime.now());
                emailDetails.setEmailId(conferenceParticipant.getEmailId());
                emailDetails.setMailSubject("cancel");
                emailDetails.setParticipant(conferenceParticipant.getParticipantName());
                emailDetails.setMeetingDate(((ConfigureConference)configureConference.get()).getScheduledDate());
                emailDetails.setMeetingFromTime(((ConfigureConference)configureConference.get()).getFromTime());
                emailDetails.setMeetingToTime(((ConfigureConference)configureConference.get()).getToTime());
                this.emailDetailsRepository.save((Object)emailDetails);
            }
        }
        this.conferenceRepository.save(configureConference.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("Conference canceled Successfully");
        logger.info(returnValue.getMessageDetail());
        return returnValue;
    }

    public RequestResponse getWeekOfData(ConferenceDateModel date, Principal authentication) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ConferenceMeetingModel> addValue = new ArrayList<ConferenceMeetingModel>();
        try {
            LocalDate startDate = date.getScheduledDate().minusDays(date.getScheduledDate().getDayOfWeek().getValue() - 1);
            LocalDate endDate = date.getScheduledDate().plusDays(7 - date.getScheduledDate().getDayOfWeek().getValue());
            if (date.getScheduledDate() != null & !date.getScheduledDate().equals("")) {
                List results = this.conferenceDetailsRepository.findAllByMeetingScheduledDateBetweenOrderByMeetingScheduledDate(startDate, endDate);
                if (!results.isEmpty()) {
                    for (ConferenceDetails meetingInfo : results) {
                        if (!meetingInfo.getCreatedBy().equals(authentication.getName())) continue;
                        ConferenceMeetingModel data = new ConferenceMeetingModel();
                        data.setId(meetingInfo.getId());
                        data.setRoomName(meetingInfo.getRoomName());
                        data.setBeepInterval(meetingInfo.getBeepInterval());
                        data.setRetryCount(meetingInfo.getRetryCount());
                        data.setDidMapping(meetingInfo.getDidMapping());
                        data.setMeetingScheduledDate(meetingInfo.getMeetingScheduledDate());
                        data.setFromTime(meetingInfo.getFromTime());
                        data.setToTime(meetingInfo.getToTime());
                        data.setVoiceRecognition(meetingInfo.getVoiceRecognition());
                        data.setPasswordRequired(meetingInfo.getPasswordRequired());
                        data.setNameAnnouncementRequired(meetingInfo.getNameAnnouncementRequired());
                        data.setMeetingType(meetingInfo.getMeetingType());
                        data.setConferenceRetryCount(meetingInfo.getRetryCount());
                        data.setRetryDelay(meetingInfo.getRetryDelay());
                        data.setRecording(meetingInfo.getRecording());
                        data.setConferenceType(meetingInfo.getConferenceType());
                        data.setCoralConfGreetingsPath(meetingInfo.getCoralConfGreetingsPath());
                        data.setParticipantName(meetingInfo.getParticipantName());
                        data.setEmailId(meetingInfo.getEmailId());
                        data.setMobileNumber(meetingInfo.getMobileNumber());
                        data.setExtensions(meetingInfo.getExtensions());
                        data.setAccessCode(meetingInfo.getAccessCode());
                        data.setStatus(meetingInfo.getStatus());
                        data.setRPtt(meetingInfo.getRPtt());
                        data.setModId(meetingInfo.getModId());
                        data.setPId(meetingInfo.getPId());
                        addValue.add(data);
                    }
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Records Found");
                    returnValue.setData(addValue);
                    logger.info(returnValue.getMessage());
                } else {
                    returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                    returnValue.setMessage("data not present");
                    logger.info(returnValue.getMessage());
                }
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Enter valid date");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to retrieve records");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessage(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getMonthOfData(ConferenceDateModel date, Principal authentication) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ConferenceMeetingModel> addValue = new ArrayList<ConferenceMeetingModel>();
        try {
            if (date.getScheduledDate() != null) {
                LocalDate endDate;
                LocalDate startDate = date.getScheduledDate().withDayOfMonth(1);
                List results = this.conferenceDetailsRepository.findAllByMeetingScheduledDateBetweenOrderByMeetingScheduledDate(startDate, endDate = date.getScheduledDate().plusMonths(1L).withDayOfMonth(1).minusDays(1L));
                if (!results.isEmpty()) {
                    for (ConferenceDetails meetingInfo : results) {
                        if (!meetingInfo.getCreatedBy().equals(authentication.getName())) continue;
                        ConferenceMeetingModel data = new ConferenceMeetingModel();
                        data.setId(meetingInfo.getId());
                        data.setRoomName(meetingInfo.getRoomName());
                        data.setBeepInterval(meetingInfo.getBeepInterval());
                        data.setRetryCount(meetingInfo.getRetryCount());
                        data.setDidMapping(meetingInfo.getDidMapping());
                        data.setMeetingScheduledDate(meetingInfo.getMeetingScheduledDate());
                        data.setFromTime(meetingInfo.getFromTime());
                        data.setToTime(meetingInfo.getToTime());
                        data.setVoiceRecognition(meetingInfo.getVoiceRecognition());
                        data.setPasswordRequired(meetingInfo.getPasswordRequired());
                        data.setNameAnnouncementRequired(meetingInfo.getNameAnnouncementRequired());
                        data.setMeetingType(meetingInfo.getMeetingType());
                        data.setConferenceRetryCount(meetingInfo.getRetryCount());
                        data.setRetryDelay(meetingInfo.getRetryDelay());
                        data.setRecording(meetingInfo.getRecording());
                        data.setConferenceType(meetingInfo.getConferenceType());
                        data.setCoralConfGreetingsPath(meetingInfo.getCoralConfGreetingsPath());
                        data.setParticipantName(meetingInfo.getParticipantName());
                        data.setEmailId(meetingInfo.getEmailId());
                        data.setMobileNumber(meetingInfo.getMobileNumber());
                        data.setExtensions(meetingInfo.getExtensions());
                        data.setAccessCode(meetingInfo.getAccessCode());
                        data.setStatus(meetingInfo.getStatus());
                        data.setRPtt(meetingInfo.getRPtt());
                        data.setModId(meetingInfo.getModId());
                        data.setPId(meetingInfo.getPId());
                        addValue.add(data);
                    }
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Records Found");
                    returnValue.setData(addValue);
                    logger.info(returnValue.getMessage());
                } else {
                    returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                    returnValue.setMessage("Data not present for the month");
                    logger.info(returnValue.getMessage());
                }
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Enter valid date");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to retrieve records");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessage(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getRecordsForDay(ConferenceDateModel date, Principal authentication) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ConferenceMeetingModel> addValue = new ArrayList<ConferenceMeetingModel>();
        try {
            if (date.getScheduledDate() != null) {
                LocalDate selectedDate = date.getScheduledDate();
                List results = this.conferenceDetailsRepository.findByMeetingScheduledDate(selectedDate);
                if (!results.isEmpty()) {
                    for (ConferenceDetails meetingInfo : results) {
                        if (!meetingInfo.getCreatedBy().equals(authentication.getName())) continue;
                        ConferenceMeetingModel data = new ConferenceMeetingModel();
                        data.setId(meetingInfo.getId());
                        data.setRoomName(meetingInfo.getRoomName());
                        data.setBeepInterval(meetingInfo.getBeepInterval());
                        data.setRetryCount(meetingInfo.getRetryCount());
                        data.setDidMapping(meetingInfo.getDidMapping());
                        data.setMeetingScheduledDate(meetingInfo.getMeetingScheduledDate());
                        data.setFromTime(meetingInfo.getFromTime());
                        data.setToTime(meetingInfo.getToTime());
                        data.setVoiceRecognition(meetingInfo.getVoiceRecognition());
                        data.setPasswordRequired(meetingInfo.getPasswordRequired());
                        data.setNameAnnouncementRequired(meetingInfo.getNameAnnouncementRequired());
                        data.setMeetingType(meetingInfo.getMeetingType());
                        data.setConferenceRetryCount(meetingInfo.getRetryCount());
                        data.setRetryDelay(meetingInfo.getRetryDelay());
                        data.setRecording(meetingInfo.getRecording());
                        data.setConferenceType(meetingInfo.getConferenceType());
                        data.setCoralConfGreetingsPath(meetingInfo.getCoralConfGreetingsPath());
                        data.setParticipantName(meetingInfo.getParticipantName());
                        data.setEmailId(meetingInfo.getEmailId());
                        data.setMobileNumber(meetingInfo.getMobileNumber());
                        data.setExtensions(meetingInfo.getExtensions());
                        data.setAccessCode(meetingInfo.getAccessCode());
                        data.setStatus(meetingInfo.getStatus());
                        data.setRPtt(meetingInfo.getRPtt());
                        data.setModId(meetingInfo.getModId());
                        data.setPId(meetingInfo.getPId());
                        addValue.add(data);
                    }
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Records Found");
                    returnValue.setData(addValue);
                    logger.info(returnValue.getMessage());
                } else {
                    returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                    returnValue.setMessage("No records found for the selected date");
                    logger.info(returnValue.getMessage());
                }
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Enter valid date");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to retrieve records");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessage(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getRecordsFromToday(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ConferenceMeetingModel> addValue = new ArrayList<ConferenceMeetingModel>();
        try {
            LocalDate today = LocalDate.now();
            List results = this.conferenceDetailsRepository.findAllByMeetingScheduledDateGreaterThanEqualOrderByMeetingScheduledDate(today);
            if (!results.isEmpty()) {
                for (ConferenceDetails meetingInfo : results) {
                    if (!meetingInfo.getCreatedBy().equals(principal.getName())) continue;
                    ConferenceMeetingModel data = new ConferenceMeetingModel();
                    data.setId(meetingInfo.getId());
                    data.setRoomName(meetingInfo.getRoomName());
                    data.setBeepInterval(meetingInfo.getBeepInterval());
                    data.setRetryCount(meetingInfo.getRetryCount());
                    data.setDidMapping(meetingInfo.getDidMapping());
                    data.setMeetingScheduledDate(meetingInfo.getMeetingScheduledDate());
                    data.setFromTime(meetingInfo.getFromTime());
                    data.setToTime(meetingInfo.getToTime());
                    data.setVoiceRecognition(meetingInfo.getVoiceRecognition());
                    data.setPasswordRequired(meetingInfo.getPasswordRequired());
                    data.setNameAnnouncementRequired(meetingInfo.getNameAnnouncementRequired());
                    data.setMeetingType(meetingInfo.getMeetingType());
                    data.setConferenceRetryCount(meetingInfo.getRetryCount());
                    data.setRetryDelay(meetingInfo.getRetryDelay());
                    data.setRecording(meetingInfo.getRecording());
                    data.setConferenceType(meetingInfo.getConferenceType());
                    data.setCoralConfGreetingsPath(meetingInfo.getCoralConfGreetingsPath());
                    data.setParticipantName(meetingInfo.getParticipantName());
                    data.setEmailId(meetingInfo.getEmailId());
                    data.setMobileNumber(meetingInfo.getMobileNumber());
                    data.setExtensions(meetingInfo.getExtensions());
                    data.setAccessCode(meetingInfo.getAccessCode());
                    data.setStatus(meetingInfo.getStatus());
                    data.setRPtt(meetingInfo.getRPtt());
                    data.setModId(meetingInfo.getModId());
                    data.setPId(meetingInfo.getPId());
                    addValue.add(data);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Records Found");
                returnValue.setData(addValue);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("No records found from today's date");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to retrieve records");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessage(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getLoggedUserConference(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ConferenceReturnModel> addValue = new ArrayList<ConferenceReturnModel>();
        List listOfParticipant = this.conferenceRoomRepository.findByCreatedBy(principal.getName());
        if (!listOfParticipant.isEmpty()) {
            for (ConferenceRoom row : listOfParticipant) {
                ConferenceReturnModel data = new ConferenceReturnModel();
                data.setAccessCode(row.getAccessCode());
                data.setLoggedUserName(row.getCreatedBy());
                data.setMeetingNameWithAccessCode(row.getAccessCode() + "-" + row.getRoomName());
                data.setRoomName(row.getRoomName());
                addValue.add(data);
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Records Found");
            returnValue.setData(addValue);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }
}

