/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.gis.service;

import com.coraltele.db.telemetry.coralnms.entity.IMSI;
import com.coraltele.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.Telephony;
import com.coraltele.service.gis.model.AreaSelectedModel;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GISService {
    private static final Logger logger = LogManager.getLogger(GISService.class);
    @Autowired
    IMSIRepository imsiRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;

    public void dialSelected(AreaSelectedModel areaSelected) {
        logger.info("Dialing Started");
        List numbersToDial = this.imsiRepository.getNumbersInAreaSelected(areaSelected.get_northEast().getLng(), areaSelected.get_northEast().getLat(), areaSelected.get_southWest().getLng(), areaSelected.get_southWest().getLat());
        if (areaSelected.getDepartment() != null && StringUtils.hasText((String)areaSelected.getDepartment())) {
            logger.info("Call initiate for Selected department:{}", (Object)areaSelected.getDepartment());
            for (IMSI imsi : numbersToDial) {
                if (imsi.getDepartment() == null || !imsi.getDepartment().equals(areaSelected.getDepartment())) continue;
                String dialCMD = "fs_cli -x \"bgapi originate {origination_caller_id_number=" + Constants.DISPATCHER_NUMBER + "}sofia/" + Constants.DISPATCHER_PROFILE_NAME + "/" + imsi.getExtensionNumber() + "@" + Constants.DISPATCHER_SIP_SERVER + " &playback('/home/coralswitch/queuesounds/broadcastmsg.wav')\"";
                logger.info(dialCMD);
                Telephony.makeCallBackCall((String)dialCMD);
            }
        } else {
            logger.info("Call initiate for all department");
            for (IMSI imsi : numbersToDial) {
                String dialCMD = "fs_cli  -x \"bgapi originate {origination_caller_id_number=" + Constants.DISPATCHER_NUMBER + "}sofia/" + Constants.DISPATCHER_PROFILE_NAME + "/" + imsi.getExtensionNumber() + "@" + Constants.DISPATCHER_SIP_SERVER + " &playback('/home/coralswitch/queuesounds/broadcastmsg.wav')\"";
                logger.info(dialCMD);
                Telephony.makeCallBackCall((String)dialCMD);
            }
        }
    }

    public void dialZone(String zone) {
        logger.info("Dialing Started");
        List numbersToDial = this.imsiRepository.findAllByZone(zone);
        for (IMSI imsi : numbersToDial) {
            String dialCMD = "fs_cli -x \"bgapi originate {origination_caller_id_number=" + Constants.DISPATCHER_NUMBER + "}sofia/" + Constants.DISPATCHER_PROFILE_NAME + "/" + imsi.getExtensionNumber() + "@" + Constants.DISPATCHER_SIP_SERVER + " &playback('/home/coralswitch/queuesounds/broadcastmsg.wav')\"";
            logger.info(dialCMD);
            Telephony.makeCallBackCall((String)dialCMD);
        }
    }

    public void dialZoneWithoutGIS(String zone) {
        logger.info("Dialing Started");
        List numbersToDial = this.extensionsRepository.findByGroupType(zone);
        for (Extension extension : numbersToDial) {
            if (StringUtils.hasLength((String)extension.getWavFilename())) {
                logger.info("Dial to number : {}, Play file {}", (Object)extension.getExtension(), (Object)extension.getWavFilename());
                String dialCMD = "fs_cli -x \"bgapi originate {origination_caller_id_number=" + Constants.DISPATCHER_NUMBER + "}sofia/" + Constants.DISPATCHER_PROFILE_NAME + "/" + extension.getExtension() + "@" + Constants.DISPATCHER_SIP_SERVER + " &playback('" + extension.getWavFilename() + "')\"";
                logger.info(dialCMD);
                Telephony.makeCallBackCall((String)dialCMD);
                continue;
            }
            logger.info("No wav file provided for : {}", (Object)extension.getExtension());
        }
    }
}

