/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.coralApps.callcenter.evaluation.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.coralApps.callcenter.evaluation.model.EvaluationModel;
import com.coraltele.service.coralApps.callcenter.evaluation.service.EvaluationService;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/evaluation"})
@RestController
public class EvaluationController {
    private static final Logger logger = LogManager.getLogger(EvaluationController.class);
    @Autowired
    private EvaluationService evaluationService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createData(@RequestBody EvaluationModel data, Principal principal) {
        RequestResponse returnValue = this.evaluationService.createEvaluation(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateData(@RequestBody EvaluationModel data, Principal principal) {
        RequestResponse returnValue = this.evaluationService.updateEvaluation(data, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.evaluationService.deleteEvaluation(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllExtensionView(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.evaluationService.getAllByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info("queueTL list successfully!");
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.info("failed on getting queueTL list!");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

