/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.pdfReportView.service;

import com.coraltele.db.billing.main.entity.view.PdfReportView;
import com.coraltele.db.billing.main.repository.PdfReportViewRepository;
import com.coraltele.db.billing.main.specification.PdfReportViewSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.billing.main.pdfReportView.model.PdfReportViewModel;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class PdfReportViewService {
    private static final Logger logger = LogManager.getLogger(PdfReportViewService.class);
    @Autowired
    PdfReportViewRepository pdfReportViewRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse getPdfReportView(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = PdfReportViewSpecification.generateFilters((SearchRequest)searchRequestData, (Principal)principal);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.pdfReportViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.pdfReportViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<PdfReportViewModel> entityToModelConversion(List<PdfReportView> report) {
        ArrayList<PdfReportViewModel> addValue = new ArrayList<PdfReportViewModel>();
        for (PdfReportView row : report) {
            PdfReportViewModel data = new PdfReportViewModel();
            data.setId(row.getId());
            if (row.getStartEpoch() != null) {
                data.setStartEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getStartEpoch()));
            }
            if (row.getEndEpoch() != null) {
                data.setEndEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getEndEpoch()));
            }
            data.setPdfLocation(row.getPdfLocation());
            data.setReportName(row.getReportName());
            data.setStatus(row.getStatus());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse checkPreviousBackupStatus() {
        RequestResponse returnValue = new RequestResponse();
        List getInProgressStatus = this.pdfReportViewRepository.findByStatus("in progress");
        if (getInProgressStatus.size() >= 1) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Already one back-up in queue");
            returnValue.setMessageDetail("Wait for previous backup completion");
            logger.error(returnValue.getMessage());
        } else {
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Continue to make new backup");
            returnValue.setMessageDetail("No any backup in queue");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }
}

