/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.billing.main.billingSummaryView.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.entity.view.ViewChannels;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.billing.main.repository.ViewChannelsRepository;
import com.coraltele.db.billing.main.specification.ViewChannelsSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.background.PdfGeneratorService;
import com.coraltele.service.billing.log.service.BillingPdfService;
import com.coraltele.service.billing.main.billingSummaryView.model.BillingSummaryViewModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="billingSummaryPDF")
public class BillingSummaryViewPDF
implements PdfGeneratorService {
    private static final Logger logger = LogManager.getLogger(BillingPdfService.class);
    private static String reportFileName = "Billing Summary Data";
    private static String reportFileNameDateFormat = "dd_MMMM_yyyy";
    private static String localDateFormat = "dd-MM-yyyy hh:mm:ss a";
    LocalDateTime currentTime = null;
    private static String logoImgPath = "/home/coral/Desktop/apple-icon.png";
    private static int noOfColumns = 0;
    @Autowired
    private ViewChannelsRepository viewChannelsRepository;
    @Autowired
    DynamicPdfThreadService generatingReports;
    @Autowired
    private PdfReportRepository pdfReportRepository;
    @Autowired
    PdfPageNumberEvent pageNumberEvent;
    @Autowired
    DateFormatUtility dateFormatUtility;
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    public void init(LocalDateTime currentTime) {
        try {
            this.pageNumberEvent.initialize(logoImgPath, reportFileName, localDateFormat, currentTime);
        }
        catch (BadElementException | IOException e) {
            e.printStackTrace();
        }
    }

    public RequestResponse generatePdfReport(SearchRequest searchRequestData, String filePath, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        this.currentTime = LocalDateTime.now();
        this.init(this.currentTime);
        logger.info("Start generating pdf for matched columns:");
        try {
            noOfColumns = searchRequestData.getColumnNames().size();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = noOfColumns > 5 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            writer.setPageEvent((PdfPageEvent)this.pageNumberEvent);
            document.open();
            this.addLogoAndDocTitle(document, searchRequestData, Integer.valueOf(noOfColumns));
            if (searchRequestData.advancedFilters != null && !searchRequestData.advancedFilters.isEmpty()) {
                BillingSummaryViewPDF.addAdvanceFilterRequest((Document)document, (SearchRequest)searchRequestData);
            }
            document.newPage();
            this.createTable(document, noOfColumns, searchRequestData);
            document.close();
            byte[] pdfBytes = byteArrayOutputStream.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            String filename = this.getPdfNameWithDate();
            this.savePdfToDestination(pdfBytes, filePath);
            headers.setContentDispositionFormData(filename, filename);
            headers.setCacheControl("must-revalidate, post-check=0, pre-check=0");
            logger.info("PDF generated successfully and saved to: {}", (Object)filePath);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("File generated and saved successfully");
            returnValue.setData((Object)filePath);
            logger.info("NMS report generated and saved successfully");
            return returnValue;
        }
        catch (DocumentException e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("failed to download");
            logger.info("NMS report failed to download");
            return returnValue;
        }
    }

    private void addLogoAndDocTitle(Document document, SearchRequest filterRequest, Integer columns) {
        try {
            logger.info("finding logo from location");
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            PdfPCell logoCell = new PdfPCell();
            logoCell.setHorizontalAlignment(1);
            logoCell.setBorder(0);
            Image img = Image.getInstance((String)logoImgPath);
            if (columns > 5) {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.5f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            } else {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.7f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            }
            PdfPCell reportNameCell = new PdfPCell();
            reportNameCell.setHorizontalAlignment(1);
            reportNameCell.setBorder(0);
            Paragraph p1 = new Paragraph(reportFileName, COURIER);
            reportNameCell.addElement((Element)p1);
            PdfPCell dateTimeCell = new PdfPCell();
            dateTimeCell.setHorizontalAlignment(1);
            dateTimeCell.setBorder(0);
            String localDateString = this.currentTime.format(DateTimeFormatter.ofPattern(localDateFormat));
            Paragraph p2 = new Paragraph("Report generated on " + localDateString, COURIER_SMALL);
            dateTimeCell.addElement((Element)p2);
            table.addCell(logoCell);
            table.addCell(reportNameCell);
            table.addCell(dateTimeCell);
            document.add((Element)table);
            logger.info("successfully found logo for pdf");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void createTable(Document document, int noOfColumns, SearchRequest searchRequestData) throws DocumentException {
        try {
            logger.info("Starting creation of table for pdf");
            Specification filters = ViewChannelsSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = this.determineSortOrder(searchRequestData);
            List filteredData = sort != null ? this.viewChannelsRepository.findAll(filters, sort) : this.viewChannelsRepository.findAll(filters);
            List aggregatedData = this.aggregateBillingSummary(filteredData);
            PdfPTable table = new PdfPTable(searchRequestData.getColumnNames().size());
            for (String columnName : searchRequestData.getColumnNames()) {
                BaseColor lightBlue = new BaseColor(2, 111, 194);
                PdfPCell cell = new PdfPCell(new Phrase((String)columnMappings.get(columnName), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE)));
                cell.setHorizontalAlignment(1);
                cell.setBackgroundColor(lightBlue);
                cell.setBorder(0);
                table.addCell(cell);
            }
            table.setHeaderRows(1);
            this.getAggregatedDbData(table, aggregatedData, searchRequestData.getColumnNames());
            document.add((Element)table);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private Sort determineSortOrder(SearchRequest searchRequestData) {
        Sort sort = null;
        if ("asc".equalsIgnoreCase(searchRequestData.getSortDirection())) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if ("desc".equalsIgnoreCase(searchRequestData.getSortDirection())) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "id" : searchRequestData.getSortBy()}).descending();
        }
        return sort;
    }

    private void getAggregatedDbData(PdfPTable table, List<BillingSummaryViewModel> aggregatedData, List<String> columnNames) {
        BaseColor lightBackground = new BaseColor(230, 230, 230);
        for (BillingSummaryViewModel row : aggregatedData) {
            table.setWidthPercentage(100.0f);
            table.getDefaultCell().setHorizontalAlignment(1);
            for (String columnName : columnNames) {
                PdfPCell cell = new PdfPCell();
                cell.setHorizontalAlignment(1);
                cell.setBackgroundColor(aggregatedData.indexOf(row) % 2 == 0 ? lightBackground : BaseColor.WHITE);
                switch (columnName) {
                    case "direction": {
                        cell.setPhrase(new Phrase(row.getDirection()));
                        break;
                    }
                    case "noCallType": {
                        cell.setPhrase(new Phrase(String.valueOf(row.getNoCallType())));
                        break;
                    }
                    case "total": {
                        cell.setPhrase(new Phrase(String.valueOf(row.getTotal())));
                        break;
                    }
                    case "local": {
                        cell.setPhrase(new Phrase(String.valueOf(row.getLocal())));
                        break;
                    }
                    case "std": {
                        cell.setPhrase(new Phrase(String.valueOf(row.getStd())));
                        break;
                    }
                    case "isd": {
                        cell.setPhrase(new Phrase(String.valueOf(row.getIsd())));
                    }
                }
                table.addCell(cell);
            }
        }
    }

    private List<BillingSummaryViewModel> aggregateBillingSummary(List<ViewChannels> billingSummaryViews) {
        HashMap<String, BillingSummaryViewModel> aggregationMap = new HashMap<String, BillingSummaryViewModel>();
        for (ViewChannels row : billingSummaryViews) {
            String direction = this.mapDirection(row.getDirection());
            BillingSummaryViewModel data = aggregationMap.getOrDefault(direction, new BillingSummaryViewModel());
            data.setDirection(direction);
            data.setTotal(Long.valueOf(data.getTotal() + 1L));
            if (row.getCallType() == null || row.getCallType().isEmpty()) {
                data.setNoCallType(Long.valueOf(data.getNoCallType() + 1L));
            } else if ("LOCAL".equalsIgnoreCase(row.getCallType())) {
                data.setLocal(Long.valueOf(data.getLocal() + 1L));
            } else if ("STD".equalsIgnoreCase(row.getCallType())) {
                data.setStd(Long.valueOf(data.getStd() + 1L));
            } else if ("ISD".equalsIgnoreCase(row.getCallType())) {
                data.setIsd(Long.valueOf(data.getIsd() + 1L));
            }
            aggregationMap.put(direction, data);
        }
        return new ArrayList<BillingSummaryViewModel>(aggregationMap.values());
    }

    private void getDbData(PdfPTable table, List<ViewChannels> filteredData, List<String> columnNames) {
        try {
            BaseColor lightBackground = new BaseColor(230, 230, 230);
            BaseColor whiteBackground = new BaseColor(255, 255, 255);
            for (int rowIndex = 0; rowIndex < filteredData.size(); ++rowIndex) {
                ViewChannels viewChannels = filteredData.get(rowIndex);
                BaseColor backgroundColor = rowIndex % 2 == 0 ? lightBackground : whiteBackground;
                Iterator<String> iterator = columnNames.iterator();
                while (iterator.hasNext()) {
                    PdfPCell cell;
                    String columnName;
                    switch (columnName = iterator.next()) {
                        case "direction": {
                            cell = new PdfPCell(new Phrase(viewChannels.getDirection() != null ? viewChannels.getDirection() : "N/A"));
                            break;
                        }
                        case "noCallType": {
                            cell = new PdfPCell(new Phrase(viewChannels.getCallType() == null || viewChannels.getCallType().isEmpty() ? "1" : "0"));
                            break;
                        }
                        case "total": {
                            cell = new PdfPCell(new Phrase("1"));
                            break;
                        }
                        case "local": {
                            cell = new PdfPCell(new Phrase("LOCAL".equalsIgnoreCase(viewChannels.getCallType()) ? "1" : "0"));
                            break;
                        }
                        case "std": {
                            cell = new PdfPCell(new Phrase("STD".equalsIgnoreCase(viewChannels.getCallType()) ? "1" : "0"));
                            break;
                        }
                        case "isd": {
                            cell = new PdfPCell(new Phrase("ISD".equalsIgnoreCase(viewChannels.getCallType()) ? "1" : "0"));
                            break;
                        }
                        default: {
                            cell = new PdfPCell(new Phrase("N/A"));
                        }
                    }
                    cell.setHorizontalAlignment(1);
                    cell.setBackgroundColor(backgroundColor);
                    table.addCell(cell);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private String getCellValue(String value) {
        return value != null && !value.isEmpty() ? value : "";
    }

    private static void leaveEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    private String getPdfNameWithDate() {
        String localDateString = LocalDateTime.now().format(DateTimeFormatter.ofPattern(reportFileNameDateFormat));
        return reportFileName + "-" + localDateString + ".pdf";
    }

    private static void addAdvanceFilterRequest(Document document, SearchRequest searchRequestData) throws DocumentException {
        List advancedFilters = searchRequestData.getAdvancedFilters();
        if (advancedFilters != null && !advancedFilters.isEmpty()) {
            Paragraph advancedFilterParagraph = new Paragraph();
            Font boldFont = new Font(Font.FontFamily.HELVETICA, 14.0f, 1);
            for (AdvanceFilter advanceFilter : advancedFilters) {
                advancedFilterParagraph.setFont(boldFont);
                if ("from".equals(advanceFilter.getDirection())) {
                    advancedFilterParagraph.add("Record on the basis of " + (String)columnMappings.get(advanceFilter.getFieldName()) + ": From " + advanceFilter.getValue());
                    continue;
                }
                if (!"to".equals(advanceFilter.getDirection())) continue;
                advancedFilterParagraph.add(" to " + advanceFilter.getValue());
                advancedFilterParagraph.add((Element)new Paragraph(""));
            }
            document.add((Element)advancedFilterParagraph);
        }
    }

    private void savePdfToDestination(byte[] pdfBytes, String destinationPath) {
        try (FileOutputStream fos = new FileOutputStream(destinationPath);){
            fos.write(pdfBytes);
            logger.info("PDF saved to: {}", (Object)destinationPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Failed to save PDF to: {}", (Object)destinationPath);
        }
    }

    public void createPdfReportRecord(String id, SearchRequest data, String filePath) {
        try {
            PdfReportFilters pdfReportFilters = new PdfReportFilters();
            ObjectMapper objectMapper = new ObjectMapper();
            pdfReportFilters.setId(id);
            pdfReportFilters.setReportName(reportFileName);
            pdfReportFilters.setFilterParameters(objectMapper.writeValueAsString((Object)data));
            pdfReportFilters.setCreatedOnDate(this.currentTime);
            pdfReportFilters.setPdfLocation(filePath);
            pdfReportFilters.setStatus("InProgress");
            this.pdfReportRepository.save((Object)pdfReportFilters);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private String mapDirection(String direction) {
        if ("INT".equalsIgnoreCase(direction)) {
            return "Intercom";
        }
        if ("IN".equalsIgnoreCase(direction)) {
            return "Incoming";
        }
        if ("OUT".equalsIgnoreCase(direction)) {
            return "Outgoing";
        }
        return direction;
    }

    static {
        columnMappings.put("direction", "Direction");
        columnMappings.put("noCallType", "NoCallType");
        columnMappings.put("total", "Total");
        columnMappings.put("local", "LOCAL");
        columnMappings.put("std", "STD");
        columnMappings.put("isd", "ISD");
    }
}

