/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.helper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

@Component
public class CustomConfigUserRole {
    private static final Logger logger = LogManager.getLogger(CustomConfigUserRole.class);
    public String dirPath = "/etc/coraltele/forms";
    public String fileCoralName = "/etc/default/coral";
    private static final String DEFAULT_DIR = "/etc/coraltele/sipserver/conf/directory/default";
    private final String[] fileNames = new String[]{"voip.json", "vonr.json", "phoneVolt.json"};
    private String[] fileContents;

    public void createDirectoryIfNotExists() {
        File directory = new File(DEFAULT_DIR);
        if (!directory.exists()) {
            boolean created = directory.mkdirs();
            if (created) {
                logger.info("Directory created: {}/etc/coraltele/sipserver/conf/directory/default");
            } else {
                logger.error("Failed to create directory: /etc/coraltele/sipserver/conf/directory/default");
            }
        } else {
            logger.info("Directory already exists: /etc/coraltele/sipserver/conf/directory/default");
        }
    }

    @PostConstruct
    public void startFile() throws IOException {
        this.createDirectoryIfNotExists();
    }

    public static void updateIniIfKeyMissing(String filePath, String section, String key, String defaultValue) {
        File iniFile = new File(filePath);
        if (!iniFile.exists()) {
            System.err.println("INI file does not exist: " + filePath);
            return;
        }
        try {
            Ini ini = new Ini(iniFile);
            IniPreferences prefs = new IniPreferences(ini);
            Preferences sectionNode = prefs.node(section);
            boolean keyExists = false;
            for (String existingKey : sectionNode.keys()) {
                if (!existingKey.equals(key)) continue;
                keyExists = true;
                break;
            }
            if (!keyExists) {
                ini.put(section, key, (Object)defaultValue);
                ini.store();
                logger.info("Key '%s' added to section [%s] with value '%s'%n", (Object)key, (Object)section, (Object)defaultValue);
            } else {
                logger.info("Key '%s' already exists in section [%s]%n {}", (Object)key, (Object)section);
            }
        }
        catch (IOException | BackingStoreException e) {
            logger.error("Error updating INI file: {}" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createFilesWithContent() throws IOException {
        String voipContent = new String(Files.readAllBytes(ResourceUtils.getFile((String)"classpath:VOIP.txt").toPath()));
        String vonrContent = new String(Files.readAllBytes(ResourceUtils.getFile((String)"classpath:VONR.txt").toPath()));
        String phoneVolteContent = new String(Files.readAllBytes(ResourceUtils.getFile((String)"classpath:phoneVolt.txt").toPath()));
        this.fileContents = new String[]{voipContent, vonrContent, phoneVolteContent};
        Path directory = Paths.get(this.dirPath, new String[0]);
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
            logger.info("Directory created: {}", (Object)directory);
        } else {
            logger.info("Directory already exists: {}", (Object)directory);
        }
        for (int i = 0; i < this.fileNames.length; ++i) {
            Path file = directory.resolve(this.fileNames[i]);
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
                try (FileWriter writer = new FileWriter(file.toFile());){
                    writer.write(this.fileContents[i]);
                    logger.info("File {} created with content.", (Object)this.fileNames[i]);
                    continue;
                }
            }
            logger.info("File {} already exists.", (Object)this.fileNames[i]);
        }
    }
}

