/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.users.main.entity;

import com.coraltele.db.users.main.entity.Menu;
import com.coraltele.db.users.main.entity.Role;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.helper.UuidUpdatable;
import com.coraltele.helper.UuidUpdateListener;
import java.time.LocalDateTime;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="m_userrole_menu")
@EntityListeners(value={UuidUpdateListener.class})
public class UserRoleMenu
implements UuidUpdatable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @Column(name="createdby")
    private String createdBy;
    @Column(name="createdon", columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP", nullable=true)
    private LocalDateTime createdOn;
    @Column(name="updatedby")
    private String updatedBy;
    @Column(name="updatedon", columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP", nullable=true)
    private LocalDateTime updatedOn;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="user_id")
    private User user;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="role_id")
    private Role role;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="menu_id")
    private Menu menu;
    private String uuid;

    public UserRoleMenu() {
        this.user = new User();
        this.role = new Role();
        this.menu = new Menu();
    }

    @PrePersist
    public void setValues() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        if (this.createdOn == null) {
            this.createdOn = LocalDateTime.now();
        }
        if (this.updatedOn == null) {
            this.updatedOn = LocalDateTime.now();
        }
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public LocalDateTime getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Generated
    public LocalDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public Role getRole() {
        return this.role;
    }

    @Generated
    public Menu getMenu() {
        return this.menu;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Generated
    public void setCreatedOn(LocalDateTime createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Generated
    public void setUpdatedOn(LocalDateTime updatedOn) {
        this.updatedOn = updatedOn;
    }

    @Generated
    public void setUser(User user) {
        this.user = user;
    }

    @Generated
    public void setRole(Role role) {
        this.role = role;
    }

    @Generated
    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public UserRoleMenu(Integer id, String createdBy, LocalDateTime createdOn, String updatedBy, LocalDateTime updatedOn, User user, Role role, Menu menu, String uuid) {
        this.id = id;
        this.createdBy = createdBy;
        this.createdOn = createdOn;
        this.updatedBy = updatedBy;
        this.updatedOn = updatedOn;
        this.user = user;
        this.role = role;
        this.menu = menu;
        this.uuid = uuid;
    }
}

