/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.db.telemetry.main.entity.view;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import lombok.Generated;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Subselect;

@Entity
@Immutable
@Subselect(value="SELECT  ROW_NUMBER() OVER (ORDER BY coral_gateway) AS id,  coral_gateway,  intercom_call, intercom_cost,  local_call, local_cost,  std_call, std_cost,  isd_call, isd_cost,  total_call, total_cost  FROM (    SELECT      coral_gateway,      SUM(intercom_call) AS intercom_call,      SUM(intercom_cost) AS intercom_cost,      SUM(local_call) AS local_call,      SUM(local_cost) AS local_cost,      SUM(std_call) AS std_call,      SUM(std_cost) AS std_cost,      SUM(isd_call) AS isd_call,      SUM(isd_cost) AS isd_cost,      SUM(total_call) AS total_call,      SUM(total_cost) AS total_cost    FROM (      SELECT        coral_gateway,        (to_timestamp(start_epoch) AT TIME ZONE 'UTC'            AT TIME ZONE 'Asia/Kolkata')::date AS call_date,        COUNT(CASE WHEN call_type = 'INTERCOM' THEN 1 END) AS intercom_call,        SUM(CASE WHEN call_type = 'INTERCOM' THEN cost ELSE 0 END) AS intercom_cost,        COUNT(CASE WHEN call_type = 'LOCAL' THEN 1 END) AS local_call,        SUM(CASE WHEN call_type = 'LOCAL' THEN cost ELSE 0 END) AS local_cost,        COUNT(CASE WHEN call_type = 'STD' THEN 1 END) AS std_call,        SUM(CASE WHEN call_type = 'STD' THEN cost ELSE 0 END) AS std_cost,        COUNT(CASE WHEN call_type = 'ISD' THEN 1 END) AS isd_call,        SUM(CASE WHEN call_type = 'ISD' THEN cost ELSE 0 END) AS isd_cost,        COUNT(call_type) AS total_call,        SUM(cost) AS total_cost      FROM billing_cdr      WHERE coral_gateway IS NOT NULL      GROUP BY coral_gateway, call_date    ) daily    GROUP BY coral_gateway  ) summary")
public class BillingCdrGatewayView {
    @Id
    private Long id;
    @Column(name="coral_gateway")
    private String coralGateway;
    @Column(name="intercom_call")
    private Long intercomCall;
    @Column(name="intercom_cost")
    private Double intercomCost;
    @Column(name="local_call")
    private Long localCall;
    @Column(name="local_cost")
    private Double localCost;
    @Column(name="std_call")
    private Long stdCall;
    @Column(name="std_cost")
    private Double stdCost;
    @Column(name="isd_call")
    private Long isdCall;
    @Column(name="isd_cost")
    private Double isdCost;
    @Column(name="total_call")
    private Long totalCall;
    @Column(name="total_cost")
    private Double totalCost;

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCoralGateway() {
        return this.coralGateway;
    }

    @Generated
    public Long getIntercomCall() {
        return this.intercomCall;
    }

    @Generated
    public Double getIntercomCost() {
        return this.intercomCost;
    }

    @Generated
    public Long getLocalCall() {
        return this.localCall;
    }

    @Generated
    public Double getLocalCost() {
        return this.localCost;
    }

    @Generated
    public Long getStdCall() {
        return this.stdCall;
    }

    @Generated
    public Double getStdCost() {
        return this.stdCost;
    }

    @Generated
    public Long getIsdCall() {
        return this.isdCall;
    }

    @Generated
    public Double getIsdCost() {
        return this.isdCost;
    }

    @Generated
    public Long getTotalCall() {
        return this.totalCall;
    }

    @Generated
    public Double getTotalCost() {
        return this.totalCost;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCoralGateway(String coralGateway) {
        this.coralGateway = coralGateway;
    }

    @Generated
    public void setIntercomCall(Long intercomCall) {
        this.intercomCall = intercomCall;
    }

    @Generated
    public void setIntercomCost(Double intercomCost) {
        this.intercomCost = intercomCost;
    }

    @Generated
    public void setLocalCall(Long localCall) {
        this.localCall = localCall;
    }

    @Generated
    public void setLocalCost(Double localCost) {
        this.localCost = localCost;
    }

    @Generated
    public void setStdCall(Long stdCall) {
        this.stdCall = stdCall;
    }

    @Generated
    public void setStdCost(Double stdCost) {
        this.stdCost = stdCost;
    }

    @Generated
    public void setIsdCall(Long isdCall) {
        this.isdCall = isdCall;
    }

    @Generated
    public void setIsdCost(Double isdCost) {
        this.isdCost = isdCost;
    }

    @Generated
    public void setTotalCall(Long totalCall) {
        this.totalCall = totalCall;
    }

    @Generated
    public void setTotalCost(Double totalCost) {
        this.totalCost = totalCost;
    }

    @Generated
    public BillingCdrGatewayView() {
    }
}

