/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.customerCDR.controller;

import com.coraltele.db.telemetry.main.entity.CustomerCDR;
import com.coraltele.db.telemetry.main.repository.CustomerCDRRepository;
import com.coraltele.db.telemetry.main.specification.AnsweredSpecification;
import com.coraltele.db.telemetry.main.specification.AnsweredSpecificationNew;
import com.coraltele.db.telemetry.main.specification.QueueAbandonedSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResultModel;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.customerCDR.controller.CustomerCDRController;
import com.coraltele.service.telemetry.main.customerCDR.service.CustomerCDRSecondaryService;
import com.coraltele.service.user.service.UserService;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/customerCDRSecondary"})
@RestController
public class CustomerCDRSecondaryController {
    private static final Logger logger = LogManager.getLogger(CustomerCDRController.class);
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    CustomerCDRRepository customerCDRRepository;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    DownloadPdfService pdfDownloadService;
    @Autowired
    CustomerCDRSecondaryService customerCDRSecondaryService;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    @PostMapping(value={"/queueAbandonedList"})
    public ResponseEntity<RequestResponse> getListOfQueueAbandoned(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.customerCDRSecondaryService.getListOfQueueAbandoned(searchRequest, principal);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSV(@RequestBody SearchRequest searchRequestData, Principal principal) {
        try {
            logger.info("CSV file download started for Queue Abandoned--");
            boolean teamLeaderUser = false;
            if (this.userService.checkRoleTL(principal.getName())) {
                teamLeaderUser = true;
            }
            List queueId = null;
            if (teamLeaderUser) {
                queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
            }
            Specification filters = QueueAbandonedSpecification.generateFilters((SearchRequest)searchRequestData, (boolean)teamLeaderUser, queueId);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.customerCDRRepository.findAll(filters, sort) : this.customerCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (CustomerCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for queue abandoned", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading queue abandoned CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(CustomerCDR item, String columnName) {
        switch (columnName) {
            case "queue": {
                return this.checkNull((Object)item.getQueue());
            }
            case "queueName": {
                return this.checkNull((Object)item.getQueueName());
            }
            case "ccAgent": {
                return this.checkNull((Object)item.getCcAgent());
            }
            case "duration": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getDuration().longValue()));
            }
            case "callId": {
                return this.checkNull((Object)item.getCallId());
            }
            case "status": {
                return this.checkNull((Object)item.getStatus());
            }
            case "startTime": {
                return this.formatNullableDate(item.getStartTime());
            }
            case "agentFullName": {
                return this.checkNull((Object)item.getAgentFullName());
            }
            case "agentTalkTime": {
                return this.checkNull((Object)DateFormatUtility.findLocalTime((Long)item.getAgentTalkTime()));
            }
            case "agentTalkedTo": {
                return this.checkNull((Object)item.getAgentTalkedTo());
            }
            case "callDirection": {
                return this.checkNull((Object)item.getCallDirection());
            }
        }
        return null;
    }

    private String formatNullableDate(Long epochMillis) {
        return epochMillis != null ? DateFormatUtility.dateAndTimeFormatterForSeconds((LocalDateTime)DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)epochMillis)) : "";
    }

    private String checkNull(Object value) {
        return value != null ? value.toString() : "";
    }

    @PostMapping(value={"/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequestData, Principal principal) {
        String folderPath = "/tmp/";
        File folder = new File(folderPath);
        String fileNamePrefix = reportType + "_";
        File[] files = folder.listFiles((dir, name) -> name.startsWith(fileNamePrefix));
        if (files != null) {
            for (File file : files) {
                if (file.delete()) {
                    logger.info("Deleted existing report: {}" + file.getName());
                    continue;
                }
                logger.error("Failed to delete existing report: {}" + file.getName());
            }
        }
        String filePath = "/tmp/" + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        CompletableFuture generationFuture = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequestData, filePath, principal);
        return generationFuture.thenApply(response -> {
            if (response.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity downloadResponse = this.pdfDownloadService.getPdfFile(filePath);
                if (downloadResponse.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok().body(downloadResponse.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Failed to download PDF. Reason: " + downloadResponse.getStatusCode()));
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(response);
        });
    }

    @PostMapping(value={"/answeredList"})
    public ResponseEntity<RequestResponse> getListOfAnswered(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.customerCDRSecondaryService.getListOfAnswered(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/answered/downloadCSV"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForAnswered(@RequestBody SearchRequest searchRequestData) {
        try {
            logger.info("CSV file download started for Answered--");
            Specification filters = AnsweredSpecification.generateFilters((SearchRequest)searchRequestData);
            Sort sort = null;
            if ("asc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).ascending();
            } else if ("desc".equals(searchRequestData.getSortDirection())) {
                sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().isEmpty() || searchRequestData.getSortBy() == null ? "startTime" : searchRequestData.getSortBy()}).descending();
            }
            List filteredData = sort != null ? this.customerCDRRepository.findAll(filters, sort) : this.customerCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getColumnNames());
                List displayNames = searchRequestData.getColumnNames().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (CustomerCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getColumnNames()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Answered", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Answered CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping(value={"/answered/downloadCSV1"})
    public ResponseEntity<byte[]> downloadFilteredDataToCSVForAnswered1(@RequestBody SearchResultModel searchRequestData) {
        try {
            logger.info("CSV file download started for Answered--");
            Specification filters = AnsweredSpecificationNew.buildSpecification((SearchResultModel)searchRequestData);
            List filteredData = this.customerCDRRepository.findAll(filters);
            StringWriter stringWriter = new StringWriter();
            try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, CSVFormat.DEFAULT);){
                logger.info("Original column names: " + searchRequestData.getSelectedColumns());
                List displayNames = searchRequestData.getSelectedColumns().stream().map(columnName -> columnMappings.getOrDefault(columnName, columnName)).collect(Collectors.toList());
                logger.info("Display names: " + displayNames);
                csvPrinter.printRecord(displayNames);
                for (CustomerCDR item : filteredData) {
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (String columnName2 : searchRequestData.getSelectedColumns()) {
                        values.add(this.getColumnValue(item, columnName2));
                    }
                    csvPrinter.printRecord(values);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Error while traversing data for Answered", (Object)e.getMessage());
            }
            String csvContent = stringWriter.toString();
            byte[] csvBytes = csvContent.getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "filtered_data.csv");
            logger.info("CSV data download successfully.");
            return new ResponseEntity((Object)csvBytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while downloading Answered CSV file!", (Object)e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    static {
        columnMappings.put("queue", "Queue");
        columnMappings.put("queueName", "Queue Name");
        columnMappings.put("ccAgent", "Agent ID");
        columnMappings.put("startTime", "Date Time");
        columnMappings.put("duration", "Duration");
        columnMappings.put("callId", "CLI");
        columnMappings.put("status", "Status");
        columnMappings.put("agentFullName", "Agent Name");
        columnMappings.put("agentTalkTime", "Talk Time");
        columnMappings.put("agentTalkedTo", "Caller Id");
        columnMappings.put("callDirection", "Direction");
    }
}

