/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.billingCDR.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.DownloadPdfService;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.DynamicPdfThreadService;
import com.coraltele.service.telemetry.main.billingCDR.controller.DepartmentSummaryController;
import com.coraltele.service.telemetry.main.billingCDR.model.DepartmentSummaryModel;
import com.coraltele.service.telemetry.main.billingCDR.service.DepartmentSummaryService;
import java.io.File;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/billingCDRDepartment"})
@RestController
public class DepartmentSummaryController {
    private static final Logger logger = LogManager.getLogger(DepartmentSummaryController.class);
    @Autowired
    private DepartmentSummaryService departmentSummaryService;
    @Autowired
    private DynamicPdfThreadService dynamicReportThreadService;
    @Autowired
    private DownloadPdfService pdfDownloadService;

    @PostMapping(value={"/summary/list"})
    public ResponseEntity<RequestResponse> getSummary(@RequestBody SearchRequest request) {
        RequestResponse res = this.departmentSummaryService.getAllByFilter(request);
        if (res.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)res);
        }
        return new ResponseEntity((Object)res, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/summary/downloadCSV"})
    public ResponseEntity<byte[]> downloadSummaryCSV(@RequestBody SearchRequest searchRequest) {
        try {
            logger.info("CSV file download started \u2014 Department Summary");
            List list = this.departmentSummaryService.getSummaryList(searchRequest);
            1 columnMappings = new /* Unavailable Anonymous Inner Class!! */;
            StringWriter sw = new StringWriter();
            try (CSVPrinter csv = new CSVPrinter((Appendable)sw, CSVFormat.DEFAULT);){
                ArrayList<String> displayHeaders = new ArrayList<String>();
                for (String c : searchRequest.getColumnNames()) {
                    displayHeaders.add(columnMappings.getOrDefault(c, c));
                }
                csv.printRecord(displayHeaders);
                for (DepartmentSummaryModel d : list) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    for (String col : searchRequest.getColumnNames()) {
                        row.add(this.getColumnValue(d, col));
                    }
                    csv.printRecord(row);
                }
            }
            byte[] bytes = sw.toString().getBytes(StandardCharsets.UTF_8);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData("attachment", "department-summary.csv");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("CSV download failed", (Object)ex.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Object getColumnValue(DepartmentSummaryModel d, String col) {
        if (d == null || col == null) {
            return "";
        }
        switch (col) {
            case "departmentCode": {
                return this.empty(d.getDepartmentCode());
            }
            case "departmentName": {
                return this.empty(d.getDepartmentName());
            }
            case "callerIdNumber": {
                return this.empty(d.getCallerIdNumber());
            }
            case "intercomCall": {
                return d.getIntercomCall();
            }
            case "intercomCost": {
                return d.getIntercomCost();
            }
            case "localCall": {
                return d.getLocalCall();
            }
            case "localCost": {
                return d.getLocalCost();
            }
            case "stdCall": {
                return d.getStdCall();
            }
            case "stdCost": {
                return d.getStdCost();
            }
            case "isdCall": {
                return d.getIsdCall();
            }
            case "isdCost": {
                return d.getIsdCost();
            }
            case "totalCall": {
                return d.getTotalCall();
            }
            case "totalCost": {
                return d.getTotalCost();
            }
        }
        return "";
    }

    private String empty(String v) {
        return v == null ? "" : v;
    }

    @PostMapping(value={"/summary/generateAndDownloadPdf"})
    public CompletableFuture<ResponseEntity<?>> generateAndDownloadPdf(@RequestParam String reportType, @RequestBody SearchRequest searchRequest, Principal principal) {
        String folderPath = "/tmp/";
        String filePath = folderPath + reportType + "_" + System.currentTimeMillis() + ".pdf";
        String id = UUID.randomUUID().toString();
        File folder = new File(folderPath);
        File[] files = folder.listFiles((dir, name) -> name.startsWith(reportType));
        if (files != null) {
            for (File f : files) {
                f.delete();
            }
        }
        CompletableFuture future = this.dynamicReportThreadService.startGeneratingReportAsync(reportType, id, searchRequest, filePath, principal);
        return future.thenApply(res -> {
            if (res.getStatus().equals((Object)Constants.Error.OK)) {
                ResponseEntity pdf = this.pdfDownloadService.getPdfFile(filePath);
                if (pdf.getStatusCode().is2xxSuccessful()) {
                    return ResponseEntity.ok((Object)pdf.getBody());
                }
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"PDF Download Failed");
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(res);
        });
    }
}

