/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.ExtensionSummary.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.PdfGeneratorService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="extensionSummaryPdf")
public class ExtensionSummaryPdf
implements PdfGeneratorService {
    private static final Logger logger = LogManager.getLogger(ExtensionSummaryPdf.class);
    private static String reportFileName = "Inbound Extension Details";
    private static String reportFileNameDateFormat = "dd_MMMM_yyyy";
    private static String localDateFormat = "dd-MM-yyyy hh:mm:ss a";
    private static String logoImgPath = "/var/www/html/apple-icon.png";
    LocalDateTime currentTime = null;
    private static int noOfColumns = 0;
    @Autowired
    BillingCDRRepository billingCDRRepository;
    @Autowired
    PdfPageNumberEvent pageNumberEvent;
    @Autowired
    private PdfReportRepository pdfReportRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final ConcurrentHashMap<String, String> columnMappings = new ConcurrentHashMap();

    public void init(LocalDateTime currentTime) {
        try {
            this.pageNumberEvent.initialize(logoImgPath, reportFileName, localDateFormat, currentTime);
        }
        catch (BadElementException | IOException e) {
            e.printStackTrace();
        }
    }

    public RequestResponse generatePdfReport(SearchRequest searchRequestData, String filePath, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        this.currentTime = LocalDateTime.now();
        this.init(this.currentTime);
        try {
            noOfColumns = searchRequestData.getColumnNames().size();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Document document = noOfColumns > 5 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
            writer.setPageEvent((PdfPageEvent)this.pageNumberEvent);
            document.open();
            this.addLogoAndDocTitle(document, searchRequestData, Integer.valueOf(noOfColumns));
            if (searchRequestData.getAdvancedFilters() != null && !searchRequestData.getAdvancedFilters().isEmpty()) {
                ExtensionSummaryPdf.addAdvanceFilterRequest((Document)document, (SearchRequest)searchRequestData);
            }
            document.newPage();
            this.createTable(document, noOfColumns, searchRequestData);
            document.close();
            byte[] pdfBytes = byteArrayOutputStream.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            this.savePdfToDestination(pdfBytes, filePath);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("PDF generated successfully");
            returnValue.setData((Object)filePath);
            return returnValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("PDF generation failed");
            return returnValue;
        }
    }

    private void createTable(Document document, int noOfColumns, SearchRequest searchRequestData) throws DocumentException {
        LocalDate fromDate = null;
        LocalDate toDate = null;
        String extension = null;
        String callerId = null;
        String callType = null;
        String search = searchRequestData.getSearch();
        String sortBy = searchRequestData.getSortBy();
        if (search != null && (search = search.trim()).isEmpty()) {
            search = null;
        }
        if (searchRequestData.getAdvancedFilters() != null) {
            for (AdvanceFilter f : searchRequestData.getAdvancedFilters()) {
                if ("date".equalsIgnoreCase(f.getDataType()) && "callDate".equalsIgnoreCase(f.getFieldName())) {
                    if ("from".equalsIgnoreCase(f.getDirection())) {
                        fromDate = this.safeDate(f.getValue());
                    }
                    if ("to".equalsIgnoreCase(f.getDirection())) {
                        toDate = this.safeDate(f.getValue());
                    }
                }
                if (!"extension".equalsIgnoreCase(f.getFieldName())) continue;
                if (f.getValue() != null && !f.getValue().trim().isEmpty()) {
                    extension = f.getValue().trim();
                    continue;
                }
                extension = null;
            }
        }
        if (search != null && sortBy != null) {
            switch (sortBy) {
                case "extensionNo": {
                    extension = search;
                    break;
                }
                case "calledNo": {
                    callerId = search;
                    break;
                }
                case "callType": {
                    callType = search;
                    break;
                }
            }
        }
        List rows = this.billingCDRRepository.extensionDetailsIn(fromDate, toDate, extension, callerId, callType);
        PdfPTable table = new PdfPTable(searchRequestData.getColumnNames().size());
        for (String columnName : searchRequestData.getColumnNames()) {
            BaseColor blue = new BaseColor(2, 111, 194);
            PdfPCell cell = new PdfPCell(new Phrase((String)columnMappings.get(columnName), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE)));
            cell.setHorizontalAlignment(1);
            cell.setBackgroundColor(blue);
            cell.setBorder(0);
            table.addCell(cell);
        }
        table.setHeaderRows(1);
        if (rows == null || rows.isEmpty()) {
            PdfPCell noData = new PdfPCell(new Phrase("No records found"));
            noData.setColspan(searchRequestData.getColumnNames().size());
            noData.setHorizontalAlignment(1);
            table.addCell(noData);
        } else {
            this.getDbData(table, rows, searchRequestData.getColumnNames());
        }
        document.add((Element)table);
    }

    private LocalDate safeDate(String v) {
        try {
            if (v == null) {
                return null;
            }
            if ((v = v.trim()).isEmpty()) {
                return null;
            }
            return LocalDate.parse(v);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void getDbData(PdfPTable table, List<Object[]> rows, List<String> columns) {
        BaseColor light = new BaseColor(230, 230, 230);
        for (int i = 0; i < rows.size(); ++i) {
            Object[] r = rows.get(i);
            if (i % 2 == 0) {
                table.getDefaultCell().setBackgroundColor(BaseColor.WHITE);
            } else {
                table.getDefaultCell().setBackgroundColor(light);
            }
            Iterator<String> iterator = columns.iterator();
            block27: while (iterator.hasNext()) {
                String col;
                switch (col = iterator.next()) {
                    case "extensionNo": {
                        table.addCell(this.safe((Object)this.val(r[0])));
                        continue block27;
                    }
                    case "callDate": {
                        table.addCell(this.safe((Object)this.val(r[1])));
                        continue block27;
                    }
                    case "calledNo": {
                        table.addCell(this.safe((Object)this.val(r[2])));
                        continue block27;
                    }
                    case "callType": {
                        table.addCell(this.safe((Object)this.val(r[3])));
                        continue block27;
                    }
                    case "talkDuration": {
                        table.addCell(this.safe((Object)this.formatTime(r[4])));
                        continue block27;
                    }
                    case "ringDuration": {
                        table.addCell(this.safe((Object)this.formatTime(r[5])));
                        continue block27;
                    }
                    case "coralCallDirection": {
                        table.addCell(this.safe((Object)this.val(r[6])));
                        continue block27;
                    }
                    case "coralFeatureCode": {
                        table.addCell(this.safe((Object)this.val(r[7])));
                        continue block27;
                    }
                    case "connected": {
                        table.addCell(this.safe((Object)this.val(r[8])));
                        continue block27;
                    }
                    case "transferAgent": {
                        table.addCell(this.safe((Object)this.val(r[9])));
                        continue block27;
                    }
                    case "transfer": {
                        table.addCell(this.safe((Object)this.val(r[10])));
                        continue block27;
                    }
                }
                table.addCell("");
            }
        }
    }

    private String val(Object v) {
        return v == null ? "" : v.toString();
    }

    private String formatTime(Object v) {
        try {
            if (v == null) {
                return "";
            }
            long sec = Long.parseLong(v.toString());
            long h = sec / 3600L;
            long m = sec % 3600L / 60L;
            long s = sec % 60L;
            return String.format("%02d:%02d:%02d", h, m, s);
        }
        catch (Exception e) {
            return "";
        }
    }

    private void addLogoAndDocTitle(Document document, SearchRequest filterRequest, Integer columns) {
        try {
            logger.info("finding logo from location");
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            PdfPCell logoCell = new PdfPCell();
            logoCell.setHorizontalAlignment(1);
            logoCell.setBorder(0);
            Image img = Image.getInstance((String)logoImgPath);
            if (columns > 5) {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.5f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            } else {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.7f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            }
            PdfPCell reportNameCell = new PdfPCell();
            reportNameCell.setHorizontalAlignment(1);
            reportNameCell.setBorder(0);
            Paragraph p1 = new Paragraph(reportFileName, COURIER);
            reportNameCell.addElement((Element)p1);
            PdfPCell dateTimeCell = new PdfPCell();
            dateTimeCell.setHorizontalAlignment(1);
            dateTimeCell.setBorder(0);
            String localDateString = this.currentTime.format(DateTimeFormatter.ofPattern(localDateFormat));
            Paragraph p2 = new Paragraph("Report generated on " + localDateString, COURIER_SMALL);
            dateTimeCell.addElement((Element)p2);
            table.addCell(logoCell);
            table.addCell(reportNameCell);
            table.addCell(dateTimeCell);
            document.add((Element)table);
            logger.info("successfully found logo for pdf");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private static void addAdvanceFilterRequest(Document document, SearchRequest searchRequestData) throws DocumentException {
        List filters = searchRequestData.getAdvancedFilters();
        if (filters != null && !filters.isEmpty()) {
            Paragraph p = new Paragraph();
            for (AdvanceFilter f : filters) {
                if ("from".equals(f.getDirection())) {
                    p.add("From: " + f.getValue() + "  ");
                    continue;
                }
                if (!"to".equals(f.getDirection())) continue;
                p.add("To: " + f.getValue());
            }
            document.add((Element)p);
        }
    }

    private void savePdfToDestination(byte[] pdfBytes, String destinationPath) {
        try (FileOutputStream fos = new FileOutputStream(destinationPath);){
            fos.write(pdfBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createPdfReportRecord(String id, SearchRequest data, String filePath) {
        try {
            PdfReportFilters pdf = new PdfReportFilters();
            ObjectMapper mapper = new ObjectMapper();
            pdf.setId(id);
            pdf.setReportName(reportFileName);
            pdf.setFilterParameters(mapper.writeValueAsString((Object)data));
            pdf.setCreatedOnDate(this.currentTime);
            pdf.setPdfLocation(filePath);
            pdf.setStatus("InProgress");
            this.pdfReportRepository.save((Object)pdf);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private String safe(Object v) {
        return v != null ? v.toString() : "";
    }

    static {
        columnMappings.put("extensionNo", "Extension No");
        columnMappings.put("calledNo", "Called Number");
        columnMappings.put("callDate", "Call Date");
        columnMappings.put("callType", "Call Type");
        columnMappings.put("talkDuration", "Talk Time(HH:MM:SS)");
        columnMappings.put("ringDuration", "Ring Time(HH:MM:SS)");
        columnMappings.put("coralCallDirection", "Call Direction");
        columnMappings.put("coralFeatureCode", "Feature Code");
        columnMappings.put("connected", "Connected");
        columnMappings.put("transferAgent", "Transfer Agent");
        columnMappings.put("transfer", "Transfer");
    }
}

